/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.responses;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;

public class APIResponses
extends BaseExtensibleModel<org.eclipse.microprofile.openapi.models.responses.APIResponses>
implements org.eclipse.microprofile.openapi.models.responses.APIResponses {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    public Map<String, APIResponse> getAPIResponses() {
        return this.getProperties(APIResponse.class);
    }

    public void setAPIResponses(Map<String, APIResponse> newValue) {
        this.getAPIResponses().keySet().forEach(this::removeAPIResponse);
        if (newValue != null) {
            newValue.forEach(this::addAPIResponse);
        }
    }

    public APIResponses addAPIResponse(String newKey, APIResponse newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.setProperty(newKey, newValue);
        return this;
    }

    public void removeAPIResponse(String key) {
        this.setProperty(key, null);
    }

    public APIResponse getDefaultValue() {
        return (APIResponse)this.getProperty("default", APIResponse.class);
    }

    public void setDefaultValue(APIResponse newValue) {
        this.setProperty("default", newValue);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(2);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(2);

        public Properties() {
            this.types.put("io.smallrye.openapi.internal.model.unwrapped", DataType.type(APIResponse.class));
            this.minVersions.put("APIResponses", OpenApiVersion.V3_0);
            this.types.put("default", DataType.type(APIResponse.class));
            this.minVersions.put("default", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            if (name.startsWith("x-")) {
                return DataType.type(Object.class);
            }
            return this.types.get("io.smallrye.openapi.internal.model.unwrapped");
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

