/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.license;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.info.LicenseImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import org.eclipse.microprofile.openapi.models.info.License;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class LicenseReader {
    private LicenseReader() {
    }

    public static License readLicense(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@License");
        AnnotationInstance nested = annotationValue.asNested();
        LicenseImpl license = new LicenseImpl();
        license.setName(JandexUtil.stringValue(nested, "name"));
        license.setUrl(JandexUtil.stringValue(nested, "url"));
        license.setExtensions(ExtensionReader.readExtensions(context, nested));
        return license;
    }

    public static License readLicense(JsonNode node) {
        if (node == null) {
            return null;
        }
        IoLogging.logger.singleJsonNode("License");
        LicenseImpl license = new LicenseImpl();
        license.setName(JsonUtil.stringProperty(node, "name"));
        license.setUrl(JsonUtil.stringProperty(node, "url"));
        ExtensionReader.readExtensions(node, license);
        return license;
    }
}

