/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.filters;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.smallrye.mutiny.Uni;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.filters.FilterUtil;
import org.jboss.resteasy.reactive.server.filters.PreventAbortResteasyReactiveContainerRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.HttpHeadersImpl;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.GeneratorUtils;
import org.jboss.resteasy.reactive.server.processor.util.KotlinUtils;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerResponseFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

final class CustomFilterGenerator {
    private static final String ABSTRACT_SUSPENDED_REQ_FILTER = "org.jboss.resteasy.reactive.server.runtime.kotlin.AbstractSuspendedRequestFilter";
    private static final String ABSTRACT_SUSPENDED_RES_FILTER = "org.jboss.resteasy.reactive.server.runtime.kotlin.AbstractSuspendedResponseFilter";

    private CustomFilterGenerator() {
    }

    static String generateContainerRequestFilter(MethodInfo targetMethod, ClassOutput classOutput, Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        CustomFilterGenerator.checkModifiers(targetMethod, ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER);
        if (KotlinUtils.isSuspendMethod(targetMethod)) {
            return CustomFilterGenerator.generateRequestFilterForSuspendedMethod(targetMethod, classOutput, unwrappableTypes, additionalBeanAnnotations);
        }
        return CustomFilterGenerator.generateStandardRequestFilter(targetMethod, classOutput, unwrappableTypes, additionalBeanAnnotations);
    }

    private static String generateRequestFilterForSuspendedMethod(MethodInfo targetMethod, ClassOutput classOutput, Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        ReturnType returnType;
        DotName returnDotName = CustomFilterGenerator.determineReturnDotNameOfSuspendMethod(targetMethod);
        if (returnDotName.equals((Object)ResteasyReactiveDotNames.VOID)) {
            returnType = ReturnType.VOID;
        } else if (returnDotName.equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
            returnType = ReturnType.RESPONSE;
        } else if (returnDotName.equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
            returnType = ReturnType.REST_RESPONSE;
        } else {
            throw new RuntimeException("Suspend method '" + targetMethod.name() + " of class '" + targetMethod.declaringClass().name() + "' cannot be used as a request filter as it does not declare 'void', 'Response', 'RestResponse' as its return type.");
        }
        String generatedClassName = CustomFilterGenerator.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER);
        DotName declaringClassName = targetMethod.declaringClass().name();
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).superClass(ABSTRACT_SUSPENDED_REQ_FILTER).build();){
            String methodName;
            FieldDescriptor delegateField = CustomFilterGenerator.generateConstructorAndDelegateField(cc, declaringClassName.toString(), ABSTRACT_SUSPENDED_REQ_FILTER, additionalBeanAnnotations);
            MethodCreator doFilterMethod = cc.getMethodCreator("doFilter", Object.class.getName(), new String[]{ResteasyReactiveContainerRequestContext.class.getName(), ResteasyReactiveDotNames.CONTINUATION.toString()});
            ResultHandle resultHandle = doFilterMethod.invokeVirtualMethod(targetMethod, doFilterMethod.readInstanceField(delegateField, doFilterMethod.getThis()), CustomFilterGenerator.getRequestFilterResultHandles(targetMethod, declaringClassName, doFilterMethod, 2, CustomFilterGenerator.getRRReqCtxHandle(doFilterMethod, CustomFilterGenerator.getRRContainerReqCtxHandle(doFilterMethod, 0)), unwrappableTypes));
            doFilterMethod.returnValue(resultHandle);
            MethodCreator handleResultMethod = cc.getMethodCreator("handleResult", Void.TYPE, new Class[]{ResteasyReactiveContainerRequestContext.class, Uni.class});
            switch (returnType) {
                case VOID: {
                    methodName = "handleUniVoid";
                    break;
                }
                case RESPONSE: {
                    methodName = "handleUniResponse";
                    break;
                }
                case REST_RESPONSE: {
                    methodName = "handleUniRestResponse";
                    break;
                }
                default: {
                    throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported, in method " + targetMethod.declaringClass() + "." + targetMethod.name());
                }
            }
            handleResultMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)methodName, Void.TYPE, (Class[])new Class[]{Uni.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{handleResultMethod.getMethodParam(1), CustomFilterGenerator.getRRContainerReqCtxHandle(handleResultMethod, 0)});
            handleResultMethod.returnValue(null);
        }
        return generatedClassName;
    }

    private static String generateStandardRequestFilter(MethodInfo targetMethod, ClassOutput classOutput, Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        String generatedClassName;
        block20: {
            ReturnType returnType = CustomFilterGenerator.determineRequestFilterReturnType(targetMethod);
            generatedClassName = CustomFilterGenerator.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER);
            DotName declaringClassName = targetMethod.declaringClass().name();
            try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).interfaces(new Class[]{CustomFilterGenerator.determineRequestInterfaceType(returnType)}).build();){
                FieldDescriptor delegateField = CustomFilterGenerator.generateConstructorAndDelegateField(cc, declaringClassName.toString(), Object.class.getName(), additionalBeanAnnotations);
                if (returnType == ReturnType.VOID || returnType == ReturnType.OPTIONAL_RESPONSE || returnType == ReturnType.OPTIONAL_REST_RESPONSE || returnType == ReturnType.RESPONSE || returnType == ReturnType.REST_RESPONSE) {
                    MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ContainerRequestContext.class});
                    ResultHandle rrContainerReqCtxHandle = CustomFilterGenerator.getRRContainerReqCtxHandle(filterMethod, 0);
                    ResultHandle resultHandle = filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), CustomFilterGenerator.getRequestFilterResultHandles(targetMethod, declaringClassName, filterMethod, 1, CustomFilterGenerator.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle), unwrappableTypes));
                    if (returnType == ReturnType.OPTIONAL_RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleOptional", Void.TYPE, (Class[])new Class[]{Optional.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    } else if (returnType == ReturnType.OPTIONAL_REST_RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleOptionalRestResponse", Void.TYPE, (Class[])new Class[]{Optional.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    } else if (returnType == ReturnType.RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleResponse", Void.TYPE, (Class[])new Class[]{Response.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    } else if (returnType == ReturnType.REST_RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleRestResponse", Void.TYPE, (Class[])new Class[]{RestResponse.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    }
                    filterMethod.returnValue(null);
                    break block20;
                }
                if (returnType == ReturnType.UNI_VOID || returnType == ReturnType.UNI_RESPONSE || returnType == ReturnType.UNI_REST_RESPONSE) {
                    String methodName;
                    MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ResteasyReactiveContainerRequestContext.class});
                    ResultHandle rrContainerReqCtxHandle = CustomFilterGenerator.getRRContainerReqCtxHandle(filterMethod, 0);
                    ResultHandle uniHandle = filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), CustomFilterGenerator.getRequestFilterResultHandles(targetMethod, declaringClassName, filterMethod, 1, CustomFilterGenerator.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle), unwrappableTypes));
                    switch (returnType) {
                        case UNI_VOID: {
                            methodName = "handleUniVoid";
                            break;
                        }
                        case UNI_RESPONSE: {
                            methodName = "handleUniResponse";
                            break;
                        }
                        case UNI_REST_RESPONSE: {
                            methodName = "handleUniRestResponse";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported, in method " + targetMethod.declaringClass() + "." + targetMethod.name());
                        }
                    }
                    filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)methodName, Void.TYPE, (Class[])new Class[]{Uni.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{uniHandle, rrContainerReqCtxHandle});
                    filterMethod.returnValue(null);
                    break block20;
                }
                throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported, in method " + targetMethod.declaringClass() + "." + targetMethod.name());
            }
        }
        return generatedClassName;
    }

    private static ResultHandle[] getRequestFilterResultHandles(MethodInfo targetMethod, DotName declaringClassName, MethodCreator filterMethod, int filterMethodParamCount, ResultHandle rrReqCtxHandle, Set<DotName> unwrappableTypes) {
        ResultHandle[] targetMethodParamHandles = new ResultHandle[targetMethod.parameters().size()];
        for (int i = 0; i < targetMethod.parameters().size(); ++i) {
            Type param = (Type)targetMethod.parameters().get(i);
            DotName paramDotName = param.name();
            if (ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.newInstance(MethodDescriptor.ofConstructor(PreventAbortResteasyReactiveContainerRequestContext.class, (Class[])new Class[]{ContainerRequestContext.class}), new ResultHandle[]{filterMethod.getMethodParam(0)});
                continue;
            }
            if (ResteasyReactiveServerDotNames.QUARKUS_REST_CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.checkCast(filterMethod.getMethodParam(0), ResteasyReactiveContainerRequestContext.class);
                continue;
            }
            if (ResteasyReactiveDotNames.URI_INFO.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getUriInfo", ResteasyReactiveDotNames.URI_INFO);
                continue;
            }
            if (ResteasyReactiveDotNames.HTTP_HEADERS.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getHttpHeaders", HttpHeadersImpl.class);
                continue;
            }
            if (ResteasyReactiveDotNames.REQUEST.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getRequest", ResteasyReactiveDotNames.REQUEST);
                continue;
            }
            if (ResteasyReactiveDotNames.RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = CustomFilterGenerator.getResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveServerDotNames.SIMPLIFIED_RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = CustomFilterGenerator.getSimpleResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveDotNames.CONTINUATION.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.getMethodParam(filterMethodParamCount - 1);
                continue;
            }
            if (unwrappableTypes.contains(paramDotName)) {
                targetMethodParamHandles[i] = GeneratorUtils.unwrapObject(filterMethod, rrReqCtxHandle, paramDotName);
                continue;
            }
            String parameterName = targetMethod.parameterName(i);
            throw new RuntimeException("Parameter '" + parameterName + "' of method '" + targetMethod.name() + " of class '" + declaringClassName + "' is not allowed");
        }
        return targetMethodParamHandles;
    }

    static String generateContainerResponseFilter(MethodInfo targetMethod, ClassOutput classOutput, Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        CustomFilterGenerator.checkModifiers(targetMethod, ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER);
        if (KotlinUtils.isSuspendMethod(targetMethod)) {
            return CustomFilterGenerator.generateResponseFilterForSuspendedMethod(targetMethod, classOutput, unwrappableTypes, additionalBeanAnnotations);
        }
        return CustomFilterGenerator.generateStandardContainerResponseFilter(targetMethod, classOutput, unwrappableTypes, additionalBeanAnnotations);
    }

    private static String generateResponseFilterForSuspendedMethod(MethodInfo targetMethod, ClassOutput classOutput, Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        DotName returnDotName = CustomFilterGenerator.determineReturnDotNameOfSuspendMethod(targetMethod);
        if (!returnDotName.equals((Object)ResteasyReactiveDotNames.VOID)) {
            throw new RuntimeException("Suspend method '" + targetMethod.name() + " of class '" + targetMethod.declaringClass().name() + "' cannot be used as a request filter as it does not declare 'void' as its return type.");
        }
        String generatedClassName = CustomFilterGenerator.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER);
        DotName declaringClassName = targetMethod.declaringClass().name();
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).superClass(ABSTRACT_SUSPENDED_RES_FILTER).build();){
            FieldDescriptor delegateField = CustomFilterGenerator.generateConstructorAndDelegateField(cc, declaringClassName.toString(), ABSTRACT_SUSPENDED_RES_FILTER, additionalBeanAnnotations);
            MethodCreator doFilterMethod = cc.getMethodCreator("doFilter", Object.class.getName(), new String[]{ResteasyReactiveContainerRequestContext.class.getName(), ContainerResponseContext.class.getName(), ResteasyReactiveDotNames.CONTINUATION.toString()});
            ResultHandle rrContainerReqCtxHandle = CustomFilterGenerator.getRRContainerReqCtxHandle(doFilterMethod, 0);
            ResultHandle rrReqCtxHandle = CustomFilterGenerator.getRRReqCtxHandle(doFilterMethod, rrContainerReqCtxHandle);
            ResultHandle resultHandle = doFilterMethod.invokeVirtualMethod(targetMethod, doFilterMethod.readInstanceField(delegateField, doFilterMethod.getThis()), CustomFilterGenerator.getResponseFilterResultHandles(targetMethod, declaringClassName, doFilterMethod, 3, rrReqCtxHandle, unwrappableTypes));
            doFilterMethod.returnValue(resultHandle);
        }
        return generatedClassName;
    }

    private static String generateStandardContainerResponseFilter(MethodInfo targetMethod, ClassOutput classOutput, Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        ReturnType returnType = CustomFilterGenerator.determineResponseFilterReturnType(targetMethod);
        String generatedClassName = CustomFilterGenerator.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER);
        DotName declaringClassName = targetMethod.declaringClass().name();
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).interfaces(new Class[]{CustomFilterGenerator.determineResponseInterfaceType(returnType)}).build();){
            FieldDescriptor delegateField = CustomFilterGenerator.generateConstructorAndDelegateField(cc, declaringClassName.toString(), Object.class.getName(), additionalBeanAnnotations);
            if (returnType == ReturnType.VOID) {
                MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ContainerRequestContext.class, ContainerResponseContext.class});
                ResultHandle rrContainerReqCtxHandle = CustomFilterGenerator.getRRContainerReqCtxHandle(filterMethod, 0);
                ResultHandle rrReqCtxHandle = CustomFilterGenerator.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle);
                filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), CustomFilterGenerator.getResponseFilterResultHandles(targetMethod, declaringClassName, filterMethod, 2, rrReqCtxHandle, unwrappableTypes));
                filterMethod.returnValue(null);
            } else if (returnType == ReturnType.UNI_VOID) {
                MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ResteasyReactiveContainerRequestContext.class, ContainerResponseContext.class});
                ResultHandle rrContainerReqCtxHandle = CustomFilterGenerator.getRRContainerReqCtxHandle(filterMethod, 0);
                ResultHandle rrReqCtxHandle = CustomFilterGenerator.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle);
                ResultHandle uniHandle = filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), CustomFilterGenerator.getResponseFilterResultHandles(targetMethod, declaringClassName, filterMethod, 2, rrReqCtxHandle, unwrappableTypes));
                filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleUniVoid", Void.TYPE, (Class[])new Class[]{Uni.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{uniHandle, rrContainerReqCtxHandle});
                filterMethod.returnValue(null);
            }
        }
        return generatedClassName;
    }

    private static FieldDescriptor generateConstructorAndDelegateField(ClassCreator cc, String declaringClassName, String superClassName, Set<String> additionalBeanAnnotations) {
        cc.addAnnotation(Singleton.class);
        for (String i : additionalBeanAnnotations) {
            cc.addAnnotation(i);
        }
        FieldDescriptor delegateField = ((FieldCreator)cc.getFieldCreator("delegate", declaringClassName).setModifiers(18)).getFieldDescriptor();
        MethodCreator ctor = cc.getMethodCreator("<init>", Void.TYPE, new Object[]{declaringClassName});
        ctor.setModifiers(1);
        ctor.addAnnotation(Inject.class);
        ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)superClassName, (String[])new String[0]), ctor.getThis(), new ResultHandle[0]);
        ResultHandle self = ctor.getThis();
        ResultHandle delegate = ctor.getMethodParam(0);
        ctor.writeInstanceField(delegateField, self, delegate);
        ctor.returnValue(null);
        return delegateField;
    }

    private static ResultHandle[] getResponseFilterResultHandles(MethodInfo targetMethod, DotName declaringClassName, MethodCreator filterMethod, int filterMethodParamCount, ResultHandle rrReqCtxHandle, Set<DotName> unwrappableTypes) {
        ResultHandle[] targetMethodParamHandles = new ResultHandle[targetMethod.parameters().size()];
        for (int i = 0; i < targetMethod.parameters().size(); ++i) {
            Type param = (Type)targetMethod.parameters().get(i);
            DotName paramDotName = param.name();
            if (ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.newInstance(MethodDescriptor.ofConstructor(PreventAbortResteasyReactiveContainerRequestContext.class, (Class[])new Class[]{ContainerRequestContext.class}), new ResultHandle[]{filterMethod.getMethodParam(0)});
                continue;
            }
            if (ResteasyReactiveServerDotNames.QUARKUS_REST_CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.checkCast(filterMethod.getMethodParam(0), ResteasyReactiveContainerRequestContext.class);
                continue;
            }
            if (ResteasyReactiveDotNames.CONTAINER_RESPONSE_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.getMethodParam(1);
                continue;
            }
            if (unwrappableTypes.contains(paramDotName)) {
                targetMethodParamHandles[i] = GeneratorUtils.unwrapObject(filterMethod, rrReqCtxHandle, paramDotName);
                continue;
            }
            if (ResteasyReactiveDotNames.URI_INFO.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getUriInfo", ResteasyReactiveDotNames.URI_INFO);
                continue;
            }
            if (ResteasyReactiveDotNames.RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = CustomFilterGenerator.getResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveServerDotNames.SIMPLIFIED_RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = CustomFilterGenerator.getSimpleResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveDotNames.THROWABLE.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getThrowable", ResteasyReactiveDotNames.THROWABLE);
                continue;
            }
            if (ResteasyReactiveDotNames.CONTINUATION.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.getMethodParam(filterMethodParamCount - 1);
                continue;
            }
            String parameterName = targetMethod.parameterName(i);
            throw new RuntimeException("Parameter '" + parameterName + "' of method '" + targetMethod.name() + " of class '" + declaringClassName + "' is not allowed");
        }
        return targetMethodParamHandles;
    }

    private static ResultHandle getRRContainerReqCtxHandle(MethodCreator filter, int containerReqCtxParamIndex) {
        ResultHandle containerReqCtxHandle = filter.getMethodParam(containerReqCtxParamIndex);
        return filter.checkCast(containerReqCtxHandle, ResteasyReactiveContainerRequestContext.class);
    }

    private static ResultHandle getRRReqCtxHandle(MethodCreator filter, ResultHandle rrContainerReqCtxHandle) {
        ResultHandle rrCtxHandle = filter.invokeInterfaceMethod(MethodDescriptor.ofMethod(ResteasyReactiveContainerRequestContext.class, (String)"getServerRequestContext", ServerRequestContext.class, (Class[])new Class[0]), rrContainerReqCtxHandle, new ResultHandle[0]);
        return filter.checkCast(rrCtxHandle, ResteasyReactiveRequestContext.class);
    }

    private static AssignableResultHandle getResourceInfoHandle(MethodCreator filterMethod, ResultHandle rrReqCtxHandle) {
        ResultHandle runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(filterMethod, rrReqCtxHandle);
        AssignableResultHandle resourceInfo = filterMethod.createVariable(ResourceInfo.class);
        BranchResult ifNullBranch = filterMethod.ifNull(runtimeResourceHandle);
        ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
        ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getLazyMethod", ResteasyReactiveResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
        return resourceInfo;
    }

    private static AssignableResultHandle getSimpleResourceInfoHandle(MethodCreator filterMethod, ResultHandle rrReqCtxHandle) {
        ResultHandle runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(filterMethod, rrReqCtxHandle);
        AssignableResultHandle resourceInfo = filterMethod.createVariable(SimpleResourceInfo.class);
        BranchResult ifNullBranch = filterMethod.ifNull(runtimeResourceHandle);
        ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
        ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getSimplifiedResourceInfo", SimpleResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
        return resourceInfo;
    }

    private static String getGeneratedClassName(MethodInfo targetMethod, DotName annotationDotName) {
        DotName declaringClassName = targetMethod.declaringClass().name();
        return declaringClassName.toString() + "$Generated" + annotationDotName.withoutPackagePrefix() + "$" + targetMethod.name();
    }

    private static void checkModifiers(MethodInfo info, DotName annotationDotName) {
        if ((info.flags() & 2) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + info.declaringClass().name() + "' cannot be private as it is annotated with '@" + annotationDotName + "'");
        }
        if ((info.flags() & 8) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + info.declaringClass().name() + "' cannot be static as it is annotated with '@" + annotationDotName + "'");
        }
    }

    private static ReturnType determineRequestFilterReturnType(MethodInfo targetMethod) {
        if (targetMethod.returnType().kind() == Type.Kind.VOID) {
            return ReturnType.VOID;
        }
        if (targetMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType parameterizedType = targetMethod.returnType().asParameterizedType();
            if (parameterizedType.name().equals((Object)ResteasyReactiveDotNames.UNI) && parameterizedType.arguments().size() == 1) {
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.VOID)) {
                    return ReturnType.UNI_VOID;
                }
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
                    return ReturnType.UNI_RESPONSE;
                }
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
                    return ReturnType.UNI_REST_RESPONSE;
                }
            } else if (parameterizedType.name().equals((Object)ResteasyReactiveDotNames.OPTIONAL) && parameterizedType.arguments().size() == 1) {
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
                    return ReturnType.OPTIONAL_RESPONSE;
                }
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
                    return ReturnType.OPTIONAL_REST_RESPONSE;
                }
            } else if (parameterizedType.name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE)) {
                return ReturnType.REST_RESPONSE;
            }
        } else if (targetMethod.returnType().name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
            return ReturnType.RESPONSE;
        }
        throw new RuntimeException("Method '" + targetMethod.name() + " of class '" + targetMethod.declaringClass().name() + "' cannot be used as a request filter as it does not declare 'void', Response, RestResponse, Optional<Response>, Optional<RestResponse>, 'Uni<Void>', 'Uni<RestResponse>' or 'Uni<Response>' as its return type");
    }

    private static ReturnType determineResponseFilterReturnType(MethodInfo targetMethod) {
        ParameterizedType parameterizedType;
        if (targetMethod.returnType().kind() == Type.Kind.VOID) {
            return ReturnType.VOID;
        }
        if (targetMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE && (parameterizedType = targetMethod.returnType().asParameterizedType()).name().equals((Object)ResteasyReactiveDotNames.UNI) && parameterizedType.arguments().size() == 1 && ((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.VOID)) {
            return ReturnType.UNI_VOID;
        }
        throw new RuntimeException("Method '" + targetMethod.name() + " of class '" + targetMethod.declaringClass().name() + "' cannot be used as a response filter as it does not declare 'void' or 'Uni<Void>' as its return type");
    }

    private static Class<?> determineRequestInterfaceType(ReturnType returnType) {
        switch (returnType) {
            case VOID: 
            case RESPONSE: 
            case REST_RESPONSE: 
            case OPTIONAL_RESPONSE: 
            case OPTIONAL_REST_RESPONSE: {
                return ContainerRequestFilter.class;
            }
            case UNI_VOID: 
            case UNI_RESPONSE: 
            case UNI_REST_RESPONSE: {
                return ResteasyReactiveContainerRequestFilter.class;
            }
        }
        throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported");
    }

    private static Class<?> determineResponseInterfaceType(ReturnType returnType) {
        if (returnType == ReturnType.VOID) {
            return ContainerResponseFilter.class;
        }
        if (returnType == ReturnType.UNI_VOID) {
            return ResteasyReactiveContainerResponseFilter.class;
        }
        throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported");
    }

    private static DotName determineReturnDotNameOfSuspendMethod(MethodInfo methodInfo) {
        Type lastParamType = (Type)methodInfo.parameters().get(methodInfo.parameters().size() - 1);
        if (lastParamType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            throw new IllegalStateException("Something went wrong during parameter type resolution - expected " + lastParamType + " to be a Continuation with a generic type");
        }
        if ((lastParamType = (Type)lastParamType.asParameterizedType().arguments().get(0)).kind() != Type.Kind.WILDCARD_TYPE) {
            throw new IllegalStateException("Something went wrong during parameter type resolution - expected " + lastParamType + " to be a Continuation with a generic type");
        }
        if ((lastParamType = lastParamType.asWildcardType().superBound()).name().equals((Object)ResteasyReactiveDotNames.KOTLIN_UNIT)) {
            return ResteasyReactiveDotNames.VOID;
        }
        return lastParamType.name();
    }

    private static enum ReturnType {
        VOID,
        RESPONSE,
        REST_RESPONSE,
        OPTIONAL_RESPONSE,
        OPTIONAL_REST_RESPONSE,
        UNI_VOID,
        UNI_RESPONSE,
        UNI_REST_RESPONSE;

    }
}

