/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;

public class AutoRolesAllowedFilter
implements OASFilter {
    private Map<String, List<String>> rolesAllowedMethodReferences;
    private List<String> authenticatedMethodReferences;
    private String defaultSecuritySchemeName;

    public AutoRolesAllowedFilter() {
    }

    public AutoRolesAllowedFilter(String defaultSecuritySchemeName, Map<String, List<String>> rolesAllowedMethodReferences, List<String> authenticatedMethodReferences) {
        this.defaultSecuritySchemeName = defaultSecuritySchemeName;
        this.rolesAllowedMethodReferences = rolesAllowedMethodReferences;
        this.authenticatedMethodReferences = authenticatedMethodReferences;
    }

    public Map<String, List<String>> getRolesAllowedMethodReferences() {
        return this.rolesAllowedMethodReferences;
    }

    public void setRolesAllowedMethodReferences(Map<String, List<String>> rolesAllowedMethodReferences) {
        this.rolesAllowedMethodReferences = rolesAllowedMethodReferences;
    }

    public boolean hasRolesAllowedMethodReferences() {
        return this.rolesAllowedMethodReferences != null && !this.rolesAllowedMethodReferences.isEmpty();
    }

    public List<String> getAuthenticatedMethodReferences() {
        return this.authenticatedMethodReferences;
    }

    public void setAuthenticatedMethodReferences(List<String> authenticatedMethodReferences) {
        this.authenticatedMethodReferences = authenticatedMethodReferences;
    }

    public boolean hasAuthenticatedMethodReferences() {
        return this.authenticatedMethodReferences != null && !this.authenticatedMethodReferences.isEmpty();
    }

    public String getDefaultSecuritySchemeName() {
        return this.defaultSecuritySchemeName;
    }

    public void setDefaultSecuritySchemeName(String defaultSecuritySchemeName) {
        this.defaultSecuritySchemeName = defaultSecuritySchemeName;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        if (this.hasRolesAllowedMethodReferences() || this.hasAuthenticatedMethodReferences()) {
            Map pathItems;
            String securitySchemeName = this.getSecuritySchemeName(openAPI);
            Paths paths = openAPI.getPaths();
            if (paths != null && (pathItems = paths.getPathItems()) != null && !pathItems.isEmpty()) {
                Set pathItemsEntries = pathItems.entrySet();
                for (Map.Entry pathItem : pathItemsEntries) {
                    Map operations = ((PathItem)pathItem.getValue()).getOperations();
                    if (operations == null || operations.isEmpty()) continue;
                    for (Operation operation : operations.values()) {
                        SecurityRequirementImpl securityRequirement;
                        OperationImpl operationImpl = (OperationImpl)operation;
                        if (this.hasRolesAllowedMethodReferences() && this.rolesAllowedMethodReferences.keySet().contains(operationImpl.getMethodRef())) {
                            securityRequirement = new SecurityRequirementImpl();
                            List<String> roles = this.rolesAllowedMethodReferences.get(operationImpl.getMethodRef());
                            securityRequirement = securityRequirement.addScheme(securitySchemeName, roles);
                            operation = operation.addSecurityRequirement((SecurityRequirement)securityRequirement);
                            APIResponses responses = operation.getResponses();
                            for (APIResponseImpl response : this.getSecurityResponses()) {
                                if (responses.hasAPIResponse(response.getResponseCode())) continue;
                                responses.addAPIResponse(response.getResponseCode(), (APIResponse)response);
                            }
                            operation = operation.responses(responses);
                            continue;
                        }
                        if (!this.hasAuthenticatedMethodReferences() || !this.authenticatedMethodReferences.contains(operationImpl.getMethodRef())) continue;
                        securityRequirement = new SecurityRequirementImpl();
                        securityRequirement = securityRequirement.addScheme(securitySchemeName);
                        operation = operation.addSecurityRequirement((SecurityRequirement)securityRequirement);
                        APIResponses responses = operation.getResponses();
                        for (APIResponseImpl response : this.getSecurityResponses()) {
                            if (responses.hasAPIResponse(response.getResponseCode())) continue;
                            responses.addAPIResponse(response.getResponseCode(), (APIResponse)response);
                        }
                        operation = operation.responses(responses);
                    }
                }
            }
        }
    }

    private String getSecuritySchemeName(OpenAPI openAPI) {
        if (openAPI.getComponents() != null && openAPI.getComponents().getSecuritySchemes() != null && !openAPI.getComponents().getSecuritySchemes().isEmpty()) {
            Map securitySchemes = openAPI.getComponents().getSecuritySchemes();
            return (String)securitySchemes.keySet().iterator().next();
        }
        return this.defaultSecuritySchemeName;
    }

    private List<APIResponseImpl> getSecurityResponses() {
        ArrayList<APIResponseImpl> responses = new ArrayList<APIResponseImpl>();
        APIResponseImpl notAuthorized = new APIResponseImpl();
        notAuthorized.setDescription("Not Authorized");
        notAuthorized.setResponseCode("401");
        responses.add(notAuthorized);
        APIResponseImpl forbidden = new APIResponseImpl();
        forbidden.setDescription("Not Allowed");
        forbidden.setResponseCode("403");
        responses.add(forbidden);
        return responses;
    }
}

