/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment;

import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.openapi.api.OpenApiConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class OpenApiConfigMapping
extends RelocateConfigSourceInterceptor {
    private static final Map<String, String> RELOCATIONS = OpenApiConfigMapping.relocations();
    private final HyphenateEnumConverter enumConverter = new HyphenateEnumConverter(OpenApiConfig.OperationIdStrategy.class);
    private static final String QUARKUS_OPEN_API_VERSION = "quarkus.smallrye-openapi.open-api-version";
    private static final String QUARKUS_SERVERS = "quarkus.smallrye-openapi.servers";
    private static final String QUARKUS_INFO_TITLE = "quarkus.smallrye-openapi.info-title";
    private static final String QUARKUS_INFO_VERSION = "quarkus.smallrye-openapi.info-version";
    private static final String QUARKUS_INFO_DESCRIPTION = "quarkus.smallrye-openapi.info-description";
    private static final String QUARKUS_INFO_TERMS = "quarkus.smallrye-openapi.info-terms-of-service";
    private static final String QUARKUS_INFO_CONTACT_EMAIL = "quarkus.smallrye-openapi.info-contact-email";
    private static final String QUARKUS_INFO_CONTACT_NAME = "quarkus.smallrye-openapi.info-contact-name";
    private static final String QUARKUS_INFO_CONTACT_URL = "quarkus.smallrye-openapi.info-contact-url";
    private static final String QUARKUS_INFO_LICENSE_NAME = "quarkus.smallrye-openapi.info-license-name";
    private static final String QUARKUS_INFO_LICENSE_URL = "quarkus.smallrye-openapi.info-license-url";
    private static final String QUARKUS_OPERATION_ID_STRATEGY = "quarkus.smallrye-openapi.operation-id-strategy";

    public OpenApiConfigMapping() {
        super(RELOCATIONS);
    }

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        ConfigValue configValue = super.getValue(context, name);
        if (name.equals("mp.openapi.extensions.smallrye.operationIdStrategy") && configValue != null) {
            String correctValue = this.enumConverter.convert(configValue.getValue()).toString();
            configValue = configValue.withValue(correctValue);
        }
        return configValue;
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = (String)namesIterator.next();
            names.add(name);
            String mappedName = RELOCATIONS.get(name);
            if (mappedName == null) continue;
            names.add(mappedName);
        }
        return names.iterator();
    }

    private static Map<String, String> relocations() {
        HashMap<String, String> relocations = new HashMap<String, String>();
        OpenApiConfigMapping.mapKey(relocations, "3.0.3", QUARKUS_OPEN_API_VERSION);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.servers", QUARKUS_SERVERS);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.info.title", QUARKUS_INFO_TITLE);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.info.version", QUARKUS_INFO_VERSION);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.info.description", QUARKUS_INFO_DESCRIPTION);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.info.termsOfService", QUARKUS_INFO_TERMS);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.info.contact.email", QUARKUS_INFO_CONTACT_EMAIL);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.info.contact.name", QUARKUS_INFO_CONTACT_NAME);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.info.contact.url", QUARKUS_INFO_CONTACT_URL);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.info.license.name", QUARKUS_INFO_LICENSE_NAME);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.info.license.url", QUARKUS_INFO_LICENSE_URL);
        OpenApiConfigMapping.mapKey(relocations, "mp.openapi.extensions.smallrye.operationIdStrategy", QUARKUS_OPERATION_ID_STRATEGY);
        return Collections.unmodifiableMap(relocations);
    }

    private static void mapKey(Map<String, String> map, String quarkusKey, String otherKey) {
        map.put(quarkusKey, otherKey);
        map.put(otherKey, quarkusKey);
    }
}

