/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.jsonb.vertx;

import java.lang.reflect.Type;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;

public class VertxJson {
    private VertxJson() {
    }

    public static void copy(io.vertx.core.json.JsonObject object, JsonObject origin) {
        origin.keySet().forEach(key -> {
            JsonValue value = (JsonValue)origin.get(key);
            JsonValue.ValueType kind = value.getValueType();
            switch (kind) {
                case STRING: {
                    object.put(key, origin.getString(key));
                    break;
                }
                case NULL: {
                    object.putNull(key);
                    break;
                }
                case TRUE: {
                    object.put(key, Boolean.valueOf(true));
                    break;
                }
                case FALSE: {
                    object.put(key, Boolean.valueOf(false));
                    break;
                }
                case NUMBER: {
                    JsonNumber number = origin.getJsonNumber(key);
                    if (number.isIntegral()) {
                        object.put(key, Long.valueOf(number.longValue()));
                        break;
                    }
                    object.put(key, Double.valueOf(number.doubleValue()));
                    break;
                }
                case ARRAY: {
                    io.vertx.core.json.JsonArray array = new io.vertx.core.json.JsonArray();
                    VertxJson.copy(array, origin.getJsonArray(key));
                    object.put(key, array);
                    break;
                }
                case OBJECT: {
                    io.vertx.core.json.JsonObject json = new io.vertx.core.json.JsonObject();
                    VertxJson.copy(json, origin.getJsonObject(key));
                    object.put(key, json);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown JSON Value " + kind);
                }
            }
        });
    }

    public static void copy(io.vertx.core.json.JsonArray array, JsonArray origin) {
        block9: for (int i = 0; i < origin.size(); ++i) {
            JsonValue value = (JsonValue)origin.get(i);
            JsonValue.ValueType kind = value.getValueType();
            switch (kind) {
                case STRING: {
                    array.add(origin.getString(i));
                    continue block9;
                }
                case TRUE: {
                    array.add(Boolean.valueOf(true));
                    continue block9;
                }
                case FALSE: {
                    array.add(Boolean.valueOf(false));
                    continue block9;
                }
                case NULL: {
                    array.addNull();
                    continue block9;
                }
                case NUMBER: {
                    JsonNumber number = origin.getJsonNumber(i);
                    if (number.isIntegral()) {
                        array.add(Long.valueOf(number.longValue()));
                        continue block9;
                    }
                    array.add(Double.valueOf(number.doubleValue()));
                    continue block9;
                }
                case ARRAY: {
                    io.vertx.core.json.JsonArray newArray = new io.vertx.core.json.JsonArray();
                    VertxJson.copy(newArray, origin.getJsonArray(i));
                    array.add(newArray);
                    continue block9;
                }
                case OBJECT: {
                    io.vertx.core.json.JsonObject newObject = new io.vertx.core.json.JsonObject();
                    VertxJson.copy(newObject, origin.getJsonObject(i));
                    array.add(newObject);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unknown JSON Value " + kind);
                }
            }
        }
    }

    public static class JsonObjectDeserializer
    implements JsonbDeserializer<io.vertx.core.json.JsonObject> {
        public io.vertx.core.json.JsonObject deserialize(JsonParser parser, DeserializationContext context, Type type) {
            io.vertx.core.json.JsonObject object = new io.vertx.core.json.JsonObject();
            VertxJson.copy(object, parser.getObject());
            return object;
        }
    }

    public static class JsonArraySerializer
    implements JsonbSerializer<io.vertx.core.json.JsonArray> {
        public void serialize(io.vertx.core.json.JsonArray json, JsonGenerator generator, SerializationContext ctxt) {
            ctxt.serialize((Object)json.getList(), generator);
        }
    }

    public static class JsonArrayDeserializer
    implements JsonbDeserializer<io.vertx.core.json.JsonArray> {
        public io.vertx.core.json.JsonArray deserialize(JsonParser parser, DeserializationContext context, Type type) {
            io.vertx.core.json.JsonArray object = new io.vertx.core.json.JsonArray();
            VertxJson.copy(object, parser.getArray());
            return object;
        }
    }

    public static class JsonObjectSerializer
    implements JsonbSerializer<io.vertx.core.json.JsonObject> {
        public void serialize(io.vertx.core.json.JsonObject json, JsonGenerator generator, SerializationContext ctxt) {
            ctxt.serialize((Object)json.getMap(), generator);
        }
    }
}

