/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.resteasy.reactive.common.runtime.ArcBeanFactory;
import io.quarkus.resteasy.reactive.common.runtime.ArcThreadSetupAction;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveCommonRecorder;
import io.quarkus.resteasy.reactive.server.runtime.QuarkusCurrentRequest;
import io.quarkus.resteasy.reactive.server.runtime.QuarkusResteasyReactiveRequestContext;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveInitialiser;
import io.quarkus.resteasy.reactive.server.runtime.observability.ObservabilityIntegrationRecorder;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.rest.DisabledRestEndpoints;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.devmode.ResourceNotFoundData;
import io.quarkus.vertx.http.runtime.devmode.RouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteMethodDescription;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.MediaType;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.resteasy.reactive.common.core.SingletonBeanFactory;
import org.jboss.resteasy.reactive.common.model.ResourceContextResolver;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.core.BlockingOperationSupport;
import org.jboss.resteasy.reactive.server.core.CurrentRequest;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeDeploymentManager;
import org.jboss.resteasy.reactive.server.handlers.RestInitialHandler;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.model.ContextResolvers;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;
import org.jboss.resteasy.reactive.server.spi.EndpointInvokerFactory;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.util.RuntimeResourceVisitor;
import org.jboss.resteasy.reactive.server.util.ScoreSystem;
import org.jboss.resteasy.reactive.server.vertx.ResteasyReactiveVertxHandler;
import org.jboss.resteasy.reactive.spi.BeanFactory;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

@Recorder
public class ResteasyReactiveRecorder
extends ResteasyReactiveCommonRecorder
implements EndpointInvokerFactory {
    private static final MethodType VOID_TYPE = MethodType.methodType(Void.TYPE);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Supplier<Executor> EXECUTOR_SUPPLIER = new Supplier<Executor>(){

        @Override
        public Executor get() {
            return ExecutorRecorder.getCurrent();
        }
    };
    public static final Supplier<Executor> VTHREAD_EXECUTOR_SUPPLIER = new Supplier<Executor>(){

        @Override
        public Executor get() {
            return VirtualThreadsRecorder.getCurrent();
        }
    };
    static volatile Deployment currentDeployment;

    public static Deployment getCurrentDeployment() {
        return currentDeployment;
    }

    public RuntimeValue<Deployment> createDeployment(String applicationPath, DeploymentInfo info, BeanContainer beanContainer, final ShutdownContext shutdownContext, VertxHttpBuildTimeConfig httpBuildTimeConfig, RequestContextFactory contextFactory, BeanFactory<ResteasyReactiveInitialiser> initClassFactory, final LaunchMode launchMode, boolean servletPresent) {
        info.setServletPresent(servletPresent);
        CurrentRequestManager.setCurrentRequestInstance((CurrentRequest)new QuarkusCurrentRequest((CurrentVertxRequest)beanContainer.beanInstance(CurrentVertxRequest.class, new Annotation[0])));
        BlockingOperationSupport.setIoThreadDetector((BlockingOperationSupport.IOThreadDetector)new BlockingOperationSupport.IOThreadDetector(){

            public boolean isBlockingAllowed() {
                return BlockingOperationControl.isBlockingAllowed();
            }
        });
        Consumer<Closeable> closeTaskHandler = new Consumer<Closeable>(){

            @Override
            public void accept(Closeable closeable) {
                shutdownContext.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable(closeable));
            }
        };
        final CurrentIdentityAssociation currentIdentityAssociation = (CurrentIdentityAssociation)Arc.container().select(CurrentIdentityAssociation.class, new Annotation[0]).orNull();
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (contextFactory == null) {
            contextFactory = new RequestContextFactory(){

                public ResteasyReactiveRequestContext createContext(Deployment deployment, Object context, ThreadSetupAction requestContext, ServerRestHandler[] handlerChain, ServerRestHandler[] abortHandlerChain) {
                    return new QuarkusResteasyReactiveRequestContext(deployment, (RoutingContext)context, requestContext, handlerChain, abortHandlerChain, launchMode == LaunchMode.DEVELOPMENT ? tccl : null, currentIdentityAssociation);
                }
            };
        }
        RuntimeDeploymentManager runtimeDeploymentManager = new RuntimeDeploymentManager(info, EXECUTOR_SUPPLIER, VTHREAD_EXECUTOR_SUPPLIER, (Consumer)closeTaskHandler, contextFactory, (ThreadSetupAction)new ArcThreadSetupAction(beanContainer.requestContext()), httpBuildTimeConfig.rootPath());
        Deployment deployment = runtimeDeploymentManager.deploy();
        DisabledRestEndpoints.set((Map)deployment.getDisabledEndpoints());
        ((ResteasyReactiveInitialiser)initClassFactory.createInstance().getInstance()).init(deployment);
        currentDeployment = deployment;
        if (LaunchMode.current() == LaunchMode.DEVELOPMENT) {
            ResourceNotFoundData.setRuntimeRoutes(this.fromClassMappers(applicationPath, deployment.getClassMappers()));
            RuntimeResourceVisitor.visitRuntimeResources((String)applicationPath, (List)deployment.getClassMappers(), (RuntimeResourceVisitor)ScoreSystem.ScoreVisitor);
        }
        return new RuntimeValue((Object)deployment);
    }

    public RuntimeValue<RestInitialHandler> restInitialHandler(RuntimeValue<Deployment> deploymentRuntimeValue) {
        Deployment deployment = (Deployment)deploymentRuntimeValue.getValue();
        return new RuntimeValue((Object)new RestInitialHandler(deployment));
    }

    public Handler<RoutingContext> handler(RuntimeValue<RestInitialHandler> restInitialHandlerRuntimeValue) {
        RestInitialHandler initialHandler = (RestInitialHandler)restInitialHandlerRuntimeValue.getValue();
        Consumer<RoutingContext> eventCustomizer = new Consumer<RoutingContext>(){

            @Override
            public void accept(RoutingContext routingContext) {
                if (routingContext.get("io.quarkus.vertx.http.auth-failure-handler") instanceof FailingDefaultAuthFailureHandler) {
                    routingContext.remove("io.quarkus.vertx.http.auth-failure-handler");
                }
            }
        };
        return new ResteasyReactiveVertxHandler((Consumer)eventCustomizer, initialHandler);
    }

    public Handler<RoutingContext> failureHandler(RuntimeValue<RestInitialHandler> restInitialHandlerRuntimeValue, final boolean noCustomAuthCompletionExMapper, final boolean noCustomAuthFailureExMapper, final boolean noCustomAuthRedirectExMapper, final boolean proactive) {
        final RestInitialHandler restInitialHandler = (RestInitialHandler)restInitialHandlerRuntimeValue.getValue();
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                boolean isOtherAuthFailure;
                if (proactive && event.get("io.quarkus.vertx.http.auth-failure-handler") instanceof HttpSecurityRecorder.DefaultAuthFailureHandler) {
                    if (event.failure() instanceof AuthenticationFailedException) {
                        if (noCustomAuthFailureExMapper) {
                            event.next();
                        } else {
                            restInitialHandler.beginProcessing((Object)event, event.failure());
                        }
                        return;
                    }
                    if (event.failure() instanceof AuthenticationCompletionException) {
                        if (noCustomAuthCompletionExMapper) {
                            event.next();
                        } else {
                            restInitialHandler.beginProcessing((Object)event, event.failure());
                        }
                        return;
                    }
                    if (event.failure() instanceof AuthenticationRedirectException) {
                        if (noCustomAuthRedirectExMapper) {
                            event.next();
                        } else {
                            restInitialHandler.beginProcessing((Object)event, event.failure());
                        }
                        return;
                    }
                }
                Throwable failure = event.failure();
                boolean bl = isOtherAuthFailure = HttpSecurityRecorder.DefaultAuthFailureHandler.isOtherAuthenticationFailure((RoutingContext)event) && ResteasyReactiveRecorder.this.isFailureHandledByExceptionMappers(failure);
                if (isOtherAuthFailure) {
                    HttpSecurityRecorder.DefaultAuthFailureHandler.removeMarkAsOtherAuthenticationFailure((RoutingContext)event);
                    restInitialHandler.beginProcessing((Object)event, failure);
                } else if (failure instanceof AuthenticationException || failure instanceof UnauthorizedException || failure instanceof ForbiddenException) {
                    restInitialHandler.beginProcessing((Object)event, failure);
                } else {
                    event.next();
                }
            }
        };
    }

    private boolean isFailureHandledByExceptionMappers(Throwable throwable) {
        return currentDeployment != null && currentDeployment.getExceptionMapper().getExceptionMapper(throwable.getClass(), null, null) != null;
    }

    public Supplier<Application> handleApplication(final Class<? extends Application> applicationClass, boolean singletonClassesEmpty) {
        Supplier<Application> applicationSupplier;
        if (singletonClassesEmpty) {
            applicationSupplier = new Supplier<Application>(){

                @Override
                public Application get() {
                    try {
                        return (Application)applicationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        } else {
            try {
                final Application application = applicationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (Object i : application.getSingletons()) {
                    SingletonBeanFactory.setInstance((String)i.getClass().getName(), i);
                }
                applicationSupplier = new Supplier<Application>(){

                    @Override
                    public Application get() {
                        return application;
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return applicationSupplier;
    }

    public void registerExceptionMapper(ExceptionMapping exceptionMapping, String string, ResourceExceptionMapper<Throwable> mapper) {
        exceptionMapping.addExceptionMapper(string, mapper);
    }

    public void registerContextResolver(ContextResolvers contextResolvers, String string, ResourceContextResolver resolver) {
        contextResolvers.addContextResolver(ResteasyReactiveRecorder.loadClass((String)string), resolver);
    }

    public Supplier<EndpointInvoker> invoker(final String invokerClassName) {
        return new Supplier<EndpointInvoker>(){

            @Override
            public EndpointInvoker get() {
                try {
                    Class invokerClass = ResteasyReactiveRecorder.loadClass((String)invokerClassName);
                    return LOOKUP.findConstructor(invokerClass, VOID_TYPE).invoke();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new UndeclaredThrowableException(t);
                }
            }
        };
    }

    public Function<Class<?>, BeanFactory<?>> factoryCreator(final BeanContainer container) {
        return new Function<Class<?>, BeanFactory<?>>(){

            @Override
            public BeanFactory<?> apply(Class<?> aClass) {
                return new ArcBeanFactory(aClass, container);
            }
        };
    }

    public Function<Object, Object> clientProxyUnwrapper() {
        return ClientProxy::unwrap;
    }

    public Supplier<Boolean> disableIfPropertyMatches(final String propertyName, final String propertyValue, final boolean disableIfMissing) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                String value = ConfigProvider.getConfig().getConfigValue(propertyName).getValue();
                if (value == null) {
                    return disableIfMissing;
                }
                return value.equals(propertyValue);
            }
        };
    }

    public ServerSerialisers createServerSerialisers() {
        return new ServerSerialisers();
    }

    public Handler<RoutingContext> defaultAuthFailureHandler(final RuntimeValue<Deployment> deployment, final boolean setTemplatePath) {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                if (event.get("io.quarkus.vertx.http.auth-failure-handler") instanceof HttpSecurityRecorder.DefaultAuthFailureHandler) {
                    if (setTemplatePath) {
                        ObservabilityIntegrationRecorder.setTemplatePath(event, (Deployment)deployment.getValue());
                    }
                    event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new FailingDefaultAuthFailureHandler());
                }
                event.next();
            }
        };
    }

    public Supplier<Boolean> beanUnavailable(final String className) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    return !Arc.container().select(Class.forName(className, false, Thread.currentThread().getContextClassLoader()), new Annotation[0]).isResolvable();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to determine if bean '" + className + "' is available", e);
                }
            }
        };
    }

    private List<RouteDescription> fromClassMappers(String applicationPath, List<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>> classMappers) {
        final HashMap descriptions = new HashMap();
        RuntimeResourceVisitor.visitRuntimeResources((String)applicationPath, classMappers, (RuntimeResourceVisitor)new RuntimeResourceVisitor(){
            private RouteDescription description;

            public void visitRuntimeResource(String httpMethod, String fullPath, RuntimeResource runtimeResource) {
                ServerMediaType serverMediaType = runtimeResource.getProduces();
                List<MediaType> produces = Collections.emptyList();
                if (serverMediaType != null && serverMediaType.getSortedOriginalMediaTypes() != null && serverMediaType.getSortedOriginalMediaTypes().length >= 1) {
                    produces = Arrays.asList(serverMediaType.getSortedOriginalMediaTypes());
                }
                this.description.addCall(new RouteMethodDescription(httpMethod, fullPath, ResteasyReactiveRecorder.this.mostPreferredOrNull(produces), ResteasyReactiveRecorder.this.mostPreferredOrNull(runtimeResource.getConsumes())));
            }

            public void visitBasePath(String basePath) {
                this.description = (RouteDescription)descriptions.get(basePath);
                if (this.description == null) {
                    this.description = new RouteDescription(basePath);
                    descriptions.put(basePath, this.description);
                }
            }
        });
        return new LinkedList<RouteDescription>(descriptions.values());
    }

    private String mostPreferredOrNull(List<MediaType> mediaTypes) {
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            return null;
        }
        return mediaTypes.get(0).toString();
    }

    private static final class FailingDefaultAuthFailureHandler
    implements BiConsumer<RoutingContext, Throwable> {
        private FailingDefaultAuthFailureHandler() {
        }

        @Override
        public void accept(RoutingContext event, Throwable throwable) {
            HttpSecurityRecorder.DefaultAuthFailureHandler.markIfOtherAuthenticationFailure((RoutingContext)event, (Throwable)throwable);
            if (!event.failed()) {
                event.fail(HttpSecurityRecorder.DefaultAuthFailureHandler.extractRootCause((Throwable)throwable));
            }
        }
    }
}

