/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.panache.common.deployment.ByteCodeType;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheFieldAccessMethodVisitor;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerVisitor;
import io.quarkus.panache.common.deployment.PanacheMovingAnnotationVisitor;
import io.quarkus.panache.common.deployment.TypeBundle;
import io.quarkus.panache.common.deployment.visitors.KotlinPanacheClassVisitor;
import io.quarkus.panache.common.deployment.visitors.PanacheRepositoryClassVisitor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public abstract class PanacheEntityClassVisitor<EntityFieldType extends EntityField>
extends ClassVisitor {
    protected org.objectweb.asm.Type thisClass;
    protected final Map<String, ? extends EntityFieldType> fields;
    private final Set<String> userMethods = new HashSet<String>();
    private final MetamodelInfo<?> modelInfo;
    protected TypeBundle typeBundle;
    protected final ClassInfo panacheEntityBaseClassInfo;
    protected ClassInfo entityInfo;
    protected List<PanacheMethodCustomizer> methodCustomizers;
    protected final Map<String, ByteCodeType> typeArguments = new HashMap<String, ByteCodeType>();
    protected final Function<String, String> argMapper;
    protected final ByteCodeType entityUpperBound;
    private final Map<String, String> erasures = new HashMap<String, String>();

    public PanacheEntityClassVisitor(ClassVisitor outputClassVisitor, MetamodelInfo<? extends EntityModel<? extends EntityFieldType>> modelInfo, TypeBundle typeBundle, ClassInfo entityInfo, List<PanacheMethodCustomizer> methodCustomizers, IndexView indexView) {
        super(589824, outputClassVisitor);
        String className = entityInfo.name().toString();
        this.thisClass = org.objectweb.asm.Type.getType((String)("L" + className.replace('.', '/') + ";"));
        this.modelInfo = modelInfo;
        this.typeBundle = typeBundle;
        EntityModel<? extends EntityFieldType> entityModel = modelInfo.getEntityModel(className);
        this.fields = entityModel != null ? entityModel.fields : null;
        this.panacheEntityBaseClassInfo = indexView.getClassByName(typeBundle.entityBase().dotName());
        this.entityInfo = entityInfo;
        this.methodCustomizers = methodCustomizers;
        ByteCodeType baseType = typeBundle.entityBase();
        List typeVariables = indexView.getClassByName(baseType.dotName()).typeParameters();
        this.entityUpperBound = !typeVariables.isEmpty() ? new ByteCodeType((Type)((TypeVariable)typeVariables.get(0)).bounds().get(0)) : null;
        this.discoverTypeParameters(entityInfo, indexView, typeBundle, baseType);
        this.argMapper = type -> {
            ByteCodeType byteCodeType = this.typeArguments.get(type);
            return byteCodeType != null ? byteCodeType.descriptor() : KotlinPanacheClassVisitor.OBJECT.descriptor();
        };
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (this.fields == null || this.fields.isEmpty()) {
            return super.visitField(access, name, descriptor, signature, value);
        }
        final EntityField ef = (EntityField)this.fields.get(name);
        if (ef == null) {
            return super.visitField(access, name, descriptor, signature, value);
        }
        FieldVisitor superVisitor = name.equals("id") ? super.visitField(access, name, descriptor, signature, value) : super.visitField((access | 4) & 0xFFFFFFFC, name, descriptor, signature, value);
        ef.signature = signature;
        return new FieldVisitor(589824, superVisitor){

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if (!descriptor.startsWith("Ljavax/xml/bind/annotation/")) {
                    return super.visitAnnotation(descriptor, visible);
                }
                EntityField.EntityFieldAnnotation efAnno = new EntityField.EntityFieldAnnotation(descriptor);
                ef.annotations.add(efAnno);
                return new PanacheMovingAnnotationVisitor(efAnno);
            }

            public void visitEnd() {
                super.visitAnnotation("Ljavax/xml/bind/annotation/XmlTransient;", true);
                super.visitEnd();
            }
        };
    }

    public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this.userMethods.add(methodName + "/" + descriptor);
        MethodVisitor superVisitor = super.visitMethod(access, methodName, descriptor, signature, exceptions);
        if (Modifier.isStatic(access) && Modifier.isPublic(access) && (access & 0x1000) == 0 && !this.methodCustomizers.isEmpty()) {
            Object[] argTypes = AsmUtil.getParameterTypes((String)descriptor);
            MethodInfo method = this.entityInfo.method(methodName, (Type[])argTypes);
            if (method == null) {
                throw new IllegalStateException("Could not find indexed method: " + this.thisClass + "." + methodName + " with descriptor " + descriptor + " and arg types " + Arrays.toString(argTypes));
            }
            superVisitor = new PanacheMethodCustomizerVisitor(superVisitor, method, this.thisClass, this.methodCustomizers);
        }
        return new PanacheFieldAccessMethodVisitor(superVisitor, this.thisClass.getInternalName(), methodName, descriptor, this.modelInfo);
    }

    public void visitEnd() {
        for (MethodInfo method : this.panacheEntityBaseClassInfo.methods()) {
            AnnotationInstance bridge;
            String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> null);
            if (this.userMethods.contains(method.name() + "/" + descriptor) || (bridge = method.annotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE)) == null) continue;
            this.generateMethod(method, bridge.value("targetReturnTypeErased"));
        }
        this.generateAccessors();
        super.visitEnd();
    }

    protected void discoverTypeParameters(ClassInfo classInfo, IndexView indexView, TypeBundle types, ByteCodeType baseType) {
        List<ByteCodeType> foundTypeArguments = KotlinPanacheClassVisitor.recursivelyFindEntityTypeArguments(indexView, classInfo.name(), baseType.dotName());
        ByteCodeType entityType = foundTypeArguments.size() > 0 ? foundTypeArguments.get(0) : KotlinPanacheClassVisitor.OBJECT;
        ByteCodeType idType = foundTypeArguments.size() > 1 ? foundTypeArguments.get(1) : KotlinPanacheClassVisitor.OBJECT;
        this.typeArguments.put("Entity", entityType);
        this.typeArguments.put("Id", idType);
        this.typeArguments.keySet().stream().filter(k -> !k.equals("Id")).forEach(k -> this.erasures.put((String)k, KotlinPanacheClassVisitor.OBJECT.descriptor()));
        try {
            ByteCodeType entity = this.typeArguments.get("Entity");
            if (entity != null) {
                this.erasures.put(entity.dotName().toString(), entity.descriptor());
            }
            this.erasures.put(types.queryType().dotName().toString(), KotlinPanacheClassVisitor.OBJECT.descriptor());
            this.erasures.put(types.updateType().dotName().toString(), KotlinPanacheClassVisitor.OBJECT.descriptor());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected void generateMethod(MethodInfo method, AnnotationValue targetReturnTypeErased) {
        List parameters = method.parameters();
        MethodVisitor mv = super.visitMethod(4105, method.name(), AsmUtil.getDescriptor((MethodInfo)method, name -> null), AsmUtil.getSignature((MethodInfo)method, name1 -> null), null);
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        mv.visitCode();
        for (PanacheMethodCustomizer customizer : this.methodCustomizers) {
            customizer.customize(this.thisClass, method, mv);
        }
        this.loadOperations(mv);
        this.loadArguments(mv, parameters);
        this.invokeOperations(mv, method);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void loadOperations(MethodVisitor mv) {
        mv.visitFieldInsn(178, this.typeBundle.operations().internalName(), "INSTANCE", this.typeBundle.operations().descriptor());
    }

    private void loadArguments(MethodVisitor mv, List<Type> parameters) {
        this.injectModel(mv);
        for (int i = 0; i < parameters.size(); ++i) {
            mv.visitIntInsn(25, i);
        }
    }

    private void invokeOperations(MethodVisitor mv, MethodInfo method) {
        StringJoiner joiner = new StringJoiner("", "(", ")");
        joiner.add(PanacheRepositoryClassVisitor.CLASS.descriptor());
        this.descriptors(method, joiner);
        Type returnType = method.returnType();
        String descriptor = AsmUtil.getDescriptor((Type)returnType, this.argMapper);
        String key = returnType.kind() == Type.Kind.TYPE_VARIABLE ? returnType.asTypeVariable().identifier() : returnType.name().toString();
        String operationDescriptor = joiner + this.erasures.getOrDefault(key, descriptor);
        mv.visitMethodInsn(182, this.typeBundle.operations().internalName(), method.name(), operationDescriptor, false);
        if (returnType.kind() != Type.Kind.PRIMITIVE) {
            String cast;
            if (returnType.kind() == Type.Kind.TYPE_VARIABLE) {
                TypeVariable typeVariable = returnType.asTypeVariable();
                ByteCodeType type = this.typeArguments.get(typeVariable.identifier());
                type = type == null && typeVariable.bounds().size() != 1 ? KotlinPanacheClassVisitor.OBJECT : new ByteCodeType((Type)typeVariable.bounds().get(0));
                cast = type.internalName();
            } else {
                cast = returnType.name().toString().replace('.', '/');
            }
            mv.visitTypeInsn(192, cast);
        }
        mv.visitInsn(AsmUtil.getReturnInstruction((Type)returnType));
    }

    private void descriptors(MethodInfo method, StringJoiner joiner) {
        for (Type parameter : method.parameters()) {
            if (parameter.kind() == Type.Kind.TYPE_VARIABLE || method.name().endsWith("ById") && parameter.name().equals((Object)this.typeArguments.get("Id").dotName())) {
                joiner.add(KotlinPanacheClassVisitor.OBJECT.descriptor());
                continue;
            }
            joiner.add(this.mapType(parameter));
        }
    }

    private String mapType(Type parameter) {
        String descriptor;
        switch (parameter.kind()) {
            case PRIMITIVE: 
            case TYPE_VARIABLE: {
                descriptor = KotlinPanacheClassVisitor.OBJECT.descriptor();
                break;
            }
            default: {
                String value = AsmUtil.getDescriptor((Type)parameter, this.argMapper);
                descriptor = this.erasures.getOrDefault(value, value);
            }
        }
        return descriptor;
    }

    protected void injectModel(MethodVisitor mv) {
        mv.visitLdcInsn((Object)this.thisClass);
    }

    protected void generateAccessors() {
        if (this.fields == null) {
            return;
        }
        for (EntityField field : this.fields.values()) {
            int loadCode;
            String getterName = field.getGetterName();
            String getterDescriptor = "()" + field.descriptor;
            if (!this.userMethods.contains(getterName + "/" + getterDescriptor)) {
                MethodVisitor mv = super.visitMethod(1, getterName, getterDescriptor, field.signature == null ? null : "()" + field.signature, null);
                mv.visitCode();
                mv.visitIntInsn(25, 0);
                this.generateAccessorGetField(mv, field);
                int returnCode = AsmUtil.getReturnInstruction((String)field.descriptor);
                mv.visitInsn(returnCode);
                mv.visitMaxs(0, 0);
                for (EntityField.EntityFieldAnnotation anno : field.annotations) {
                    anno.writeToVisitor(mv);
                }
                if (this.shouldAddJsonProperty(field)) {
                    AnnotationValue jsonPropertyValue;
                    AnnotationInstance jsonPropertyInstance;
                    AnnotationVisitor visitor = mv.visitAnnotation("Lcom/fasterxml/jackson/annotation/JsonProperty;", true);
                    FieldInfo fieldInfo = this.entityInfo.field(field.name);
                    if (fieldInfo != null && (jsonPropertyInstance = fieldInfo.annotation(PanacheEntityEnhancer.JSON_PROPERTY_DOT_NAME)) != null && (jsonPropertyValue = jsonPropertyInstance.value()) != null && !jsonPropertyValue.asString().isEmpty()) {
                        visitor.visit("value", (Object)jsonPropertyValue.asString());
                    }
                    visitor.visitEnd();
                }
                mv.visitEnd();
            }
            String setterName = field.getSetterName();
            String setterDescriptor = "(" + field.descriptor + ")V";
            if (this.userMethods.contains(setterName + "/" + setterDescriptor)) continue;
            MethodVisitor mv = super.visitMethod(1, setterName, setterDescriptor, field.signature == null ? null : "(" + field.signature + ")V", null);
            mv.visitCode();
            mv.visitIntInsn(25, 0);
            switch (field.descriptor) {
                case "Z": 
                case "B": 
                case "C": 
                case "S": 
                case "I": {
                    loadCode = 21;
                    break;
                }
                case "J": {
                    loadCode = 22;
                    break;
                }
                case "F": {
                    loadCode = 23;
                    break;
                }
                case "D": {
                    loadCode = 24;
                    break;
                }
                default: {
                    loadCode = 25;
                }
            }
            mv.visitIntInsn(loadCode, 1);
            this.generateAccessorSetField(mv, field);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private boolean shouldAddJsonProperty(EntityField entityField) {
        if (this.isAnnotatedWithJsonIgnore(entityField)) {
            return false;
        }
        return !entityField.hasAnnotation("Lcom/fasterxml/jackson/annotation/JsonProperty;");
    }

    private boolean isAnnotatedWithJsonIgnore(EntityField entityField) {
        FieldInfo field = this.entityInfo.field(entityField.name);
        if (field != null) {
            return field.hasAnnotation(PanacheEntityEnhancer.JSON_IGNORE_DOT_NAME);
        }
        return false;
    }

    protected abstract void generateAccessorSetField(MethodVisitor var1, EntityField var2);

    protected abstract void generateAccessorGetField(MethodVisitor var1, EntityField var2);
}

