/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.merger;

import io.quarkus.annotation.processor.documentation.config.merger.JavadocRepository;
import io.quarkus.annotation.processor.documentation.config.merger.MergedModel;
import io.quarkus.annotation.processor.documentation.config.model.AbstractConfigItem;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemCollection;
import io.quarkus.annotation.processor.documentation.config.model.ConfigRoot;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.Extension;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.model.ResolvedModel;
import io.quarkus.annotation.processor.documentation.config.util.JacksonMappers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class ModelMerger {
    private ModelMerger() {
    }

    public static MergedModel mergeModel(List<Path> buildOutputDirectories) {
        return ModelMerger.mergeModel(null, buildOutputDirectories);
    }

    public static MergedModel mergeModel(JavadocRepository javadocRepository, List<Path> buildOutputDirectories) {
        return ModelMerger.mergeModel(javadocRepository, buildOutputDirectories, false);
    }

    public static MergedModel mergeModel(List<Path> buildOutputDirectories, boolean mergeCommonOrInternalExtensions) {
        return ModelMerger.mergeModel(null, buildOutputDirectories, mergeCommonOrInternalExtensions);
    }

    public static MergedModel mergeModel(JavadocRepository javadocRepository, List<Path> buildOutputDirectories, boolean mergeCommonOrInternalExtensions) {
        Map<Extension, Map<MergedModel.ConfigRootKey, ConfigRoot>> configRoots = new HashMap<Extension, Map<MergedModel.ConfigRootKey, ConfigRoot>>();
        TreeMap<String, ConfigRoot> configRootsInSpecificFile = new TreeMap<String, ConfigRoot>();
        HashMap<Extension, List<ConfigSection>> generatedConfigSections = new HashMap<Extension, List<ConfigSection>>();
        for (Path path : buildOutputDirectories) {
            Path resolvedModelPath = path.resolve("quarkus-config-doc/quarkus-config-model.yaml");
            if (!Files.isReadable(resolvedModelPath)) continue;
            try {
                InputStream resolvedModelIs = Files.newInputStream(resolvedModelPath, new OpenOption[0]);
                try {
                    ResolvedModel resolvedModel = (ResolvedModel)JacksonMappers.yamlObjectReader().readValue(resolvedModelIs, ResolvedModel.class);
                    if (resolvedModel.getConfigRoots() == null || resolvedModel.getConfigRoots().isEmpty()) continue;
                    for (ConfigRoot configRoot : resolvedModel.getConfigRoots()) {
                        MergedModel.ConfigRootKey configRootKey;
                        if (configRoot.getOverriddenDocFileName() != null) {
                            ConfigRoot existingConfigRootInSpecificFile = (ConfigRoot)configRootsInSpecificFile.get(configRoot.getOverriddenDocFileName());
                            if (existingConfigRootInSpecificFile == null) {
                                configRootsInSpecificFile.put(configRoot.getOverriddenDocFileName(), configRoot);
                                continue;
                            }
                            if (!existingConfigRootInSpecificFile.getExtension().equals(configRoot.getExtension()) || !existingConfigRootInSpecificFile.getPrefix().equals(configRoot.getPrefix())) {
                                throw new IllegalStateException("Two config roots with different extensions or prefixes cannot be merged in the same specific config file: " + configRoot.getOverriddenDocFileName());
                            }
                            existingConfigRootInSpecificFile.merge(configRoot);
                            continue;
                        }
                        Map extensionConfigRoots = configRoots.computeIfAbsent(ModelMerger.normalizeExtension(configRoot.getExtension(), mergeCommonOrInternalExtensions), e -> new TreeMap());
                        ConfigRoot existingConfigRoot = (ConfigRoot)extensionConfigRoots.get(configRootKey = ModelMerger.getConfigRootKey(javadocRepository, configRoot));
                        if (existingConfigRoot == null) {
                            extensionConfigRoots.put(configRootKey, configRoot);
                            continue;
                        }
                        existingConfigRoot.merge(configRoot);
                    }
                }
                finally {
                    if (resolvedModelIs == null) continue;
                    resolvedModelIs.close();
                }
            }
            catch (IOException e2) {
                throw new IllegalStateException("Unable to parse: " + String.valueOf(resolvedModelPath), e2);
            }
        }
        configRoots = ModelMerger.retainBestExtensionKey(configRoots);
        for (Map.Entry entry : configRoots.entrySet()) {
            List extensionGeneratedConfigSections = generatedConfigSections.computeIfAbsent((Extension)entry.getKey(), e -> new ArrayList());
            for (ConfigRoot configRoot : ((Map)entry.getValue()).values()) {
                ModelMerger.collectGeneratedConfigSections(extensionGeneratedConfigSections, configRoot);
            }
        }
        return new MergedModel(configRoots, configRootsInSpecificFile, generatedConfigSections);
    }

    private static Extension normalizeExtension(Extension extension, boolean mergeCommonOrInternalExtensions) {
        if (!mergeCommonOrInternalExtensions) {
            return extension;
        }
        if (extension.commonOrInternal()) {
            return extension.normalizeCommonOrInternal();
        }
        return extension;
    }

    private static Map<Extension, Map<MergedModel.ConfigRootKey, ConfigRoot>> retainBestExtensionKey(Map<Extension, Map<MergedModel.ConfigRootKey, ConfigRoot>> configRoots) {
        return configRoots.entrySet().stream().collect(Collectors.toMap(e -> {
            Extension extension = (Extension)e.getKey();
            for (ConfigRoot configRoot : ((Map)e.getValue()).values()) {
                if (configRoot.getExtension().nameSource().isBetterThan(extension.nameSource())) {
                    extension = configRoot.getExtension();
                }
                if (!Extension.NameSource.EXTENSION_METADATA.equals((Object)extension.nameSource())) continue;
                break;
            }
            return extension;
        }, e -> (Map)e.getValue(), (k1, k2) -> k1, TreeMap::new));
    }

    private static void collectGeneratedConfigSections(List<ConfigSection> extensionGeneratedConfigSections, ConfigItemCollection configItemCollection) {
        for (AbstractConfigItem configItem : configItemCollection.getItems()) {
            if (!configItem.isSection()) continue;
            ConfigSection configSection = (ConfigSection)configItem;
            if (configSection.isGenerated()) {
                extensionGeneratedConfigSections.add(configSection);
            }
            ModelMerger.collectGeneratedConfigSections(extensionGeneratedConfigSections, configSection);
        }
    }

    private static MergedModel.ConfigRootKey getConfigRootKey(JavadocRepository javadocRepository, ConfigRoot configRoot) {
        return new MergedModel.ConfigRootKey(configRoot.getTopLevelPrefix(), ModelMerger.getConfigRootDescription(javadocRepository, configRoot));
    }

    private static String getConfigRootDescription(JavadocRepository javadocRepository, ConfigRoot configRoot) {
        if (!configRoot.getExtension().splitOnConfigRootDescription()) {
            return null;
        }
        if (javadocRepository == null) {
            return null;
        }
        String description = null;
        for (String qualifiedName : configRoot.getQualifiedNames()) {
            Optional<JavadocElements.JavadocElement> javadocElement = javadocRepository.getElement(qualifiedName);
            if (javadocElement.isEmpty()) {
                return null;
            }
            String descriptionCandidate = ModelMerger.trimFinalDot(javadocElement.get().description());
            if (description == null) {
                description = descriptionCandidate;
                continue;
            }
            if (description.equals(descriptionCandidate)) continue;
            return null;
        }
        return description;
    }

    private static String trimFinalDot(String javadoc) {
        if (javadoc == null || javadoc.isBlank()) {
            return null;
        }
        int dotIndex = (javadoc = javadoc.trim()).indexOf(".");
        if (dotIndex == -1) {
            return javadoc;
        }
        return javadoc.substring(0, dotIndex);
    }
}

