/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.platform.catalog.processor.CatalogProcessor;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ResourceLoaders;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.config.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.aether.artifact.Artifact;

public final class CodestartResourceLoadersBuilder {
    private static final String BASE_CODESTARTS_ARTIFACT_PROPERTY = "quarkus-base-codestart-artifact";
    private static final String BASE_CODESTARTS_ARTIFACT_PROPERTIES_NAME = "/quarkus-devtools-base-codestarts.properties";
    private static final String BASE_CODESTARTS_ARTIFACT_COORDS = CodestartResourceLoadersBuilder.retrieveBaseCodestartsArtifactCoords();
    private ExtensionCatalog catalog = null;
    private MavenArtifactResolver artifactResolver;
    private String baseCodestartsArtifactCoords = BASE_CODESTARTS_ARTIFACT_COORDS;
    private Collection<String> extraCodestartsArtifactCoords = new ArrayList<String>();

    private static String retrieveBaseCodestartsArtifactCoords() {
        String string;
        block9: {
            String artifact = PropertiesUtil.getProperty((String)BASE_CODESTARTS_ARTIFACT_PROPERTY);
            if (artifact != null) {
                return artifact;
            }
            InputStream resource = QuarkusProjectHelper.class.getResourceAsStream(BASE_CODESTARTS_ARTIFACT_PROPERTIES_NAME);
            try {
                Properties properties = new Properties();
                Objects.requireNonNull(resource, "/quarkus-devtools-base-codestarts.properties resource not found.");
                properties.load(resource);
                string = Objects.requireNonNull(properties.getProperty("artifact"), "base codestarts 'artifact' property not found");
                if (resource == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Couldn't load the base codestarts artifact properties", e);
                }
            }
            resource.close();
        }
        return string;
    }

    private CodestartResourceLoadersBuilder() {
    }

    public static CodestartResourceLoadersBuilder codestartLoadersBuilder() {
        return new CodestartResourceLoadersBuilder();
    }

    public static List<ResourceLoader> getCodestartResourceLoaders() {
        return CodestartResourceLoadersBuilder.codestartLoadersBuilder().build();
    }

    public static List<ResourceLoader> getCodestartResourceLoaders(ExtensionCatalog catalog) {
        return CodestartResourceLoadersBuilder.codestartLoadersBuilder().catalog(catalog).build();
    }

    public CodestartResourceLoadersBuilder catalog(ExtensionCatalog catalog) {
        this.catalog = catalog;
        return this;
    }

    public CodestartResourceLoadersBuilder artifactResolver(MavenArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
        return this;
    }

    public CodestartResourceLoadersBuilder baseCodestartsArtifactCoords(String baseCodestartsArtifactCoords) {
        this.baseCodestartsArtifactCoords = baseCodestartsArtifactCoords;
        return this;
    }

    public CodestartResourceLoadersBuilder noBaseCodestarts() {
        this.baseCodestartsArtifactCoords = null;
        return this;
    }

    public CodestartResourceLoadersBuilder addExtraCodestartsArtifactCoords(Collection<String> extraCodestartsArtifactCoords) {
        this.extraCodestartsArtifactCoords.addAll(extraCodestartsArtifactCoords);
        return this;
    }

    public List<ResourceLoader> build() {
        return CodestartResourceLoadersBuilder.getCodestartResourceLoaders(this.baseCodestartsArtifactCoords, this.extraCodestartsArtifactCoords, this.catalog, this.artifactResolver == null ? QuarkusProjectHelper.artifactResolver() : this.artifactResolver);
    }

    private static List<ResourceLoader> getCodestartResourceLoaders(String baseCodestartsArtifactCoords, Collection<String> extraCodestartsArtifactCoords, ExtensionCatalog catalog, MavenArtifactResolver mvn) {
        String coords;
        LinkedHashMap<String, Artifact> codestartsArtifacts = new LinkedHashMap<String, Artifact>();
        if (catalog != null) {
            for (Extension e : catalog.getExtensions()) {
                coords = ExtensionProcessor.getCodestartArtifact(e);
                if (coords == null || codestartsArtifacts.containsKey(coords)) continue;
                codestartsArtifacts.put(coords, DependencyUtils.toArtifact((String)coords));
            }
        }
        if (baseCodestartsArtifactCoords != null) {
            codestartsArtifacts.put(baseCodestartsArtifactCoords, DependencyUtils.toArtifact((String)baseCodestartsArtifactCoords));
        }
        if (catalog != null) {
            Extension e;
            List<String> catalogCodestartArtifacts = CatalogProcessor.getCodestartArtifacts(catalog);
            e = catalogCodestartArtifacts.iterator();
            while (e.hasNext()) {
                coords = (String)e.next();
                if (codestartsArtifacts.containsKey(coords)) {
                    codestartsArtifacts.remove(coords);
                }
                codestartsArtifacts.put(coords, DependencyUtils.toArtifact((String)coords));
            }
        }
        for (String coords2 : extraCodestartsArtifactCoords) {
            if (codestartsArtifacts.containsKey(coords2)) {
                codestartsArtifacts.remove(coords2);
            }
            codestartsArtifacts.put(coords2, DependencyUtils.toArtifact((String)coords2));
        }
        ArrayList<ResourceLoader> codestartResourceLoaders = new ArrayList<ResourceLoader>(codestartsArtifacts.size());
        for (Artifact a : codestartsArtifacts.values()) {
            try {
                File artifactFile = mvn.resolve(a).getArtifact().getFile();
                codestartResourceLoaders.add(ResourceLoaders.resolveFileResourceLoader(artifactFile));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve codestart artifact " + a, e);
            }
        }
        return codestartResourceLoaders;
    }
}

