/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.SelectionResult;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

final class QuarkusCommandHandlers {
    private QuarkusCommandHandlers() {
    }

    static List<Extension> computeExtensionsFromQuery(ExtensionCatalog catalog, Set<String> extensionsQuery, MessageWriter log) {
        ArrayList<Extension> builder = new ArrayList<Extension>();
        Collection extensionCatalog = catalog.getExtensions();
        for (String query : extensionsQuery) {
            int countColons = StringUtils.countMatches((CharSequence)query, (CharSequence)":");
            if (countColons > 1) {
                ArtifactCoords artifact = ArtifactCoords.fromString((String)query);
                Extension ext = Extension.builder().setArtifact(artifact).setName(artifact.getArtifactId()).build();
                builder.add(ext);
                continue;
            }
            SelectionResult result = null;
            if (countColons == 1) {
                ArtifactKey key = ArtifactKey.fromString((String)query);
                for (Extension ext : extensionCatalog) {
                    if (!ext.getArtifact().getKey().equals((Object)key)) continue;
                    result = new SelectionResult(Collections.singletonList(ext), true);
                    break;
                }
                if (result == null) {
                    result = new SelectionResult(Collections.emptyList(), false);
                }
            } else {
                result = QuarkusCommandHandlers.select(query, extensionCatalog, false);
            }
            if (result.matches()) {
                builder.addAll(result.getExtensions());
                continue;
            }
            StringBuilder sb = new StringBuilder();
            Collection<Extension> candidates = result.getExtensions();
            if (candidates.isEmpty()) {
                log.error("Cannot find a dependency matching '" + query + "', maybe a typo?");
                return null;
            }
            sb.append(MessageIcons.ERROR_ICON + " Multiple extensions matching '").append(query).append("'");
            candidates.forEach(extension -> sb.append(System.lineSeparator()).append("     - ").append(extension.managementKey()));
            sb.append(System.lineSeparator()).append("     try using the exact name or the full GAV (group id, artifact id, and version).");
            log.info(sb.toString());
            return null;
        }
        return builder;
    }

    static List<ArtifactCoords> computeCoordsFromQuery(QuarkusCommandInvocation invocation, Set<String> extensionsQuery) {
        List<Extension> extensions = QuarkusCommandHandlers.computeExtensionsFromQuery(invocation.getExtensionsCatalog(), extensionsQuery, invocation.log());
        return extensions == null ? null : extensions.stream().map(e -> Extensions.stripVersion(e.getArtifact())).collect(Collectors.toList());
    }

    static SelectionResult select(String query, Collection<Extension> allExtensions, boolean labelLookup) {
        String q = query.trim().toLowerCase();
        LinkedHashMap matches = new LinkedHashMap();
        if (!QuarkusCommandHandlers.isExpression(q)) {
            allExtensions.stream().filter(extension -> extension.getName().equalsIgnoreCase(q) || QuarkusCommandHandlers.matchesArtifactId(extension.getArtifact().getArtifactId(), q)).forEach(e -> matches.putIfAbsent(e.getArtifact().getKey(), e));
            if (matches.size() == 1) {
                return new SelectionResult(matches.values(), true);
            }
            List<Extension> listedExtensions = QuarkusCommandHandlers.getListedExtensions(allExtensions);
            listedExtensions.stream().filter(extension -> QuarkusCommandHandlers.matchesShortName(extension, q)).forEach(e -> matches.putIfAbsent(e.getArtifact().getKey(), e));
            if (matches.size() == 1) {
                return new SelectionResult(matches.values(), true);
            }
            listedExtensions.stream().filter(extension -> extension.getName().toLowerCase().contains(q) || extension.getArtifact().getArtifactId().toLowerCase().contains(q) || ExtensionProcessor.getShortName(extension).toLowerCase().contains(q)).forEach(e -> matches.putIfAbsent(e.getArtifact().getKey(), e));
            if (matches.size() == 1) {
                return new SelectionResult(matches.values(), true);
            }
            if (labelLookup) {
                listedExtensions.stream().filter(extension -> ExtensionProcessor.getExtendedKeywords(extension).contains(q)).forEach(e -> matches.put(e.getArtifact().getKey(), e));
            }
            return new SelectionResult(matches.values(), false);
        }
        List<Extension> listedExtensions = QuarkusCommandHandlers.getListedExtensions(allExtensions);
        Pattern pattern = QuarkusCommandHandlers.toRegex(q);
        if (pattern != null) {
            listedExtensions.stream().filter(extension -> pattern.matcher(extension.getName().toLowerCase()).matches() || pattern.matcher(extension.getArtifact().getArtifactId().toLowerCase()).matches() || pattern.matcher(ExtensionProcessor.getShortName(extension).toLowerCase()).matches() || QuarkusCommandHandlers.matchLabels(pattern, ExtensionProcessor.getExtendedKeywords(extension))).forEach(e -> matches.putIfAbsent(e.getArtifact().getKey(), e));
        }
        return new SelectionResult(matches.values(), !matches.isEmpty());
    }

    private static List<Extension> getListedExtensions(Collection<Extension> allExtensions) {
        return allExtensions.stream().filter(e -> !ExtensionProcessor.isUnlisted(e)).collect(Collectors.toList());
    }

    private static boolean matchLabels(Pattern pattern, Collection<String> labels) {
        boolean matches = false;
        for (String label : labels) {
            matches = matches || pattern.matcher(label.toLowerCase()).matches();
        }
        return matches;
    }

    private static Pattern toRegex(String str) {
        try {
            String wildcardToRegex = QuarkusCommandHandlers.wildcardToRegex(str);
            if (wildcardToRegex != null && !wildcardToRegex.isEmpty()) {
                return Pattern.compile(wildcardToRegex);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static String wildcardToRegex(String wildcard) {
        if (!QuarkusCommandHandlers.isExpression(wildcard)) {
            return null;
        }
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append("^.*");
        int is = wildcard.length();
        block6: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block6;
                }
                case '?': {
                    s.append(".");
                    continue block6;
                }
                case '^': {
                    s.append("\\");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block6;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append(".*$");
        return s.toString();
    }

    private static boolean isExpression(String s) {
        return s == null || s.isEmpty() ? false : s.contains("*") || s.contains("?");
    }

    private static boolean matchesShortName(Extension extension, String q) {
        return q.equalsIgnoreCase(ExtensionProcessor.getShortName(extension));
    }

    private static boolean matchesArtifactId(String artifactId, String q) {
        return artifactId.equalsIgnoreCase(q) || artifactId.equalsIgnoreCase("quarkus-" + q);
    }
}

