/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartResource;
import io.quarkus.devtools.codestarts.CodestartStructureException;
import io.quarkus.devtools.codestarts.core.CodestartData;
import io.quarkus.devtools.codestarts.core.CodestartPathProcessor;
import io.quarkus.devtools.codestarts.core.reader.CodestartFileReader;
import io.quarkus.devtools.codestarts.core.reader.TargetFile;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategy;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.core.strategy.DefaultCodestartFileStrategyHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

final class CodestartProcessor {
    private final MessageWriter log;
    private final String languageName;
    private final Path targetDirectory;
    private final List<CodestartFileStrategy> strategies;
    private final Map<String, Object> data;
    private final Map<String, List<TargetFile>> files = new LinkedHashMap<String, List<TargetFile>>();

    CodestartProcessor(MessageWriter log, String languageName, Path targetDirectory, List<CodestartFileStrategy> strategies, Map<String, Object> data) {
        this.log = log;
        this.languageName = languageName;
        this.targetDirectory = targetDirectory;
        this.strategies = strategies;
        this.data = data;
    }

    void process(CodestartResource projectResource, Codestart codestart) {
        this.log.debug("processing codestart '%s'...", new Object[]{codestart.getName()});
        this.addBuiltinData();
        codestart.use(l -> {
            Map<String, Object> finalData = CodestartData.buildCodestartData(codestart, this.languageName, this.data);
            this.log.debug("codestart data: %s", new Object[]{finalData});
            Stream.of("base", this.languageName).filter(l::dirExists).forEach(languageDir -> this.processLanguageDir(projectResource, (CodestartResource)l, (String)languageDir, finalData));
        });
    }

    public void checkTargetDir() throws IOException {
        if (!Files.exists(this.targetDirectory, new LinkOption[0])) {
            boolean mkdirStatus = this.targetDirectory.toFile().mkdirs();
            if (!mkdirStatus) {
                throw new IOException("Failed to create the project directory: " + this.targetDirectory);
            }
            return;
        }
        if (!Files.isDirectory(this.targetDirectory, new LinkOption[0])) {
            throw new IOException("Project path needs to point to a directory: " + this.targetDirectory);
        }
        String[] files = this.targetDirectory.toFile().list();
        if (files != null && files.length > 0) {
            throw new IOException("You can't create a project when the directory is not empty: " + this.targetDirectory);
        }
    }

    public void writeFiles() throws IOException {
        for (Map.Entry<String, List<TargetFile>> e : this.files.entrySet()) {
            String relativePath = e.getKey();
            CodestartFileStrategyHandler strategy = this.getStrategy(relativePath).orElse(this.getSelectedDefaultStrategy());
            this.log.debug("processing file '%s' with strategy %s", new Object[]{relativePath, strategy.name()});
            strategy.process(this.targetDirectory, relativePath, e.getValue(), this.data);
        }
    }

    public static List<CodestartFileStrategy> buildStrategies(Map<String, String> spec) {
        ArrayList<CodestartFileStrategy> codestartFileStrategyHandlers = new ArrayList<CodestartFileStrategy>(spec.size());
        for (Map.Entry<String, String> entry : spec.entrySet()) {
            CodestartFileStrategyHandler handler = CodestartFileStrategyHandler.BY_NAME.get(entry.getValue());
            if (handler == null) {
                throw new CodestartStructureException("ConflictStrategyHandler named '" + entry.getValue() + "' not found. Used with filter '" + entry.getKey() + "'");
            }
            codestartFileStrategyHandlers.add(new CodestartFileStrategy(entry.getKey(), handler));
        }
        return codestartFileStrategyHandlers;
    }

    void addBuiltinData() {
        this.data.put("gen-info", Collections.singletonMap("time", System.currentTimeMillis()));
    }

    void processLanguageDir(CodestartResource projectResource, CodestartResource resource, String languageDir, Map<String, Object> finalData) {
        this.log.debug("processing dir: %s", new Object[]{resource.pathName()});
        List<CodestartResource.Source> sources = resource.listSources(languageDir);
        for (CodestartResource.Source source : sources) {
            this.log.debug("found sourceName file: %s", new Object[]{resource.pathName(), source.absolutePath()});
            String sourceFileName = source.getFileName();
            Optional<CodestartFileReader> possibleReader = CodestartFileReader.ALL.stream().filter(r -> r.matches(sourceFileName)).findFirst();
            CodestartFileReader reader = possibleReader.orElse(CodestartFileReader.DEFAULT);
            this.log.debug("using reader: %s", new Object[]{reader.getClass().getName()});
            String targetFileName = reader.cleanFileName(sourceFileName);
            String fileDir = source.getFileDir();
            String relativeTargetPath = "".equals(fileDir) ? targetFileName : fileDir + targetFileName;
            boolean hasFileStrategyHandler = this.getStrategy(relativeTargetPath).isPresent();
            try {
                String processedRelativeTargetPath = CodestartPathProcessor.process(relativeTargetPath, finalData);
                if (!possibleReader.isPresent() && !hasFileStrategyHandler) {
                    Path targetPath = this.targetDirectory.resolve(processedRelativeTargetPath);
                    this.log.debug("copy static file: %s -> %s", new Object[]{source.absolutePath(), targetPath});
                    this.getSelectedDefaultStrategy().copyStaticFile(source, targetPath);
                    continue;
                }
                Optional<String> content = reader.read(projectResource, source, this.languageName, finalData);
                if (content.isPresent()) {
                    this.log.debug("adding file to processing stack: %s", new Object[]{source.absolutePath()});
                    this.files.putIfAbsent(processedRelativeTargetPath, new ArrayList());
                    this.files.get(processedRelativeTargetPath).add(new TargetFile(processedRelativeTargetPath, content.get()));
                    continue;
                }
                Path targetPath = this.targetDirectory.resolve(processedRelativeTargetPath);
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                this.log.debug("ignoring file (but creating directory): %s", new Object[]{source.absolutePath()});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    DefaultCodestartFileStrategyHandler getSelectedDefaultStrategy() {
        for (CodestartFileStrategy codestartFileStrategy : this.strategies) {
            if (!Objects.equals(codestartFileStrategy.getFilter(), "*")) continue;
            if (codestartFileStrategy.getHandler() instanceof DefaultCodestartFileStrategyHandler) {
                return (DefaultCodestartFileStrategyHandler)codestartFileStrategy.getHandler();
            }
            throw new CodestartStructureException(codestartFileStrategy.getHandler().name() + " can't be used as '*' file strategy");
        }
        return CodestartFileStrategyHandler.DEFAULT_STRATEGY;
    }

    Optional<CodestartFileStrategyHandler> getStrategy(String key) {
        for (CodestartFileStrategy codestartFileStrategy : this.strategies) {
            if (!codestartFileStrategy.test(key)) continue;
            return Optional.of(codestartFileStrategy.getHandler());
        }
        return Optional.empty();
    }
}

