/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.logging;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.GeneratedClassGizmo2Adaptor;
import io.quarkus.deployment.IsProduction;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConsoleCommandBuildItem;
import io.quarkus.deployment.builditem.ConsoleFormatterBannerBuildItem;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.LogCategoryMinLevelDefaultsBuildItem;
import io.quarkus.deployment.builditem.LogConsoleFormatBuildItem;
import io.quarkus.deployment.builditem.LogFileFormatBuildItem;
import io.quarkus.deployment.builditem.LogHandlerBuildItem;
import io.quarkus.deployment.builditem.LogSocketFormatBuildItem;
import io.quarkus.deployment.builditem.LogSyslogFormatBuildItem;
import io.quarkus.deployment.builditem.NamedLogHandlersBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownListenerBuildItem;
import io.quarkus.deployment.builditem.StreamingLogHandlerBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.QuarkusCommand;
import io.quarkus.deployment.console.SetCompleter;
import io.quarkus.deployment.dev.ExceptionNotificationBuildItem;
import io.quarkus.deployment.dev.testing.TestSetupBuildItem;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.logging.LogStreamBuildItem;
import io.quarkus.deployment.logging.LoggingDecorateBuildItem;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.metrics.MetricsFactoryConsumerBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.dev.console.CurrentAppExceptionHighlighter;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.This;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.logging.LoggingFilter;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.console.ConsoleRuntimeConfig;
import io.quarkus.runtime.logging.DecorateStackUtil;
import io.quarkus.runtime.logging.DiscoveredLogComponents;
import io.quarkus.runtime.logging.InheritableLevel;
import io.quarkus.runtime.logging.LogBuildTimeConfig;
import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LogFilterFactory;
import io.quarkus.runtime.logging.LogMetricsHandlerRecorder;
import io.quarkus.runtime.logging.LogRuntimeConfig;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import io.smallrye.config.SmallRyeConfig;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommand;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Option;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContextInitializer;
import org.jboss.logmanager.LogManager;
import org.jboss.logmanager.Logger;

public final class LoggingResourceProcessor {
    private static final String LOGMANAGER_LOGGER_CLASS_NAME = "io.quarkus.runtime.generated.Target_org_jboss_logmanager_Logger";
    private static final String LOGGING_LOGGER_CLASS_NAME = "io.quarkus.runtime.generated.Target_org_jboss_logging_Logger";
    private static final String LOGGER_NODE_CLASS_NAME = "io.quarkus.runtime.generated.Target_org_jboss_logmanager_LoggerNode";
    private static final String MIN_LEVEL_COMPUTE_CLASS_NAME = "io.quarkus.runtime.generated.MinLevelCompute";
    private static final MethodDesc IS_MIN_LEVEL_ENABLED = ClassMethodDesc.of((ClassDesc)ClassDesc.of("io.quarkus.runtime.generated.MinLevelCompute"), (String)"isMinLevelEnabled", Boolean.TYPE, (Class[])new Class[]{Integer.TYPE, String.class});
    public static final DotName LOGGING_FILTER = DotName.createSimple((String)LoggingFilter.class.getName());
    private static final DotName FILTER = DotName.createSimple((String)Filter.class.getName());
    private static final String ILLEGAL_LOGGING_FILTER_USE_MESSAGE = "'@" + LoggingFilter.class.getName() + "' can only be used on classes that implement '" + Filter.class.getName() + "' and that are marked as final.";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String SRC_MAIN_JAVA = "src/main/java";

    @BuildStep
    void setupLogFilters(BuildProducer<LogCleanupFilterBuildItem> filters) {
        filters.produce(new LogCleanupFilterBuildItem("org.jboss.threads", "JBoss Threads version"));
    }

    @BuildStep
    void setProperties(BuildProducer<SystemPropertyBuildItem> producer) {
        producer.produce(new SystemPropertyBuildItem("java.util.logging.manager", "org.jboss.logmanager.LogManager"));
        producer.produce(new SystemPropertyBuildItem("org.jboss.logging.provider", "jboss"));
    }

    @BuildStep
    void setMinLevelForInitialConfigurator(LogBuildTimeConfig logBuildTimeConfig, BuildProducer<SystemPropertyBuildItem> systemPropertyBuildItemBuildProducer, BuildProducer<NativeImageSystemPropertyBuildItem> nativeImageSystemPropertyBuildItemBuildProducer) {
        Level effectiveMinLevel = logBuildTimeConfig.minLevel();
        for (LogBuildTimeConfig.CategoryBuildTimeConfig categoryBuildTimeConfig : logBuildTimeConfig.categories().values()) {
            Level categoryMinLevel;
            InheritableLevel inheritableLevel = categoryBuildTimeConfig.minLevel();
            if (inheritableLevel.isInherited() || (categoryMinLevel = inheritableLevel.getLevel()).intValue() >= effectiveMinLevel.intValue()) continue;
            effectiveMinLevel = categoryMinLevel;
        }
        String key = "logging.initial-configurator.min-level";
        String value = "" + effectiveMinLevel.intValue();
        systemPropertyBuildItemBuildProducer.produce(new SystemPropertyBuildItem(key, value));
        nativeImageSystemPropertyBuildItemBuildProducer.produce(new NativeImageSystemPropertyBuildItem(key, value));
    }

    @BuildStep
    void setUpDefaultLevels(List<LogCategoryBuildItem> categories, Consumer<RunTimeConfigurationDefaultBuildItem> configOutput, Consumer<LogCategoryMinLevelDefaultsBuildItem> minLevelDefaultsOutput) {
        HashMap<String, InheritableLevel> minLevelDefaults = new HashMap<String, InheritableLevel>();
        for (LogCategoryBuildItem category : categories) {
            configOutput.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.category.\"" + category.getCategory() + "\".level", category.getLevel().toString()));
            if (!category.isSetMinLevelDefault()) continue;
            minLevelDefaults.put(category.getCategory(), InheritableLevel.of((Level)category.getLevel()));
        }
        minLevelDefaultsOutput.accept(new LogCategoryMinLevelDefaultsBuildItem(minLevelDefaults));
    }

    @BuildStep
    void setUpDefaultLogCleanupFilters(List<LogCleanupFilterBuildItem> logCleanupFilters, Consumer<RunTimeConfigurationDefaultBuildItem> configOutput) {
        for (LogCleanupFilterBuildItem logCleanupFilter : logCleanupFilters) {
            String startsWithClause = logCleanupFilter.getFilterElement().getMessageStarts().stream().map(s -> s.replace(",", "\\,")).collect(Collectors.joining(","));
            configOutput.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.filter.\"" + logCleanupFilter.getFilterElement().getLoggerName() + "\".if-starts-with", startsWithClause));
            if (logCleanupFilter.getFilterElement().getTargetLevel() == null) continue;
            configOutput.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.filter.\"" + logCleanupFilter.getFilterElement().getLoggerName() + "\".target-level", logCleanupFilter.getFilterElement().getTargetLevel().toString()));
        }
    }

    @BuildStep
    void miscSetup(Consumer<RuntimeInitializedClassBuildItem> runtimeInit, Consumer<NativeImageSystemPropertyBuildItem> systemProp, Consumer<ServiceProviderBuildItem> provider) {
        runtimeInit.accept(new RuntimeInitializedClassBuildItem(ConsoleHandler.class.getName()));
        runtimeInit.accept(new RuntimeInitializedClassBuildItem("io.smallrye.common.ref.References$ReaperThread"));
        runtimeInit.accept(new RuntimeInitializedClassBuildItem("io.smallrye.common.os.Process"));
        systemProp.accept(new NativeImageSystemPropertyBuildItem("java.util.logging.manager", "org.jboss.logmanager.LogManager"));
        provider.accept(new ServiceProviderBuildItem(LogContextInitializer.class.getName(), InitialConfigurator.class.getName()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    LoggingSetupBuildItem setupLoggingRuntimeInit(RecorderContext context, LoggingSetupRecorder recorder, CombinedIndexBuildItem combinedIndexBuildItem, LogCategoryMinLevelDefaultsBuildItem categoryMinLevelDefaults, Optional<StreamingLogHandlerBuildItem> streamingLogStreamHandlerBuildItem, List<LogHandlerBuildItem> handlerBuildItems, List<NamedLogHandlersBuildItem> namedHandlerBuildItems, List<LogConsoleFormatBuildItem> consoleFormatItems, List<LogFileFormatBuildItem> fileFormatItems, List<LogSyslogFormatBuildItem> syslogFormatItems, List<LogSocketFormatBuildItem> socketFormatItems, Optional<ConsoleFormatterBannerBuildItem> possibleBannerBuildItem, List<LogStreamBuildItem> logStreamBuildItems, BuildProducer<ShutdownListenerBuildItem> shutdownListenerBuildItemBuildProducer, LaunchModeBuildItem launchModeBuildItem, List<LogCleanupFilterBuildItem> logCleanupFilters, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, BuildProducer<ServiceProviderBuildItem> serviceProviderBuildItemBuildProducer) {
        if (!launchModeBuildItem.isAuxiliaryApplication() || launchModeBuildItem.getAuxiliaryDevModeType().orElse(null) == DevModeType.TEST_ONLY) {
            List handlers = handlerBuildItems.stream().map(LogHandlerBuildItem::getHandlerValue).collect(Collectors.toList());
            List namedHandlers = namedHandlerBuildItems.stream().map(NamedLogHandlersBuildItem::getNamedHandlersMap).collect(Collectors.toList());
            ConsoleFormatterBannerBuildItem bannerBuildItem = null;
            RuntimeValue<Optional<Supplier<String>>> possibleSupplier = null;
            if (possibleBannerBuildItem.isPresent()) {
                bannerBuildItem = possibleBannerBuildItem.get();
            }
            if (bannerBuildItem != null) {
                possibleSupplier = bannerBuildItem.getBannerSupplier();
            }
            RuntimeValue<Optional<Handler>> streamingDevUiLogHandler = null;
            if (streamingLogStreamHandlerBuildItem.isPresent()) {
                streamingDevUiLogHandler = streamingLogStreamHandlerBuildItem.get().getHandlerValue();
            }
            boolean alwaysEnableLogStream = false;
            if (!logStreamBuildItems.isEmpty()) {
                alwaysEnableLogStream = true;
            }
            List possibleConsoleFormatters = consoleFormatItems.stream().map(LogConsoleFormatBuildItem::getFormatterValue).collect(Collectors.toList());
            List possibleFileFormatters = fileFormatItems.stream().map(LogFileFormatBuildItem::getFormatterValue).collect(Collectors.toList());
            List possibleSyslogFormatters = syslogFormatItems.stream().map(LogSyslogFormatBuildItem::getFormatterValue).collect(Collectors.toList());
            List possibleSocketFormatters = socketFormatItems.stream().map(LogSocketFormatBuildItem::getFormatterValue).collect(Collectors.toList());
            context.registerSubstitution(InheritableLevel.ActualLevel.class, String.class, InheritableLevel.Substitution.class);
            context.registerSubstitution(InheritableLevel.Inherited.class, String.class, InheritableLevel.Substitution.class);
            DiscoveredLogComponents discoveredLogComponents = this.discoverLogComponents(combinedIndexBuildItem.getIndex());
            if (!discoveredLogComponents.getNameToFilterClass().isEmpty()) {
                reflectiveClassBuildItemBuildProducer.produce(ReflectiveClassBuildItem.builder(discoveredLogComponents.getNameToFilterClass().values().toArray(EMPTY_STRING_ARRAY)).reason(this.getClass().getName()).build());
                serviceProviderBuildItemBuildProducer.produce(ServiceProviderBuildItem.allProvidersFromClassPath(LogFilterFactory.class.getName()));
            }
            shutdownListenerBuildItemBuildProducer.produce(new ShutdownListenerBuildItem(recorder.initializeLogging(discoveredLogComponents, categoryMinLevelDefaults.content, alwaysEnableLogStream, streamingDevUiLogHandler, handlers, namedHandlers, possibleConsoleFormatters, possibleFileFormatters, possibleSyslogFormatters, possibleSocketFormatters, possibleSupplier, launchModeBuildItem.getLaunchMode(), true)));
            ArrayList<LogCleanupFilterElement> additionalLogCleanupFilters = new ArrayList<LogCleanupFilterElement>(logCleanupFilters.size());
            for (LogCleanupFilterBuildItem i : logCleanupFilters) {
                LogCleanupFilterElement filterElement = i.getFilterElement();
                additionalLogCleanupFilters.add(new LogCleanupFilterElement(filterElement.getLoggerName(), (Level)(filterElement.getTargetLevel() == null ? org.jboss.logmanager.Level.DEBUG : filterElement.getTargetLevel()), filterElement.getMessageStarts()));
            }
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
            LogBuildTimeConfig logBuildTimeConfig = (LogBuildTimeConfig)config.getConfigMapping(LogBuildTimeConfig.class);
            LogRuntimeConfig logRuntimeConfigInBuild = (LogRuntimeConfig)config.getConfigMapping(LogRuntimeConfig.class);
            ConsoleRuntimeConfig consoleRuntimeConfig = (ConsoleRuntimeConfig)config.getConfigMapping(ConsoleRuntimeConfig.class);
            LoggingSetupRecorder.initializeBuildTimeLogging((LogRuntimeConfig)logRuntimeConfigInBuild, (LogBuildTimeConfig)logBuildTimeConfig, (ConsoleRuntimeConfig)consoleRuntimeConfig, categoryMinLevelDefaults.content, additionalLogCleanupFilters, (LaunchMode)launchModeBuildItem.getLaunchMode());
        }
        return new LoggingSetupBuildItem();
    }

    private DiscoveredLogComponents discoverLogComponents(IndexView index) {
        Collection loggingFilterInstances = index.getAnnotations(LOGGING_FILTER);
        DiscoveredLogComponents result = new DiscoveredLogComponents();
        HashMap<String, String> filtersMap = new HashMap<String, String>();
        for (AnnotationInstance instance : loggingFilterInstances) {
            AnnotationTarget target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS) {
                throw new IllegalStateException("Unimplemented mode of use of '" + LoggingFilter.class.getName() + "'");
            }
            ClassInfo classInfo = target.asClass();
            boolean isFilterImpl = false;
            ClassInfo currentClassInfo = classInfo;
            while (currentClassInfo != null && !JandexUtil.DOTNAME_OBJECT.equals((Object)currentClassInfo.name())) {
                boolean hasFilterInterface = false;
                List ifaces = currentClassInfo.interfaceNames();
                for (DotName iface : ifaces) {
                    if (!FILTER.equals((Object)iface)) continue;
                    hasFilterInterface = true;
                    break;
                }
                if (hasFilterInterface) {
                    isFilterImpl = true;
                    break;
                }
                currentClassInfo = index.getClassByName(currentClassInfo.superName());
            }
            if (!isFilterImpl) {
                throw new RuntimeException(ILLEGAL_LOGGING_FILTER_USE_MESSAGE + " Offending class is '" + String.valueOf(classInfo.name()) + "'");
            }
            String filterName = instance.value("name").asString();
            if (filtersMap.containsKey(filterName)) {
                throw new RuntimeException("Filter '" + filterName + "' was defined multiple times.");
            }
            filtersMap.put(filterName, classInfo.name().toString());
        }
        if (!filtersMap.isEmpty()) {
            result.setNameToFilterClass(filtersMap);
        }
        return result;
    }

    @BuildStep(onlyIfNot={IsProduction.class})
    @Produce.List(value={@Produce(value=TestSetupBuildItem.class), @Produce(value=LogConsoleFormatBuildItem.class)})
    @Consume(value=ConsoleInstalledBuildItem.class)
    void setupStackTraceFormatter(ApplicationArchivesBuildItem item, EffectiveIdeBuildItem ideSupport, BuildSystemTargetBuildItem buildSystemTargetBuildItem, final List<ExceptionNotificationBuildItem> exceptionNotificationBuildItems, CuratedApplicationShutdownBuildItem curatedApplicationShutdownBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, final LaunchModeBuildItem launchMode, final LogBuildTimeConfig logBuildTimeConfig, BuildProducer<LoggingDecorateBuildItem> loggingDecorateProducer) {
        ArrayList<IndexView> indexList = new ArrayList<IndexView>();
        for (ApplicationArchive i : item.getAllApplicationArchives()) {
            if (!i.getResolvedPaths().isSinglePath() || !Files.isDirectory(i.getResolvedPaths().getSinglePath(), new LinkOption[0])) continue;
            indexList.add(i.getIndex());
        }
        final Path srcMainJava = this.getSourceRoot(curateOutcomeBuildItem.getApplicationModel(), outputTargetBuildItem.getOutputDirectory());
        final CompositeIndex index = CompositeIndex.create(indexList);
        loggingDecorateProducer.produce(new LoggingDecorateBuildItem(srcMainJava, index));
        CurrentAppExceptionHighlighter.THROWABLE_FORMATTER = new BiConsumer<LogRecord, Consumer<LogRecord>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(LogRecord logRecord, Consumer<LogRecord> logRecordConsumer) {
                StackTraceElement lastUserCode = null;
                HashMap<Throwable, StackTraceElement[]> restore = new HashMap<Throwable, StackTraceElement[]>();
                for (Throwable c = logRecord.getThrown(); c != null; c = c.getCause()) {
                    StackTraceElement[] stackTrace = c.getStackTrace();
                    for (int i = 0; i < stackTrace.length; ++i) {
                        String decoratedString;
                        StackTraceElement elem = stackTrace[i];
                        if (index.getClassByName(DotName.createSimple((String)elem.getClassName())) == null) continue;
                        lastUserCode = stackTrace[i];
                        if (launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT) && logBuildTimeConfig.decorateStacktraces() && (decoratedString = DecorateStackUtil.getDecoratedString((Path)srcMainJava, (StackTraceElement)elem)) != null) {
                            if (logRecord instanceof ExtLogRecord) {
                                ExtLogRecord elr = (ExtLogRecord)logRecord;
                                switch (elr.getFormatStyle()) {
                                    case MESSAGE_FORMAT: {
                                        p = elr.getParameters();
                                        np = p != null ? Arrays.copyOf(p, p.length + 1) : new Object[1];
                                        np[np.length - 1] = decoratedString;
                                        elr.setParameters(np);
                                        elr.setMessage(elr.getMessage() + "\n\n{" + (np.length - 1) + "}\n\n");
                                        break;
                                    }
                                    case PRINTF: {
                                        p = elr.getParameters();
                                        np = p != null ? Arrays.copyOf(p, p.length + 1) : new Object[1];
                                        np[np.length - 1] = decoratedString;
                                        elr.setParameters(np);
                                        elr.setMessage(elr.getMessage() + "\n\n%" + np.length + "$s", ExtLogRecord.FormatStyle.PRINTF);
                                        break;
                                    }
                                    case NO_FORMAT: {
                                        elr.setParameters(new Object[]{elr.getMessage(), decoratedString});
                                        elr.setMessage("{0}\n\n{1}\n\n");
                                    }
                                }
                            } else {
                                p = logRecord.getParameters();
                                np = p != null ? Arrays.copyOf(p, p.length + 1) : new Object[1];
                                np[np.length - 1] = decoratedString;
                                logRecord.setParameters(np);
                                logRecord.setMessage(logRecord.getMessage() + "\n\n{" + (np.length - 1) + "}\n\n");
                            }
                        }
                        stackTrace[i] = new StackTraceElement(elem.getClassLoaderName(), elem.getModuleName(), elem.getModuleVersion(), "\u001b[4m\u001b[1m" + elem.getClassName() + "\u001b[24m\u001b[22m", elem.getMethodName(), elem.getFileName(), elem.getLineNumber());
                    }
                    restore.put(c, c.getStackTrace());
                    c.setStackTrace(stackTrace);
                }
                try {
                    logRecordConsumer.accept(logRecord);
                }
                finally {
                    for (Map.Entry entry : restore.entrySet()) {
                        ((Throwable)entry.getKey()).setStackTrace((StackTraceElement[])entry.getValue());
                    }
                }
                if (logRecord.getThrown() != null) {
                    for (ExceptionNotificationBuildItem i : exceptionNotificationBuildItems) {
                        i.getExceptionHandler().accept(logRecord.getThrown(), lastUserCode);
                    }
                }
            }
        };
        curatedApplicationShutdownBuildItem.addCloseTask(() -> {
            CurrentAppExceptionHighlighter.THROWABLE_FORMATTER = null;
        }, true);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupLoggingStaticInit(LoggingSetupRecorder recorder, LaunchModeBuildItem launchModeBuildItem) {
        if (!launchModeBuildItem.isAuxiliaryApplication()) {
            recorder.initializeLoggingForImageBuild();
        }
    }

    @BuildStep
    void setUpDarkeningDefault(Consumer<RunTimeConfigurationDefaultBuildItem> rtcConsumer) {
        rtcConsumer.accept(new RunTimeConfigurationDefaultBuildItem("quarkus.log.console.darken", "0"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerMetrics(LogMetricsHandlerRecorder recorder, LogBuildTimeConfig log, BuildProducer<MetricsFactoryConsumerBuildItem> metrics, BuildProducer<LogHandlerBuildItem> logHandler, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (metricsCapability.isPresent() && log.metricsEnabled()) {
            recorder.initCounters();
            metrics.produce(new MetricsFactoryConsumerBuildItem(recorder.registerMetrics()));
            logHandler.produce(new LogHandlerBuildItem((RuntimeValue<Optional<Handler>>)recorder.getLogHandler()));
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void setUpMinLevelLogging(LogBuildTimeConfig log, LogCategoryMinLevelDefaultsBuildItem categoryMinLevelDefaults, BuildProducer<GeneratedClassBuildItem> gcProducer, BuildProducer<GeneratedResourceBuildItem> grProducer) {
        GeneratedClassGizmo2Adaptor output = new GeneratedClassGizmo2Adaptor(gcProducer, grProducer, false);
        LoggingResourceProcessor.generateDefaultLoggerNode(output);
        if (LoggingResourceProcessor.allRootMinLevelOrHigher(log.minLevel().intValue(), log.categories(), categoryMinLevelDefaults.content)) {
            Level minLevel = log.minLevel();
            LoggingResourceProcessor.generateDefaultLoggingLogger(minLevel, output);
            String defaultMinLevelName = minLevel.getName();
            LoggingResourceProcessor.generateLogManagerLogger(output, (b0, name, levelIntValue) -> {
                Expr defaultLevelIntValue = LoggingResourceProcessor.getLogManagerLevelIntValue(defaultMinLevelName, b0);
                return b0.ge((Expr)levelIntValue, defaultLevelIntValue);
            });
        } else {
            Map categories = log.categories();
            Level rootMinLevel = log.minLevel();
            LoggingResourceProcessor.generateMinLevelCompute(categories, categoryMinLevelDefaults.content, rootMinLevel, output);
            LoggingResourceProcessor.generateLogManagerLogger(output, (b0, name, levelIntValue) -> b0.invokeStatic(IS_MIN_LEVEL_ENABLED, (Expr)levelIntValue, (Expr)name));
        }
    }

    @BuildStep
    @Produce(value=ServiceStartBuildItem.class)
    void closeBuildTimeLogging(List<DevServicesResultBuildItem> devServices) {
        if (devServices.isEmpty()) {
            ((QuarkusClassLoader)Thread.currentThread().getContextClassLoader()).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    InitialConfigurator.DELAYED_HANDLER.buildTimeComplete();
                }
            });
        }
    }

    private static boolean allRootMinLevelOrHigher(int rootMinLogLevel, Map<String, LogBuildTimeConfig.CategoryBuildTimeConfig> categories, Map<String, InheritableLevel> categoryMinLevelDefaults) {
        LinkedHashSet<String> allConfiguredCategoryNames = new LinkedHashSet<String>(categories.keySet());
        allConfiguredCategoryNames.addAll(categoryMinLevelDefaults.keySet());
        for (String categoryName : allConfiguredCategoryNames) {
            InheritableLevel categoryMinLevel = LoggingSetupRecorder.getLogLevelNoInheritance((String)categoryName, categories, LogBuildTimeConfig.CategoryBuildTimeConfig::minLevel, categoryMinLevelDefaults);
            if (categoryMinLevel.isInherited() || categoryMinLevel.getLevel().intValue() >= rootMinLogLevel) continue;
            return false;
        }
        return true;
    }

    private static void generateMinLevelCompute(Map<String, LogBuildTimeConfig.CategoryBuildTimeConfig> categories, Map<String, InheritableLevel> categoryMinLevelDefaults, Level rootMinLevel, ClassOutput output) {
        Gizmo g = Gizmo.create((ClassOutput)output).withDebugInfo(false).withParameters(false);
        g.class_(MIN_LEVEL_COMPUTE_CLASS_NAME, cc -> {
            cc.final_();
            cc.staticMethod("isMinLevelEnabled", mc -> {
                mc.returning(Boolean.TYPE);
                ParamVar level = mc.parameter("level", Integer.TYPE);
                ParamVar name = mc.parameter("name", String.class);
                mc.body(b0 -> {
                    for (Map.Entry entry : categories.entrySet()) {
                        String category = (String)entry.getKey();
                        int categoryLevelIntValue = LoggingSetupRecorder.getLogLevel((String)category, (Map)categories, LogBuildTimeConfig.CategoryBuildTimeConfig::minLevel, (Map)categoryMinLevelDefaults, (Level)rootMinLevel).intValue();
                        b0.if_(b0.objEquals((Expr)name, (Expr)Const.of((String)category)), BlockCreator::returnTrue);
                        b0.if_(b0.invokeVirtual(MethodDesc.of(String.class, (String)"startsWith", Boolean.TYPE, (Class[])new Class[]{String.class}), (Expr)name, (Expr)Const.of((String)(category + "."))), t1 -> t1.return_(t1.ge((Expr)level, categoryLevelIntValue)));
                    }
                    b0.return_(b0.ge((Expr)level, LoggingResourceProcessor.getLogManagerLevelIntValue(rootMinLevel.toString(), b0)));
                });
            });
        });
    }

    private static void generateDefaultLoggerNode(ClassOutput output) {
        Gizmo g = Gizmo.create((ClassOutput)output).withDebugInfo(false).withParameters(false);
        g.class_(LOGGER_NODE_CLASS_NAME, cc -> {
            cc.final_();
            cc.addAnnotation(TargetClass.class, ac -> ac.add(TargetClass::className, "org.jboss.logmanager.LoggerNode"));
            cc.method("isLoggableLevel", mc -> {
                mc.addAnnotation(Alias.class);
                mc.parameter("level", Integer.TYPE);
                mc.returning(Boolean.TYPE);
                mc.body(BlockCreator::returnFalse);
            });
        });
    }

    private static void generateLogManagerLogger(ClassOutput output, MinLevelEnabledFunction isMinLevelEnabledFunction) {
        Gizmo gizmo = Gizmo.create((ClassOutput)output).withDebugInfo(false).withParameters(false);
        gizmo.class_(LOGMANAGER_LOGGER_CLASS_NAME, cc -> {
            cc.final_();
            This this_ = cc.this_();
            cc.addAnnotation(TargetClass.class, ac -> ac.add(TargetClass::value, Logger.class));
            FieldDesc name = cc.field("name", fc -> {
                fc.setType(String.class);
                fc.addAnnotation(Alias.class);
            });
            FieldDesc loggerNode = cc.field("loggerNode", fc -> {
                fc.setType(ClassDesc.of(LOGGER_NODE_CLASS_NAME));
                fc.addAnnotation(Alias.class);
            });
            cc.method("isLoggable", mc -> {
                mc.returning(Boolean.TYPE);
                mc.addAnnotation(Substitute.class);
                ParamVar level = mc.parameter("level", Level.class);
                mc.body(b0 -> {
                    LocalVar levelInt = b0.localVar("levelInt", b0.invokeVirtual(MethodDesc.of(Level.class, (String)"intValue", Integer.TYPE, (Class[])new Class[0]), (Expr)level));
                    b0.ifNot(isMinLevelEnabledFunction.apply((BlockCreator)b0, (Var)this_.field(name), (Var)levelInt), BlockCreator::returnFalse);
                    b0.return_(b0.invokeVirtual((MethodDesc)ClassMethodDesc.of((ClassDesc)ClassDesc.of(LOGGER_NODE_CLASS_NAME), (String)"isLoggableLevel", Boolean.TYPE, (Class[])new Class[]{Integer.TYPE}), (Expr)this_.field(loggerNode), (Expr)levelInt));
                });
            });
        });
    }

    private static Expr getLogManagerLevelIntValue(String levelName, BlockCreator b0) {
        FieldDesc fd = FieldDesc.of(switch (levelName) {
            case "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE" -> org.jboss.logmanager.Level.class;
            default -> Level.class;
        }, (String)levelName);
        return b0.invokeVirtual(MethodDesc.of(Level.class, (String)"intValue", Integer.TYPE, (Class[])new Class[0]), b0.get((Assignable)Expr.staticField((FieldDesc)fd)));
    }

    private static void generateDefaultLoggingLogger(Level minLevel, ClassOutput output) {
        Gizmo gizmo = Gizmo.create((ClassOutput)output).withDebugInfo(false).withParameters(false);
        gizmo.class_(LOGGING_LOGGER_CLASS_NAME, cc -> {
            cc.final_();
            cc.addAnnotation(TargetClass.class, ac -> ac.add(TargetClass::className, "org.jboss.logging.Logger"));
            if (minLevel.intValue() >= org.jboss.logmanager.Level.INFO.intValue()) {
                LoggingResourceProcessor.generateFalseFoldMethod("isTraceEnabled", cc);
                LoggingResourceProcessor.generateFalseFoldMethod("isDebugEnabled", cc);
            } else if (minLevel.intValue() == org.jboss.logmanager.Level.DEBUG.intValue()) {
                LoggingResourceProcessor.generateFalseFoldMethod("isTraceEnabled", cc);
            }
        });
    }

    private static void generateFalseFoldMethod(String name, ClassCreator cc) {
        cc.method(name, mc -> {
            mc.public_();
            mc.returning(Boolean.TYPE);
            mc.addAnnotation(Substitute.class);
            mc.addAnnotation(ClassDesc.of("org.graalvm.compiler.api.replacements.Fold"), RetentionPolicy.RUNTIME, ac -> {});
            mc.body(BlockCreator::returnFalse);
        });
    }

    @BuildStep
    ConsoleCommandBuildItem logConsoleCommand() {
        return new ConsoleCommandBuildItem((Command<?>)new LogCommand());
    }

    private Path getSourceRoot(ApplicationModel applicationModel, Path target) {
        WorkspaceModule workspaceModule = applicationModel.getAppArtifact().getWorkspaceModule();
        if (workspaceModule != null) {
            return workspaceModule.getModuleDir().toPath().resolve(SRC_MAIN_JAVA);
        }
        if (target != null) {
            Path baseDir = target.getParent();
            if (baseDir == null) {
                baseDir = target;
            }
            return baseDir.resolve(SRC_MAIN_JAVA);
        }
        return Paths.get(SRC_MAIN_JAVA, new String[0]);
    }

    static interface MinLevelEnabledFunction {
        public Expr apply(BlockCreator var1, Var var2, Var var3);
    }

    @GroupCommandDefinition(name="log", description="Logging Commands")
    public static class LogCommand
    implements GroupCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        public boolean help;

        public List<Command> getCommands() {
            return List.of(new SetLogLevelCommand());
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.getShell().writeln(commandInvocation.getHelpInfo());
            return CommandResult.SUCCESS;
        }
    }

    public static class LevelCompleter
    extends SetCompleter {
        @Override
        protected Set<String> allOptions(String soFar) {
            return Set.of(Logger.Level.TRACE.name(), Logger.Level.DEBUG.name(), Logger.Level.INFO.name(), Logger.Level.WARN.name(), Logger.Level.ERROR.name(), Logger.Level.FATAL.name());
        }
    }

    public static class LoggerCompleter
    implements OptionCompleter<CompleterInvocation> {
        public void complete(CompleterInvocation completerInvocation) {
            String soFar = completerInvocation.getGivenCompleteValue();
            Enumeration<String> loggers = LogManager.getLogManager().getLoggerNames();
            HashSet<Object> possible = new HashSet<Object>();
            while (loggers.hasMoreElements()) {
                String name = loggers.nextElement();
                if (name.equals(soFar)) {
                    possible.add(name);
                    continue;
                }
                if (!name.startsWith(soFar)) continue;
                int pos = name.indexOf(46, soFar.length() + 1);
                if (pos == -1) {
                    possible.add(name);
                    continue;
                }
                possible.add(name.substring(0, pos) + ".");
                completerInvocation.setAppendSpace(false);
            }
            completerInvocation.setCompleterValues(possible);
        }
    }

    @CommandDefinition(name="set-level", description="Sets the log level for a logger")
    public static class SetLogLevelCommand
    extends QuarkusCommand {
        @Option(required=true, completer=LoggerCompleter.class, description="The logger to modify")
        private String logger;
        @Option(required=true, completer=LevelCompleter.class, description="The log level")
        private String level;

        @Override
        public CommandResult doExecute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            java.util.logging.Logger logger = LogManager.getLogManager().getLogger(this.logger);
            Level level = org.jboss.logmanager.Level.parse((String)this.level);
            logger.setLevel(level);
            for (Handler i : logger.getHandlers()) {
                if (i.getLevel().intValue() <= level.intValue()) continue;
                i.setLevel(level);
            }
            return CommandResult.SUCCESS;
        }
    }
}

