/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.matching.ConfigPatternMap;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.registry.ValueRegistry;
import io.quarkus.runtime.ValueRegistryConfigSource;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.configuration.AbstractConfigBuilder;
import io.quarkus.runtime.configuration.ConfigDiagnostic;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.configuration.NameIterator;
import io.quarkus.runtime.configuration.PropertiesUtil;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import io.smallrye.config.common.utils.StringUtil;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public final class RunTimeConfigurationGenerator {
    public static final String CONFIG_CLASS_NAME = "io.quarkus.runtime.generated.Config";
    public static final String CONFIG_STATIC_NAME = "io.quarkus.runtime.generated.StaticInitConfig";
    public static final String CONFIG_RUNTIME_NAME = "io.quarkus.runtime.generated.RunTimeConfig";
    public static final MethodDescriptor C_CREATE_RUN_TIME_CONFIG = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"createRunTimeConfig", Void.TYPE, (Object[])new Object[]{ValueRegistry.class});
    public static final MethodDescriptor C_ENSURE_INITIALIZED = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"ensureInitialized", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor REINIT = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"reinit", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor C_READ_CONFIG = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"readConfig", Void.TYPE, (Object[])new Object[]{ValueRegistry.class});
    static final FieldDescriptor C_UNKNOWN = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"unknown", Set.class);
    static final FieldDescriptor C_UNKNOWN_RUNTIME = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"unknownRuntime", Set.class);
    static final MethodDescriptor CD_INVALID_VALUE = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"invalidValue", Void.TYPE, (Class[])new Class[]{String.class, IllegalArgumentException.class});
    static final MethodDescriptor CD_IS_ERROR = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"isError", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor CD_GET_ERROR_KEYS = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"getErrorKeys", Set.class, (Class[])new Class[0]);
    static final MethodDescriptor CD_MISSING_VALUE = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"missingValue", Void.TYPE, (Class[])new Class[]{String.class, NoSuchElementException.class});
    static final MethodDescriptor CD_RESET_ERROR = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"resetError", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor CD_REPORT_UNKNOWN = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"reportUnknown", Void.TYPE, (Class[])new Class[]{Set.class});
    static final MethodDescriptor CD_REPORT_UNKNOWN_RUNTIME = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"reportUnknownRuntime", Void.TYPE, (Class[])new Class[]{Set.class});
    static final MethodDescriptor ITRA_ITERATOR = MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]);
    static final MethodDescriptor ITR_HAS_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor ITR_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]);
    static final MethodDescriptor NI_NEW_STRING = MethodDescriptor.ofConstructor(NameIterator.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor NI_HAS_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"next", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor OBJ_TO_STRING = MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]);
    static final MethodDescriptor SB_NEW = MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[0]);
    static final MethodDescriptor SB_APPEND_STRING = MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor QCF_SET_CONFIG = MethodDescriptor.ofMethod(QuarkusConfigFactory.class, (String)"setConfig", Void.TYPE, (Class[])new Class[]{SmallRyeConfig.class});
    static final MethodDescriptor SRC_GET_PROPERTY_NAMES = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getPropertyNames", Iterable.class, (Class[])new Class[0]);
    static final MethodDescriptor SRCB_NEW = MethodDescriptor.ofConstructor(SmallRyeConfigBuilder.class, (Class[])new Class[0]);
    static final MethodDescriptor SRCB_WITH_CUSTOMIZER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withCustomizer", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SmallRyeConfigBuilderCustomizer.class});
    static final MethodDescriptor SRCB_WITH_CUSTOMIZER_BY_NAME = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withCustomizer", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, String.class});
    static final MethodDescriptor SRCB_BUILD = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"build", SmallRyeConfig.class, (Class[])new Class[0]);
    static final MethodDescriptor PU_IS_MAPPED = MethodDescriptor.ofMethod(PropertiesUtil.class, (String)"isMapped", Boolean.TYPE, (Class[])new Class[]{NameIterator.class, String.class});
    static final MethodDescriptor PU_IS_PROPERTY_QUARKUS_COMPOUND_NAME = MethodDescriptor.ofMethod(PropertiesUtil.class, (String)"isPropertyQuarkusCompoundName", Boolean.TYPE, (Class[])new Class[]{NameIterator.class});
    static final MethodDescriptor PU_IS_PROPERTY_IN_ROOTS = MethodDescriptor.ofMethod(PropertiesUtil.class, (String)"isPropertyInRoots", Boolean.TYPE, (Class[])new Class[]{String.class, Set.class});
    static final MethodDescriptor HS_NEW = MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]);
    static final MethodDescriptor HS_ADD = MethodDescriptor.ofMethod(HashSet.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class});

    private RunTimeConfigurationGenerator() {
    }

    private static enum Type {
        BUILD_TIME("si"),
        RUNTIME("rt");

        final String methodPrefix;

        private Type(String methodPrefix) {
            this.methodPrefix = methodPrefix;
        }
    }

    public static final class GenerateOperation
    implements AutoCloseable {
        final boolean liveReloadPossible;
        final BuildTimeConfigurationReader.ReadResult buildTimeConfigResult;
        final ClassOutput classOutput;
        final ClassCreator cc;
        final MethodCreator clinit;
        final MethodCreator reinit;
        final MethodCreator readConfig;
        final ResultHandle clinitConfig;

        GenerateOperation(Builder builder) {
            this.liveReloadPossible = builder.liveReloadPossible;
            this.buildTimeConfigResult = (BuildTimeConfigurationReader.ReadResult)Assert.checkNotNullParam((String)"buildTimeReadResult", (Object)builder.getBuildTimeReadResult());
            this.classOutput = (ClassOutput)Assert.checkNotNullParam((String)"classOutput", (Object)builder.getClassOutput());
            this.cc = ClassCreator.builder().classOutput(this.classOutput).className(RunTimeConfigurationGenerator.CONFIG_CLASS_NAME).setFinal(true).build();
            try (MethodCreator mc = this.cc.getMethodCreator(MethodDescriptor.ofConstructor((String)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String[])new String[0]));){
                mc.setModifiers(2);
                mc.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), mc.getThis(), new ResultHandle[0]);
                mc.returnValue(null);
            }
            if (this.liveReloadPossible) {
                this.reinit = this.cc.getMethodCreator(REINIT);
                this.reinit.setModifiers(9);
            } else {
                this.reinit = null;
            }
            this.clinit = this.cc.getMethodCreator(MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)"<clinit>", Void.TYPE, (Object[])new Object[0]));
            this.clinit.setModifiers(8);
            this.cc.getFieldCreator(C_UNKNOWN).setModifiers(8);
            this.clinit.writeStaticField(C_UNKNOWN, this.clinit.newInstance(HS_NEW, new ResultHandle[0]));
            this.cc.getFieldCreator(C_UNKNOWN_RUNTIME).setModifiers(8);
            this.clinit.writeStaticField(C_UNKNOWN_RUNTIME, this.clinit.newInstance(HS_NEW, new ResultHandle[0]));
            this.generateIsMapped();
            ResultHandle buildTimeBuilder = this.clinit.newInstance(SRCB_NEW, new ResultHandle[0]);
            this.clinit.invokeStaticMethod(SRCB_WITH_CUSTOMIZER_BY_NAME, new ResultHandle[]{buildTimeBuilder, this.clinit.load(RunTimeConfigurationGenerator.CONFIG_STATIC_NAME)});
            this.clinitConfig = this.clinit.checkCast(this.clinit.invokeVirtualMethod(SRCB_BUILD, buildTimeBuilder, new ResultHandle[0]), SmallRyeConfig.class);
            this.readConfig = this.cc.getMethodCreator(C_READ_CONFIG);
        }

        public void run() {
            this.installConfiguration(this.clinitConfig, this.clinit);
            if (this.liveReloadPossible) {
                ResultHandle buildTimeBuilder = this.reinit.newInstance(SRCB_NEW, new ResultHandle[0]);
                this.reinit.invokeStaticMethod(SRCB_WITH_CUSTOMIZER_BY_NAME, new ResultHandle[]{buildTimeBuilder, this.reinit.load(RunTimeConfigurationGenerator.CONFIG_STATIC_NAME)});
                ResultHandle clinitConfig = this.reinit.checkCast(this.reinit.invokeVirtualMethod(SRCB_BUILD, buildTimeBuilder, new ResultHandle[0]), SmallRyeConfig.class);
                this.installConfiguration(clinitConfig, this.reinit);
                this.reinit.returnValue(null);
            }
            ResultHandle runTimeBuilder = this.readConfig.newInstance(SRCB_NEW, new ResultHandle[0]);
            ResultHandle valueRegistry = this.readConfig.getMethodParam(0);
            MethodDescriptor valueRegistryConfigCustomizer = MethodDescriptor.ofMethod(ValueRegistryConfigSource.class, (String)"customizer", SmallRyeConfigBuilderCustomizer.class, (Class[])new Class[]{ValueRegistry.class});
            ResultHandle customizer = this.readConfig.invokeStaticMethod(valueRegistryConfigCustomizer, new ResultHandle[]{valueRegistry});
            this.readConfig.invokeStaticMethod(SRCB_WITH_CUSTOMIZER, new ResultHandle[]{runTimeBuilder, customizer});
            this.readConfig.invokeStaticMethod(SRCB_WITH_CUSTOMIZER_BY_NAME, new ResultHandle[]{runTimeBuilder, this.readConfig.load(RunTimeConfigurationGenerator.CONFIG_RUNTIME_NAME)});
            ResultHandle runTimeConfig = this.readConfig.invokeVirtualMethod(SRCB_BUILD, runTimeBuilder, new ResultHandle[0]);
            this.installConfiguration(runTimeConfig, this.readConfig);
            this.configSweepLoop(this.clinit, this.clinitConfig, this.getRegisteredRoots(ConfigPhase.BUILD_AND_RUN_TIME_FIXED), Type.BUILD_TIME);
            this.clinit.invokeStaticMethod(CD_REPORT_UNKNOWN, new ResultHandle[]{this.clinit.readStaticField(C_UNKNOWN)});
            if (this.liveReloadPossible) {
                this.configSweepLoop(this.readConfig, runTimeConfig, this.getRegisteredRoots(ConfigPhase.RUN_TIME), Type.RUNTIME);
            }
            this.configSweepLoop(this.readConfig, runTimeConfig, this.getRegisteredRoots(ConfigPhase.RUN_TIME), Type.RUNTIME);
            this.readConfig.invokeStaticMethod(CD_REPORT_UNKNOWN_RUNTIME, new ResultHandle[]{this.readConfig.readStaticField(C_UNKNOWN_RUNTIME)});
            try (MethodCreator mc = this.cc.getMethodCreator(C_ENSURE_INITIALIZED);){
                mc.setModifiers(9);
                mc.returnValue(null);
            }
            mc = this.cc.getMethodCreator(C_CREATE_RUN_TIME_CONFIG);
            try {
                mc.setModifiers(9);
                ResultHandle instance = mc.newInstance(MethodDescriptor.ofConstructor((String)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String[])new String[0]), new ResultHandle[0]);
                mc.invokeVirtualMethod(C_READ_CONFIG, instance, new ResultHandle[]{mc.getMethodParam(0)});
                mc.returnValue(null);
            }
            finally {
                if (mc != null) {
                    mc.close();
                }
            }
            BytecodeCreator isError = this.readConfig.ifNonZero(this.readConfig.invokeStaticMethod(CD_IS_ERROR, new ResultHandle[0])).trueBranch();
            ResultHandle niceErrorMessage = isError.invokeStaticMethod(MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"getNiceErrorMessage", String.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle errorKeys = isError.invokeStaticMethod(CD_GET_ERROR_KEYS, new ResultHandle[0]);
            isError.invokeStaticMethod(CD_RESET_ERROR, new ResultHandle[0]);
            ResultHandle finalErrorMessageBuilder = isError.newInstance(SB_NEW, new ResultHandle[0]);
            isError.invokeVirtualMethod(SB_APPEND_STRING, finalErrorMessageBuilder, new ResultHandle[]{isError.load("One or more configuration errors have prevented the application from starting. The errors are:\n")});
            isError.invokeVirtualMethod(SB_APPEND_STRING, finalErrorMessageBuilder, new ResultHandle[]{niceErrorMessage});
            ResultHandle finalErrorMessage = isError.invokeVirtualMethod(OBJ_TO_STRING, finalErrorMessageBuilder, new ResultHandle[0]);
            ResultHandle configurationException = isError.newInstance(MethodDescriptor.ofConstructor(ConfigurationException.class, (Class[])new Class[]{String.class, Set.class}), new ResultHandle[]{finalErrorMessage, errorKeys});
            ResultHandle emptyStackTraceElement = isError.newArray(StackTraceElement.class, 0);
            isError.invokeVirtualMethod(MethodDescriptor.ofMethod(ConfigurationException.class, (String)"setStackTrace", Void.TYPE, (Class[])new Class[]{StackTraceElement[].class}), configurationException, new ResultHandle[]{emptyStackTraceElement});
            isError.throwException(configurationException);
            this.readConfig.returnValue(null);
            this.readConfig.close();
            this.clinit.returnValue(null);
            this.clinit.close();
            this.cc.close();
        }

        private void configSweepLoop(MethodCreator method, ResultHandle config, Set<String> registeredRoots, Type type) {
            ResultHandle propertyNames = method.invokeVirtualMethod(SRC_GET_PROPERTY_NAMES, config, new ResultHandle[0]);
            ResultHandle iterator = method.invokeInterfaceMethod(ITRA_ITERATOR, propertyNames, new ResultHandle[0]);
            ResultHandle rootSet = method.newInstance(HS_NEW, new ResultHandle[0]);
            for (String registeredRoot : registeredRoots) {
                method.invokeVirtualMethod(HS_ADD, rootSet, new ResultHandle[]{method.load(registeredRoot)});
            }
            try (BytecodeCreator sweepLoop = method.createScope();
                 BytecodeCreator hasNext = sweepLoop.ifNonZero(sweepLoop.invokeInterfaceMethod(ITR_HAS_NEXT, iterator, new ResultHandle[0])).trueBranch();){
                ResultHandle key = hasNext.checkCast(hasNext.invokeInterfaceMethod(ITR_NEXT, iterator, new ResultHandle[0]), String.class);
                ResultHandle keyIter = hasNext.newInstance(NI_NEW_STRING, new ResultHandle[]{key});
                ResultHandle isMappedName = hasNext.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)"isMapped", Boolean.TYPE, (Object[])new Object[]{NameIterator.class}), new ResultHandle[]{keyIter});
                try (BytecodeCreator isMappedPropertyTrue = hasNext.ifTrue(isMappedName).trueBranch();){
                    isMappedPropertyTrue.continueScope(sweepLoop);
                }
                BranchResult quarkusCompoundName = hasNext.ifNonZero(hasNext.invokeStaticMethod(PU_IS_PROPERTY_QUARKUS_COMPOUND_NAME, new ResultHandle[]{keyIter}));
                try (BytecodeCreator trueBranch = quarkusCompoundName.trueBranch();){
                    ResultHandle unknown = type == Type.BUILD_TIME ? trueBranch.readStaticField(C_UNKNOWN) : trueBranch.readStaticField(C_UNKNOWN_RUNTIME);
                    trueBranch.invokeVirtualMethod(HS_ADD, unknown, new ResultHandle[]{key});
                }
                hasNext.ifNonZero(hasNext.invokeStaticMethod(PU_IS_PROPERTY_IN_ROOTS, new ResultHandle[]{key, rootSet})).falseBranch().continueScope(sweepLoop);
                ResultHandle unknown = type == Type.BUILD_TIME ? hasNext.readStaticField(C_UNKNOWN) : hasNext.readStaticField(C_UNKNOWN_RUNTIME);
                hasNext.invokeVirtualMethod(HS_ADD, unknown, new ResultHandle[]{key});
                hasNext.continueScope(sweepLoop);
            }
        }

        private Set<String> getRegisteredRoots(ConfigPhase configPhase) {
            HashSet<String> registeredRoots = new HashSet<String>();
            if (ConfigPhase.BUILD_AND_RUN_TIME_FIXED.equals((Object)configPhase)) {
                for (ConfigMappings.ConfigClass mapping : this.buildTimeConfigResult.getBuildTimeRunTimeMappings()) {
                    registeredRoots.add(mapping.getPrefix());
                }
            }
            if (ConfigPhase.RUN_TIME.equals((Object)configPhase)) {
                for (ConfigMappings.ConfigClass mapping : this.buildTimeConfigResult.getRunTimeMappings()) {
                    registeredRoots.add(mapping.getPrefix());
                }
            }
            return registeredRoots;
        }

        private void installConfiguration(ResultHandle config, MethodCreator methodCreator) {
            methodCreator.invokeStaticMethod(QCF_SET_CONFIG, new ResultHandle[]{config});
        }

        private void generateIsMapped() {
            ConfigPatternMap<Boolean> patterns = new ConfigPatternMap<Boolean>();
            List<ConfigMappings.ConfigClass> configMappings = this.buildTimeConfigResult.getAllMappings();
            for (ConfigMappings.ConfigClass configMapping : configMappings) {
                Set names = ConfigMappings.getProperties((ConfigMappings.ConfigClass)configMapping).keySet();
                for (String name : names) {
                    NameIterator ni = new NameIterator(name);
                    ConfigPatternMap<Boolean> current = patterns;
                    while (ni.hasNext()) {
                        String segment = ni.getNextSegment();
                        ConfigPatternMap<Boolean> child = current.getChild(segment);
                        if (child == null) {
                            child = new ConfigPatternMap();
                            current.addChild(segment, child);
                        }
                        current = child;
                        ni.next();
                    }
                    current.setMatched(true);
                }
            }
            this.generateIsMapped("isMapped", patterns);
        }

        private void generateIsMapped(String methodName, ConfigPatternMap<Boolean> names) {
            MethodDescriptor method = MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)methodName, Boolean.TYPE, (Object[])new Object[]{NameIterator.class});
            MethodCreator mc = this.cc.getMethodCreator(method);
            mc.setModifiers(10);
            ResultHandle nameIterator = mc.getMethodParam(0);
            BranchResult hasNext = mc.ifTrue(mc.invokeVirtualMethod(NI_HAS_NEXT, nameIterator, new ResultHandle[0]));
            try (BytecodeCreator hasNextTrue = hasNext.trueBranch();){
                ArrayDeque<String> childNames = new ArrayDeque<String>();
                for (String childName : names.childNames()) {
                    if (childName.startsWith("*")) {
                        childNames.addLast(childName);
                        continue;
                    }
                    childNames.addFirst(childName);
                }
                for (String childName : childNames) {
                    ConfigPatternMap<Boolean> child = names.getChild(childName);
                    BranchResult nextEquals = hasNextTrue.ifTrue(hasNextTrue.invokeStaticMethod(PU_IS_MAPPED, new ResultHandle[]{nameIterator, hasNextTrue.load(childName)}));
                    BytecodeCreator nextEqualsTrue = nextEquals.trueBranch();
                    try {
                        childName = childName.replace("[*]", "-collection");
                        String childMethodName = methodName + "$" + StringUtil.skewer((String)childName, (char)'_');
                        if (child.getMatched() == null) {
                            this.generateIsMapped(childMethodName, child);
                            nextEqualsTrue.invokeVirtualMethod(NI_NEXT, nameIterator, new ResultHandle[0]);
                            nextEqualsTrue.returnValue(nextEqualsTrue.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)childMethodName, Boolean.TYPE, (Object[])new Object[]{NameIterator.class}), new ResultHandle[]{nameIterator}));
                            continue;
                        }
                        nextEqualsTrue.returnBoolean(true);
                    }
                    finally {
                        if (nextEqualsTrue == null) continue;
                        nextEqualsTrue.close();
                    }
                }
                hasNextTrue.returnBoolean(false);
            }
            try (BytecodeCreator hasNextFalse = hasNext.falseBranch();){
                hasNextFalse.returnBoolean(false);
            }
            mc.returnBoolean(false);
            mc.close();
        }

        @Override
        public void close() {
            try {
                this.clinit.close();
            }
            finally {
                this.cc.close();
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public boolean liveReloadPossible;
            private ClassOutput classOutput;
            private BuildTimeConfigurationReader.ReadResult buildTimeReadResult;

            Builder() {
            }

            ClassOutput getClassOutput() {
                return this.classOutput;
            }

            public Builder setClassOutput(ClassOutput classOutput) {
                this.classOutput = classOutput;
                return this;
            }

            public Builder setLiveReloadPossible(boolean liveReloadPossible) {
                this.liveReloadPossible = liveReloadPossible;
                return this;
            }

            BuildTimeConfigurationReader.ReadResult getBuildTimeReadResult() {
                return this.buildTimeReadResult;
            }

            public Builder setBuildTimeReadResult(BuildTimeConfigurationReader.ReadResult buildTimeReadResult) {
                this.buildTimeReadResult = buildTimeReadResult;
                return this;
            }

            public GenerateOperation build() {
                return new GenerateOperation(this);
            }
        }
    }
}

