/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ExtensionDevModeConfig;
import io.quarkus.bootstrap.model.JvmOption;
import io.quarkus.bootstrap.model.JvmOptions;
import io.quarkus.bootstrap.model.JvmOptionsBuilder;
import io.quarkus.deployment.dev.DevModeCommandLine;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.ExtensionDevModeJvmOptionFilter;
import io.quarkus.deployment.dev.IsolatedRemoteDevModeMain;
import io.quarkus.deployment.util.CommandLineUtil;
import io.quarkus.maven.dependency.ArtifactKey;
import io.smallrye.common.process.ProcessUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.logging.Logger;

public class DevModeCommandLineBuilder {
    private static final Logger log = Logger.getLogger(DevModeCommandLineBuilder.class);
    private static final String TIERED_STOP_AT_LEVEL = "TieredStopAtLevel";
    private static final String AGENTLIB_JDWP = "agentlib:jdwp";
    final Pattern validDebug = Pattern.compile("^(true|false|client|[0-9]+)$");
    final Pattern validPort = Pattern.compile("^-?[0-9]+$");
    private List<String> args = new ArrayList<String>();
    private JvmOptionsBuilder jvmOptionsBuilder = JvmOptions.builder();
    private String debug;
    private String suspend;
    private String debugHost = "localhost";
    private String debugPort = "5005";
    private String actualDebugPort;
    private File projectDir;
    private File buildDir;
    private File outputDir;
    private Map<String, String> buildSystemProperties = new HashMap<String, String>(0);
    private String applicationName;
    private String applicationVersion;
    private String sourceEncoding;
    private Map<String, Set<String>> compilerOptions = new HashMap<String, Set<String>>(1);
    private List<String> compilerPluginArtifacts;
    private List<String> compilerPluginOptions;
    private String releaseJavaVersion;
    private String sourceJavaVersion;
    private String targetJavaVersion;
    private Set<Path> buildFiles = new HashSet<Path>(0);
    private boolean deleteDevJar = true;
    private Boolean forceC2;
    private String baseName;
    private Consumer<DevModeContext> entryPointCustomizer;
    private String applicationArgs;
    private Set<ArtifactKey> localArtifacts = new HashSet<ArtifactKey>();
    private DevModeContext.ModuleInfo main;
    private List<DevModeContext.ModuleInfo> dependencies = new ArrayList<DevModeContext.ModuleInfo>(0);
    private LinkedHashMap<ArtifactKey, File> classpath = new LinkedHashMap();
    private Set<File> processorPaths;
    private List<String> processors;
    private Collection<ExtensionDevModeConfig> extDevModeConfig;
    private ExtensionDevModeJvmOptionFilter extDevModeJvmOptionFilter;

    private static void extensionsEnableC2Warning(List<ArtifactKey> extensions) {
        StringBuilder sb = new StringBuilder().append("Extension");
        if (extensions.size() > 1) {
            sb.append("s");
        }
        sb.append(" ").append(extensions.get(0).toGacString());
        for (int i = 1; i < extensions.size(); ++i) {
            sb.append(", ").append(extensions.get(i).toGacString());
        }
        sb.append(" enable");
        if (extensions.size() == 1) {
            sb.append("s");
        }
        sb.append(" the C2 compiler which is disabled by default in Dev mode for optimal performance.");
        log.info((Object)sb.toString());
    }

    private static void extensionsDisablingDebugWarning(List<ArtifactKey> extensions) {
        StringBuilder sb = new StringBuilder().append("Extension");
        if (extensions.size() > 1) {
            sb.append("s");
        }
        sb.append(" ").append(extensions.get(0).toGacString());
        for (int i = 1; i < extensions.size(); ++i) {
            sb.append(", ").append(extensions.get(i).toGacString());
        }
        sb.append(" disable");
        if (extensions.size() == 1) {
            sb.append("s");
        }
        sb.append(" the Debug mode for optimal performance. Debugging can still be enabled in the Quarkus plugin configuration or with -Ddebug on the command line.");
        log.info((Object)sb.toString());
    }

    protected DevModeCommandLineBuilder(String java) {
        String javaTool = java == null ? ProcessUtil.pathOfJava().toString() : java;
        log.debugf("Using javaTool: %s", (Object)javaTool);
        this.args.add(javaTool);
    }

    public DevModeCommandLineBuilder forceC2(Boolean force) {
        this.forceC2 = force;
        return this;
    }

    public DevModeCommandLineBuilder jvmArgs(String jvmArgs) {
        this.args.add(jvmArgs);
        return this;
    }

    public DevModeCommandLineBuilder jvmArgs(List<String> jvmArgs) {
        this.args.addAll(jvmArgs);
        return this;
    }

    public DevModeCommandLineBuilder debug(String debug) {
        this.debug = debug;
        return this;
    }

    public DevModeCommandLineBuilder suspend(String suspend) {
        this.suspend = suspend;
        return this;
    }

    public DevModeCommandLineBuilder projectDir(File projectDir) {
        this.projectDir = projectDir;
        return this;
    }

    public DevModeCommandLineBuilder buildDir(File buildDir) {
        this.buildDir = buildDir;
        return this;
    }

    public DevModeCommandLineBuilder outputDir(File outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public DevModeCommandLineBuilder buildSystemProperties(Map<String, String> buildSystemProperties) {
        this.buildSystemProperties = buildSystemProperties;
        return this;
    }

    public DevModeCommandLineBuilder buildSystemProperty(String name, String value) {
        this.buildSystemProperties.put(name, value);
        return this;
    }

    public DevModeCommandLineBuilder applicationName(String appName) {
        this.applicationName = appName;
        return this;
    }

    public DevModeCommandLineBuilder applicationVersion(String appVersion) {
        this.applicationVersion = appVersion;
        return this;
    }

    public DevModeCommandLineBuilder applicationArgs(String appArgs) {
        this.applicationArgs = appArgs;
        return this;
    }

    public DevModeCommandLineBuilder sourceEncoding(String srcEncoding) {
        this.sourceEncoding = srcEncoding;
        return this;
    }

    public DevModeCommandLineBuilder compilerOptions(String name, List<String> options) {
        this.compilerOptions.compute(name, (key, value) -> {
            if (value == null) {
                return new HashSet(options);
            }
            value.addAll(options);
            return value;
        });
        return this;
    }

    public DevModeCommandLineBuilder compilerOptions(Map<String, Set<String>> options) {
        this.compilerOptions.putAll(options);
        return this;
    }

    public DevModeCommandLineBuilder compilerPluginArtifacts(List<String> artifacts) {
        this.compilerPluginArtifacts = artifacts;
        return this;
    }

    public DevModeCommandLineBuilder compilerPluginOptions(List<String> options) {
        this.compilerPluginOptions = options;
        return this;
    }

    public DevModeCommandLineBuilder annotationProcessorPaths(Set<File> processorPaths) {
        this.processorPaths = processorPaths;
        return this;
    }

    public DevModeCommandLineBuilder annotationProcessors(List<String> processors) {
        this.processors = processors;
        return this;
    }

    public DevModeCommandLineBuilder releaseJavaVersion(String releaseJavaVersion) {
        this.releaseJavaVersion = releaseJavaVersion;
        return this;
    }

    public DevModeCommandLineBuilder sourceJavaVersion(String sourceJavaVersion) {
        this.sourceJavaVersion = sourceJavaVersion;
        return this;
    }

    public DevModeCommandLineBuilder targetJavaVersion(String targetJavaVersion) {
        this.targetJavaVersion = targetJavaVersion;
        return this;
    }

    public DevModeCommandLineBuilder watchedBuildFile(Path buildFile) {
        this.buildFiles.add(buildFile);
        return this;
    }

    public DevModeCommandLineBuilder deleteDevJar(boolean deleteDevJar) {
        this.deleteDevJar = deleteDevJar;
        return this;
    }

    public DevModeCommandLineBuilder baseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    public DevModeCommandLineBuilder remoteDev(boolean remoteDev) {
        this.entryPointCustomizer = devModeContext -> {
            devModeContext.setMode(QuarkusBootstrap.Mode.REMOTE_DEV_CLIENT);
            devModeContext.setAlternateEntryPoint(IsolatedRemoteDevModeMain.class.getName());
        };
        return this;
    }

    public DevModeCommandLineBuilder entryPointCustomizer(Consumer<DevModeContext> consumer) {
        this.entryPointCustomizer = consumer;
        return this;
    }

    public DevModeCommandLineBuilder localArtifact(ArtifactKey localArtifact) {
        this.localArtifacts.add(localArtifact);
        return this;
    }

    public boolean isLocal(ArtifactKey artifact) {
        return this.localArtifacts.contains(artifact);
    }

    public DevModeCommandLineBuilder mainModule(DevModeContext.ModuleInfo mainModule) {
        this.main = mainModule;
        return this;
    }

    public DevModeCommandLineBuilder dependency(DevModeContext.ModuleInfo module) {
        this.dependencies.add(module);
        return this;
    }

    public DevModeCommandLineBuilder classpathEntry(ArtifactKey key, File f) {
        File prev = this.classpath.put(key, f);
        if (prev != null && !f.equals(prev)) {
            Logger.getLogger(this.getClass()).warn((Object)(String.valueOf(key) + " classpath entry " + String.valueOf(prev) + " was overriden with " + String.valueOf(f)));
        }
        return this;
    }

    public DevModeCommandLineBuilder debugHost(String host) {
        if (null != host && !host.isEmpty()) {
            this.debugHost = host;
        }
        return this;
    }

    public DevModeCommandLineBuilder debugPort(String port) {
        if (null != port && !port.isEmpty()) {
            this.debugPort = port;
        }
        return this;
    }

    public DevModeCommandLineBuilder addOpens(String value) {
        this.jvmOptionsBuilder.add("add-opens", value);
        return this;
    }

    public DevModeCommandLineBuilder addModules(Collection<String> modules) {
        this.jvmOptionsBuilder.addAll("add-modules", modules);
        return this;
    }

    public DevModeCommandLineBuilder extensionDevModeConfig(Collection<ExtensionDevModeConfig> extDevModeConfig) {
        this.extDevModeConfig = extDevModeConfig;
        return this;
    }

    public DevModeCommandLineBuilder extensionDevModeJvmOptionFilter(ExtensionDevModeJvmOptionFilter extDevModeJvmOptionFilter) {
        this.extDevModeJvmOptionFilter = extDevModeJvmOptionFilter;
        return this;
    }

    public DevModeCommandLine build() throws Exception {
        DevModeContext devModeContext = new DevModeContext();
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            devModeContext.getSystemProperties().put(e.getKey().toString(), (String)e.getValue());
        }
        devModeContext.setProjectDir(this.projectDir);
        devModeContext.getBuildSystemProperties().putAll(this.buildSystemProperties);
        devModeContext.getBuildSystemProperties().putIfAbsent("quarkus.application.name", this.applicationName);
        devModeContext.getBuildSystemProperties().putIfAbsent("quarkus.application.version", this.applicationVersion);
        devModeContext.getBuildSystemProperties().putIfAbsent("quarkus.live-reload.ignore-module-info", "true");
        devModeContext.setSourceEncoding(this.sourceEncoding);
        devModeContext.setCompilerOptions(this.compilerOptions);
        if (this.compilerPluginArtifacts != null) {
            devModeContext.setCompilerPluginArtifacts(this.compilerPluginArtifacts);
        }
        if (this.compilerPluginOptions != null) {
            devModeContext.setCompilerPluginsOptions(this.compilerPluginOptions);
        }
        if (this.processorPaths != null) {
            devModeContext.setAnnotationProcessorPaths(this.processorPaths);
        }
        if (this.processors != null) {
            devModeContext.setAnnotationProcessors(this.processors);
        }
        devModeContext.setReleaseJavaVersion(this.releaseJavaVersion);
        devModeContext.setSourceJavaVersion(this.sourceJavaVersion);
        devModeContext.setTargetJvmVersion(this.targetJavaVersion);
        devModeContext.getLocalArtifacts().addAll(this.localArtifacts);
        devModeContext.setApplicationRoot(this.main);
        devModeContext.getAdditionalModules().addAll(this.dependencies);
        devModeContext.setBaseName(this.baseName);
        devModeContext.setCacheDir(new File(this.buildDir, "transformer-cache").getAbsoluteFile());
        if (this.entryPointCustomizer != null) {
            this.entryPointCustomizer.accept(devModeContext);
        }
        if (devModeContext.isEnablePreview()) {
            this.jvmOptionsBuilder.add("enable-preview");
        }
        this.setJvmOptions();
        this.args.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
        this.outputDir.mkdirs();
        this.args.add("-jar");
        this.args.add(this.createDevJar(devModeContext).getAbsolutePath());
        if (this.applicationArgs != null) {
            this.args.addAll(Arrays.asList(CommandLineUtil.translateCommandline(this.applicationArgs)));
        }
        return new DevModeCommandLine(this.args, this.actualDebugPort, this.buildFiles);
    }

    private File createDevJar(DevModeContext devModeContext) throws IOException {
        File tempFile = new File(this.buildDir, this.applicationName + "-dev.jar");
        tempFile.delete();
        if (this.deleteDevJar) {
            tempFile.deleteOnExit();
        }
        log.debugf("Executable jar: %s", (Object)tempFile.getAbsolutePath());
        devModeContext.setDevModeRunnerJarFile(tempFile);
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));){
            out.putNextEntry(new ZipEntry("META-INF/"));
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            StringBuilder classPathManifest = new StringBuilder();
            this.classpath.values().forEach(file -> {
                URI uri = file.toPath().toAbsolutePath().toUri();
                classPathManifest.append(uri).append(" ");
            });
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPathManifest.toString());
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, DevModeMain.class.getName());
            out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            manifest.write(out);
            out.putNextEntry(new ZipEntry("META-INF/dev-mode-context.dat"));
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream obj = new ObjectOutputStream(new DataOutputStream(bytes));
            obj.writeObject(devModeContext);
            obj.close();
            out.write(bytes.toByteArray());
        }
        return tempFile;
    }

    private void setJvmOptions() throws Exception {
        List<ArtifactKey> extensionsDisablingDebug;
        Map<String, List<ArtifactKey>> lockedJvmOptions = this.addExtensionJvmOptions();
        if (this.isDisableC2(lockedJvmOptions)) {
            this.args.add("-XX:TieredStopAtLevel=1");
        }
        if (this.debug == null && (extensionsDisablingDebug = lockedJvmOptions.get(AGENTLIB_JDWP)) != null) {
            DevModeCommandLineBuilder.extensionsDisablingDebugWarning(extensionsDisablingDebug);
        } else {
            this.configureDebugging();
        }
        for (JvmOption jvmOption : this.jvmOptionsBuilder.build()) {
            if (this.forceC2 != null && jvmOption.getName().equals(TIERED_STOP_AT_LEVEL)) continue;
            this.args.addAll(jvmOption.toCliOptions());
        }
    }

    private boolean isDisableC2(Map<String, List<ArtifactKey>> lockedJvmOptions) {
        if (this.forceC2 != null) {
            return this.forceC2 == false;
        }
        if (this.jvmOptionsBuilder.contains(TIERED_STOP_AT_LEVEL)) {
            return false;
        }
        List<ArtifactKey> lockingExtensions = lockedJvmOptions.get(TIERED_STOP_AT_LEVEL);
        if (lockingExtensions != null) {
            DevModeCommandLineBuilder.extensionsEnableC2Warning(lockingExtensions);
            return false;
        }
        return true;
    }

    private void configureDebugging() throws Exception {
        if (this.suspend != null) {
            switch (this.suspend.toLowerCase(Locale.ENGLISH)) {
                case "n": 
                case "false": {
                    this.suspend = "n";
                    break;
                }
                case "y": 
                case "true": {
                    this.suspend = "y";
                    break;
                }
                default: {
                    log.warn((Object)("Ignoring invalid value \"" + this.suspend + "\" for \"suspend\" param and defaulting to \"n\""));
                    this.suspend = "n";
                    break;
                }
            }
        } else {
            this.suspend = "n";
        }
        int port = 5005;
        if (this.debugPort != null && this.validPort.matcher(this.debugPort).matches()) {
            port = Integer.parseInt(this.debugPort);
        }
        if (this.debug != null) {
            if (!this.validDebug.matcher(this.debug).matches()) {
                throw new Exception("Invalid value for debug parameter: " + this.debug + " must be true|false|client|{port}");
            }
            if (this.validPort.matcher(this.debug).matches()) {
                port = Integer.parseInt(this.debug);
            }
        }
        int originalPort = port;
        if (port <= 0) {
            port = this.getRandomPort();
        }
        if (this.debug != null && this.debug.equalsIgnoreCase("client")) {
            this.args.add("-agentlib:jdwp=transport=dt_socket,address=" + this.debugHost + ":" + port + ",server=n,suspend=" + this.suspend);
            this.actualDebugPort = String.valueOf(port);
        } else if (this.debug == null || !this.debug.equalsIgnoreCase("false")) {
            boolean warnAboutChange = false;
            if (this.actualDebugPort == null) {
                int tries = 0;
                while (true) {
                    boolean isPortUsed;
                    try (Socket socket = new Socket();){
                        socket.connect(new InetSocketAddress(this.getInetAddress(this.debugHost), port), 500);
                        isPortUsed = true;
                        warnAboutChange = warnAboutChange || originalPort != 0;
                    }
                    catch (IOException e) {
                        isPortUsed = false;
                    }
                    if (!isPortUsed) {
                        this.actualDebugPort = String.valueOf(port);
                        break;
                    }
                    if (++tries >= 5) break;
                    port = this.getRandomPort();
                }
            }
            if (this.actualDebugPort != null) {
                if (warnAboutChange) {
                    log.warn((Object)("Changed debug port to " + this.actualDebugPort + " because of a port conflict"));
                }
                this.args.add("-agentlib:jdwp=transport=dt_socket,address=" + this.debugHost + ":" + port + ",server=y,suspend=" + this.suspend);
            } else {
                log.error((Object)("Port " + port + " in use, not starting in debug mode"));
            }
        }
    }

    private Map<String, List<ArtifactKey>> addExtensionJvmOptions() {
        if (this.extDevModeConfig == null || this.extDevModeJvmOptionFilter != null && this.extDevModeJvmOptionFilter.isDisableAll()) {
            return Map.of();
        }
        Map<String, List<ArtifactKey>> mergedLockedOptions = Map.of();
        for (ExtensionDevModeConfig extDevConfig : this.extDevModeConfig) {
            if (this.extDevModeJvmOptionFilter != null && this.extDevModeJvmOptionFilter.isDisabled(extDevConfig.getExtensionKey())) {
                log.debugf("Skipped JVM options from %s", (Object)extDevConfig.getExtensionKey());
                continue;
            }
            JvmOptions jvmOptions = extDevConfig.getJvmOptions();
            if (jvmOptions != null && !jvmOptions.isEmpty()) {
                this.jvmOptionsBuilder.addAll(jvmOptions);
                if (log.isDebugEnabled()) {
                    log.debugf("Adding JVM options from %s", (Object)extDevConfig.getExtensionKey());
                    for (JvmOption arg : jvmOptions.asCollection()) {
                        log.debug((Object)("  " + arg.getName() + ": " + String.valueOf(arg.getValues())));
                    }
                }
            }
            if (extDevConfig.getLockJvmOptions().isEmpty()) continue;
            mergedLockedOptions = DevModeCommandLineBuilder.collectLockedOptions(mergedLockedOptions, extDevConfig);
        }
        return mergedLockedOptions;
    }

    private static Map<String, List<ArtifactKey>> collectLockedOptions(Map<String, List<ArtifactKey>> allLockedOptions, ExtensionDevModeConfig extDevConfig) {
        Set extLockedOptions = extDevConfig.getLockJvmOptions();
        if (allLockedOptions.isEmpty()) {
            allLockedOptions = new HashMap<String, List<ArtifactKey>>(extLockedOptions.size());
        }
        for (String option : extLockedOptions) {
            allLockedOptions.computeIfAbsent(option, k -> new ArrayList(1)).add(extDevConfig.getExtensionKey());
        }
        log.debugf("%s locks JVM options %s", (Object)extDevConfig.getExtensionKey(), (Object)extLockedOptions);
        return allLockedOptions;
    }

    private int getRandomPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    private InetAddress getInetAddress(String host) throws UnknownHostException {
        if ("localhost".equals(host)) {
            return InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        return InetAddress.getByName(host);
    }
}

