/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.configuration.definition.ClassDefinition;
import io.quarkus.deployment.configuration.matching.ConfigPatternMap;
import io.quarkus.deployment.configuration.matching.Container;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DefaultValuesConfigurationSource
implements ConfigSource {
    private final ConfigPatternMap<Container> leafs;

    public DefaultValuesConfigurationSource(ConfigPatternMap<Container> leafs) {
        this.leafs = leafs;
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public String getValue(String propertyName) {
        if (!propertyName.startsWith("quarkus.")) {
            return null;
        }
        Container match = this.leafs.match(propertyName.substring(8));
        if (match == null) {
            return null;
        }
        ClassDefinition.ClassMember member = match.getClassMember();
        if (member instanceof ClassDefinition.ItemMember) {
            ClassDefinition.ItemMember leafMember = (ClassDefinition.ItemMember)member;
            return leafMember.getDefaultValue();
        }
        return null;
    }

    public String getName() {
        return "default values";
    }

    public int getOrdinal() {
        return Integer.MIN_VALUE;
    }
}

