/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.GroupConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.steps.ConfigurationSetup;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.Optional;
import org.eclipse.microprofile.config.spi.Converter;

public class BooleanConfigType
extends LeafConfigType {
    private static final MethodDescriptor BOOL_VALUE_METHOD = MethodDescriptor.ofMethod(Boolean.class, (String)"booleanValue", Boolean.TYPE, (Class[])new Class[0]);
    final String defaultValue;
    private final Class<? extends Converter<Boolean>> converterClass;

    public BooleanConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue, String javadocKey, String configKey, Class<? extends Converter<Boolean>> converterClass) {
        super(containingName, container, consumeSegment, javadocKey, configKey);
        this.defaultValue = defaultValue;
        this.converterClass = converterClass;
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            name.previous();
        }
        container.acceptConfigurationValueIntoLeaf(this, name, cache, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        container.generateAcceptConfigurationValueIntoLeaf(body, this, name, cache, config);
    }

    @Override
    public void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            Optional optionalValue = ConfigUtils.getOptionalValue((SmallRyeConfig)config, (String)name.toString(), Boolean.class, this.converterClass);
            field.setBoolean(enclosing, optionalValue.orElse(Boolean.FALSE));
        }
        catch (IllegalAccessException e) {
            throw BooleanConfigType.toError(e);
        }
    }

    @Override
    public void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        ResultHandle optionalValue = body.checkCast(body.invokeStaticMethod(CU_GET_OPT_VALUE, new ResultHandle[]{config, body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(Boolean.class), this.loadConverterClass(body)}), Optional.class);
        ResultHandle convertedDefault = body.readStaticField(FieldDescriptor.of(Boolean.class, (String)"FALSE", Boolean.class));
        ResultHandle defaultedValue = body.checkCast(body.invokeVirtualMethod(OPT_OR_ELSE_METHOD, optionalValue, new ResultHandle[]{convertedDefault}), Boolean.class);
        ResultHandle booleanValue = body.invokeVirtualMethod(BOOL_VALUE_METHOD, defaultedValue, new ResultHandle[0]);
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, booleanValue});
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultValue;
    }

    public Class<? extends Converter<Boolean>> getConverterClass() {
        return this.converterClass;
    }

    @Override
    public Class<?> getItemClass() {
        return Boolean.TYPE;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        try {
            Boolean value = (Boolean)ConfigUtils.convert((SmallRyeConfig)config, (String)ExpandingConfigSource.expandValue((String)this.defaultValue, (ExpandingConfigSource.Cache)cache), Boolean.class, this.converterClass);
            field.setBoolean(enclosing, value);
        }
        catch (IllegalAccessException e) {
            throw BooleanConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        ResultHandle value = body.invokeVirtualMethod(BOOL_VALUE_METHOD, this.getConvertedDefault(body, cache, config), new ResultHandle[0]);
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, value});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle smallRyeConfig) {
        return body.invokeVirtualMethod(BOOL_VALUE_METHOD, this.getConvertedDefault(body, cache, smallRyeConfig), new ResultHandle[0]);
    }

    private ResultHandle getConvertedDefault(BytecodeCreator body, ResultHandle cache, ResultHandle config) {
        return body.invokeStaticMethod(CU_CONVERT, new ResultHandle[]{config, cache == null ? body.load(this.defaultValue) : body.invokeStaticMethod(ConfigurationSetup.ECS_EXPAND_VALUE, new ResultHandle[]{body.load(this.defaultValue), cache}), body.loadClass(Boolean.class), this.loadConverterClass(body)});
    }
}

