/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.json.Json;
import io.quarkus.bootstrap.json.JsonArray;
import io.quarkus.bootstrap.json.JsonMember;
import io.quarkus.bootstrap.json.JsonObject;
import io.quarkus.bootstrap.json.JsonReader;
import io.quarkus.bootstrap.json.JsonValue;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.MappableCollectionFactory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationModelSerializer {
    private static final MappableCollectionFactory JSON_CONTAINER_FACTORY = new JsonCollectionFactory();
    private static final String QUARKUS_APPLICATION_MODEL_SERIALIZATION_FORMAT_PROP = "quarkus.bootstrap.application-model.serialization.format";
    private static final boolean JOS;

    private static Path getTempFile(boolean test) throws IOException {
        return Files.createTempFile("quarkus-" + (test ? "test-" : "") + "app-model", ".dat", new FileAttribute[0]);
    }

    public static void exportGradleModel(ApplicationModel model, boolean test) throws IOException {
        System.setProperty(test ? "quarkus-internal-test.serialized-app-model.path" : "quarkus-internal.serialized-app-model.path", ApplicationModelSerializer.serializeGradleModel(model, test).toString());
    }

    public static Path serializeGradleModel(ApplicationModel model, boolean test) throws IOException {
        Path serializedModel = ApplicationModelSerializer.getTempFile(test);
        if (JOS) {
            ApplicationModelSerializer.serializeWithJos(model, serializedModel);
        } else {
            ApplicationModelSerializer.writeJson(ApplicationModelSerializer.toJsonObjectBuilder(model.asMap()), serializedModel);
        }
        return serializedModel;
    }

    public static Path serialize(ApplicationModel model, boolean test) throws IOException {
        Path serializedModel = ApplicationModelSerializer.getTempFile(test);
        ApplicationModelSerializer.serialize(model, serializedModel);
        return serializedModel;
    }

    public static void serialize(ApplicationModel appModel, Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        if (JOS) {
            ApplicationModelSerializer.serializeWithJos(appModel, file);
        } else {
            ApplicationModelSerializer.toJson(appModel, file);
        }
    }

    public static ApplicationModel deserialize(Path file) throws IOException {
        return JOS ? ApplicationModelSerializer.deserializeWithJos(file) : ApplicationModelSerializer.fromJson(file);
    }

    private static void serializeWithJos(ApplicationModel appModel, Path file) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            out.writeObject(appModel);
        }
    }

    private static ApplicationModel deserializeWithJos(Path file) throws IOException {
        ApplicationModel applicationModel;
        block8: {
            InputStream existing = Files.newInputStream(file, new OpenOption[0]);
            try {
                applicationModel = (ApplicationModel)new ObjectInputStream(existing).readObject();
                if (existing == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (existing != null) {
                        try {
                            existing.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            existing.close();
        }
        return applicationModel;
    }

    private static void toJson(ApplicationModel appModel, Path file) throws IOException {
        ApplicationModelSerializer.writeJson((Json.JsonObjectBuilder)appModel.asMap(JSON_CONTAINER_FACTORY), file);
    }

    private static void writeJson(Json.JsonObjectBuilder jsonObject, Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            jsonObject.appendTo((Appendable)writer);
        }
    }

    private static ApplicationModel fromJson(Path file) throws IOException {
        Map<String, Object> modelMap = ApplicationModelSerializer.asMap((JsonObject)JsonReader.of((String)Files.readString(file)).read());
        return ApplicationModelBuilder.fromMap(modelMap);
    }

    private static Map<String, Object> asMap(JsonObject jsonObject) {
        List members = jsonObject.members();
        HashMap<String, Object> map = new HashMap<String, Object>(members.size());
        for (JsonMember member : members) {
            map.put(member.attribute().value(), ApplicationModelSerializer.asObject(member.value()));
        }
        return map;
    }

    private static Collection<Object> asCollection(JsonArray jsonArray) {
        ArrayList<Object> col = new ArrayList<Object>(jsonArray.size());
        jsonArray.stream().map(ApplicationModelSerializer::asObject).forEach(col::add);
        return col;
    }

    private static Object asObject(JsonValue jsonValue) {
        if (jsonValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            return ApplicationModelSerializer.asMap(jsonObject);
        }
        if (jsonValue instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            return ApplicationModelSerializer.asCollection(jsonArray);
        }
        return jsonValue.toString();
    }

    private static Json.JsonObjectBuilder toJsonObjectBuilder(Map<String, Object> map) {
        Json.JsonObjectBuilder result = Json.object((int)map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey(), ApplicationModelSerializer.toJsonTypeBuilder(entry.getValue()));
        }
        return result;
    }

    private static Json.JsonArrayBuilder toJsonArrayBuilder(Collection<Object> col) {
        Json.JsonArrayBuilder result = Json.array((int)col.size());
        for (Object o : col) {
            result.add(ApplicationModelSerializer.toJsonTypeBuilder(o));
        }
        return result;
    }

    private static Object toJsonTypeBuilder(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            return ApplicationModelSerializer.toJsonObjectBuilder(map);
        }
        if (o instanceof Collection) {
            Collection col = (Collection)o;
            return ApplicationModelSerializer.toJsonArrayBuilder(col);
        }
        return o;
    }

    private static void logMap(Map<String, Object> map, int offset) {
        String offsetString = " ".repeat(Math.max(0, offset));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                System.out.println(offsetString + entry.getKey());
                ApplicationModelSerializer.logMap((Map)entry.getValue(), offset + 2);
                continue;
            }
            if (entry.getValue() instanceof Collection) {
                System.out.println(offsetString + entry.getKey());
                ApplicationModelSerializer.logCollection((Collection)entry.getValue(), offset + 2);
                continue;
            }
            System.out.println(offsetString + entry.getKey() + ": " + String.valueOf(entry.getValue()));
        }
    }

    private static void logCollection(Collection<Object> col, int offset) {
        String offsetString = " ".repeat(Math.max(0, offset));
        for (Object entry : col) {
            if (entry instanceof Map) {
                ApplicationModelSerializer.logMap((Map)entry, offset + 2);
                continue;
            }
            if (entry instanceof Collection) {
                ApplicationModelSerializer.logCollection((Collection)entry, offset + 2);
                continue;
            }
            System.out.println(offsetString + String.valueOf(entry));
        }
    }

    static {
        String serializationFormat = System.getProperty(QUARKUS_APPLICATION_MODEL_SERIALIZATION_FORMAT_PROP);
        if (serializationFormat == null) {
            JOS = false;
        } else if (serializationFormat.equalsIgnoreCase("jos")) {
            JOS = true;
        } else {
            JOS = false;
            if (!serializationFormat.equalsIgnoreCase("json")) {
                throw new IllegalStateException("Unsupported serialization format: " + serializationFormat);
            }
        }
    }

    private static class JsonCollectionFactory
    implements MappableCollectionFactory {
        private JsonCollectionFactory() {
        }

        public Map<String, Object> newMap() {
            return Json.object();
        }

        public Map<String, Object> newMap(int initialCapacity) {
            return Json.object((int)initialCapacity);
        }

        public Collection<Object> newCollection() {
            return Json.array();
        }

        public Collection<Object> newCollection(int initialCapacity) {
            return Json.array((int)initialCapacity);
        }
    }
}

