/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.ApplicationModelSerializer;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;

public class IDELauncherImpl
implements Closeable {
    public static final String FORCE_COLOR_SUPPORT = "io.quarkus.force-color-support";
    private final CuratedApplication curatedApp;
    private final Closeable runningApp;

    public static Closeable launch(Path classesDir, Map<String, Object> context) {
        System.setProperty(FORCE_COLOR_SUPPORT, "true");
        System.setProperty("quarkus.console.basic", "true");
        Path projectDir = BuildToolHelper.getProjectDir(classesDir);
        if (projectDir == null) {
            throw new IllegalStateException("Failed to locate project dir for " + String.valueOf(classesDir));
        }
        try {
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setBaseClassLoader(IDELauncherImpl.class.getClassLoader()).setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.DEV).setTargetDirectory(classesDir.getParent());
            if (BuildToolHelper.isGradleProject(classesDir)) {
                ApplicationModel quarkusModel = BuildToolHelper.enableGradleAppModelForDevMode(classesDir);
                context.put("quarkus-internal.serialized-app-model.path", ApplicationModelSerializer.serializeGradleModel(quarkusModel, false));
                ArtifactSources mainSources = quarkusModel.getApplicationModule().getMainSources();
                PathsCollection applicationRoots = IDELauncherImpl.collectOutputDirs(mainSources);
                Path launchingModulePath = (Path)applicationRoots.iterator().next();
                builder.setProjectRoot(launchingModulePath).setApplicationRoot((PathCollection)applicationRoots).setTargetDirectory(quarkusModel.getApplicationModule().getBuildDir().toPath());
                for (ResolvedDependency dep : quarkusModel.getDependencies()) {
                    WorkspaceModule module = dep.getWorkspaceModule();
                    if (module == null) continue;
                    IDELauncherImpl.addAdditionalArchives(module.getSources(dep.getClassifier()), builder);
                }
            } else {
                builder.setApplicationRoot(classesDir).setProjectRoot(projectDir);
                BootstrapMavenContext mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setCurrentProject(projectDir.toString()));
                MavenArtifactResolver mvnResolver = new MavenArtifactResolver(mvnCtx);
                builder.setMavenArtifactResolver(mvnResolver);
            }
            CuratedApplication curatedApp = builder.build().bootstrap();
            Object appInstance = curatedApp.runInAugmentClassLoader("io.quarkus.deployment.dev.IDEDevModeMain", context);
            return new IDELauncherImpl(curatedApp, appInstance == null ? null : (appInstance instanceof Closeable ? (Closeable)appInstance : null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static PathsCollection collectOutputDirs(ArtifactSources mainSources) {
        PathsCollection.Builder outputDirs = PathsCollection.builder();
        IDELauncherImpl.collectOutputDirs(mainSources.getSourceDirs(), outputDirs);
        IDELauncherImpl.collectOutputDirs(mainSources.getResourceDirs(), outputDirs);
        return outputDirs.build();
    }

    private static void collectOutputDirs(Collection<SourceDir> sourceDirs, PathsCollection.Builder applicationRoots) {
        for (SourceDir sourceDir : sourceDirs) {
            if (applicationRoots.contains(sourceDir.getOutputDir()) || !Files.exists(sourceDir.getOutputDir(), new LinkOption[0])) continue;
            applicationRoots.add(sourceDir.getOutputDir());
        }
    }

    private static void addAdditionalArchives(ArtifactSources sources, QuarkusBootstrap.Builder builder) {
        IDELauncherImpl.addAdditionalArchives(builder, sources.getSourceDirs());
        IDELauncherImpl.addAdditionalArchives(builder, sources.getResourceDirs());
    }

    private static void addAdditionalArchives(QuarkusBootstrap.Builder builder, Collection<SourceDir> sourceDirs) {
        for (SourceDir dir : sourceDirs) {
            if (!Files.exists(dir.getOutputDir(), new LinkOption[0])) continue;
            builder.addAdditionalApplicationArchive(new AdditionalDependency(dir.getOutputDir(), true, false));
        }
    }

    private IDELauncherImpl(CuratedApplication curatedApp, Closeable runningApp) {
        this.curatedApp = curatedApp;
        this.runningApp = runningApp;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.runningApp != null) {
                this.runningApp.close();
            }
        }
        finally {
            if (this.curatedApp != null) {
                this.curatedApp.close();
            }
        }
    }
}

