/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.resolver.update.DefaultUpdateDiscovery;
import io.quarkus.bootstrap.resolver.update.DependenciesOrigin;
import io.quarkus.bootstrap.resolver.update.VersionUpdate;
import io.quarkus.bootstrap.resolver.update.VersionUpdateNumber;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedArtifactDependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.jboss.logging.Logger;

public class BootstrapAppModelFactory {
    private static final String QUARKUS = "quarkus";
    private static final String BOOTSTRAP = "bootstrap";
    private static final String APP_MODEL_DAT = "app-model.dat";
    public static final String CREATOR_APP_GROUP_ID = "creator.app.groupId";
    public static final String CREATOR_APP_ARTIFACT_ID = "creator.app.artifactId";
    public static final String CREATOR_APP_CLASSIFIER = "creator.app.classifier";
    public static final String CREATOR_APP_TYPE = "creator.app.type";
    public static final String CREATOR_APP_VERSION = "creator.app.version";
    private static final int CP_CACHE_FORMAT_ID = 2;
    private static final Logger log = Logger.getLogger(BootstrapAppModelFactory.class);
    private ArtifactCoords managingProject;
    private Path projectRoot;
    private List<Path> appCp = new ArrayList<Path>(0);
    private Boolean localProjectsDiscovery;
    private Boolean offline;
    private boolean enableClasspathCache;
    private boolean test;
    private boolean devMode;
    private AppModelResolver bootstrapAppModelResolver;
    private VersionUpdateNumber versionUpdateNumber;
    private VersionUpdate versionUpdate;
    private DependenciesOrigin dependenciesOrigin;
    private ResolvedDependency appArtifact;
    private MavenArtifactResolver mavenArtifactResolver;
    private BootstrapMavenContext mvnContext;
    Set<ArtifactKey> reloadableModules = Collections.emptySet();
    private Collection<io.quarkus.maven.dependency.Dependency> forcedDependencies = Collections.emptyList();

    public static BootstrapAppModelFactory newInstance() {
        return new BootstrapAppModelFactory();
    }

    private BootstrapAppModelFactory() {
    }

    public BootstrapAppModelFactory setTest(boolean test) {
        this.test = test;
        return this;
    }

    public BootstrapAppModelFactory setDevMode(boolean devMode) {
        this.devMode = devMode;
        return this;
    }

    public BootstrapAppModelFactory setLocalArtifacts(Set<AppArtifactKey> localArtifacts) {
        this.reloadableModules = localArtifacts.stream().map(k -> new GACT(k.getGroupId(), k.getArtifactId(), k.getClassifier(), k.getType())).collect(Collectors.toSet());
        return this;
    }

    public BootstrapAppModelFactory setProjectRoot(Path projectRoot) {
        this.projectRoot = projectRoot;
        return this;
    }

    public BootstrapAppModelFactory addToClassPath(Path path) {
        this.appCp.add(path);
        return this;
    }

    public BootstrapAppModelFactory setLocalProjectsDiscovery(Boolean localProjectsDiscovery) {
        this.localProjectsDiscovery = localProjectsDiscovery;
        return this;
    }

    public BootstrapAppModelFactory setOffline(Boolean offline) {
        this.offline = offline;
        return this;
    }

    public BootstrapAppModelFactory setEnableClasspathCache(boolean enable) {
        this.enableClasspathCache = enable;
        return this;
    }

    public BootstrapAppModelFactory setBootstrapAppModelResolver(AppModelResolver bootstrapAppModelResolver) {
        this.bootstrapAppModelResolver = bootstrapAppModelResolver;
        return this;
    }

    public BootstrapAppModelFactory setVersionUpdateNumber(VersionUpdateNumber versionUpdateNumber) {
        this.versionUpdateNumber = versionUpdateNumber;
        return this;
    }

    public BootstrapAppModelFactory setVersionUpdate(VersionUpdate versionUpdate) {
        this.versionUpdate = versionUpdate;
        return this;
    }

    public BootstrapAppModelFactory setDependenciesOrigin(DependenciesOrigin dependenciesOrigin) {
        this.dependenciesOrigin = dependenciesOrigin;
        return this;
    }

    public BootstrapAppModelFactory setAppArtifact(ResolvedDependency appArtifact) {
        this.appArtifact = appArtifact;
        return this;
    }

    public BootstrapAppModelFactory setForcedDependencies(Collection<io.quarkus.maven.dependency.Dependency> forcedDependencies) {
        this.forcedDependencies = forcedDependencies;
        return this;
    }

    public AppModelResolver getAppModelResolver() {
        if (this.bootstrapAppModelResolver != null) {
            return this.bootstrapAppModelResolver;
        }
        try {
            if (this.projectRoot != null && !Files.isDirectory(this.projectRoot, new LinkOption[0])) {
                MavenArtifactResolver mvn;
                if (this.mavenArtifactResolver == null) {
                    BootstrapMavenContext mvnCtx = this.createBootstrapMavenContext();
                    if (this.managingProject == null) {
                        this.managingProject = mvnCtx.getCurrentProjectArtifact("pom");
                    }
                    mvn = new MavenArtifactResolver(mvnCtx);
                } else {
                    mvn = this.mavenArtifactResolver;
                }
                this.bootstrapAppModelResolver = new BootstrapAppModelResolver(mvn).setTest(this.test).setDevMode(this.devMode);
                return this.bootstrapAppModelResolver;
            }
            MavenArtifactResolver mvn = this.mavenArtifactResolver;
            if (mvn == null) {
                mvn = new MavenArtifactResolver(this.createBootstrapMavenContext());
            }
            this.bootstrapAppModelResolver = new BootstrapAppModelResolver(mvn).setTest(this.test).setDevMode(this.devMode);
            return this.bootstrapAppModelResolver;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create application model resolver for " + this.projectRoot, e);
        }
    }

    private BootstrapMavenContext createBootstrapMavenContext() throws AppModelResolverException {
        Path projectPom;
        if (this.mvnContext != null) {
            return this.mvnContext;
        }
        if (this.mavenArtifactResolver != null) {
            this.mvnContext = this.mavenArtifactResolver.getMavenContext();
            if (this.mvnContext != null) {
                return this.mvnContext;
            }
        }
        BootstrapMavenContextConfig config = BootstrapMavenContext.config();
        if (this.offline != null) {
            config.setOffline(this.offline.booleanValue());
        }
        if ((projectPom = config.getPomForDirOrNull(this.projectRoot)) != null) {
            config.setCurrentProject(projectPom.toString());
        }
        config.setWorkspaceDiscovery(this.isWorkspaceDiscoveryEnabled());
        this.mvnContext = new BootstrapMavenContext(config);
        return this.mvnContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CurationResult resolveAppModel() throws BootstrapException {
        String serializedModel = this.test ? System.getProperty("quarkus-internal-test.serialized-app-model.path") : System.getProperty("quarkus-internal.serialized-app-model.path");
        if (serializedModel != null) {
            Path p = Paths.get(serializedModel, new String[0]);
            if (Files.exists(p, new LinkOption[0])) {
                try (InputStream existing = Files.newInputStream(Paths.get(serializedModel, new String[0]), new OpenOption[0]);){
                    ApplicationModel appModel = (ApplicationModel)new ObjectInputStream(existing).readObject();
                    CurationResult curationResult = new CurationResult(appModel);
                    return curationResult;
                }
                catch (IOException | ClassNotFoundException e) {
                    log.error((Object)"Failed to load serialized app mode", (Throwable)e);
                    IoUtils.recursiveDelete((Path)p);
                }
            } else {
                log.error((Object)("Failed to locate serialized application model at " + serializedModel));
            }
        }
        if (this.projectRoot != null) {
            if (!Files.isDirectory(this.projectRoot, new LinkOption[0])) return this.createAppModelForJar(this.projectRoot);
            if (this.projectRoot.getFileSystem().getClass().getName().contains("Zip")) {
                return this.createAppModelForJar(this.projectRoot);
            }
        }
        ResolvedDependency appArtifact = this.appArtifact;
        try {
            LocalProject localProject = null;
            if (appArtifact == null) {
                if (this.projectRoot == null) {
                    throw new IllegalArgumentException("Neither the application artifact nor the project root path has been provided");
                }
                LocalProject localProject2 = localProject = this.enableClasspathCache ? this.loadWorkspace() : LocalProject.load((Path)this.projectRoot, (boolean)false);
                if (localProject == null) {
                    log.warn((Object)"Unable to locate the maven project on the filesystem");
                    throw new BootstrapException("Failed to determine the Maven artifact associated with the application " + this.projectRoot);
                }
                appArtifact = localProject.getAppArtifact();
            }
            Path cachedCpPath = null;
            LocalWorkspace workspace = null;
            if (this.enableClasspathCache) {
                if (localProject == null) {
                    localProject = this.loadWorkspace();
                }
                workspace = localProject.getWorkspace();
                cachedCpPath = this.resolveCachedCpPath(localProject);
                if (Files.exists(cachedCpPath, new LinkOption[0]) && workspace.getLastModified() < Files.getLastModifiedTime(cachedCpPath, new LinkOption[0]).toMillis()) {
                    try (DataInputStream reader = new DataInputStream(Files.newInputStream(cachedCpPath, new OpenOption[0]));){
                        if (reader.readInt() == 2) {
                            if (reader.readInt() == workspace.getId()) {
                                Path p;
                                ObjectInputStream in = new ObjectInputStream(reader);
                                ApplicationModel appModel = (ApplicationModel)in.readObject();
                                log.debugf("Loaded cached AppModel %s from %s", (Object)appModel, (Object)cachedCpPath);
                                Object object = appModel.getDependencies().iterator();
                                block24: while (true) {
                                    if (!object.hasNext()) {
                                        object = new CurationResult(appModel);
                                        return object;
                                    }
                                    ResolvedDependency d = (ResolvedDependency)object.next();
                                    Iterator iterator = d.getResolvedPaths().iterator();
                                    do {
                                        if (!iterator.hasNext()) continue block24;
                                    } while (Files.exists(p = (Path)iterator.next(), new LinkOption[0]));
                                    break;
                                }
                                throw new IOException("Cached artifact does not exist: " + p);
                            }
                            BootstrapAppModelFactory.debug("Cached deployment classpath has expired for %s", appArtifact);
                        } else {
                            BootstrapAppModelFactory.debug("Unsupported classpath cache format in %s for %s", cachedCpPath, appArtifact);
                        }
                    }
                    catch (IOException e) {
                        log.warn((Object)("Failed to read deployment classpath cache from " + cachedCpPath + " for " + appArtifact), (Throwable)e);
                    }
                }
            }
            CurationResult curationResult = new CurationResult(this.getAppModelResolver().resolveManagedModel((ArtifactCoords)appArtifact, this.forcedDependencies, this.managingProject, this.reloadableModules));
            if (cachedCpPath == null) return curationResult;
            Files.createDirectories(cachedCpPath.getParent(), new FileAttribute[0]);
            try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(cachedCpPath, new OpenOption[0]));){
                out.writeInt(2);
                out.writeInt(workspace.getId());
                ObjectOutputStream obj = new ObjectOutputStream(out);
                obj.writeObject(curationResult.getApplicationModel());
                return curationResult;
            }
            catch (Exception e) {
                log.warn((Object)"Failed to write classpath cache", (Throwable)e);
            }
            return curationResult;
        }
        catch (Exception e) {
            throw new BootstrapException("Failed to create the application model for " + appArtifact, e);
        }
    }

    private boolean isWorkspaceDiscoveryEnabled() {
        return this.localProjectsDiscovery == null ? this.projectRoot != null && (this.test || this.devMode) : this.localProjectsDiscovery;
    }

    private LocalProject loadWorkspace() throws AppModelResolverException {
        return this.projectRoot == null || !Files.isDirectory(this.projectRoot, new LinkOption[0]) ? null : this.createBootstrapMavenContext().getCurrentProject();
    }

    private CurationResult createAppModelForJar(Path appArtifactPath) {
        Collection appDeps;
        ApplicationModel initialDepsList;
        ResolvedDependency appArtifact;
        AppModelResolver modelResolver;
        boolean loadedFromState;
        ResolvedDependency stateArtifact;
        block21: {
            log.debugf("provideOutcome depsOrigin=%s, versionUpdate=%s, versionUpdateNumber=%s", (Object)this.dependenciesOrigin, (Object)this.versionUpdate, (Object)this.versionUpdateNumber);
            stateArtifact = null;
            loadedFromState = false;
            modelResolver = this.getAppModelResolver();
            appArtifact = this.appArtifact;
            try {
                if (appArtifact == null) {
                    appArtifact = ModelUtils.resolveAppArtifact((Path)appArtifactPath);
                }
                modelResolver.relink((ArtifactCoords)appArtifact, appArtifactPath);
                if (this.dependenciesOrigin == DependenciesOrigin.LAST_UPDATE) {
                    log.info((Object)"Looking for the state of the last update");
                    Path statePath = null;
                    try {
                        ArtifactCoords stateCoords = ModelUtils.getStateArtifact((ArtifactCoords)appArtifact);
                        String latest = modelResolver.getLatestVersion(stateCoords, null, false);
                        if (!stateCoords.getVersion().equals(latest)) {
                            stateCoords = new GACTV(stateCoords.getGroupId(), stateCoords.getArtifactId(), stateCoords.getClassifier(), stateCoords.getType(), latest);
                        }
                        stateArtifact = modelResolver.resolve(stateArtifact);
                        statePath = stateArtifact.getResolvedPaths().getSinglePath();
                        log.info((Object)("- located the state at " + statePath));
                    }
                    catch (AppModelResolverException stateCoords) {
                        // empty catch block
                    }
                    if (statePath != null) {
                        Model model;
                        try {
                            model = ModelUtils.readModel(statePath);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to read application state " + statePath, e);
                        }
                        List modelStateDeps = model.getDependencies();
                        ArrayList<ArtifactDependency> updatedDeps = new ArrayList<ArtifactDependency>(modelStateDeps.size());
                        String groupIdProp = "${creator.app.groupId}";
                        for (Dependency modelDep : modelStateDeps) {
                            if (modelDep.getGroupId().equals("${creator.app.groupId}")) continue;
                            updatedDeps.add(new ArtifactDependency((ArtifactCoords)new ResolvedArtifactDependency((ArtifactCoords)new GACTV(modelDep.getGroupId(), modelDep.getArtifactId(), modelDep.getClassifier(), modelDep.getType(), modelDep.getVersion())), modelDep.getScope(), new int[]{modelDep.isOptional() ? 1 : 0}));
                        }
                        initialDepsList = modelResolver.resolveModel((ArtifactCoords)appArtifact, updatedDeps);
                        loadedFromState = true;
                        break block21;
                    }
                    initialDepsList = modelResolver.resolveModel((ArtifactCoords)appArtifact);
                    break block21;
                }
                initialDepsList = modelResolver.resolveManagedModel((ArtifactCoords)appArtifact, Collections.emptyList(), this.managingProject, this.reloadableModules);
            }
            catch (AppModelResolverException | IOException e) {
                throw new RuntimeException("Failed to resolve initial application dependencies", e);
            }
        }
        if (this.versionUpdate == VersionUpdate.NONE) {
            return new CurationResult(initialDepsList, Collections.emptyList(), loadedFromState, appArtifact, stateArtifact);
        }
        log.info((Object)"Checking for available updates");
        try {
            appDeps = modelResolver.resolveUserDependencies((ArtifactCoords)appArtifact, new ArrayList(initialDepsList.getRuntimeDependencies()));
        }
        catch (AppModelResolverException e) {
            throw new RuntimeException("Failed to determine the list of dependencies to update", e);
        }
        Iterator depsI = appDeps.iterator();
        while (depsI.hasNext()) {
            ResolvedDependency appDep = (ResolvedDependency)depsI.next();
            if (!appDep.getType().equals("jar")) {
                depsI.remove();
                continue;
            }
            appDep.getResolvedPaths().forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (!Files.exists(path.resolve("META-INF/quarkus-extension.properties"), new LinkOption[0])) {
                        depsI.remove();
                    }
                    return;
                }
                try (FileSystem artifactFs = ZipUtils.newFileSystem((Path)path);){
                    if (!Files.exists(artifactFs.getPath("META-INF/quarkus-extension.properties", new String[0]), new LinkOption[0])) {
                        depsI.remove();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to open " + path, e);
                }
            });
        }
        DefaultUpdateDiscovery ud = new DefaultUpdateDiscovery(modelResolver, this.versionUpdateNumber);
        ArrayList<ArtifactDependency> availableUpdates = null;
        for (ResolvedDependency depArtifact : appDeps) {
            String updatedVersion = this.versionUpdate == VersionUpdate.NEXT ? ud.getNextVersion(depArtifact) : ud.getLatestVersion(depArtifact);
            if (updatedVersion == null || depArtifact.getVersion().equals(updatedVersion)) continue;
            log.info((Object)(depArtifact.toGACTVString() + " -> " + updatedVersion));
            if (availableUpdates == null) {
                availableUpdates = new ArrayList<ArtifactDependency>();
            }
            availableUpdates.add(new ArtifactDependency((ArtifactCoords)new GACTV(depArtifact.getGroupId(), depArtifact.getArtifactId(), depArtifact.getClassifier(), depArtifact.getType(), updatedVersion), depArtifact.getScope(), new int[0]));
        }
        if (availableUpdates != null) {
            try {
                return new CurationResult(modelResolver.resolveManagedModel((ArtifactCoords)appArtifact, availableUpdates, this.managingProject, this.reloadableModules), availableUpdates, loadedFromState, appArtifact, stateArtifact);
            }
            catch (AppModelResolverException e) {
                throw new RuntimeException(e);
            }
        }
        log.info((Object)"- no updates available");
        return new CurationResult(initialDepsList, Collections.emptyList(), loadedFromState, appArtifact, stateArtifact);
    }

    private Path resolveCachedCpPath(LocalProject project) {
        String filePrefix = this.devMode ? "dev-" : (this.test ? "test-" : null);
        return project.getOutputDir().resolve(QUARKUS).resolve(BOOTSTRAP).resolve((String)(filePrefix == null ? APP_MODEL_DAT : filePrefix + APP_MODEL_DAT));
    }

    private static void debug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format(msg, args));
        }
    }

    public BootstrapAppModelFactory setMavenArtifactResolver(MavenArtifactResolver mavenArtifactResolver) {
        this.mavenArtifactResolver = mavenArtifactResolver;
        return this;
    }

    public BootstrapAppModelFactory setManagingProject(ArtifactCoords managingProject) {
        this.managingProject = managingProject;
        return this;
    }
}

