/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultApplicationModel
implements ApplicationModel,
Serializable {
    private static final long serialVersionUID = -3878782344578748234L;
    private final ResolvedDependency appArtifact;
    private final List<ResolvedDependency> dependencies;
    private final PlatformImports platformImports;
    private final List<ExtensionCapabilities> capabilityContracts;
    private final Set<ArtifactKey> localProjectArtifacts;
    private final Map<ArtifactKey, Set<String>> excludedResources;

    public DefaultApplicationModel(ApplicationModelBuilder builder) {
        this.appArtifact = builder.appArtifact;
        this.dependencies = builder.buildDependencies();
        this.platformImports = builder.platformImports;
        this.capabilityContracts = builder.extensionCapabilities;
        this.localProjectArtifacts = builder.reloadableWorkspaceModules;
        this.excludedResources = builder.excludedResources;
    }

    @Override
    public ResolvedDependency getAppArtifact() {
        return this.appArtifact;
    }

    @Override
    public Collection<ResolvedDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public PlatformImports getPlatforms() {
        return this.platformImports;
    }

    @Override
    public Collection<ExtensionCapabilities> getExtensionCapabilities() {
        return this.capabilityContracts;
    }

    @Override
    public Set<ArtifactKey> getParentFirst() {
        return this.getDependencies().stream().filter(Dependency::isClassLoaderParentFirst).map(ArtifactCoords::getKey).collect(Collectors.toSet());
    }

    @Override
    public Set<ArtifactKey> getRunnerParentFirst() {
        return this.getDependencies().stream().filter(d -> d.isFlagSet(512)).map(ArtifactCoords::getKey).collect(Collectors.toSet());
    }

    @Override
    public Set<ArtifactKey> getLowerPriorityArtifacts() {
        return this.getDependencies().stream().filter(d -> d.isFlagSet(1024)).map(ArtifactCoords::getKey).collect(Collectors.toSet());
    }

    @Override
    public Set<ArtifactKey> getReloadableWorkspaceDependencies() {
        return this.localProjectArtifacts;
    }

    @Override
    public Map<ArtifactKey, Set<String>> getRemovedResources() {
        return this.excludedResources;
    }
}

