/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.StartupBuildSteps;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.dev.DisableInstrumentationForIndexPredicateBuildItem;
import io.quarkus.runtime.StartupEvent;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodParameterInfo;

public class HotDeploymentConfigBuildStep {
    private static final DotName STARTUP_EVENT_NAME = DotName.createSimple((String)StartupEvent.class.getName());

    @BuildStep
    HotDeploymentWatchedFileBuildItem configFile() {
        return new HotDeploymentWatchedFileBuildItem("META-INF/beans.xml");
    }

    @BuildStep
    DisableInstrumentationForIndexPredicateBuildItem startup() {
        return new DisableInstrumentationForIndexPredicateBuildItem((Predicate)new Predicate<Index>(){

            @Override
            public boolean test(Index index) {
                if (!index.getAnnotations(StartupBuildSteps.STARTUP_NAME).isEmpty()) {
                    return true;
                }
                List observesInstances = index.getAnnotations(DotNames.OBSERVES);
                if (!observesInstances.isEmpty()) {
                    for (AnnotationInstance observesInstance : observesInstances) {
                        if (observesInstance.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) continue;
                        MethodParameterInfo methodParameterInfo = observesInstance.target().asMethodParameter();
                        short paramPos = methodParameterInfo.position();
                        if (!STARTUP_EVENT_NAME.equals((Object)methodParameterInfo.method().parameterType((int)paramPos).name())) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

