/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2014 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package io.undertow.httpcore;

import java.io.IOException;

import org.jboss.logging.Logger;

/**
 * @author Stuart Douglas
 */
public interface IoCallback<T> {

    Logger log = Logger.getLogger("io.undertow.request.io");

    void onComplete(final HttpExchange exchange, final T context);

    default void onException(final HttpExchange exchange, final T context, final IOException exception) {
        log.debugf(exception, "IO Exception");
        exchange.close();
    }

    /**
     * A default callback that simply ends the exchange.
     */
    IoCallback END_EXCHANGE = new IoCallback<Object>() {
        @Override
        public void onComplete(HttpExchange exchange, Object context) {
            exchange.endExchange();
        }
    };

}
