/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.httpcore;

import io.netty.util.concurrent.EventExecutor;
import io.undertow.httpcore.BlockingHttpExchange;
import io.undertow.httpcore.BufferAllocator;
import io.undertow.httpcore.CompletedListener;
import io.undertow.httpcore.InputChannel;
import io.undertow.httpcore.OutputChannel;
import io.undertow.httpcore.PreCommitListener;
import io.undertow.httpcore.SSLSessionInfo;
import io.undertow.httpcore.UndertowOptionMap;
import io.undertow.httpcore.WriteFunction;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public interface HttpExchange
extends Closeable {
    public BufferAllocator getBufferAllocator();

    public HttpExchange setStatusCode(int var1);

    public int getStatusCode();

    public String getRequestHeader(String var1);

    public List<String> getRequestHeaders(String var1);

    public boolean containsRequestHeader(String var1);

    public void removeRequestHeader(String var1);

    public void setRequestHeader(String var1, String var2);

    public Collection<String> getRequestHeaderNames();

    public void addRequestHeader(String var1, String var2);

    public void clearRequestHeaders();

    public List<String> getResponseHeaders(String var1);

    public boolean containsResponseHeader(String var1);

    public void removeResponseHeader(String var1);

    public void setResponseHeader(String var1, String var2);

    public Collection<String> getResponseHeaderNames();

    public void addResponseHeader(String var1, String var2);

    public void clearResponseHeaders();

    public String getResponseHeader(String var1);

    public void setCompletedListener(CompletedListener var1);

    public void setPreCommitListener(PreCommitListener var1);

    default public long getRequestContentLength() {
        String contentLengthString = this.getRequestHeader("Content-Length");
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    default public long getResponseContentLength() {
        String contentLengthString = this.getResponseHeader("Content-Length");
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    default public boolean isUpgrade() {
        return this.getStatusCode() == 101;
    }

    public String getRequestMethod();

    public String getRequestScheme();

    public String getRequestURI();

    public String getProtocol();

    public boolean isInIoThread();

    public void addWriteFunction(WriteFunction var1);

    public OutputChannel getOutputChannel();

    public InputChannel getInputChannel();

    public InputStream getInputStream();

    public OutputStream getOutputStream();

    public void setBlockingHttpExchange(BlockingHttpExchange var1);

    public InetSocketAddress getDestinationAddress();

    public InetSocketAddress getSourceAddress();

    public boolean isComplete();

    public boolean isRequestComplete();

    public boolean isResponseComplete();

    @Override
    public void close();

    public EventExecutor getIoThread();

    public void setUpgradeListener(Consumer<Object> var1);

    public Executor getWorker();

    public UndertowOptionMap getUndertowOptions();

    public void sendContinue();

    public void discardRequest();

    public boolean isUpgradeSupported();

    public SSLSessionInfo getSslSessionInfo();

    default public boolean isPushSupported() {
        return false;
    }

    default public boolean isRequestTrailerFieldsSupported() {
        return false;
    }

    public boolean isIoOperationQueued();

    public void setMaxEntitySize(long var1);

    public long getMaxEntitySize();

    public void setReadTimeout(long var1);

    public long getReadTimeout();

    public void endExchange();

    public long getResponseBytesSent();
}

