/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.httpcore;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.undertow.httpcore.BlockingHttpExchange;
import io.undertow.httpcore.CompletedListener;
import io.undertow.httpcore.DefaultBlockingHttpExchange;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.InputChannel;
import io.undertow.httpcore.IoCallback;
import io.undertow.httpcore.OutputChannel;
import io.undertow.httpcore.PreCommitListener;
import io.undertow.httpcore.WriteFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public abstract class HttpExchangeBase
implements HttpExchange,
OutputChannel {
    private static final Logger log = Logger.getLogger(HttpExchangeBase.class);
    private static final BiConsumer<InputChannel, HttpExchangeBase> DRAIN_CALLBACK = new BiConsumer<InputChannel, HttpExchangeBase>(){

        @Override
        public void accept(InputChannel channel, HttpExchangeBase exchange) {
            while (channel.isReadable()) {
                try {
                    if (channel.readAsync() != null) continue;
                    return;
                }
                catch (IOException e) {
                    log.debugf((Throwable)e, "Error draining request", new Object[0]);
                    exchange.close();
                    return;
                }
            }
            channel.setReadHandler(this, exchange);
        }
    };
    private boolean requestTerminated;
    private boolean responseTerminated;
    private CompletedListener completedListener;
    private BlockingHttpExchange blockingHttpExchange;
    private int writeFunctionCount;
    private WriteFunction[] writeFunctions;
    protected PreCommitListener preCommitListener;
    private boolean responseStarted;
    private long responseBytesSent = 0L;

    @Override
    public void setCompletedListener(CompletedListener listener) {
        this.completedListener = listener;
    }

    @Override
    public void setPreCommitListener(PreCommitListener listener) {
        this.preCommitListener = listener;
    }

    protected void terminateRequest() {
        if (this.requestTerminated) {
            return;
        }
        this.requestTerminated = true;
        if (this.responseTerminated && this.completedListener != null) {
            this.completedListener.completed(this);
        }
    }

    protected void terminateResponse() {
        if (this.responseTerminated) {
            return;
        }
        this.responseTerminated = true;
        if (this.requestTerminated && this.completedListener != null) {
            this.completedListener.completed(this);
        }
    }

    @Override
    public void setBlockingHttpExchange(BlockingHttpExchange exchange) {
        if (this.blockingHttpExchange != null) {
            return;
        }
        this.blockingHttpExchange = exchange;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.blockingHttpExchange == null) {
            this.blockingHttpExchange = new DefaultBlockingHttpExchange(this);
        }
        return this.blockingHttpExchange.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        if (this.blockingHttpExchange == null) {
            this.blockingHttpExchange = new DefaultBlockingHttpExchange(this);
        }
        return this.blockingHttpExchange.getInputStream();
    }

    @Override
    public boolean isComplete() {
        return this.requestTerminated && this.responseTerminated;
    }

    @Override
    public boolean isRequestComplete() {
        return this.requestTerminated;
    }

    @Override
    public boolean isResponseComplete() {
        return this.responseTerminated;
    }

    @Override
    public void endExchange() {
        if (this.blockingHttpExchange != null) {
            try {
                this.blockingHttpExchange.close();
            }
            catch (IOException e) {
                this.close();
            }
        }
        if (!this.isRequestComplete()) {
            DRAIN_CALLBACK.accept(this.getInputChannel(), this);
        }
        if (!this.isResponseComplete()) {
            this.getOutputChannel().writeAsync(null, true, null, null);
        }
    }

    @Override
    public final void writeAsync(String data) {
        OutputChannel.super.writeAsync(data);
    }

    @Override
    public final void writeAsync(String data, Charset charset) {
        OutputChannel.super.writeAsync(data, charset);
    }

    @Override
    public final <T> void writeAsync(String data, Charset charset, boolean last, IoCallback<T> callback, T context) {
        OutputChannel.super.writeAsync(data, charset, last, callback, context);
    }

    @Override
    public void addWriteFunction(WriteFunction listener) {
        int writeFunctionCount = this.writeFunctionCount++;
        WriteFunction[] writeFunctions = this.writeFunctions;
        if (writeFunctions == null || writeFunctions.length == writeFunctionCount) {
            WriteFunction[] old = writeFunctions;
            this.writeFunctions = writeFunctions = new WriteFunction[writeFunctionCount + 2];
            if (old != null) {
                System.arraycopy(old, 0, writeFunctions, 0, writeFunctionCount);
            }
        }
        writeFunctions[writeFunctionCount] = listener;
    }

    @Override
    public OutputChannel getOutputChannel() {
        return this;
    }

    protected boolean isResponseStarted() {
        return this.responseStarted;
    }

    @Override
    public final <T> void writeAsync(ByteBuf data, boolean last, IoCallback<T> callback, T context) {
        if (!last) {
            Objects.requireNonNull(callback, "Callback cannot be null");
        }
        data = this.processData(data, last);
        this.writeAsync0(data, last, callback, context);
    }

    protected abstract <T> void writeAsync0(ByteBuf var1, boolean var2, IoCallback<T> var3, T var4);

    @Override
    public final void writeBlocking(ByteBuf data, boolean last) throws IOException {
        data = this.processData(data, last);
        this.writeBlocking0(data, last);
    }

    protected abstract void writeBlocking0(ByteBuf var1, boolean var2) throws IOException;

    @Override
    public long getResponseBytesSent() {
        if (this.isResponseEntityBodyAllowed() && !this.getRequestMethod().equals("HEAD")) {
            return this.responseBytesSent;
        }
        return 0L;
    }

    private ByteBuf processData(ByteBuf data, boolean last) {
        if (!this.responseStarted) {
            if (this.preCommitListener != null) {
                this.preCommitListener.preCommit(this);
            }
            if (!this.isResponseEntityBodyAllowed()) {
                this.addWriteFunction(new WriteFunction(){

                    @Override
                    public ByteBuf preWrite(ByteBuf data, boolean last) {
                        data.release();
                        return Unpooled.EMPTY_BUFFER;
                    }
                });
            }
            if (this.writeFunctions != null && data != null) {
                for (int i = 0; i < this.writeFunctionCount; ++i) {
                    data = this.writeFunctions[i].preWrite(data, last);
                }
            }
            if (last) {
                if (data == null) {
                    if (!this.containsResponseHeader("Content-Length")) {
                        this.addResponseHeader("Content-Length", "0");
                    }
                } else if (!this.containsResponseHeader("Content-Length")) {
                    this.addResponseHeader("Content-Length", Integer.toString(data.readableBytes()));
                }
            } else if (!this.containsResponseHeader("Content-Length")) {
                this.setResponseHeader("Transfer-Encoding", "chunked");
            }
            this.responseStarted = true;
        } else if (this.writeFunctions != null && data != null) {
            for (int i = 0; i < this.writeFunctionCount; ++i) {
                data = this.writeFunctions[i].preWrite(data, last);
            }
        }
        if (data != null && !this.isResponseEntityBodyAllowed()) {
            data.release();
            return Unpooled.EMPTY_BUFFER;
        }
        if (data != null) {
            this.responseBytesSent += (long)data.readableBytes();
        }
        return data;
    }

    protected boolean isResponseEntityBodyAllowed() {
        if (this.getRequestMethod().equals("HEAD")) {
            return false;
        }
        int code = this.getStatusCode();
        if (code >= 100 && code < 200) {
            return false;
        }
        return code != 204 && code != 304;
    }

    protected boolean isRequestEntityBodyAllowed() {
        String method = this.getRequestMethod();
        return !method.equals("GET") && !method.equals("HEAD");
    }
}

