/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.Descs;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.List;

public class EqualsHashCodeToStringGenerator {
    private final ClassCreator cc;
    private final List<FieldDesc> fields;

    public EqualsHashCodeToStringGenerator(ClassCreator cc, List<FieldDesc> fields) {
        this.cc = cc;
        this.fields = fields;
    }

    public void generateEquals() {
        ClassDesc thisClass = this.cc.type();
        this.cc.method("equals", mc -> {
            mc.public_();
            mc.returning(ConstantDescs.CD_boolean);
            ParamVar other = mc.parameter("other", ConstantDescs.CD_Object);
            mc.body(b0 -> {
                b0.if_(b0.eq((Expr)this.cc.this_(), other), BlockCreator::returnTrue);
                b0.ifNotInstanceOf((Expr)other, thisClass, BlockCreator::returnFalse);
                LocalVar otherCast = b0.localVar("other", b0.cast((Expr)other, thisClass));
                block7: for (FieldDesc field : this.fields) {
                    if (!Util.equals(field.owner(), thisClass)) {
                        throw new IllegalArgumentException("Field does not belong to " + thisClass.displayName() + ": " + String.valueOf(field));
                    }
                    LocalVar thisValue = b0.localVar("thisValue", b0.get(this.cc.this_().field(field)));
                    LocalVar thatValue = b0.localVar("thatValue", b0.get(otherCast.field(field)));
                    String fieldDesc = field.type().descriptorString();
                    switch (fieldDesc.charAt(0)) {
                        case 'B': 
                        case 'C': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            b0.if_(b0.ne((Expr)thisValue, thatValue), BlockCreator::returnFalse);
                            continue block7;
                        }
                        case 'F': {
                            Expr thisBits = b0.invokeStatic((MethodDesc)Descs.MD_Float.floatToIntBits, (Expr)thisValue);
                            Expr thatBits = b0.invokeStatic((MethodDesc)Descs.MD_Float.floatToIntBits, (Expr)thatValue);
                            b0.if_(b0.ne(thisBits, thatBits), BlockCreator::returnFalse);
                            continue block7;
                        }
                        case 'D': {
                            Expr thisBits = b0.invokeStatic((MethodDesc)Descs.MD_Double.doubleToLongBits, (Expr)thisValue);
                            Expr thatBits = b0.invokeStatic((MethodDesc)Descs.MD_Double.doubleToLongBits, (Expr)thatValue);
                            b0.if_(b0.ne(thisBits, thatBits), BlockCreator::returnFalse);
                            continue block7;
                        }
                        case 'L': {
                            b0.ifNot(b0.exprEquals(thisValue, thatValue), BlockCreator::returnFalse);
                            continue block7;
                        }
                        case '[': {
                            b0.ifNot(b0.arrayEquals(thisValue, thatValue), BlockCreator::returnFalse);
                            continue block7;
                        }
                    }
                    throw Assert.impossibleSwitchCase((Object)field);
                }
                b0.return_(true);
            });
        });
    }

    public void generateHashCode() {
        ClassDesc thisClass = this.cc.type();
        this.cc.method("hashCode", mc -> {
            mc.public_();
            mc.returning(Integer.TYPE);
            mc.body(b0 -> {
                if (this.fields.isEmpty()) {
                    b0.return_(0);
                    return;
                }
                LocalVar result = b0.localVar("result", Const.of(1));
                for (FieldDesc field : this.fields) {
                    if (!Util.equals(field.owner(), thisClass)) {
                        throw new IllegalArgumentException("Field does not belong to " + thisClass.displayName() + ": " + String.valueOf(field));
                    }
                    LocalVar value = b0.localVar("value", b0.get(this.cc.this_().field(field)));
                    LocalVar hash = b0.localVar("hash", field.type().isArray() ? b0.arrayHashCode(value) : b0.exprHashCode(value));
                    b0.set((Assignable)result, b0.add(b0.mul((Expr)Const.of(31), result), hash));
                }
                b0.return_(result);
            });
        });
    }

    public void generateToString() {
        ClassDesc thisClass = this.cc.type();
        this.cc.method("toString", mc -> {
            mc.public_();
            mc.returning(String.class);
            mc.body(b0 -> {
                LocalVar result = b0.localVar("result", b0.new_(Descs.CD_StringBuilder));
                b0.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.append_String, (Expr)result, (Expr)Const.of(thisClass.displayName() + "("));
                boolean first = true;
                for (FieldDesc field : this.fields) {
                    if (!Util.equals(field.owner(), thisClass)) {
                        throw new IllegalArgumentException("Field does not belong to " + thisClass.displayName() + ": " + String.valueOf(field));
                    }
                    if (first) {
                        b0.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.append_String, (Expr)result, (Expr)Const.of(field.name() + "="));
                    } else {
                        b0.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.append_String, (Expr)result, (Expr)Const.of(", " + field.name() + "="));
                    }
                    Expr value = b0.get(this.cc.this_().field(field));
                    b0.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.append_String, (Expr)result, field.type().isArray() ? b0.arrayToString(value) : b0.exprToString(value));
                    first = false;
                }
                b0.invokeVirtual((MethodDesc)Descs.MD_StringBuilder.append_String, (Expr)result, (Expr)Const.of(")"));
                b0.return_(b0.withObject(result).toString_());
            });
        });
    }
}

