/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jooq.sql;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.jooq.Configuration;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteType;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.VisitContext;
import org.jooq.VisitListener;
import org.jooq.VisitListenerProvider;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultVisitListener;
import org.jooq.impl.DefaultVisitListenerProvider;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.LoggerListener;
import org.jooq.tools.StringUtils;

public class SqlLoggerListener
extends LoggerListener {
    private static final Logger log = Logger.getLogger(SqlLoggerListener.class);
    public static JooqLogger sqlLog = JooqLogger.getLogger(SqlLoggerListener.class);
    private static final int maxLength = 2000;

    private final Configuration abbreviateBindVariables(Configuration configuration) {
        VisitListenerProvider[] oldProviders = configuration.visitListenerProviders();
        VisitListenerProvider[] newProviders = new VisitListenerProvider[oldProviders.length + 1];
        System.arraycopy(oldProviders, 0, newProviders, 0, oldProviders.length);
        newProviders[newProviders.length - 1] = new DefaultVisitListenerProvider((VisitListener)new BindValueAbbreviator());
        return configuration.derive(newProviders);
    }

    public void renderEnd(ExecuteContext ctx) {
        if (log.isDebugEnabled()) {
            String newline;
            Configuration configuration = ctx.configuration();
            String string = newline = Boolean.TRUE.equals(configuration.settings().isRenderFormatted()) ? "\n" : "";
            if (!log.isTraceEnabled()) {
                configuration = this.abbreviateBindVariables(configuration);
            }
            String[] batchSQL = ctx.batchSQL();
            if (ctx.query() != null) {
                String inlined = DSL.using((Configuration)configuration).renderInlined((QueryPart)ctx.query());
                if (!ctx.sql().equals(inlined)) {
                    sqlLog.debug((Object)"<<SQL>>", (Object)(newline + inlined));
                } else {
                    sqlLog.debug((Object)"<<SQL>>", (Object)(newline + ctx.sql()));
                }
            } else if (ctx.routine() != null) {
                String inlined = DSL.using((Configuration)configuration).renderInlined((QueryPart)ctx.routine());
                if (!ctx.sql().equals(inlined)) {
                    sqlLog.debug((Object)"<<SQL:routine>>", (Object)(newline + inlined));
                } else {
                    sqlLog.debug((Object)"<<SQL:routine>>", (Object)(newline + ctx.sql()));
                }
            } else if (!StringUtils.isBlank((String)ctx.sql())) {
                if (ctx.type() == ExecuteType.BATCH) {
                    sqlLog.debug((Object)"<<SQL:batch>>", (Object)(newline + ctx.sql()));
                } else {
                    sqlLog.debug((Object)"<<SQL>>", (Object)(newline + ctx.sql()));
                }
            } else if (batchSQL.length > 0 && batchSQL[batchSQL.length - 1] != null) {
                for (String sql : batchSQL) {
                    sqlLog.debug((Object)"<<SQL:batch>>", (Object)(newline + sql));
                }
            }
        }
    }

    public void recordEnd(ExecuteContext ctx) {
    }

    public void resultEnd(ExecuteContext ctx) {
    }

    public void executeEnd(ExecuteContext ctx) {
    }

    static void setStaticFinalField(Class<?> clsObj, String fieldName, Object newValue) {
        SqlLoggerListener.setFinalField(null, clsObj, fieldName, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setFinalField(Object reflectObj, Class<?> clsObj, String fieldName, Object newValue) {
        if (clsObj == null) {
            throw new IllegalArgumentException("(clsObj == null)");
        }
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("(fieldName == null || fieldName.length() == 0), fieldName=[" + fieldName + "]");
        }
        try {
            Field field = clsObj.getDeclaredField(fieldName);
            boolean keepStatus = field.canAccess(reflectObj);
            if (!keepStatus) {
                field.setAccessible(true);
            }
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            try {
                field.set(reflectObj, newValue);
            }
            finally {
                field.setAccessible(keepStatus);
                modifiersField.setInt(field, field.getModifiers() & 0x10);
            }
        }
        catch (Exception e) {
            String msg = "reflect object class: " + (reflectObj == null ? "<null>" : reflectObj.getClass().getName()) + ", declared class: " + clsObj.getName() + ", field name: " + fieldName;
            log.warn((Object)(msg + ", error: " + e.toString()));
            throw new RuntimeException(msg, e);
        }
    }

    static {
        log.debug((Object)("sqlLog.isTraceEnabled: " + sqlLog.isTraceEnabled()));
        if (sqlLog.isTraceEnabled()) {
            try {
                SqlLoggerListener.setStaticFinalField(LoggerListener.class, "log", sqlLog);
            }
            catch (Exception e) {
                log.warn((Object)e.toString());
            }
        }
    }

    private static class BindValueAbbreviator
    extends DefaultVisitListener {
        private boolean anyAbbreviations = false;

        private BindValueAbbreviator() {
        }

        public void visitStart(VisitContext context) {
            QueryPart part;
            if (context.renderContext() != null && (part = context.queryPart()) instanceof Param) {
                Param param = (Param)part;
                Object value = param.getValue();
                if (value instanceof String && ((String)value).length() > 2000) {
                    this.anyAbbreviations = true;
                    context.queryPart((QueryPart)DSL.val((String)StringUtils.abbreviate((String)((String)value), (int)2000)));
                } else if (value instanceof byte[] && ((byte[])value).length > 2000) {
                    this.anyAbbreviations = true;
                    context.queryPart((QueryPart)DSL.val((byte[])Arrays.copyOf((byte[])value, 2000)));
                }
            }
        }

        public void visitEnd(VisitContext context) {
            if (this.anyAbbreviations && context.queryPartsLength() == 1) {
                context.renderContext().sql(" -- Bind values may have been abbreviated for DEBUG logging. Use TRACE logging for very large bind variables.");
            }
        }
    }
}

