/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoLexer;
import io.protostuff.parser.ProtoParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public final class ProtoUtil {
    private ProtoUtil() {
    }

    public static void loadFrom(ANTLRReaderStream input, Proto target) throws Exception {
        ProtoLexer lexer = new ProtoLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ProtoParser parser = new ProtoParser((TokenStream)tokens);
        parser.parse(target);
    }

    public static void loadFrom(InputStream in, Proto target) throws Exception {
        ProtoUtil.loadFrom((ANTLRReaderStream)new ANTLRInputStream(in), target);
    }

    public static void loadFrom(Reader reader, Proto target) throws Exception {
        ProtoUtil.loadFrom(new ANTLRReaderStream(reader), target);
    }

    public static Proto parseProto(File file) {
        Proto proto = new Proto(file);
        try {
            ProtoUtil.loadFrom(file, proto);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return proto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFrom(File file, Proto target) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            ProtoUtil.loadFrom(in, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFrom(URL resource, Proto target) throws Exception {
        try (InputStream in = resource.openStream();){
            ProtoUtil.loadFrom(in, target);
        }
    }

    public static StringBuilder toCamelCase(String name) {
        StringBuilder buffer = new StringBuilder();
        int toUpper = 0;
        int i = 0;
        int len = name.length();
        while (i < len) {
            char c;
            if ((c = name.charAt(i++)) == '_') {
                if (i == len) break;
                if (buffer.length() == 0) continue;
                ++toUpper;
                continue;
            }
            if (toUpper != 0) {
                if (c > '`' && c < '{') {
                    buffer.append((char)(c - 32));
                    toUpper = 0;
                    continue;
                }
                if (c > '@' && c < '[') {
                    buffer.append(c);
                    toUpper = 0;
                    continue;
                }
                while (toUpper > 0) {
                    buffer.append('_');
                    --toUpper;
                }
                buffer.append(c);
                continue;
            }
            if (buffer.length() == 0 && c > '@' && c < '[') {
                buffer.append((char)(c + 32));
                continue;
            }
            buffer.append(c);
        }
        return buffer;
    }

    public static StringBuilder toPascalCase(String name) {
        StringBuilder buffer = ProtoUtil.toCamelCase(name);
        char c = buffer.charAt(0);
        if (c > '`' && c < '{') {
            buffer.setCharAt(0, (char)(c - 32));
        }
        return buffer;
    }

    public static StringBuilder toUnderscoreCase(String name) {
        StringBuilder buffer = new StringBuilder();
        boolean toLower = false;
        boolean appendUnderscore = false;
        int i = 0;
        int len = name.length();
        while (i < len) {
            char c;
            if ((c = name.charAt(i++)) == '_') {
                if (i == len) break;
                if (buffer.length() == 0) continue;
                appendUnderscore = true;
                continue;
            }
            if (appendUnderscore) {
                buffer.append('_');
            }
            if (c > '`' && c < '{') {
                buffer.append(c);
                toLower = true;
            } else if (c > '@' && c < '[') {
                if (toLower) {
                    if (!appendUnderscore) {
                        buffer.append('_');
                    }
                    toLower = false;
                }
                buffer.append((char)(c + 32));
            } else {
                buffer.append(c);
                toLower = false;
            }
            appendUnderscore = false;
        }
        return buffer;
    }
}

