/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.AnnotationContainer;
import io.protostuff.parser.ConfiguredReference;
import io.protostuff.parser.EnumField;
import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Extension;
import io.protostuff.parser.Field;
import io.protostuff.parser.HasFields;
import io.protostuff.parser.HasName;
import io.protostuff.parser.MessageField;
import io.protostuff.parser.Proto;
import io.protostuff.parser.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class Message
extends AnnotationContainer
implements HasName,
HasFields {
    final String name;
    final Message parentMessage;
    final Proto proto;
    final LinkedHashMap<String, Message> nestedMessages = new LinkedHashMap();
    final LinkedHashMap<String, EnumGroup> nestedEnumGroups = new LinkedHashMap();
    final LinkedHashMap<String, Service> nestedServices = new LinkedHashMap();
    final LinkedHashMap<String, Field<?>> fields = new LinkedHashMap();
    final ArrayList<Extension> nestedExtensions = new ArrayList();
    final ArrayList<Field<?>> sortedFields = new ArrayList();
    final ArrayList<int[]> extensionRanges = new ArrayList();
    final LinkedHashMap<Integer, Field<?>> extensions = new LinkedHashMap();
    final LinkedHashMap<String, Object> standardOptions = new LinkedHashMap();
    final LinkedHashMap<String, Object> extraOptions = new LinkedHashMap();
    boolean extensible;
    boolean bytesFieldPresent;
    boolean repeatedFieldPresent;
    boolean requiredFieldPresent;
    boolean bytesOrStringDefaultValuePresent;
    private boolean byteBufferFieldPresent;
    boolean annotationPresentOnFields;
    int requiredFieldCount;
    int repeatedFieldCount;
    int singularFieldCount;
    int requiredMessageFieldCount;
    int repeatedMessageFieldCount;
    int singularMessageFieldCount;
    int requiredEnumFieldCount;
    int repeatedEnumFieldCount;
    int singularEnumFieldCount;
    int requiredBytesFieldCount;
    int repeatedBytesFieldCount;
    int singularBytesFieldCount;
    int requiredStringFieldCount;
    int repeatedStringFieldCount;
    int singularStringFieldCount;

    public Message(String name, Message parentMessage, Proto proto) {
        this.name = name;
        this.parentMessage = parentMessage;
        if (parentMessage != null) {
            this.proto = parentMessage.getProto();
            parentMessage.addNestedMessage(this);
        } else {
            this.proto = proto;
            proto.addMessage(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Proto getProto() {
        return this.proto;
    }

    public Message getRootMessage() {
        return this.parentMessage == null ? null : Message.getRoot(this.parentMessage);
    }

    public Message getParentMessage() {
        return this.parentMessage;
    }

    public boolean isNested() {
        return this.parentMessage != null;
    }

    public boolean hasNestedMessages() {
        return !this.nestedMessages.isEmpty();
    }

    public boolean hasNestedEnumGroups() {
        return !this.nestedEnumGroups.isEmpty();
    }

    public LinkedHashMap<String, Message> getNestedMessageMap() {
        return this.nestedMessages;
    }

    public Collection<Message> getNestedMessages() {
        return this.nestedMessages.values();
    }

    public Message getNestedMessage(String name) {
        return this.nestedMessages.get(name);
    }

    void addNestedMessage(Message message) {
        if (this.nestedMessages.put(message.name, message) != null) {
            throw Message.err("Duplicate nested message: " + message.name + " from message: " + this.name, this.getProto());
        }
    }

    public LinkedHashMap<String, EnumGroup> getNestedEnumGroupMap() {
        return this.nestedEnumGroups;
    }

    public Collection<EnumGroup> getNestedEnumGroups() {
        return this.nestedEnumGroups.values();
    }

    public EnumGroup getNestedEnumGroup(String name) {
        return this.nestedEnumGroups.get(name);
    }

    void addNestedEnumGroup(EnumGroup enumGroup) {
        if (this.nestedEnumGroups.put(enumGroup.name, enumGroup) != null) {
            throw Message.err("Duplicate nested enum: " + enumGroup.name + " from message: " + this.name, this.getProto());
        }
    }

    public LinkedHashMap<String, Service> getNestedServiceMap() {
        return this.nestedServices;
    }

    public Collection<Service> getNestedServices() {
        return this.nestedServices.values();
    }

    public Service getNestedService(String name) {
        return this.nestedServices.get(name);
    }

    void addNestedService(Service service) {
        if (this.nestedServices.put(service.name, service) != null) {
            throw Message.err("Duplicate nested service: " + service.name + " from message: " + this.name, this.getProto());
        }
    }

    public LinkedHashMap<String, Field<?>> getFieldMap() {
        return this.fields;
    }

    public List<Field<?>> getFields() {
        return this.sortedFields;
    }

    @Override
    public Field<?> getField(String name) {
        return this.fields.get(name);
    }

    public boolean isDescendant(Message other) {
        if (this.parentMessage == null) {
            return false;
        }
        return this.parentMessage == other || this.parentMessage.isDescendant(other);
    }

    public Message getDescendant(String name) {
        if (this.parentMessage == null) {
            return null;
        }
        return name.equals(this.parentMessage.name) ? this.parentMessage : this.parentMessage.getDescendant(name);
    }

    public <T extends Field<?>> T getField(String name, Class<T> typeClass) {
        return (T)this.fields.get(name);
    }

    @Override
    public void addField(Field<?> field) {
        if (field.number < 1) {
            throw new IllegalArgumentException("Invalid field number " + field.number + " from field " + field.name);
        }
        if (this.fields.put(field.name, field) != null) {
            throw Message.err("Duplicate message field: " + field.name, this.getProto());
        }
    }

    public void defineExtensionRange(int first, int last) {
        this.extensionRanges.add(new int[]{first, last});
        this.extensible = true;
    }

    public void addNestedExtension(Extension extension) {
        this.nestedExtensions.add(extension);
    }

    public Collection<Extension> getNestedExtensions() {
        return this.nestedExtensions;
    }

    public void extend(Extension extension) {
        if (!this.isExtensible()) {
            throw Message.err("Message " + this.getFullName() + " does not define extension range", this.getProto());
        }
        for (Field<?> field : extension.getFields()) {
            int number = field.getNumber();
            boolean inRange = false;
            for (int[] range : this.extensionRanges) {
                if (number < range[0] || number > range[1]) continue;
                inRange = true;
                break;
            }
            if (!inRange) {
                throw Message.err("Extension '" + field.getName() + "' is outside extension range", this.getProto());
            }
            if (this.extensions.containsKey(number)) {
                throw Message.err("Extension already defined for number '" + number + "'", this.getProto());
            }
            this.extensions.put(number, field);
        }
    }

    @Override
    public void putStandardOption(String key, Object value) {
        this.putExtraOption(key, value);
        this.standardOptions.put(key, value);
    }

    @Override
    public void putExtraOption(String key, Object value) {
        if (this.extraOptions.put(key, value) != null) {
            throw Message.err("Duplicate message option: " + key, this.getProto());
        }
    }

    public LinkedHashMap<String, Object> getStandardOptions() {
        return this.standardOptions;
    }

    public Object getStandardOption(String key) {
        return this.standardOptions.get(key);
    }

    public LinkedHashMap<String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    public <V> V getExtraOption(String key) {
        return (V)this.extraOptions.get(key);
    }

    public LinkedHashMap<String, Object> getO() {
        return this.getOptions();
    }

    public LinkedHashMap<String, Object> getOptions() {
        return this.extraOptions;
    }

    public String toString() {
        return '{' + "name:" + this.name + ',' + "enumGroups:" + this.nestedEnumGroups.values() + ',' + "extensions:" + this.nestedExtensions + ',' + "fields:" + this.fields.values() + '}';
    }

    @Override
    public String getEnclosingNamespace() {
        return this.getFullName();
    }

    public String getFullName() {
        StringBuilder buffer = new StringBuilder();
        Message.resolveFullName(this, buffer);
        return buffer.toString();
    }

    public String getJavaFullName() {
        StringBuilder buffer = new StringBuilder();
        Message.resolveJavaFullName(this, buffer);
        return buffer.toString();
    }

    public String getRelativeName() {
        StringBuilder buffer = new StringBuilder();
        Message.resolveRelativeName(this, buffer, null);
        return buffer.toString();
    }

    public boolean isExtensible() {
        return this.extensible;
    }

    public boolean isAnnotationPresentOnFields() {
        return this.annotationPresentOnFields;
    }

    public boolean isRepeatedFieldPresent() {
        return this.repeatedFieldPresent;
    }

    public boolean isBytesFieldPresent() {
        return this.bytesFieldPresent;
    }

    public boolean isByteBufferFieldPresent() {
        return this.byteBufferFieldPresent;
    }

    public void setByteBufferFieldPresent(boolean v) {
        this.byteBufferFieldPresent = v;
    }

    public boolean isBytesOrStringDefaultValuePresent() {
        return this.bytesOrStringDefaultValuePresent;
    }

    public boolean isRequiredFieldPresent() {
        return this.requiredFieldPresent;
    }

    public boolean isRequiredFieldPresentOnCurrent() {
        return this.requiredFieldCount != 0;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public int getRequiredFieldCount() {
        return this.requiredFieldCount;
    }

    public int getRepeatedFieldCount() {
        return this.repeatedFieldCount;
    }

    public int getOptionalFieldCount() {
        return this.singularFieldCount - this.requiredFieldCount;
    }

    public int getSingularFieldCount() {
        return this.singularFieldCount;
    }

    public int getMessageFieldCount() {
        return this.repeatedMessageFieldCount + this.singularMessageFieldCount;
    }

    public int getRequiredMessageFieldCount() {
        return this.requiredMessageFieldCount;
    }

    public int getRepeatedMessageFieldCount() {
        return this.repeatedMessageFieldCount;
    }

    public int getOptionalMessageFieldCount() {
        return this.singularMessageFieldCount - this.requiredMessageFieldCount;
    }

    public int getSingularMessageFieldCount() {
        return this.singularMessageFieldCount;
    }

    public int getEnumFieldCount() {
        return this.repeatedEnumFieldCount + this.singularEnumFieldCount;
    }

    public int getRequiredEnumFieldCount() {
        return this.requiredEnumFieldCount;
    }

    public int getRepeatedEnumFieldCount() {
        return this.repeatedEnumFieldCount;
    }

    public int getOptionalEnumFieldCount() {
        return this.singularEnumFieldCount - this.requiredEnumFieldCount;
    }

    public int getSingularEnumFieldCount() {
        return this.singularEnumFieldCount;
    }

    public int getBytesFieldCount() {
        return this.repeatedBytesFieldCount + this.singularBytesFieldCount;
    }

    public int getRequiredBytesFieldCount() {
        return this.requiredBytesFieldCount;
    }

    public int getRepeatedBytesFieldCount() {
        return this.repeatedBytesFieldCount;
    }

    public int getOptionalBytesFieldCount() {
        return this.singularBytesFieldCount - this.requiredBytesFieldCount;
    }

    public int getSingularBytesFieldCount() {
        return this.singularBytesFieldCount;
    }

    public int getStringFieldCount() {
        return this.repeatedStringFieldCount + this.singularStringFieldCount;
    }

    public int getRequiredStringFieldCount() {
        return this.requiredStringFieldCount;
    }

    public int getRepeatedStringFieldCount() {
        return this.repeatedStringFieldCount;
    }

    public int getOptionalStringFieldCount() {
        return this.singularStringFieldCount - this.requiredStringFieldCount;
    }

    public int getSingularStringFieldCount() {
        return this.singularStringFieldCount;
    }

    public int getScalarFieldCount() {
        return this.getFields().size() - this.repeatedMessageFieldCount - this.singularMessageFieldCount;
    }

    public int getScalarWithoutEnumFieldCount() {
        return this.getScalarFieldCount() - this.repeatedEnumFieldCount - this.singularEnumFieldCount;
    }

    void resolveReferences(Message root) {
        Proto proto = this.getProto();
        String fullName = this.getFullName();
        for (Field<?> f : this.fields.values()) {
            f.owner = this;
            if (f.isRepeated()) {
                ++this.repeatedFieldCount;
                root.repeatedFieldPresent = true;
            } else {
                ++this.singularFieldCount;
                if (f.isRequired()) {
                    ++this.requiredFieldCount;
                    root.requiredFieldPresent = true;
                }
            }
            if (!this.annotationPresentOnFields && !f.annotations.isEmpty()) {
                this.annotationPresentOnFields = true;
            }
            if (f instanceof Field.Bytes) {
                if (f.isRepeated()) {
                    ++this.repeatedBytesFieldCount;
                } else {
                    ++this.singularBytesFieldCount;
                    if (f.isRequired()) {
                        ++this.requiredBytesFieldCount;
                    }
                }
                if (f.hasOption("ByteBuffer")) {
                    root.byteBufferFieldPresent = true;
                }
                if (!root.bytesFieldPresent) {
                    root.bytesFieldPresent = true;
                }
                if (!root.bytesOrStringDefaultValuePresent && f.defaultValue != null) {
                    root.bytesOrStringDefaultValuePresent = true;
                }
            } else if (f instanceof Field.String) {
                if (f.isRepeated()) {
                    ++this.repeatedStringFieldCount;
                } else {
                    ++this.singularStringFieldCount;
                    if (f.isRequired()) {
                        ++this.requiredStringFieldCount;
                    }
                }
                if (!root.bytesOrStringDefaultValuePresent && f.defaultValue != null) {
                    root.bytesOrStringDefaultValuePresent = true;
                }
            } else if (f instanceof Field.Reference) {
                Field.Reference fr = (Field.Reference)f;
                String refName = fr.refName;
                String packageName = fr.packageName;
                String fullRefName = packageName == null ? refName : packageName + '.' + refName;
                HasName refObj = proto.findReference(fullRefName, fullName);
                if (refObj instanceof Message) {
                    MessageField mf = Message.newMessageField((Message)refObj, fr, this);
                    this.fields.put(mf.name, mf);
                    if (mf.isRepeated()) {
                        ++this.repeatedMessageFieldCount;
                    } else {
                        ++this.singularMessageFieldCount;
                        if (mf.isRequired()) {
                            ++this.requiredMessageFieldCount;
                        }
                    }
                    if (mf.standardOptions.isEmpty()) continue;
                    proto.references.add(new ConfiguredReference(mf.standardOptions, mf.extraOptions, fullName));
                    continue;
                }
                if (refObj instanceof EnumGroup) {
                    EnumField ef = Message.newEnumField((EnumGroup)refObj, fr, this);
                    this.fields.put(ef.name, ef);
                    if (ef.isRepeated()) {
                        ++this.repeatedEnumFieldCount;
                    } else {
                        ++this.singularEnumFieldCount;
                        if (ef.isRequired()) {
                            ++this.requiredEnumFieldCount;
                        }
                    }
                    if (ef.standardOptions.isEmpty()) continue;
                    proto.references.add(new ConfiguredReference(ef.standardOptions, ef.extraOptions, fullName));
                    continue;
                }
                throw Message.err("unknown field: " + fullRefName, this.getProto());
            }
            if (f.standardOptions.isEmpty()) continue;
            proto.references.add(new ConfiguredReference(f.standardOptions, f.extraOptions, fullName));
        }
        this.sortedFields.addAll(this.fields.values());
        Collections.sort(this.sortedFields);
        for (Extension extension : this.nestedExtensions) {
            extension.resolveReferences();
        }
        for (Service s : this.nestedServices.values()) {
            s.resolveReferences();
        }
        for (Message m : this.nestedMessages.values()) {
            m.resolveReferences(root);
        }
    }

    void cacheFullyQualifiedNames() {
        Proto proto = this.getProto();
        proto.fullyQualifiedMessages.put(this.getFullName(), this);
        for (Message m : this.nestedMessages.values()) {
            m.cacheFullyQualifiedNames();
        }
        for (EnumGroup eg : this.nestedEnumGroups.values()) {
            eg.cacheFullyQualifiedName();
        }
        if (!this.standardOptions.isEmpty()) {
            proto.references.add(new ConfiguredReference(this.standardOptions, this.extraOptions, this.getFullName()));
        }
    }

    static MessageField newMessageField(Message message, Field.Reference fr, Message owner) {
        MessageField mf = new MessageField(message);
        mf.owner = owner;
        mf.packable = false;
        Message.copy(fr, mf);
        return mf;
    }

    static EnumField newEnumField(EnumGroup enumGroup, Field.Reference fr, Message owner) {
        EnumField ef = new EnumField(enumGroup);
        ef.owner = owner;
        ef.packable = true;
        String refName = (String)fr.getDefaultValue();
        if (refName == null) {
            ef.defaultValue = enumGroup.getFirstValue();
        } else {
            ef.defaultValueSet = true;
            ef.defaultValue = enumGroup.getValue(refName);
            if (ef.defaultValue == null) {
                throw Message.err("The field: " + ef.name + " contains an unknown enum value: " + refName, owner.getProto());
            }
        }
        Message.copy(fr, ef);
        return ef;
    }

    static void copy(Field<?> from, Field<?> to) {
        to.name = from.name;
        to.number = from.number;
        to.modifier = from.modifier;
        to.addAnnotations(from.annotations, true);
        to.standardOptions.putAll(from.standardOptions);
        to.extraOptions.putAll(from.extraOptions);
        to.docs.addAll(from.docs);
    }

    static void resolveFullName(Message message, StringBuilder buffer) {
        buffer.insert(0, message.name).insert(0, '.');
        if (message.isNested()) {
            Message.resolveFullName(message.parentMessage, buffer);
        } else {
            buffer.insert(0, message.getProto().getPackageName());
        }
    }

    static void resolveJavaFullName(Message message, StringBuilder buffer) {
        buffer.insert(0, message.name).insert(0, '.');
        if (message.isNested()) {
            Message.resolveFullName(message.parentMessage, buffer);
        } else {
            buffer.insert(0, message.getProto().getJavaPackageName());
        }
    }

    static void resolveRelativeName(Message message, StringBuilder buffer, Message descendant) {
        buffer.insert(0, message.name);
        if (message.parentMessage != null && message.parentMessage != descendant) {
            buffer.insert(0, '.');
            Message.resolveRelativeName(message.parentMessage, buffer, descendant);
        }
    }

    static void computeName(Message message, Message owner, StringBuilder buffer) {
        if (owner == message || message.parentMessage == owner || owner.isDescendant(message)) {
            buffer.append(message.name);
        } else if (message.isDescendant(owner)) {
            Message.resolveRelativeName(message, buffer, owner);
        } else if (message.getProto().getJavaPackageName().equals(owner.getProto().getJavaPackageName())) {
            buffer.append(message.getRelativeName());
        } else {
            buffer.append(message.getJavaFullName());
        }
    }

    static Message getRoot(Message parent) {
        return parent.parentMessage == null ? parent : Message.getRoot(parent.parentMessage);
    }
}

