/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.CompilerUtil;
import io.protostuff.compiler.ProtoModule;
import io.protostuff.compiler.STCodeGenerator;
import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.NoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;

public class ProtoToJavaBeanModelCompiler
extends STCodeGenerator {
    public ProtoToJavaBeanModelCompiler() {
        super("java_bean_model");
    }

    @Override
    public void compile(ProtoModule module, Proto proto) throws IOException {
        String javaPackageName = proto.getJavaPackageName();
        StringTemplateGroup modelTemplateGroup = ProtoToJavaBeanModelCompiler.getSTG("java_bean_model_model");
        StringTemplateGroup schemaTemplateGroup = ProtoToJavaBeanModelCompiler.getSTG("java_bean_model_schema");
        for (EnumGroup eg : proto.getEnumGroups()) {
            if (eg.getAnnotation("Transient") != null) continue;
            Writer writer = CompilerUtil.newWriter(module, javaPackageName, eg.getName() + ".java");
            AutoIndentWriter out = new AutoIndentWriter(writer);
            StringTemplate enumBlock = schemaTemplateGroup.getInstanceOf("enum_block");
            enumBlock.setAttribute("eg", (Object)eg);
            enumBlock.setAttribute("module", (Object)module);
            enumBlock.setAttribute("options", (Object)module.getOptions());
            enumBlock.write((StringTemplateWriter)out);
            writer.close();
        }
        for (Message m : proto.getMessages()) {
            if (m.getAnnotation("Transient") != null) continue;
            boolean generateModel = this.shouldGenerateModel(module, proto, m);
            if (generateModel) {
                String modelFullName = this.getRemoteModelName(modelTemplateGroup, m);
                String modelPackage = javaPackageName;
                String modelName = modelFullName;
                if (modelFullName.lastIndexOf(46) > -1) {
                    int lastDotIndex = modelFullName.lastIndexOf(46);
                    modelPackage = modelFullName.substring(0, lastDotIndex);
                    modelName = modelFullName.substring(lastDotIndex + 1);
                }
                Writer writer = CompilerUtil.newWriter(module, modelPackage, modelName + ".java");
                AutoIndentWriter out = new AutoIndentWriter(writer);
                StringTemplate messageBlock = modelTemplateGroup.getInstanceOf("message_block");
                messageBlock.setAttribute("message", (Object)m);
                messageBlock.setAttribute("module", (Object)module);
                messageBlock.setAttribute("options", (Object)module.getOptions());
                messageBlock.write((StringTemplateWriter)out);
                writer.close();
            }
            Writer writer = CompilerUtil.newWriter(module, javaPackageName, this.getRemoteModelSchemaName(schemaTemplateGroup, m) + ".java");
            AutoIndentWriter out = new AutoIndentWriter(writer);
            StringTemplate messageBlock = schemaTemplateGroup.getInstanceOf("message_block");
            messageBlock.setAttribute("message", (Object)m);
            messageBlock.setAttribute("module", (Object)module);
            messageBlock.setAttribute("options", (Object)module.getOptions());
            messageBlock.write((StringTemplateWriter)out);
            writer.close();
        }
    }

    public boolean shouldGenerateModel(ProtoModule module, Proto proto, Message m) {
        String optGenerateModel;
        boolean generateModel = false;
        if (module.getOptions().containsKey("models")) {
            optGenerateModel = module.getOption("models");
            generateModel = optGenerateModel.equalsIgnoreCase("true") || optGenerateModel.equals("1");
        } else if (module.getOptions().containsKey("no_models")) {
            optGenerateModel = module.getOption("no_models");
            boolean bl = generateModel = !optGenerateModel.equalsIgnoreCase("true") && !optGenerateModel.equals("1");
        }
        if (proto.getOptions().containsKey("models")) {
            optGenerateModel = proto.getExtraOption("models").toString();
            generateModel = optGenerateModel.equalsIgnoreCase("true") || optGenerateModel.equals("1");
        } else if (proto.getOptions().containsKey("no_models")) {
            optGenerateModel = (String)proto.getExtraOption("no_models");
            boolean bl = generateModel = !optGenerateModel.equalsIgnoreCase("true") && !optGenerateModel.equals("1");
        }
        if (m.getOptions().containsKey("model")) {
            optGenerateModel = m.getExtraOption("model").toString();
            generateModel = optGenerateModel.equalsIgnoreCase("true") || optGenerateModel.equals("1");
        } else if (m.getOptions().containsKey("no_model")) {
            optGenerateModel = (String)m.getExtraOption("no_model");
            generateModel = !optGenerateModel.equalsIgnoreCase("true") && !optGenerateModel.equals("1");
        }
        return generateModel;
    }

    public String getRemoteModelName(StringTemplateGroup group, Message message) throws IOException {
        StringWriter writer = new StringWriter(16);
        NoIndentWriter out = new NoIndentWriter((Writer)writer);
        StringTemplate messageBlock = group.getInstanceOf("remote_model_name");
        messageBlock.setAttribute("message", (Object)message);
        messageBlock.setAttribute("name", (Object)message.getName());
        messageBlock.write((StringTemplateWriter)out);
        String result = writer.toString();
        writer.close();
        return result;
    }

    public String getRemoteModelSchemaName(StringTemplateGroup group, Message message) throws IOException {
        StringWriter writer = new StringWriter(16);
        NoIndentWriter out = new NoIndentWriter((Writer)writer);
        StringTemplate messageBlock = group.getInstanceOf("remote_model_schema_name");
        messageBlock.setAttribute("message", (Object)message);
        messageBlock.setAttribute("name", (Object)message.getName());
        messageBlock.write((StringTemplateWriter)out);
        String result = writer.toString();
        writer.close();
        return result;
    }
}

