/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.CachingProtoLoader;
import io.protostuff.compiler.FilenameUtil;
import io.protostuff.compiler.PluginProtoCompiler;
import io.protostuff.compiler.ProtoCompiler;
import io.protostuff.compiler.ProtoModule;
import io.protostuff.compiler.ProtoToGwtOverlayCompiler;
import io.protostuff.compiler.ProtoToJavaBeanCompiler;
import io.protostuff.compiler.ProtoToJavaBeanMeCompiler;
import io.protostuff.compiler.ProtoToJavaBeanModelCompiler;
import io.protostuff.compiler.ProtoToJavaBeanPrimitiveCompiler;
import io.protostuff.compiler.ProtoToJavaV2ProtocSchemaCompiler;
import io.protostuff.compiler.ProtoToProtoCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public final class CompilerMain {
    public static final boolean SILENT_MODE = Boolean.parseBoolean(System.getProperty("protostuff.compiler.silent_mode", "true"));
    public static final Pattern COMMA = Pattern.compile(",");
    static final HashMap<String, ProtoCompiler> __compilers = new HashMap();
    private static CompilerResolver __compilerResolver = null;

    public static void setCompilerResolver(CompilerResolver resolver) {
        __compilerResolver = resolver;
    }

    public static void addCompiler(ProtoCompiler compiler) {
        __compilers.put(compiler.getOutputId(), compiler);
    }

    public static boolean isAvailableOutput(String output) {
        return __compilers.get(output) != null;
    }

    static Properties propsFrom(File file) throws IOException {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props;
    }

    static Properties propsFrom(String resource) throws IOException {
        File file = new File(resource);
        return file.exists() ? CompilerMain.propsFrom(file) : null;
    }

    public static List<ProtoModule> loadModules(File file, File baseDirForSource, File baseDirForOutput) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return CompilerMain.loadModules(props, baseDirForSource, baseDirForOutput);
    }

    public static List<ProtoModule> loadModules(InputStream in) {
        Properties props = new Properties();
        try {
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return CompilerMain.loadModules(props, null, null);
    }

    public static List<ProtoModule> loadModules(Properties props) {
        return CompilerMain.loadModules(props, null, null);
    }

    public static List<ProtoModule> loadModules(Properties props, File baseDirForSource, File baseDirForOutput) {
        String moduleString = props.getProperty("modules");
        if (moduleString == null || moduleString.length() == 0) {
            CompilerMain.propsErr();
            return null;
        }
        CachingProtoLoader loader = "true".equals(props.getProperty("cache_protos")) ? new CachingProtoLoader() : null;
        Properties globalOptions = CompilerMain.newGlobalOptions(props);
        ArrayList<ProtoModule> modules = new ArrayList<ProtoModule>();
        for (String m : COMMA.split(moduleString)) {
            modules.add(CompilerMain.loadModule(props, m.trim(), loader, baseDirForSource, baseDirForOutput, globalOptions, null, null));
        }
        return modules;
    }

    public static ProtoModule loadModule(Properties props, String name, CachingProtoLoader loader, File baseDirForSource, File baseDirForOutput, Properties globalOptions, String[] profileOptions, String[] rootProfileOptions) {
        String source = props.getProperty(name + ".source");
        if (source == null) {
            throw new IllegalStateException(name + " must have a source");
        }
        String output = props.getProperty(name + ".output");
        if (output == null) {
            throw new IllegalStateException(name + " must have an output");
        }
        String outputDir = props.getProperty(name + ".outputDir");
        if (outputDir == null) {
            throw new IllegalStateException(name + " must have an outputDir");
        }
        String encoding = props.getProperty(name + ".encoding");
        String options = props.getProperty(name + ".options");
        ProtoModule module = CompilerMain.newProtoModule(source, output, encoding, outputDir, baseDirForSource, baseDirForOutput);
        module.setCachingProtoLoader(loader);
        module.getOptions().putAll((Map<?, ?>)globalOptions);
        module.config = props;
        if (options != null) {
            CompilerMain.addOptionsTo(module.getOptions(), COMMA.split(options), props);
        }
        if (profileOptions != null) {
            CompilerMain.addOptionsTo(module.getOptions(), profileOptions, props);
        }
        if (rootProfileOptions != null) {
            CompilerMain.addOptionsTo(module.getOptions(), rootProfileOptions, props);
        }
        return module;
    }

    static ProtoModule newProtoModule(String source, String output, String encoding, String outputDir, File baseDirForSource, File baseDirForOutput) {
        if (baseDirForSource != null) {
            if (baseDirForOutput != null) {
                return new ProtoModule(new File(baseDirForSource, source), output, encoding, new File(baseDirForOutput, outputDir));
            }
            return new ProtoModule(new File(baseDirForSource, source), output, encoding, new File(outputDir));
        }
        if (baseDirForOutput != null) {
            return new ProtoModule(new File(source), output, encoding, new File(baseDirForOutput, outputDir));
        }
        return new ProtoModule(new File(source), output, encoding, new File(outputDir));
    }

    public static void addOptionsTo(ProtoModule module, String[] options) {
        CompilerMain.addOptionsTo(module.getOptions(), options, module.getConfig());
    }

    public static void addOptionsTo(Properties target, String[] options, Properties config) {
        block4: for (String o : options) {
            int idx = o.indexOf(58);
            if (idx != -1) {
                target.setProperty(o.substring(0, idx).trim(), o.substring(idx + 1).trim());
                continue;
            }
            String key = o.trim();
            switch (key.charAt(0)) {
                case '!': {
                    target.remove(key.substring(1));
                    continue block4;
                }
                case '_': {
                    String csv;
                    if (config != null && (csv = config.getProperty(key)) != null) {
                        CompilerMain.addOptionsTo(target, COMMA.split(csv), config);
                    }
                }
                default: {
                    target.setProperty(key, "");
                }
            }
        }
    }

    static void propsErr() {
        System.err.println("\nError parsing the properties file ...");
        System.err.println("\nThe properties file would look like:");
        System.err.println("modules = foo");
        System.err.println("foo.source = path/to/your/proto/file/or/dir");
        System.err.println("foo.output = java_bean");
        System.err.println("foo.outputDir = src/main/java");
        System.err.println("foo.encoding = UTF-8");
        System.err.println("foo.options = key1:value1,key2:value2");
    }

    static void usage() {
        System.err.println("\nTo generate code for multiple modules:");
        System.err.println("  java -cp -jar protostuff-compiler.jar modules.properties");
        System.err.println("\nThe properties file would look like:\n");
        System.err.println("modules = foo,bar");
        System.err.println("foo.source = path/to/your/proto/file/or/dir");
        System.err.println("foo.output = java_bean");
        System.err.println("foo.outputDir = src/main/java");
        System.err.println("foo.encoding = UTF-8");
        System.err.println("foo.options = key1:value1,key2:value2");
        System.err.println("bar.source = path/to/your/proto/file/or/dir");
        System.err.println("bar.output = java_bean");
        System.err.println("bar.outputDir = target/generated");
        System.err.println("bar.encoding = UTF-8");
        System.err.println("bar.options = separate_schema,generate_field_map");
        System.err.println("\n===================================================\n");
        System.err.println("\nTo generate code for a single module, execute the jar without args and specify:");
        System.err.println("  -Dsource=path/to/your/proto/file/or/dir");
        System.err.println("  -Doutput=java_bean");
        System.err.println("  -DoutputDir=src/main/java");
        System.err.println("  -Dencoding=UTF-8");
        System.err.println("  -Doptions=key1:value1,key2:value2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compile(ProtoModule module) throws Exception {
        String strOptions = null;
        String originalOutput = module.getOutput();
        try {
            for (String output : COMMA.split(originalOutput)) {
                output = output.trim();
                module.setOutput(output);
                module.setGenerator(output);
                ProtoCompiler compiler = __compilers.get(output);
                if (compiler == null) {
                    if (__compilerResolver != null) {
                        compiler = __compilerResolver.resolve(module);
                    } else if (output.endsWith(".stg")) {
                        String generator = CompilerMain.createGeneratorName(output);
                        module.setGenerator(generator);
                        compiler = new PluginProtoCompiler(module, output);
                    } else {
                        throw new IllegalStateException("unknown output: " + output);
                    }
                }
                compiler.compile(module);
                if (SILENT_MODE) continue;
                StringBuilder buffer = new StringBuilder().append("Successfully compiled proto from ").append(module.getSource()).append(" to output: ").append(output);
                if (strOptions == null) {
                    strOptions = module.getOptions().toString();
                }
                if (strOptions.length() > 2) {
                    buffer.append(' ').append(strOptions);
                }
                System.out.println(buffer.toString());
            }
        }
        finally {
            module.setOutput(originalOutput);
            module.setGenerator(null);
        }
    }

    private static String createGeneratorName(String output) {
        String fileName = FilenameUtil.getFileName(output);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (CompilerMain.isAlpha(c) || CompilerMain.isNumber(c) || CompilerMain.isAllowedCharacter(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static boolean isAllowedCharacter(char c) {
        return c == '.' || c == '_' || c == '-' || c == '$';
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static void compile(List<ProtoModule> modules) throws Exception {
        for (ProtoModule m : modules) {
            CompilerMain.compile(m);
        }
    }

    static void compileProfile(Properties props, String profile, CachingProtoLoader loader, Properties globalOptions, String[] rootProfileOptions, int nestCount) throws Exception {
        String moduleString = props.getProperty(profile);
        if (moduleString == null || moduleString.length() == 0) {
            throw new RuntimeException("No modules for profile: " + profile);
        }
        for (int i = 0; i < nestCount; ++i) {
            System.out.print("  ");
        }
        System.out.println(profile);
        long start = System.nanoTime();
        String profileOptionsParam = props.getProperty(profile + ".options");
        String[] profileOptions = profileOptionsParam == null ? null : COMMA.split(profileOptionsParam);
        for (String m : COMMA.split(moduleString)) {
            if ((m = m.trim()).charAt(0) == '@') {
                CompilerMain.compileProfile(props, m, loader, globalOptions, nestCount == 0 ? profileOptions : rootProfileOptions, nestCount + 1);
                continue;
            }
            CompilerMain.compile(CompilerMain.loadModule(props, m, loader, null, null, globalOptions, profileOptions, nestCount == 0 ? profileOptions : rootProfileOptions));
        }
        long end = System.nanoTime();
        for (int i = 0; i < nestCount; ++i) {
            System.out.print("  ");
        }
        long ms = (end - start) / 1000000L;
        System.out.println(ms + " ms\n");
    }

    static void compileWithNoArgs() throws Exception {
        Properties props = System.getProperties();
        String source = props.getProperty("source");
        String output = props.getProperty("output");
        String outputDir = props.getProperty("outputDir");
        String encoding = props.getProperty("encoding");
        String options = props.getProperty("options");
        if (source == null || output == null || outputDir == null) {
            CompilerMain.usage();
            return;
        }
        ProtoModule module = new ProtoModule(new File(source), output, encoding, new File(outputDir));
        if (options != null) {
            for (String o : COMMA.split(options)) {
                int idx = o.indexOf(58);
                if (idx == -1) {
                    module.setOption(o.trim(), "");
                    continue;
                }
                module.setOption(o.substring(0, idx).trim(), o.substring(idx + 1).trim());
            }
        }
        CompilerMain.compile(module);
    }

    static void compileWithArgs(String[] args, int offset, int limit) throws Exception {
        String propsResource;
        Properties props;
        if ((props = CompilerMain.propsFrom(propsResource = args[offset++])) == null) {
            System.err.println(propsResource + " does not exist.");
            return;
        }
        Properties globalOptions = CompilerMain.newGlobalOptions(props);
        CachingProtoLoader loader = "true".equals(props.getProperty("cache_protos")) || "true".equals(System.getProperty("cache_protos")) ? new CachingProtoLoader() : null;
        boolean selectedProfileOrModule = false;
        String arg = propsResource;
        while (true) {
            if (offset != limit) {
                arg = args[offset];
                if (arg.charAt(0) == '@') {
                    CompilerMain.compileProfile(props, arg, loader, globalOptions, null, 0);
                    selectedProfileOrModule = true;
                    ++offset;
                    continue;
                }
                if (!new File(arg).exists()) {
                    CompilerMain.compile(CompilerMain.loadModule(props, arg, loader, null, null, globalOptions, null, null));
                    selectedProfileOrModule = true;
                    ++offset;
                    continue;
                }
            }
            if (selectedProfileOrModule) {
                if (offset == limit) {
                    return;
                }
                selectedProfileOrModule = false;
                if ((props = CompilerMain.propsFrom(arg = args[offset++])) == null) {
                    System.err.println(arg + " does not exist.");
                    return;
                }
                globalOptions = CompilerMain.newGlobalOptions(props);
                continue;
            }
            String moduleString = props.getProperty("modules");
            if (moduleString == null || moduleString.length() == 0) {
                System.err.println("Errors on: " + arg);
                CompilerMain.propsErr();
                return;
            }
            for (String m : COMMA.split(moduleString)) {
                if ((m = m.trim()).charAt(0) == '@') {
                    CompilerMain.compileProfile(props, m, loader, globalOptions, null, 0);
                    continue;
                }
                CompilerMain.compile(CompilerMain.loadModule(props, m, loader, null, null, globalOptions, null, null));
            }
            if (offset == limit) {
                return;
            }
            if ((props = CompilerMain.propsFrom(arg = args[offset++])) == null) {
                System.err.println(arg + " does not exist.");
                return;
            }
            globalOptions = CompilerMain.newGlobalOptions(props);
        }
    }

    static Properties putIncludes(Properties props) {
        String includes = props.getProperty("includes");
        if (includes == null) {
            return props;
        }
        for (String include : COMMA.split(includes)) {
            Properties p;
            try {
                p = CompilerMain.propsFrom(include.trim());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (Object key : p.keySet()) {
                if (props.containsKey(key)) continue;
                props.put(key, p.get(key));
            }
        }
        return props;
    }

    public static Properties newGlobalOptions(Properties props) {
        return CompilerMain.newOptions(CompilerMain.putIncludes(props), "global_options");
    }

    public static Properties newOptions(Properties props, String key) {
        Properties options = new Properties();
        String csv = props.getProperty(key);
        if (csv != null) {
            CompilerMain.addOptionsTo(options, COMMA.split(csv), props);
        }
        return options;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            CompilerMain.compileWithNoArgs();
        } else {
            CompilerMain.compileWithArgs(args, 0, args.length);
        }
    }

    static {
        CompilerMain.addCompiler(new ProtoToJavaBeanCompiler());
        CompilerMain.addCompiler(new ProtoToJavaBeanPrimitiveCompiler());
        CompilerMain.addCompiler(new ProtoToJavaBeanMeCompiler());
        CompilerMain.addCompiler(new ProtoToGwtOverlayCompiler());
        CompilerMain.addCompiler(new ProtoToJavaV2ProtocSchemaCompiler());
        CompilerMain.addCompiler(new ProtoToJavaBeanModelCompiler());
        CompilerMain.addCompiler(new ProtoToProtoCompiler());
    }

    public static interface CompilerResolver {
        public ProtoCompiler resolve(ProtoModule var1);
    }
}

