/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.IncubatingUtil;
import io.opentelemetry.sdk.autoconfigure.LoggerProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.MeterProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.PropagatorConfiguration;
import io.opentelemetry.sdk.autoconfigure.ResourceConfiguration;
import io.opentelemetry.sdk.autoconfigure.TracerProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.AutoConfigureListener;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.SdkTracerProviderConfigurer;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class AutoConfiguredOpenTelemetrySdkBuilder
implements AutoConfigurationCustomizer {
    private static final Logger logger = Logger.getLogger(AutoConfiguredOpenTelemetrySdkBuilder.class.getName());
    private static final boolean INCUBATOR_AVAILABLE;
    @Nullable
    private ConfigProperties config;
    private BiFunction<SdkTracerProviderBuilder, ConfigProperties, SdkTracerProviderBuilder> tracerProviderCustomizer = (a, unused) -> a;
    private BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> propagatorCustomizer = (a, unused) -> a;
    private BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer = (a, unused) -> a;
    private BiFunction<? super SpanProcessor, ConfigProperties, ? extends SpanProcessor> spanProcessorCustomizer = (a, unused) -> a;
    private BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer = (a, unused) -> a;
    private BiFunction<SdkMeterProviderBuilder, ConfigProperties, SdkMeterProviderBuilder> meterProviderCustomizer = (a, unused) -> a;
    private BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer = (a, unused) -> a;
    private BiFunction<? super MetricReader, ConfigProperties, ? extends MetricReader> metricReaderCustomizer = (a, unused) -> a;
    private BiFunction<SdkLoggerProviderBuilder, ConfigProperties, SdkLoggerProviderBuilder> loggerProviderCustomizer = (a, unused) -> a;
    private BiFunction<? super LogRecordExporter, ConfigProperties, ? extends LogRecordExporter> logRecordExporterCustomizer = (a, unused) -> a;
    private BiFunction<? super LogRecordProcessor, ConfigProperties, ? extends LogRecordProcessor> logRecordProcessorCustomizer = (a, unused) -> a;
    private BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer = (a, unused) -> a;
    private Supplier<Map<String, String>> propertiesSupplier = Collections::emptyMap;
    private final List<Function<ConfigProperties, Map<String, String>>> propertiesCustomizers = new ArrayList<Function<ConfigProperties, Map<String, String>>>();
    private Function<ConfigProperties, ConfigProperties> configPropertiesCustomizer = Function.identity();
    private ComponentLoader componentLoader = ComponentLoader.forClassLoader((ClassLoader)AutoConfiguredOpenTelemetrySdk.class.getClassLoader());
    private boolean registerShutdownHook = true;
    private boolean setResultAsGlobal = false;
    private boolean customized;

    AutoConfiguredOpenTelemetrySdkBuilder() {
    }

    AutoConfiguredOpenTelemetrySdkBuilder setConfig(ConfigProperties config) {
        Objects.requireNonNull(config, "config");
        this.config = config;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addTracerProviderCustomizer(BiFunction<SdkTracerProviderBuilder, ConfigProperties, SdkTracerProviderBuilder> tracerProviderCustomizer) {
        Objects.requireNonNull(tracerProviderCustomizer, "tracerProviderCustomizer");
        this.tracerProviderCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.tracerProviderCustomizer, tracerProviderCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addPropagatorCustomizer(BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> propagatorCustomizer) {
        Objects.requireNonNull(propagatorCustomizer, "propagatorCustomizer");
        this.propagatorCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.propagatorCustomizer, propagatorCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addResourceCustomizer(BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer) {
        Objects.requireNonNull(resourceCustomizer, "resourceCustomizer");
        this.resourceCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.resourceCustomizer, resourceCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addSamplerCustomizer(BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer) {
        Objects.requireNonNull(samplerCustomizer, "samplerCustomizer");
        this.samplerCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.samplerCustomizer, samplerCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addSpanExporterCustomizer(BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer) {
        Objects.requireNonNull(spanExporterCustomizer, "spanExporterCustomizer");
        this.spanExporterCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.spanExporterCustomizer, spanExporterCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addSpanProcessorCustomizer(BiFunction<? super SpanProcessor, ConfigProperties, ? extends SpanProcessor> spanProcessorCustomizer) {
        Objects.requireNonNull(spanProcessorCustomizer, "spanProcessorCustomizer");
        this.spanProcessorCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.spanProcessorCustomizer, spanProcessorCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addPropertiesSupplier(Supplier<Map<String, String>> propertiesSupplier) {
        Objects.requireNonNull(propertiesSupplier, "propertiesSupplier");
        this.propertiesSupplier = AutoConfiguredOpenTelemetrySdkBuilder.mergeProperties(this.propertiesSupplier, propertiesSupplier);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addPropertiesCustomizer(Function<ConfigProperties, Map<String, String>> propertiesCustomizer) {
        Objects.requireNonNull(propertiesCustomizer, "propertiesCustomizer");
        this.propertiesCustomizers.add(propertiesCustomizer);
        return this;
    }

    AutoConfiguredOpenTelemetrySdkBuilder setConfigPropertiesCustomizer(Function<ConfigProperties, ConfigProperties> configPropertiesCustomizer) {
        Objects.requireNonNull(configPropertiesCustomizer, "configPropertiesCustomizer");
        this.configPropertiesCustomizer = configPropertiesCustomizer;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addMeterProviderCustomizer(BiFunction<SdkMeterProviderBuilder, ConfigProperties, SdkMeterProviderBuilder> meterProviderCustomizer) {
        Objects.requireNonNull(meterProviderCustomizer, "meterProviderCustomizer");
        this.meterProviderCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.meterProviderCustomizer, meterProviderCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addMetricExporterCustomizer(BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer) {
        Objects.requireNonNull(metricExporterCustomizer, "metricExporterCustomizer");
        this.metricExporterCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.metricExporterCustomizer, metricExporterCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addMetricReaderCustomizer(BiFunction<? super MetricReader, ConfigProperties, ? extends MetricReader> readerCustomizer) {
        Objects.requireNonNull(readerCustomizer, "readerCustomizer");
        this.metricReaderCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.metricReaderCustomizer, readerCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addLoggerProviderCustomizer(BiFunction<SdkLoggerProviderBuilder, ConfigProperties, SdkLoggerProviderBuilder> loggerProviderCustomizer) {
        Objects.requireNonNull(loggerProviderCustomizer, "loggerProviderCustomizer");
        this.loggerProviderCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.loggerProviderCustomizer, loggerProviderCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addLogRecordExporterCustomizer(BiFunction<? super LogRecordExporter, ConfigProperties, ? extends LogRecordExporter> logRecordExporterCustomizer) {
        Objects.requireNonNull(logRecordExporterCustomizer, "logRecordExporterCustomizer");
        this.logRecordExporterCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.logRecordExporterCustomizer, logRecordExporterCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder addLogRecordProcessorCustomizer(BiFunction<? super LogRecordProcessor, ConfigProperties, ? extends LogRecordProcessor> logRecordProcessorCustomizer) {
        Objects.requireNonNull(logRecordProcessorCustomizer, "logRecordProcessorCustomizer");
        this.logRecordProcessorCustomizer = AutoConfiguredOpenTelemetrySdkBuilder.mergeCustomizer(this.logRecordProcessorCustomizer, logRecordProcessorCustomizer);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder disableShutdownHook() {
        this.registerShutdownHook = false;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder setResultAsGlobal() {
        this.setResultAsGlobal = true;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder setServiceClassLoader(ClassLoader serviceClassLoader) {
        Objects.requireNonNull(serviceClassLoader, "serviceClassLoader");
        this.componentLoader = ComponentLoader.forClassLoader((ClassLoader)serviceClassLoader);
        return this;
    }

    public AutoConfiguredOpenTelemetrySdkBuilder setComponentLoader(ComponentLoader componentLoader) {
        Objects.requireNonNull(componentLoader, "componentLoader");
        this.componentLoader = componentLoader;
        return this;
    }

    public AutoConfiguredOpenTelemetrySdk build() {
        if (!this.setResultAsGlobal) {
            return this.buildImpl();
        }
        AtomicReference autoConfiguredRef = new AtomicReference();
        GlobalOpenTelemetry.set(() -> {
            AutoConfiguredOpenTelemetrySdk sdk = this.buildImpl();
            autoConfiguredRef.set(sdk);
            return sdk.getOpenTelemetrySdk();
        });
        AutoConfiguredOpenTelemetrySdk sdk = Objects.requireNonNull((AutoConfiguredOpenTelemetrySdk)autoConfiguredRef.get());
        logger.log(Level.FINE, "Global OpenTelemetry set to {0} by autoconfiguration", sdk.getOpenTelemetrySdk());
        return sdk;
    }

    private AutoConfiguredOpenTelemetrySdk buildImpl() {
        AutoConfiguredOpenTelemetrySdk fromFileConfiguration = AutoConfiguredOpenTelemetrySdkBuilder.maybeConfigureFromFile((ConfigProperties)(this.config != null ? this.config : DefaultConfigProperties.create(Collections.emptyMap(), (ComponentLoader)this.componentLoader)), this.componentLoader);
        if (fromFileConfiguration != null) {
            this.maybeRegisterShutdownHook(fromFileConfiguration.getOpenTelemetrySdk());
            return fromFileConfiguration;
        }
        SpiHelper spiHelper = SpiHelper.create(this.componentLoader);
        if (!this.customized) {
            this.customized = true;
            this.mergeSdkTracerProviderConfigurer();
            for (AutoConfigurationCustomizerProvider customizer : spiHelper.loadOrdered(AutoConfigurationCustomizerProvider.class)) {
                customizer.customize((AutoConfigurationCustomizer)this);
            }
        }
        ConfigProperties config = this.getConfig();
        Resource resource = ResourceConfiguration.configureResource(config, spiHelper, this.resourceCustomizer);
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        try {
            boolean sdkEnabled;
            OpenTelemetrySdkBuilder sdkBuilder = OpenTelemetrySdk.builder();
            ContextPropagators propagators = PropagatorConfiguration.configurePropagators(config, spiHelper, this.propagatorCustomizer);
            sdkBuilder.setPropagators(propagators);
            boolean bl = sdkEnabled = !config.getBoolean("otel.sdk.disabled", false);
            if (sdkEnabled) {
                this.configureSdk(sdkBuilder, config, resource, spiHelper, closeables);
            }
            OpenTelemetrySdk openTelemetrySdk = sdkBuilder.build();
            this.maybeRegisterShutdownHook(openTelemetrySdk);
            this.callAutoConfigureListeners(spiHelper, openTelemetrySdk);
            return AutoConfiguredOpenTelemetrySdk.create(openTelemetrySdk, resource, config);
        }
        catch (RuntimeException e) {
            logger.info("Error encountered during autoconfiguration. Closing partially configured components.");
            for (Closeable closeable : closeables) {
                try {
                    logger.fine("Closing " + closeable.getClass().getName());
                    closeable.close();
                }
                catch (IOException ex) {
                    logger.warning("Error closing " + closeable.getClass().getName() + ": " + ex.getMessage());
                }
            }
            if (e instanceof ConfigurationException) {
                throw e;
            }
            throw new ConfigurationException("Unexpected configuration error", (Throwable)e);
        }
    }

    void configureSdk(OpenTelemetrySdkBuilder sdkBuilder, ConfigProperties config, Resource resource, SpiHelper spiHelper, List<Closeable> closeables) {
        SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder();
        meterProviderBuilder.setResource(resource);
        MeterProviderConfiguration.configureMeterProvider(meterProviderBuilder, config, spiHelper, this.metricReaderCustomizer, this.metricExporterCustomizer, closeables);
        meterProviderBuilder = this.meterProviderCustomizer.apply(meterProviderBuilder, config);
        SdkMeterProvider meterProvider = meterProviderBuilder.build();
        closeables.add((Closeable)meterProvider);
        SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder();
        tracerProviderBuilder.setResource(resource);
        TracerProviderConfiguration.configureTracerProvider(tracerProviderBuilder, config, spiHelper, (MeterProvider)meterProvider, this.spanExporterCustomizer, this.spanProcessorCustomizer, this.samplerCustomizer, closeables);
        tracerProviderBuilder = this.tracerProviderCustomizer.apply(tracerProviderBuilder, config);
        SdkTracerProvider tracerProvider = tracerProviderBuilder.build();
        closeables.add((Closeable)tracerProvider);
        SdkLoggerProviderBuilder loggerProviderBuilder = SdkLoggerProvider.builder();
        loggerProviderBuilder.setResource(resource);
        LoggerProviderConfiguration.configureLoggerProvider(loggerProviderBuilder, config, spiHelper, (MeterProvider)meterProvider, this.logRecordExporterCustomizer, this.logRecordProcessorCustomizer, closeables);
        loggerProviderBuilder = this.loggerProviderCustomizer.apply(loggerProviderBuilder, config);
        SdkLoggerProvider loggerProvider = loggerProviderBuilder.build();
        closeables.add((Closeable)loggerProvider);
        sdkBuilder.setTracerProvider(tracerProvider).setLoggerProvider(loggerProvider).setMeterProvider(meterProvider);
    }

    @Nullable
    private static AutoConfiguredOpenTelemetrySdk maybeConfigureFromFile(ConfigProperties config, ComponentLoader componentLoader) {
        String configurationFile;
        AutoConfiguredOpenTelemetrySdk sdk;
        if (INCUBATOR_AVAILABLE && (sdk = IncubatingUtil.configureFromSpi(componentLoader)) != null) {
            logger.fine("Autoconfigured from SPI by opentelemetry-sdk-extension-incubator");
            return sdk;
        }
        String otelConfigFile = config.getString("otel.config.file");
        if (otelConfigFile != null && !otelConfigFile.isEmpty()) {
            logger.warning("otel.config.file was set, but has been replaced with otel.experimental.config.file");
        }
        if ((configurationFile = config.getString("otel.experimental.config.file")) == null || configurationFile.isEmpty()) {
            return null;
        }
        if (!INCUBATOR_AVAILABLE) {
            throw new ConfigurationException("Cannot autoconfigure from config file without opentelemetry-sdk-extension-incubator on the classpath");
        }
        return IncubatingUtil.configureFromFile(logger, configurationFile, componentLoader);
    }

    private void maybeRegisterShutdownHook(OpenTelemetrySdk openTelemetrySdk) {
        if (!this.registerShutdownHook) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(this.shutdownHook(openTelemetrySdk));
    }

    void callAutoConfigureListeners(SpiHelper spiHelper, OpenTelemetrySdk openTelemetrySdk) {
        for (AutoConfigureListener listener : spiHelper.getListeners()) {
            try {
                listener.afterAutoConfigure(openTelemetrySdk);
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Error invoking listener " + listener.getClass().getName(), throwable);
            }
        }
    }

    void mergeSdkTracerProviderConfigurer() {
        for (SdkTracerProviderConfigurer configurer : this.componentLoader.load(SdkTracerProviderConfigurer.class)) {
            this.addTracerProviderCustomizer((builder, config) -> {
                configurer.configure(builder, config);
                return builder;
            });
        }
    }

    private ConfigProperties getConfig() {
        ConfigProperties config = this.config;
        if (config == null) {
            config = this.computeConfigProperties();
        }
        return config;
    }

    private ConfigProperties computeConfigProperties() {
        DefaultConfigProperties properties = DefaultConfigProperties.create(this.propertiesSupplier.get(), (ComponentLoader)this.componentLoader);
        for (Function<ConfigProperties, Map<String, String>> customizer : this.propertiesCustomizers) {
            Map<String, String> overrides = customizer.apply((ConfigProperties)properties);
            properties = properties.withOverrides(overrides);
        }
        return this.configPropertiesCustomizer.apply((ConfigProperties)properties);
    }

    Thread shutdownHook(OpenTelemetrySdk sdk) {
        return new Thread(() -> {
            try {
                sdk.close();
            }
            catch (Throwable e) {
                System.out.printf("%s Flush failed during shutdown: %s%n", Level.WARNING, e);
            }
        });
    }

    private static <I, O1, O2> BiFunction<I, ConfigProperties, O2> mergeCustomizer(BiFunction<? super I, ConfigProperties, ? extends O1> first, BiFunction<? super O1, ConfigProperties, ? extends O2> second) {
        return (configured, config) -> {
            Object firstResult = first.apply((Object)configured, (ConfigProperties)config);
            return second.apply((Object)firstResult, (ConfigProperties)config);
        };
    }

    private static Supplier<Map<String, String>> mergeProperties(Supplier<Map<String, String>> first, Supplier<Map<String, String>> second) {
        return () -> {
            HashMap merged = new HashMap();
            merged.putAll((Map)first.get());
            merged.putAll((Map)second.get());
            return merged;
        };
    }

    static {
        boolean incubatorAvailable = false;
        try {
            Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration", false, AutoConfiguredOpenTelemetrySdkBuilder.class.getClassLoader());
            incubatorAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INCUBATOR_AVAILABLE = incubatorAvailable;
    }
}

