/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.money;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.money.MonetaryAmount;
import org.hibernate.HibernateException;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.usertype.CompositeUserType;
import org.javamoney.moneta.Money;

public class MonetaryAmountType
implements CompositeUserType<MonetaryAmount> {
    public Object getPropertyValue(MonetaryAmount component, int property) throws HibernateException {
        switch (property) {
            case 0: {
                return component.getNumber().numberValue(BigDecimal.class);
            }
            case 1: {
                return component.getCurrency().getCurrencyCode();
            }
        }
        return null;
    }

    public MonetaryAmount instantiate(ValueAccess values) {
        BigDecimal amount = (BigDecimal)values.getValue(0, BigDecimal.class);
        String currency = (String)values.getValue(1, String.class);
        return Money.of((BigDecimal)amount, (String)currency);
    }

    public Class<?> embeddable() {
        return MonetaryAmountMapper.class;
    }

    public Class<MonetaryAmount> returnedClass() {
        return MonetaryAmount.class;
    }

    public boolean equals(MonetaryAmount x, MonetaryAmount y) {
        return Objects.equals(x, y);
    }

    public int hashCode(MonetaryAmount x) {
        return x.hashCode();
    }

    public MonetaryAmount deepCopy(MonetaryAmount value) {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(MonetaryAmount value) {
        return (Serializable)value;
    }

    public MonetaryAmount assemble(Serializable cached, Object owner) {
        return (MonetaryAmount)cached;
    }

    public MonetaryAmount replace(MonetaryAmount detached, MonetaryAmount managed, Object owner) {
        return detached;
    }

    public static class MonetaryAmountMapper {
        BigDecimal amount;
        String currency;
    }
}

