/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.shared.model.assertion;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.stats.assertion.Assertion;
import io.gatling.commons.stats.assertion.AssertionPath;
import io.gatling.commons.stats.assertion.AssertionPath$ForAll$;
import io.gatling.commons.stats.assertion.AssertionPath$Global$;
import io.gatling.commons.stats.assertion.Condition;
import io.gatling.commons.stats.assertion.CountMetric;
import io.gatling.commons.stats.assertion.CountMetric$AllRequests$;
import io.gatling.commons.stats.assertion.CountMetric$FailedRequests$;
import io.gatling.commons.stats.assertion.CountMetric$SuccessfulRequests$;
import io.gatling.commons.stats.assertion.Stat;
import io.gatling.commons.stats.assertion.Stat$Max$;
import io.gatling.commons.stats.assertion.Stat$Mean$;
import io.gatling.commons.stats.assertion.Stat$Min$;
import io.gatling.commons.stats.assertion.Stat$StandardDeviation$;
import io.gatling.commons.stats.assertion.Target;
import io.gatling.commons.stats.assertion.Target$MeanRequestsPerSecond$;
import io.gatling.commons.stats.assertion.TimeMetric;
import io.gatling.commons.stats.assertion.TimeMetric$ResponseTime$;
import io.gatling.shared.model.assertion.AssertionResult;
import io.gatling.shared.model.assertion.AssertionStatsRepository;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t-s!B\u0014)\u0011\u0003\u0019d!B\u001b)\u0011\u00031\u0004\"B\u001f\u0002\t\u0003qT\u0001B \u0002\t\u00013A!V\u0001G-\"Aa\r\u0002BK\u0002\u0013\u0005q\r\u0003\u0005n\t\tE\t\u0015!\u0003i\u0011!qGA!f\u0001\n\u0003y\u0007\u0002\u0003:\u0005\u0005#\u0005\u000b\u0011\u00029\t\u000bu\"A\u0011A:\t\u000f]$\u0011\u0011!C\u0001q\"91\u0010BI\u0001\n\u0003a\b\"CA\b\tE\u0005I\u0011AA\t\u0011%\t)\u0002BA\u0001\n\u0003\n9\u0002C\u0005\u0002*\u0011\t\t\u0011\"\u0001\u0002,!I\u00111\u0007\u0003\u0002\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003\u0003\"\u0011\u0011!C!\u0003\u0007B\u0011\"!\u0015\u0005\u0003\u0003%\t!a\u0015\t\u0013\u0005uC!!A\u0005B\u0005}\u0003\"CA2\t\u0005\u0005I\u0011IA3\u0011%\t9\u0007BA\u0001\n\u0003\nI\u0007C\u0005\u0002l\u0011\t\t\u0011\"\u0011\u0002n\u001dI\u0011\u0011O\u0001\u0002\u0002#%\u00111\u000f\u0004\t+\u0006\t\t\u0011#\u0003\u0002v!1Qh\u0006C\u0001\u0003\u0017C\u0011\"a\u001a\u0018\u0003\u0003%)%!\u001b\t\u0013\u00055u#!A\u0005\u0002\u0006=\u0005\"CAK/\u0005\u0005I\u0011QAL\u0011%\t)kFA\u0001\n\u0013\t9KB\u00036Q\t\ty\u000b\u0003\u0006\u00022v\u0011\t\u0011)A\u0005\u0003gCa!P\u000f\u0005\u0002\u0005e\u0006bBA`;\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003+lB\u0011BAl\u0011\u001d\tI0\bC\u0005\u0003wDqAa\u0003\u001e\t\u0013\u0011i\u0001C\u0004\u0003\"u!IAa\t\t\u000f\t%R\u0004\"\u0003\u0003,!9!\u0011I\u000f\u0005\n\t\r\u0013AE!tg\u0016\u0014H/[8o-\u0006d\u0017\u000eZ1u_JT!!\u000b\u0016\u0002\u0013\u0005\u001c8/\u001a:uS>t'BA\u0016-\u0003\u0015iw\u000eZ3m\u0015\tic&\u0001\u0004tQ\u0006\u0014X\r\u001a\u0006\u0003_A\nqaZ1uY&twMC\u00012\u0003\tIwn\u0001\u0001\u0011\u0005Q\nQ\"\u0001\u0015\u0003%\u0005\u001b8/\u001a:uS>tg+\u00197jI\u0006$xN]\n\u0003\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00014\u00055\u0019F/\u0019;t\u0005f\u001cF/\u0019;vgB!\u0001(Q\"O\u0013\t\u0011\u0015HA\u0005Gk:\u001cG/[8ocA\u0019\u0001\b\u0012$\n\u0005\u0015K$AB(qi&|g\u000e\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006)1\u000f^1ug*\u00111JL\u0001\bG>lWn\u001c8t\u0013\ti\u0005J\u0001\u0004Ti\u0006$Xo\u001d\t\u0003\u001fJs!\u0001\u000e)\n\u0005EC\u0013\u0001G!tg\u0016\u0014H/[8o'R\fGo\u001d*fa>\u001c\u0018\u000e^8ss&\u00111\u000b\u0016\u0002\u0006'R\fGo\u001d\u0006\u0003#\"\u0012a\u0002U1uQJ+7o\u001c7vi&|gn\u0005\u0003\u0005o]S\u0006C\u0001\u001dY\u0013\tI\u0016HA\u0004Qe>$Wo\u0019;\u0011\u0005m\u001bgB\u0001/b\u001d\ti\u0006-D\u0001_\u0015\ty&'\u0001\u0004=e>|GOP\u0005\u0002u%\u0011!-O\u0001\ba\u0006\u001c7.Y4f\u0013\t!WM\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002cs\u0005\tRO\u001c4pY\u0012,G-Q:tKJ$\u0018n\u001c8\u0016\u0003!\u0004\"![6\u000e\u0003)T!!\u000b%\n\u00051T'!C!tg\u0016\u0014H/[8o\u0003I)hNZ8mI\u0016$\u0017i]:feRLwN\u001c\u0011\u0002\u001bM$\u0018\r^:CsN#\u0018\r^;t+\u0005\u0001\bCA9\u0004\u001b\u0005\t\u0011AD:uCR\u001c()_*uCR,8\u000f\t\u000b\u0004iV4\bCA9\u0005\u0011\u00151\u0017\u00021\u0001i\u0011\u0015q\u0017\u00021\u0001q\u0003\u0011\u0019w\u000e]=\u0015\u0007QL(\u0010C\u0004g\u0015A\u0005\t\u0019\u00015\t\u000f9T\u0001\u0013!a\u0001a\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A?+\u0005!t8&A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013I\u0014AC1o]>$\u0018\r^5p]&!\u0011QBA\u0002\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019B\u000b\u0002q}\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005!A.\u00198h\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003;\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0017!\rA\u0014qF\u0005\u0004\u0003cI$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001c\u0003{\u00012\u0001OA\u001d\u0013\r\tY$\u000f\u0002\u0004\u0003:L\b\"CA \u001f\u0005\u0005\t\u0019AA\u0017\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\t\t\u0007\u0003\u000f\ni%a\u000e\u000e\u0005\u0005%#bAA&s\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0013\u0011\n\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002V\u0005m\u0003c\u0001\u001d\u0002X%\u0019\u0011\u0011L\u001d\u0003\u000f\t{w\u000e\\3b]\"I\u0011qH\t\u0002\u0002\u0003\u0007\u0011qG\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u001a\u0005\u0005\u0004\"CA %\u0005\u0005\t\u0019AA\u0017\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0017\u0003!!xn\u0015;sS:<GCAA\r\u0003\u0019)\u0017/^1mgR!\u0011QKA8\u0011%\ty$FA\u0001\u0002\u0004\t9$\u0001\bQCRD'+Z:pYV$\u0018n\u001c8\u0011\u0005E<2#B\f\u0002x\u0005\r\u0005cBA=\u0003\u007fB\u0007\u000f^\u0007\u0003\u0003wR1!! :\u0003\u001d\u0011XO\u001c;j[\u0016LA!!!\u0002|\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005\u0015\u0015\u0011R\u0007\u0003\u0003\u000fS1!MA\u0011\u0013\r!\u0017q\u0011\u000b\u0003\u0003g\nQ!\u00199qYf$R\u0001^AI\u0003'CQA\u001a\u000eA\u0002!DQA\u001c\u000eA\u0002A\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001a\u0006\u0005\u0006\u0003\u0002\u001dE\u00037\u0003R\u0001OAOQBL1!a(:\u0005\u0019!V\u000f\u001d7fe!A\u00111U\u000e\u0002\u0002\u0003\u0007A/A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!+\u0011\t\u0005m\u00111V\u0005\u0005\u0003[\u000biB\u0001\u0004PE*,7\r^\n\u0003;]\n!B]3q_NLGo\u001c:z!\r!\u0014QW\u0005\u0004\u0003oC#\u0001G!tg\u0016\u0014H/[8o'R\fGo\u001d*fa>\u001c\u0018\u000e^8ssR!\u00111XA_!\t!T\u0004C\u0004\u00022~\u0001\r!a-\u0002%Y\fG.\u001b3bi\u0016\f5o]3si&|gn\u001d\u000b\u0005\u0003\u0007\fy\rE\u0003\\\u0003\u000b\fI-C\u0002\u0002H\u0016\u0014A\u0001T5tiB\u0019A'a3\n\u0007\u00055\u0007FA\bBgN,'\u000f^5p]J+7/\u001e7u\u0011\u001d\t\t\u000e\ta\u0001\u0003'\f!\"Y:tKJ$\u0018n\u001c8t!\u0011Y\u0016Q\u00195\u0002\u0017I,7o\u001c7wKB\u000bG\u000f\u001b\u000b\u0007\u00033\f\u00190!>\u0011\u000fm\u000bY.a8\u0002n&\u0019\u0011Q\\3\u0003\r\u0015KG\u000f[3s!\u0011\t\t/!;\u000f\t\u0005\r\u0018Q\u001d\t\u0003;fJ1!a::\u0003\u0019\u0001&/\u001a3fM&!\u0011qEAv\u0015\r\t9/\u000f\t\u00067\u0006\u0015\u0017q\u001e\t\u0004\u0003c$aB\u0001\u001b\u0001\u0011\u0015I\u0013\u00051\u0001i\u0011\u001d\t90\ta\u0001\u0003g\u000b1b\u001d;biN\u001cv.\u001e:dK\u0006i!/Z:pYZ,G+\u0019:hKR$b!!@\u0003\u0006\t\u001d\u0001c\u0002\u001d\u0002\u001e\u0006}\u0018Q\u000b\t\u0004q\t\u0005\u0011b\u0001B\u0002s\t1Ai\\;cY\u0016DQ!\u000b\u0012A\u0002!Da!\u0013\u0012A\u0002\t%\u0001cAAy\u0007\u0005i\"/Z:pYZ,7i\\;oiR\u000b'oZ3u\u0003\u000e$X/\u00197WC2,X\r\u0006\u0004\u0003\u0010\tU!q\u0004\t\u0004q\tE\u0011b\u0001B\ns\t!Aj\u001c8h\u0011\u001d\u00119b\ta\u0001\u00053\ta!\\3ue&\u001c\u0007cA5\u0003\u001c%\u0019!Q\u00046\u0003\u0017\r{WO\u001c;NKR\u0014\u0018n\u0019\u0005\u0007\u0013\u000e\u0002\rA!\u0003\u0002?I,7o\u001c7wKB+'oY3oiR\u000b'oZ3u\u0003\u000e$X/\u00197WC2,X\r\u0006\u0004\u0002\u0000\n\u0015\"q\u0005\u0005\b\u0005/!\u0003\u0019\u0001B\r\u0011\u0019IE\u00051\u0001\u0003\n\u0005a\"/Z:pYZ,G+[7f)\u0006\u0014x-\u001a;BGR,\u0018\r\u001c,bYV,G\u0003CA\u0017\u0005[\u0011)Da\u0010\t\u000f\t]Q\u00051\u0001\u00030A\u0019\u0011N!\r\n\u0007\tM\"N\u0001\u0006US6,W*\u001a;sS\u000eDqAa\u000e&\u0001\u0004\u0011I$\u0001\u0003ti\u0006$\bcA5\u0003<%\u0019!Q\b6\u0003\tM#\u0018\r\u001e\u0005\u0007\u0013\u0016\u0002\rA!\u0003\u0002!I,7o\u001c7wK\u000e{g\u000eZ5uS>tGCBA+\u0005\u000b\u00129\u0005C\u0003*M\u0001\u0007\u0001\u000eC\u0004\u0003J\u0019\u0002\r!a@\u0002\u0017\u0005\u001cG/^1m-\u0006dW/\u001a")
public final class AssertionValidator {
    private final AssertionStatsRepository repository;

    public List<AssertionResult> validateAssertions(List<Assertion> assertions) {
        return assertions.flatMap((Function1 & Serializable)rawAssertion -> {
            Either<String, List<PathResolution>> either = this.resolvePath((Assertion)rawAssertion, $this.repository);
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                AssertionResult.ResolutionError resolutionError = new AssertionResult.ResolutionError((Assertion)rawAssertion, error);
                return Nil$.MODULE$.$colon$colon((Object)resolutionError);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                List pathResolutions = (List)right.value();
                return pathResolutions.map((Function1 & Serializable)x0$1 -> {
                    PathResolution pathResolution = x0$1;
                    if (pathResolution != null) {
                        Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus;
                        Assertion unfoldedAssertion = pathResolution.unfoldedAssertion();
                        Tuple2<Object, Object> tuple2 = this.resolveTarget(unfoldedAssertion, statsByStatus = pathResolution.statsByStatus());
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        double actualValue = tuple2._1$mcD$sp();
                        boolean success = tuple2._2$mcZ$sp();
                        Tuple2.mcDZ.sp sp2 = new Tuple2.mcDZ.sp(actualValue, success);
                        double actualValue2 = sp2._1$mcD$sp();
                        boolean success2 = sp2._2$mcZ$sp();
                        return new AssertionResult.Resolved(unfoldedAssertion, success2, actualValue2);
                    }
                    throw new MatchError((Object)pathResolution);
                });
            }
            throw new MatchError(either);
        });
    }

    private Either<String, List<PathResolution>> resolvePath(Assertion assertion, AssertionStatsRepository statsSource) {
        AssertionPath.Details details;
        List<String> list;
        AssertionPath assertionPath = assertion.path();
        if (AssertionPath$Global$.MODULE$.equals(assertionPath) ? true : assertionPath instanceof AssertionPath.Details && Nil$.MODULE$.equals(list = (details = (AssertionPath.Details)assertionPath).parts())) {
            PathResolution pathResolution = new PathResolution(assertion, (Function1<Option<Status>, AssertionStatsRepository.Stats>)(Function1 & Serializable)x$2 -> statsSource.requestGeneralStats((List<String>)Nil$.MODULE$, (Option<String>)None$.MODULE$, (Option<Status>)x$2));
            return new Right((Object)Nil$.MODULE$.$colon$colon((Object)pathResolution));
        }
        if (AssertionPath$ForAll$.MODULE$.equals(assertionPath)) {
            return new Right((Object)statsSource.allRequestPaths().map((Function1 & Serializable)x0$1 -> {
                AssertionStatsRepository.StatsPath.Request request = x0$1;
                if (request != null) {
                    List<String> group = request.group();
                    String request2 = request.request();
                    List<String> list = group;
                    String string = request2;
                    return new PathResolution(assertion.copy(new AssertionPath.Details((List<String>)Nil$.MODULE$.$colon$colon((Object)string).$colon$colon$colon(list)), assertion.copy$default$2(), assertion.copy$default$3()), (Function1<Option<Status>, AssertionStatsRepository.Stats>)(Function1 & Serializable)x$3 -> statsSource.requestGeneralStats(group, (Option<String>)new Some((Object)request2), (Option<Status>)x$3));
                }
                throw new MatchError((Object)request);
            }));
        }
        if (assertionPath instanceof AssertionPath.Details) {
            AssertionStatsRepository.StatsPath statsPath;
            AssertionPath.Details details2 = (AssertionPath.Details)assertionPath;
            List<String> parts = details2.parts();
            boolean bl = false;
            Some some = null;
            Option<AssertionStatsRepository.StatsPath> option = statsSource.findPathByParts(parts);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                AssertionStatsRepository.StatsPath statsPath2 = (AssertionStatsRepository.StatsPath)some.value();
                if (statsPath2 instanceof AssertionStatsRepository.StatsPath.Request) {
                    AssertionStatsRepository.StatsPath.Request request = (AssertionStatsRepository.StatsPath.Request)statsPath2;
                    List<String> group = request.group();
                    String request2 = request.request();
                    PathResolution pathResolution = new PathResolution(assertion, (Function1<Option<Status>, AssertionStatsRepository.Stats>)(Function1 & Serializable)x$4 -> statsSource.requestGeneralStats(group, (Option<String>)new Some((Object)request2), (Option<Status>)x$4));
                    return new Right((Object)Nil$.MODULE$.$colon$colon((Object)pathResolution));
                }
            }
            if (bl && (statsPath = (AssertionStatsRepository.StatsPath)some.value()) instanceof AssertionStatsRepository.StatsPath.Group) {
                AssertionStatsRepository.StatsPath.Group group = (AssertionStatsRepository.StatsPath.Group)statsPath;
                List<String> group2 = group.group();
                PathResolution pathResolution = new PathResolution(assertion, (Function1<Option<Status>, AssertionStatsRepository.Stats>)(Function1 & Serializable)x$5 -> statsSource.groupCumulatedResponseTimeGeneralStats(group2, (Option<Status>)x$5));
                return new Right((Object)Nil$.MODULE$.$colon$colon((Object)pathResolution));
            }
            return new Left((Object)("Could not find stats matching assertion path " + parts));
        }
        throw new MatchError((Object)assertionPath);
    }

    private Tuple2<Object, Object> resolveTarget(Assertion assertion, Function1<Option<Status>, AssertionStatsRepository.Stats> stats) {
        double d;
        Target target = assertion.target();
        if (Target$MeanRequestsPerSecond$.MODULE$.equals(target)) {
            d = ((AssertionStatsRepository.Stats)stats.apply((Object)None$.MODULE$)).meanRequestsPerSec();
        } else if (target instanceof Target.Count) {
            Target.Count count = (Target.Count)target;
            CountMetric metric = count.metric();
            d = this.resolveCountTargetActualValue(metric, stats);
        } else if (target instanceof Target.Percent) {
            Target.Percent percent = (Target.Percent)target;
            CountMetric metric = percent.metric();
            d = this.resolvePercentTargetActualValue(metric, stats);
        } else if (target instanceof Target.Time) {
            Target.Time time = (Target.Time)target;
            TimeMetric metric = time.metric();
            Stat stat = time.stat();
            d = this.resolveTimeTargetActualValue(metric, stat, stats);
        } else {
            throw new MatchError((Object)target);
        }
        double actualValue = d;
        return new Tuple2.mcDZ.sp(actualValue, this.resolveCondition(assertion, actualValue));
    }

    private long resolveCountTargetActualValue(CountMetric metric, Function1<Option<Status>, AssertionStatsRepository.Stats> stats) {
        AssertionStatsRepository.Stats stats2;
        CountMetric countMetric = metric;
        if (CountMetric$AllRequests$.MODULE$.equals(countMetric)) {
            stats2 = (AssertionStatsRepository.Stats)stats.apply((Object)None$.MODULE$);
        } else if (CountMetric$FailedRequests$.MODULE$.equals(countMetric)) {
            stats2 = (AssertionStatsRepository.Stats)stats.apply((Object)new Some((Object)KO$.MODULE$));
        } else if (CountMetric$SuccessfulRequests$.MODULE$.equals(countMetric)) {
            stats2 = (AssertionStatsRepository.Stats)stats.apply((Object)new Some((Object)OK$.MODULE$));
        } else {
            throw new MatchError((Object)countMetric);
        }
        AssertionStatsRepository.Stats resolvedStats = stats2;
        return resolvedStats.count();
    }

    private double resolvePercentTargetActualValue(CountMetric metric, Function1<Option<Status>, AssertionStatsRepository.Stats> stats) {
        long allCount = ((AssertionStatsRepository.Stats)stats.apply((Object)None$.MODULE$)).count();
        CountMetric countMetric = metric;
        if (CountMetric$SuccessfulRequests$.MODULE$.equals(countMetric)) {
            if (allCount == 0L) {
                return 0.0;
            }
            return (double)((AssertionStatsRepository.Stats)stats.apply((Object)new Some((Object)OK$.MODULE$))).count() / (double)allCount * (double)100;
        }
        if (CountMetric$FailedRequests$.MODULE$.equals(countMetric)) {
            if (allCount == 0L) {
                return 100.0;
            }
            return (double)((AssertionStatsRepository.Stats)stats.apply((Object)new Some((Object)KO$.MODULE$))).count() / (double)allCount * (double)100;
        }
        return 100.0;
    }

    private int resolveTimeTargetActualValue(TimeMetric metric, Stat stat, Function1<Option<Status>, AssertionStatsRepository.Stats> stats) {
        TimeMetric timeMetric = metric;
        if (!TimeMetric$ResponseTime$.MODULE$.equals(timeMetric)) {
            throw new MatchError((Object)timeMetric);
        }
        AssertionStatsRepository.Stats resolvedStats = (AssertionStatsRepository.Stats)stats.apply((Object)None$.MODULE$);
        Stat stat2 = stat;
        if (Stat$Min$.MODULE$.equals(stat2)) {
            return resolvedStats.min();
        }
        if (Stat$Max$.MODULE$.equals(stat2)) {
            return resolvedStats.max();
        }
        if (Stat$Mean$.MODULE$.equals(stat2)) {
            return resolvedStats.mean();
        }
        if (Stat$StandardDeviation$.MODULE$.equals(stat2)) {
            return resolvedStats.stdDev();
        }
        if (stat2 instanceof Stat.Percentile) {
            Stat.Percentile percentile = (Stat.Percentile)stat2;
            double value = percentile.value();
            return resolvedStats.percentile().apply$mcID$sp(value);
        }
        throw new MatchError((Object)stat2);
    }

    private boolean resolveCondition(Assertion assertion, double actualValue) {
        boolean bl = false;
        Condition.Between between = null;
        Condition condition = assertion.condition();
        if (condition instanceof Condition.Lt) {
            Condition.Lt lt = (Condition.Lt)condition;
            double upper = lt.value();
            return actualValue < upper;
        }
        if (condition instanceof Condition.Lte) {
            Condition.Lte lte = (Condition.Lte)condition;
            double upper = lte.value();
            return actualValue <= upper;
        }
        if (condition instanceof Condition.Gt) {
            Condition.Gt gt = (Condition.Gt)condition;
            double lower = gt.value();
            return actualValue > lower;
        }
        if (condition instanceof Condition.Gte) {
            Condition.Gte gte = (Condition.Gte)condition;
            double lower = gte.value();
            return actualValue >= lower;
        }
        if (condition instanceof Condition.Is) {
            Condition.Is is = (Condition.Is)condition;
            double exactValue = is.value();
            return actualValue == exactValue;
        }
        if (condition instanceof Condition.Between) {
            bl = true;
            between = (Condition.Between)condition;
            double lower = between.lowerBound();
            double upper = between.upperBound();
            boolean bl2 = between.inclusive();
            if (bl2) {
                return actualValue >= lower && actualValue <= upper;
            }
        }
        if (bl) {
            double lower = between.lowerBound();
            double upper = between.upperBound();
            boolean bl3 = between.inclusive();
            if (!bl3) {
                return actualValue > lower && actualValue < upper;
            }
        }
        if (condition instanceof Condition.In) {
            Condition.In in = (Condition.In)condition;
            List<Object> elements = in.elements();
            return elements.contains((Object)BoxesRunTime.boxToDouble((double)actualValue));
        }
        throw new MatchError((Object)condition);
    }

    public AssertionValidator(AssertionStatsRepository repository) {
        this.repository = repository;
    }

    private static final class PathResolution
    implements Product,
    Serializable {
        private final Assertion unfoldedAssertion;
        private final Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Assertion unfoldedAssertion() {
            return this.unfoldedAssertion;
        }

        public Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus() {
            return this.statsByStatus;
        }

        public PathResolution copy(Assertion unfoldedAssertion, Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus) {
            return new PathResolution(unfoldedAssertion, statsByStatus);
        }

        public Assertion copy$default$1() {
            return this.unfoldedAssertion();
        }

        public Function1<Option<Status>, AssertionStatsRepository.Stats> copy$default$2() {
            return this.statsByStatus();
        }

        public String productPrefix() {
            return "PathResolution";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.unfoldedAssertion();
                }
                case 1: {
                    return this.statsByStatus();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PathResolution;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "unfoldedAssertion";
                }
                case 1: {
                    return "statsByStatus";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PathResolution)) return false;
            boolean bl = true;
            if (!bl) return false;
            PathResolution pathResolution = (PathResolution)x$1;
            Assertion assertion = this.unfoldedAssertion();
            Assertion assertion2 = pathResolution.unfoldedAssertion();
            if (assertion == null) {
                if (assertion2 != null) {
                    return false;
                }
            } else if (!((Object)assertion).equals(assertion2)) return false;
            Function1<Option<Status>, AssertionStatsRepository.Stats> function1 = this.statsByStatus();
            Function1<Option<Status>, AssertionStatsRepository.Stats> function12 = pathResolution.statsByStatus();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public PathResolution(Assertion unfoldedAssertion, Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus) {
            this.unfoldedAssertion = unfoldedAssertion;
            this.statsByStatus = statsByStatus;
            Product.$init$((Product)this);
        }
    }
}

