/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum AutoPullMode {
    ON(true, "on", "true"),
    ONCE(true, "once"),
    OFF(false, "off", "false"),
    ALWAYS(true, "always");

    private Set<String> values = new HashSet<String>();
    private boolean doPullIfNotPresent;

    private AutoPullMode(boolean doPullIfNotPresent, String ... vals) {
        this.doPullIfNotPresent = doPullIfNotPresent;
        Collections.addAll(this.values, vals);
    }

    public boolean doPullIfNotPresent() {
        return this.doPullIfNotPresent;
    }

    public boolean alwaysPull() {
        return this == ONCE || this == ALWAYS;
    }

    public static AutoPullMode fromString(String val) {
        String valNorm = val.toLowerCase();
        for (AutoPullMode mode : AutoPullMode.values()) {
            if (!mode.values.contains(valNorm)) continue;
            return mode;
        }
        throw new IllegalArgumentException("Invalid auto-pull mode " + val + ". Please use 'on', 'off', 'once' or 'always'.");
    }
}

