/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config.handler;

import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ExternalConfigHandler;
import io.fabric8.maven.docker.config.handler.compose.DockerComposeConfigHandler;
import io.fabric8.maven.docker.config.handler.property.PropertyConfigHandler;
import io.fabric8.maven.docker.util.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

@Component(role=ImageConfigResolver.class, instantiationStrategy="singleton")
public class ImageConfigResolver
implements Initializable {
    private Map<String, ExternalConfigHandler> registry;
    @Requirement(role=PropertyConfigHandler.class)
    private ExternalConfigHandler propertyConfigHandler;
    @Requirement(role=DockerComposeConfigHandler.class)
    private ExternalConfigHandler dockerComposeConfigHandler;
    private Logger log;

    public void initialize() throws InitializationException {
        this.registry = new HashMap<String, ExternalConfigHandler>();
        for (ExternalConfigHandler handler : new ExternalConfigHandler[]{this.propertyConfigHandler, this.dockerComposeConfigHandler}) {
            if (handler == null) continue;
            this.registry.put(handler.getType(), handler);
        }
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public List<ImageConfiguration> resolve(ImageConfiguration unresolvedConfig, MavenProject project, MavenSession session) {
        this.injectExternalConfigActivation(unresolvedConfig, project);
        Map<String, String> externalConfig = unresolvedConfig.getExternalConfig();
        if (externalConfig != null) {
            String type = externalConfig.get("type");
            if (type == null) {
                throw new IllegalArgumentException(unresolvedConfig.getDescription() + ": No config type given");
            }
            ExternalConfigHandler handler = this.registry.get(type);
            if (handler == null) {
                throw new IllegalArgumentException(unresolvedConfig.getDescription() + ": No handler for type " + type + " given");
            }
            return handler.resolve(unresolvedConfig, project, session);
        }
        return Collections.singletonList(unresolvedConfig);
    }

    private void injectExternalConfigActivation(ImageConfiguration unresolvedConfig, MavenProject project) {
        String mode = ConfigHelper.getExternalConfigActivationProperty(project);
        if (mode == null) {
            return;
        }
        Map<String, String> externalConfig = unresolvedConfig.getExternalConfig();
        if (externalConfig == null) {
            externalConfig = new HashMap<String, String>();
            externalConfig.put("type", this.propertyConfigHandler.getType());
            externalConfig.put("mode", mode);
            unresolvedConfig.setExternalConfiguration(externalConfig);
            this.log.verbose(Logger.LogVerboseCategory.BUILD, "Global %s=%s property activates property configuration for image", "docker.imagePropertyConfiguration", mode);
        } else {
            this.log.verbose(Logger.LogVerboseCategory.BUILD, "Ignoring %s=%s property, image has <external> in POM which takes precedence", "docker.imagePropertyConfiguration", mode);
        }
    }
}

