/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.assembly;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AssemblyFiles {
    private final File assemblyDirectory;
    private List<Entry> entries = new ArrayList<Entry>();

    public AssemblyFiles(File assemblyDirectory) {
        this.assemblyDirectory = assemblyDirectory;
    }

    public void addEntry(File srcFile, File destFile) {
        this.entries.add(new Entry(srcFile, destFile));
    }

    public List<Entry> getUpdatedEntriesAndRefresh() {
        ArrayList<Entry> ret = new ArrayList<Entry>();
        for (Entry entry : this.entries) {
            if (!entry.isUpdated()) continue;
            ret.add(entry);
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public File getAssemblyDirectory() {
        return this.assemblyDirectory;
    }

    public static class Entry {
        private long lastModified;
        private File srcFile;
        private File destFile;

        private Entry(File srcFile, File destFile) {
            this.srcFile = srcFile;
            this.destFile = destFile;
            if (!srcFile.exists()) {
                throw new IllegalArgumentException("Source " + srcFile + " does not exist");
            }
            if (!destFile.exists()) {
                throw new IllegalArgumentException("Destination " + destFile + " does not exist");
            }
            if (srcFile.isDirectory()) {
                throw new IllegalArgumentException("Can only watch files, not directories: " + srcFile);
            }
            this.lastModified = this.srcFile.lastModified();
        }

        public File getSrcFile() {
            return this.srcFile;
        }

        public File getDestFile() {
            return this.destFile;
        }

        boolean isUpdated() {
            if (this.srcFile.lastModified() > this.lastModified) {
                this.lastModified = this.srcFile.lastModified();
                return true;
            }
            return false;
        }
    }
}

