/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.element.svg;

import org.vaadin.firitin.element.svg.PathElement;
import org.vaadin.firitin.element.svg.SvgElement;
import org.vaadin.firitin.element.svg.SvgGraphicsElement;
import org.vaadin.firitin.element.svg.TextElement;

public class TextPathElement
extends SvgGraphicsElement {
    private static int idCounter = 0;

    public TextPathElement() {
        super("textPath");
    }

    public TextPathElement(PathElement path) {
        super("textPath");
        this.path(path);
    }

    public TextPathElement(PathElement path, String text) {
        super("textPath");
        this.path(path);
        this.setText(text);
    }

    public TextPathElement text(String text) {
        this.setText(text);
        return this;
    }

    public TextPathElement path(PathElement path) {
        this.setAttribute("href", "#" + TextPathElement.ensureId(path));
        return this;
    }

    public TextPathElement href(String href) {
        this.setWriteOnlyAttribute("href", href);
        return this;
    }

    public TextPathElement hrefRW(String href) {
        this.setAttribute("href", href);
        return this;
    }

    private static String ensureId(SvgElement element) {
        Object id = element.getAttribute("id");
        if (id == null || ((String)id).isEmpty()) {
            id = "svg-textpath-" + ++idCounter;
            element.setAttribute("id", (String)id);
        }
        return id;
    }

    public TextPathElement startOffset(double offset) {
        this.setWriteOnlyAttribute("startOffset", String.valueOf(offset));
        return this;
    }

    public TextPathElement startOffset(String offset) {
        this.setWriteOnlyAttribute("startOffset", offset);
        return this;
    }

    public TextPathElement startOffsetRW(double offset) {
        this.setAttribute("startOffset", String.valueOf(offset));
        return this;
    }

    public TextPathElement startOffsetRW(String offset) {
        this.setAttribute("startOffset", offset);
        return this;
    }

    public TextPathElement method(Method method) {
        this.setWriteOnlyAttribute("method", method.toString());
        return this;
    }

    public TextPathElement methodRW(Method method) {
        this.setAttribute("method", method.toString());
        return this;
    }

    public TextPathElement spacing(Spacing spacing) {
        this.setWriteOnlyAttribute("spacing", spacing.toString());
        return this;
    }

    public TextPathElement spacingRW(Spacing spacing) {
        this.setAttribute("spacing", spacing.toString());
        return this;
    }

    public TextPathElement side(Side side) {
        this.setWriteOnlyAttribute("side", side.toString());
        return this;
    }

    public TextPathElement sideRW(Side side) {
        this.setAttribute("side", side.toString());
        return this;
    }

    public TextPathElement textLength(double length) {
        this.setWriteOnlyAttribute("textLength", String.valueOf(length));
        return this;
    }

    public TextPathElement textLengthRW(double length) {
        this.setAttribute("textLength", String.valueOf(length));
        return this;
    }

    public TextPathElement fontFamily(String fontFamily) {
        this.setWriteOnlyAttribute("font-family", fontFamily);
        return this;
    }

    public TextPathElement fontFamilyRW(String fontFamily) {
        this.setAttribute("font-family", fontFamily);
        return this;
    }

    public TextPathElement fontSize(double size) {
        this.setWriteOnlyAttribute("font-size", String.valueOf(size));
        return this;
    }

    public TextPathElement fontSize(String size) {
        this.setWriteOnlyAttribute("font-size", size);
        return this;
    }

    public TextPathElement fontSizeRW(double size) {
        this.setAttribute("font-size", String.valueOf(size));
        return this;
    }

    public TextPathElement fontSizeRW(String size) {
        this.setAttribute("font-size", size);
        return this;
    }

    public TextPathElement fontWeight(TextElement.FontWeight weight) {
        this.setWriteOnlyAttribute("font-weight", weight.toString());
        return this;
    }

    public TextPathElement fontWeightRW(TextElement.FontWeight weight) {
        this.setAttribute("font-weight", weight.toString());
        return this;
    }

    public static enum Method {
        ALIGN("align"),
        STRETCH("stretch");

        private final String value;

        private Method(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Spacing {
        AUTO("auto"),
        EXACT("exact");

        private final String value;

        private Spacing(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Side {
        LEFT("left"),
        RIGHT("right");

        private final String value;

        private Side(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

