/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.grid;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.FooterRow;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.components.grid.VGrid;
import org.vaadin.firitin.components.orderedlayout.VHorizontalLayout;

public class PagingGrid<T>
extends VGrid<T> {
    private PaginationBar secondaryBar;
    private FooterRow.FooterCell footerCell;
    private HeaderRow.HeaderCell headerCell;
    private MessageFormat statusMessage = new MessageFormat("Page {0}, showing {1} results per page.");
    private PaginationBarMode paginationBarMode = PaginationBarMode.TOP;
    private PagingDataProvider<T> dataProvider;
    private PaginationBar paginationBar;
    private ComponentEventListener<SortEvent<Grid<T>, GridSortOrder<T>>> sortListener = (ComponentEventListener & Serializable)event -> {
        if (this.dataProvider == null) {
            return;
        }
        this.setItems(this.dataProvider.pageRequested(this.paginationBar.currentPage, this.getPageSize()));
    };

    public PagingGrid() {
        this.init();
    }

    public PagingGrid(Class<T> beanType) {
        super(beanType);
        this.init();
    }

    public PagingGrid(Class<T> beanType, boolean autoCreateColumns) {
        super(beanType, autoCreateColumns);
        this.init();
    }

    public PagingGrid(int pageSize) {
        super(pageSize);
        this.init();
    }

    public void setPaginationBarMode(PaginationBarMode value) {
        if (this.paginationBarMode != value) {
            this.paginationBarMode = value;
            if (this.paginationBar != null) {
                this.preparePaginationBar();
            }
        }
    }

    private void init() {
        this.addSortListener(this.sortListener);
        this.setPageSize(10);
        this.setAllRowsVisible(true);
    }

    protected void preparePaginationBar() {
        if (this.paginationBar == null) {
            this.paginationBar = new PaginationBar(null);
        } else {
            this.paginationBar.size = null;
            this.paginationBar.pages = null;
            this.paginationBar.currentPage = 0L;
            this.paginationBar.updateState();
        }
        if (this.getColumns().isEmpty()) {
            return;
        }
        if (this.paginationBarMode == PaginationBarMode.BOTH) {
            this.addToHeader();
            this.secondaryBar = new PaginationBar(this.paginationBar.size);
            this.secondaryBar.currentPage = this.paginationBar.currentPage;
            this.secondaryBar.updateState();
            this.addToFooter();
        } else {
            if (this.secondaryBar != null) {
                try {
                    this.secondaryBar.removeFromParent();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.secondaryBar = null;
            }
            if (this.paginationBarMode == PaginationBarMode.TOP) {
                this.addToHeader();
            } else if (this.paginationBarMode == PaginationBarMode.BOTTOM) {
                this.addToFooter();
            }
        }
    }

    protected void addToFooter() {
        PaginationBar bar;
        PaginationBar paginationBar = bar = this.secondaryBar == null ? this.paginationBar : this.secondaryBar;
        if (this.footerCell == null) {
            this.uglyHackToAllowJoiningFirstFooterRowCells();
            FooterRow footerRow = this.appendFooterRow();
            this.footerCell = (FooterRow.FooterCell)footerRow.join(this.getColumns().toArray(new Grid.Column[0]));
        }
        this.footerCell.setComponent((Component)bar);
    }

    private void uglyHackToAllowJoiningFirstFooterRowCells() {
        if (this.getFooterRows().isEmpty()) {
            this.appendFooterRow();
            this.addClassName("paging-grid");
            Element style = new Element("style");
            style.setProperty("innerHTML", "vaadin-grid.paging-grid::part(first-footer-row-cell) {\n   display: none;\n}\n");
            UI.getCurrent().getElement().appendChild(new Element[]{style});
        }
    }

    protected void addToHeader() {
        if (this.headerCell == null) {
            HeaderRow headerRow = this.prependHeaderRow();
            this.headerCell = headerRow.join(this.getColumns().toArray(new Grid.Column[0]));
        }
        this.headerCell.setComponent((Component)this.paginationBar);
    }

    public PagingDataProvider<T> getPagingDataProvider() {
        return this.dataProvider;
    }

    public void setPagingDataProvider(PagingDataProvider<T> provider) {
        this.dataProvider = provider;
        this.preparePaginationBar();
        this.setItems(this.dataProvider.pageRequested(0L, this.getPageSize()));
        if (this.paginationBar.currentPage != 0L) {
            this.paginationBar.currentPage = 0L;
            this.paginationBar.updateState();
            if (this.secondaryBar != null) {
                this.secondaryBar.currentPage = 0L;
                this.secondaryBar.updateState();
            }
        }
    }

    public void setTotalResults(long totalResults) {
        this.paginationBar.setSize(totalResults);
        this.paginationBar.updateState();
        if (this.secondaryBar != null) {
            this.secondaryBar.setSize(totalResults);
            this.secondaryBar.updateState();
        }
    }

    public void setPageSize(int pageSize) {
        super.setPageSize(pageSize);
        if (this.paginationBar != null) {
            this.paginationBar.fetchPage();
        }
    }

    public void setStatusMessage(MessageFormat statusMessage) {
        this.statusMessage = statusMessage;
        if (this.paginationBar != null) {
            this.paginationBar.updateState();
            if (this.secondaryBar != null) {
                this.secondaryBar.updateState();
            }
        }
    }

    public static enum PaginationBarMode {
        TOP,
        BOTTOM,
        BOTH;

    }

    class PaginationBar
    extends VHorizontalLayout {
        private static final long serialVersionUID = 7799263034212965499L;
        private final Span status = new Span();
        private Long size;
        private long currentPage;
        private Long pages;
        private Button first;
        private Button last;
        private Button next;
        private Button previous;
        private VHorizontalLayout pageBtns = new VHorizontalLayout();

        public PaginationBar(Long size) {
            this.setSize(size);
            this.initButtons();
            this.updateState();
            this.add(new Component[]{this.first, this.previous});
            ((VHorizontalLayout)this.space().withComponents(new Component[]{this.pageBtns, this.status})).space();
            this.add(new Component[]{this.next, this.last});
            this.alignAll(FlexComponent.Alignment.CENTER);
            this.withFullWidth();
        }

        private void updateState() {
            boolean hasPrev = this.currentPage > 0L;
            this.first.setEnabled(hasPrev);
            this.previous.setEnabled(hasPrev);
            if (this.sizeKnown()) {
                long end;
                boolean hasNext = this.currentPage < this.pages - 1L;
                this.last.setVisible(true);
                this.last.setEnabled(hasNext);
                this.next.setEnabled(hasNext);
                this.pageBtns.removeAll();
                if (this.pages < 10L) {
                    start = 0L;
                    end = this.pages;
                } else {
                    start = this.currentPage - 4L;
                    if (start < 0L) {
                        start = 0L;
                    }
                    if ((end = start + 9L) > this.pages) {
                        end = this.pages;
                    }
                    if (end - start < 10L) {
                        start = end - 9L;
                    }
                }
                for (long i = start; i < end; ++i) {
                    long finalI = i;
                    VButton btn = (VButton)new VButton("" + (i + 1L), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> {
                        this.currentPage = finalI;
                        this.fetchPage();
                    }).withEnabled(this.currentPage != i);
                    btn.withThemeVariants(ButtonVariant.LUMO_TERTIARY_INLINE, ButtonVariant.LUMO_SMALL);
                    this.pageBtns.add(new Component[]{btn});
                }
                this.status.setVisible(false);
                this.pageBtns.setVisible(true);
            } else {
                this.last.setEnabled(false);
                this.next.setEnabled(true);
                this.status.setVisible(true);
                this.status.setText(PagingGrid.this.statusMessage.format(new Object[]{this.currentPage + 1L, PagingGrid.this.getPageSize()}));
                this.pageBtns.setVisible(false);
            }
        }

        private void initButtons() {
            this.first = new VButton(VaadinIcon.FAST_BACKWARD.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> this.handleClick((ClickEvent<Button>)e));
            this.last = new VButton(VaadinIcon.FAST_FORWARD.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> this.handleClick((ClickEvent<Button>)e));
            this.next = new VButton(VaadinIcon.FORWARD.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> this.handleClick((ClickEvent<Button>)e));
            this.previous = new VButton(VaadinIcon.BACKWARDS.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> this.handleClick((ClickEvent<Button>)e));
        }

        private void handleClick(ClickEvent<Button> event) {
            if (event.getSource() == this.first) {
                this.currentPage = 0L;
            } else if (event.getSource() == this.last) {
                this.currentPage = this.pages - 1L;
            } else if (event.getSource() == this.next) {
                ++this.currentPage;
            } else if (event.getSource() == this.previous) {
                --this.currentPage;
            }
            this.fetchPage();
            if (PagingGrid.this.secondaryBar != null) {
                if (this == PagingGrid.this.paginationBar) {
                    PagingGrid.this.secondaryBar.currentPage = this.currentPage;
                    PagingGrid.this.secondaryBar.updateState();
                } else {
                    PagingGrid.this.paginationBar.currentPage = this.currentPage;
                    PagingGrid.this.paginationBar.updateState();
                }
            }
        }

        void fetchPage() {
            List page = PagingGrid.this.dataProvider.pageRequested(this.currentPage, PagingGrid.this.getPageSize());
            if (page.size() > 0) {
                PagingGrid.this.setItems(page);
                if (page.size() < PagingGrid.this.getPageSize()) {
                    this.setSize((long)page.size() + this.currentPage * (long)PagingGrid.this.getPageSize());
                }
            } else {
                this.setSize(this.currentPage * (long)PagingGrid.this.getPageSize());
                if (this.currentPage > 0L) {
                    --this.currentPage;
                }
            }
            this.updateState();
        }

        public long getSize() {
            return this.size;
        }

        void setSize(Long s) {
            this.size = s;
            if (this.sizeKnown()) {
                this.pages = (long)Math.ceil(1.0 * (double)this.size.longValue() / (double)PagingGrid.this.getPageSize());
            }
        }

        private boolean sizeKnown() {
            return this.size != null;
        }
    }

    public static interface PagingDataProvider<T>
    extends Serializable {
        public List<T> pageRequested(long var1, int var3);
    }
}

