/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.protocol.ProtocolCaracteristicsImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportAllCaracteristicAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ExportAllCaracteristicAction.class);
    protected File file;

    public ExportAllCaracteristicAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.saveFile(((EditProtocolUIModel)this.getModel()).getName() + "-allCaracteristics", "csv", I18n.t((String)"tutti.editProtocol.title.choose.caracteristicExportFile", (Object[])new Object[0]), I18n.t((String)"tutti.editProtocol.action.exportProtocolCaracteristicFile", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export all caracteristic to file: " + this.file));
        }
        ProtocolCaracteristicsImportExportService service = this.getContext().getProtocolCaracteristicsImportExportService();
        service.exportAllCaracteristic(this.file, ((EditProtocolUIModel)this.getModel()).getAllCaracteristic());
        this.sendMessage(I18n.t((String)"tutti.flash.info.all.caractristic.exported", (Object[])new Object[]{this.file}));
    }
}

