/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModelCache;
import fr.ifremer.tutti.util.Numbers;
import fr.ifremer.tutti.util.Weights;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class SpeciesFrequencyTableModel
extends AbstractApplicationTableModel<SpeciesFrequencyRowModel> {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> LENGTH_STEP = ColumnIdentifier.newId((String)"lengthStep", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> NUMBER = ColumnIdentifier.newId((String)"number", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> WEIGHT = ColumnIdentifier.newId((String)"weight", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> RTP_COMPUTED_WEIGHT = ColumnIdentifier.newId((String)"rtpComputedWeight", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.rtpComputedWeight", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.rtpComputedWeight", (Object[])new Object[0]));
    private final SpeciesFrequencyUIModel uiModel;
    private final SpeciesFrequencyUIModelCache modelCache;
    protected final WeightUnit weightUnit;
    protected final WeightUnit individualObservationWeightUnit;
    protected transient PropertyChangeListener onLengthStepChangedListener;
    protected transient PropertyChangeListener onWeightChangedListener;
    protected transient PropertyChangeListener onNumberChangedListener;

    public SpeciesFrequencyTableModel(WeightUnit weightUnit, WeightUnit individualObservationWeightUnit, TableColumnModelExt columnModel, SpeciesFrequencyUIModel uiModel) {
        super(columnModel, true, true);
        this.weightUnit = weightUnit;
        this.individualObservationWeightUnit = individualObservationWeightUnit;
        this.uiModel = uiModel;
        this.modelCache = uiModel.getCache();
        this.setNoneEditableCols(new ColumnIdentifier[]{RTP_COMPUTED_WEIGHT});
    }

    public boolean isCreateNewRow() {
        return this.uiModel.isCopyIndividualObservationNothing() && super.isCreateNewRow();
    }

    public SpeciesFrequencyRowModel createNewRow() {
        return this.createNewRow(true, true);
    }

    public SpeciesFrequencyRowModel createNewRow(boolean useDefaultStep, boolean attachListeners) {
        SpeciesFrequencyRowModel rowModel;
        Float lengthStep;
        Float defaultStep = null;
        int rowCount = this.getRowCount();
        if (useDefaultStep && rowCount > 0 && (lengthStep = (rowModel = (SpeciesFrequencyRowModel)this.getEntry(rowCount - 1)).getLengthStep()) != null) {
            defaultStep = Float.valueOf(this.uiModel.getLengthStep(lengthStep.floatValue() + this.uiModel.getStep().floatValue()));
        }
        SpeciesFrequencyRowModel result = new SpeciesFrequencyRowModel(this.weightUnit);
        if (attachListeners) {
            this.attachListeners(result);
        }
        result.setLengthStepCaracteristic(this.uiModel.getLengthStepCaracteristic());
        result.setLengthStep(defaultStep);
        result.setValid(defaultStep != null);
        return result;
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<SpeciesFrequencyRowModel> propertyName) {
        CopyIndividualObservationMode copyIndividualObservationMode = this.uiModel.getCopyIndividualObservationMode();
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result && copyIndividualObservationMode != null) {
            switch (copyIndividualObservationMode) {
                case ALL: {
                    result = false;
                    break;
                }
                case NOTHING: {
                    result = !WEIGHT.equals(propertyName) || !this.uiModel.isCopyRtpWeights();
                    break;
                }
                case SIZE: {
                    result = WEIGHT.equals(propertyName) && !this.uiModel.isCopyRtpWeights();
                }
            }
        }
        return result;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<SpeciesFrequencyRowModel> propertyName, SpeciesFrequencyRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, (Serializable)entry);
        this.uiModel.setModify(true);
    }

    protected void onRowAdded(int rowIndex, SpeciesFrequencyRowModel row) {
        this.uiModel.recomputeCanEditLengthStep();
        this.uiModel.setModify(true);
    }

    protected void onRowUpdated(int rowIndex, SpeciesFrequencyRowModel row) {
        this.uiModel.recomputeCanEditLengthStep();
        this.uiModel.setModify(true);
    }

    protected void onRowRemoved(int rowIndex, SpeciesFrequencyRowModel row) {
        this.dettachListeners(row);
        this.uiModel.recomputeCanEditLengthStep();
    }

    protected void onBeforeRowsChanged(List<SpeciesFrequencyRowModel> oldRows) {
        if (oldRows != null) {
            oldRows.forEach(this::dettachListeners);
        }
    }

    protected void onRowsChanged(List<SpeciesFrequencyRowModel> newRows) {
        if (newRows != null) {
            newRows.forEach(this::attachListeners);
        }
        this.uiModel.recomputeCanEditLengthStep();
    }

    public boolean recomputeCanEditLengthStep() {
        boolean result = true;
        if (this.rows != null) {
            for (SpeciesFrequencyRowModel row : this.rows) {
                if (row.isEmpty() || row.getLengthStep() == null || row.getNumber() == null) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public void decrementNumberForLengthStep(Float lengthStep) {
        SpeciesFrequencyRowModel row = this.modelCache.getRowCache().get(lengthStep);
        if (row != null) {
            Integer number = row.getNumber();
            if (number != null) {
                if (number > 1) {
                    row.setNumber(number - 1);
                } else {
                    row.setNumber(null);
                }
                int rowIndex = this.getRowIndex(row);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
            this.uiModel.recomputeCanEditLengthStep();
        }
    }

    public SpeciesFrequencyRowModel getOrCreateRowForLengthStep(float lengthstep) {
        float realLengthStep = this.uiModel.getLengthStep(lengthstep);
        Map<Float, SpeciesFrequencyRowModel> rowCache = this.modelCache.getRowCache();
        SpeciesFrequencyRowModel row = rowCache.get(Float.valueOf(realLengthStep));
        if (row == null) {
            row = this.createNewRow(false, true);
            row.setLengthStep(Float.valueOf(realLengthStep));
            rowCache.put(Float.valueOf(realLengthStep), row);
            ArrayList<Float> steps = new ArrayList<Float>(rowCache.keySet());
            steps.add(Float.valueOf(realLengthStep));
            Collections.sort(steps);
            int indexToInsert = steps.indexOf(Float.valueOf(realLengthStep));
            this.addNewRow(indexToInsert, row);
        }
        return row;
    }

    public Optional<SpeciesFrequencyRowModel> getOptionalRowForLengthStep(float lengthstep) {
        float realLengthStep = this.uiModel.getLengthStep(lengthstep);
        Map<Float, SpeciesFrequencyRowModel> rowCache = this.modelCache.getRowCache();
        SpeciesFrequencyRowModel row = rowCache.get(Float.valueOf(realLengthStep));
        return Optional.ofNullable(row);
    }

    public void incrementFrequencyRowsNumbers(float lengthStepToIncrement) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("incrementFrequencyRowsNumbers" + lengthStepToIncrement));
        }
        SpeciesFrequencyRowModel row = this.getOrCreateRowForLengthStep(lengthStepToIncrement);
        row.incNumber();
        this.updateRow(row);
    }

    public void decrementFrequencyRowsNumbers(float lengthStepToDecrement) {
        Optional<SpeciesFrequencyRowModel> optionalRow;
        if (log.isDebugEnabled()) {
            log.debug((Object)("decrementFrequencyRowsNumbers " + lengthStepToDecrement));
        }
        if ((optionalRow = this.getOptionalRowForLengthStep(lengthStepToDecrement)).isPresent()) {
            SpeciesFrequencyRowModel row = optionalRow.get();
            row.decNumber();
            if (!row.withNumber()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Remove length class " + row + " from frequencies."));
                }
                this.removeRow(row);
            } else {
                this.updateRow(row);
            }
        }
    }

    public Float convertWeightFromIndividualObservation(float weight) {
        return Float.valueOf(Weights.convert(this.uiModel.getIndividualObservationWeightUnit(), this.weightUnit, weight));
    }

    public void addWeightToFrequencyRow(float lengthStep, float weight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("add weight to frequency (lengthStep: " + lengthStep + "): " + weight));
        }
        Preconditions.checkState((!this.weightUnit.isSmallerThanZero(weight) ? 1 : 0) != 0);
        SpeciesFrequencyRowModel row = this.getOrCreateRowForLengthStep(lengthStep);
        row.addToWeight(weight);
        this.updateRow(row);
    }

    public void removeWeightToFrequencyRow(float lengthStep, float weight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove weight to frequency (lengthStep: " + lengthStep + "): " + weight));
        }
        Preconditions.checkState((!this.weightUnit.isSmallerThanZero(weight) ? 1 : 0) != 0);
        Optional<SpeciesFrequencyRowModel> optionalRow = this.getOptionalRowForLengthStep(lengthStep);
        if (optionalRow.isPresent()) {
            SpeciesFrequencyRowModel row = optionalRow.get();
            row.removeFromWeight(weight);
            this.updateRow(row);
        }
    }

    public List<SpeciesFrequencyRowModel> loadRows(List<SpeciesFrequencyRowModel> incomingRows) {
        ArrayList<SpeciesFrequencyRowModel> result = new ArrayList<SpeciesFrequencyRowModel>();
        if (CollectionUtils.isNotEmpty(incomingRows)) {
            for (SpeciesFrequencyRowModel rowModel : incomingRows) {
                SpeciesFrequencyRowModel newRow = this.createNewRow(false, false);
                newRow.copy(rowModel);
                result.add(newRow);
            }
        }
        Collections.sort(result);
        return result;
    }

    public SpeciesFrequencyRowModel addRafaleRow(float lengthStep) {
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = this.modelCache.getRowCache();
        SpeciesFrequencyRowModel row = rowsByStep.get(Float.valueOf(lengthStep));
        if (row != null) {
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            this.updateRow(row);
        } else {
            row = this.createNewRow();
            row.setLengthStep(Float.valueOf(lengthStep));
            row.setNumber(1);
            row.setValid(this.uiModel.isRowValid(row));
            ArrayList<Float> steps = new ArrayList<Float>(rowsByStep.keySet());
            steps.add(Float.valueOf(lengthStep));
            Collections.sort(steps);
            int rowIndex = steps.indexOf(Float.valueOf(lengthStep));
            this.addNewRow(rowIndex, row);
        }
        return row;
    }

    public void generateRows() {
        float minStep = this.uiModel.getLengthStep(this.uiModel.getMinStep().floatValue());
        float maxStep = this.uiModel.getLengthStep(this.uiModel.getMaxStep().floatValue());
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = this.modelCache.getRowCache();
        HashSet<Float> existingKeys = new HashSet<Float>(rowsByStep.keySet());
        ArrayList<SpeciesFrequencyRowModel> rows = new ArrayList<SpeciesFrequencyRowModel>(rowsByStep.values());
        float lengthClass = minStep;
        float step = this.uiModel.getStep().floatValue();
        while (lengthClass <= maxStep) {
            if (!existingKeys.contains(Float.valueOf(lengthClass))) {
                SpeciesFrequencyRowModel newRow = this.createNewRow(false, true);
                newRow.setLengthStep(Float.valueOf(lengthClass));
                rows.add(newRow);
            }
            lengthClass = Numbers.getRoundedLengthStep(lengthClass + step, true);
        }
        Collections.sort(rows);
        this.uiModel.setRows(rows);
    }

    public void reloadRowsFromIndividualObservations() {
        if (this.uiModel.mustCopyIndividualObservationSize()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Generate frequencies from individual observations (mode: " + (Object)((Object)this.uiModel.getCopyIndividualObservationMode()) + ")"));
            }
            boolean copyWeights = this.uiModel.isCopyIndividualObservationAll();
            this.rows.clear();
            this.uiModel.getValidIndividualObservations().stream().filter(IndividualObservationBatchRowModel::withSize).forEachOrdered(individualObservation -> {
                SpeciesFrequencyRowModel row = this.getOrCreateRowForLengthStep(individualObservation.getSize().floatValue());
                row.incNumber();
                if (copyWeights && individualObservation.withWeight()) {
                    Float weight = this.convertWeightFromIndividualObservation(individualObservation.getWeight().floatValue());
                    row.addToWeight(weight.floatValue());
                }
            });
        } else if (this.rows.isEmpty()) {
            this.addNewRow();
        }
        Collections.sort(this.rows);
        this.uiModel.reloadRows();
        this.fireTableDataChanged();
    }

    private void lengthStepWasRemoved(Float lengthStep) {
        this.uiModel.getAverageWeightsHistogramModel().removeValue(lengthStep);
        this.uiModel.getFrequenciesHistogramModel().removeValue(lengthStep);
    }

    private void lengthStepOrNumberWasUpdated(SpeciesFrequencyRowModel row) {
        if (row.withNumber()) {
            this.uiModel.getAverageWeightsHistogramModel().addOrUpdate(row);
            this.uiModel.getFrequenciesHistogramModel().addOrUpdate(row);
        }
    }

    private PropertyChangeListener getOnLengthStepChangedListener() {
        if (this.onLengthStepChangedListener == null) {
            this.onLengthStepChangedListener = evt -> {
                Float newValue;
                SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)evt.getSource();
                this.uiModel.computeRowWeightWithRtp(row);
                Float oldValue = (Float)evt.getOldValue();
                if (oldValue != null) {
                    this.modelCache.removeLengthStep(oldValue);
                    this.lengthStepWasRemoved(oldValue);
                }
                if ((newValue = (Float)evt.getNewValue()) != null) {
                    this.modelCache.addLengthStep(row);
                    this.lengthStepOrNumberWasUpdated(row);
                }
                this.uiModel.recomputeCanEditLengthStep();
                this.uiModel.recomputeRowsValidateState();
                this.uiModel.updateEmptyRow(row);
                this.uiModel.recomputeTotalNumber();
                this.uiModel.recomputeTotalWeight();
            };
        }
        return this.onLengthStepChangedListener;
    }

    private PropertyChangeListener getOnNumberChangedListener() {
        if (this.onNumberChangedListener == null) {
            this.onNumberChangedListener = evt -> {
                SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)evt.getSource();
                this.uiModel.computeRowWeightWithRtp(row);
                Float lengthStep = row.getLengthStep();
                if (lengthStep != null) {
                    if (!row.withNumber()) {
                        this.lengthStepWasRemoved(lengthStep);
                    } else {
                        this.lengthStepOrNumberWasUpdated(row);
                    }
                }
                this.uiModel.recomputeCanEditLengthStep();
                this.uiModel.recomputeRowValidState(row);
                this.uiModel.updateEmptyRow(row);
                this.uiModel.recomputeTotalNumber();
                this.uiModel.recomputeTotalWeight();
            };
        }
        return this.onNumberChangedListener;
    }

    private PropertyChangeListener getOnWeightChangedListener() {
        if (this.onWeightChangedListener == null) {
            this.onWeightChangedListener = evt -> {
                SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)evt.getSource();
                this.modelCache.updateRowWithWeight(row);
                Float lengthStep = row.getLengthStep();
                if (lengthStep != null) {
                    if (!row.withWeight()) {
                        this.uiModel.getAverageWeightsHistogramModel().removeValue(lengthStep);
                    } else {
                        this.uiModel.getAverageWeightsHistogramModel().addOrUpdate(row);
                    }
                }
                this.uiModel.recomputeRowsValidateState();
                this.uiModel.updateEmptyRow(row);
                this.uiModel.recomputeTotalWeight();
                this.uiModel.recomputeTotalNumber();
            };
        }
        return this.onWeightChangedListener;
    }

    private void dettachListeners(SpeciesFrequencyRowModel result) {
        result.removePropertyChangeListener("lengthStep", this.getOnLengthStepChangedListener());
        result.removePropertyChangeListener("weight", this.getOnWeightChangedListener());
        result.removePropertyChangeListener("number", this.getOnNumberChangedListener());
    }

    private void attachListeners(SpeciesFrequencyRowModel result) {
        this.dettachListeners(result);
        result.addPropertyChangeListener("lengthStep", this.getOnLengthStepChangedListener());
        result.addPropertyChangeListener("weight", this.getOnWeightChangedListener());
        result.addPropertyChangeListener("number", this.getOnNumberChangedListener());
    }

    private void removeRow(SpeciesFrequencyRowModel row) {
        int rowIndex = this.getRowIndex(row);
        this.removeRow(rowIndex);
        this.modelCache.getRowCache().remove(row.getLengthStep());
    }
}

