/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class SynchroDatabaseConfiguration {
    public static String IS_TARGET_DATABASE = "synchro.database.isTarget";
    public static String READ_ONLY = "synchro.database.readonly";
    public static String ENABLE_FULL_METADATA = "synchro.database.enableQueryMetadata";
    public static String IS_MIRROR_DATABASE = "synchro.database.isMirror";
    public static String KEEP_WHERE_CLAUSE_ON_QUERIES_BY_FKS = "synchro.database.keepWhereClauseOnQueriesByFks";
    public static String CHECK_UNIQUE_CONSTRAINTS_BETWEEN_INPUT_ROWS = "synchro.database.checkUniqueConstraintOverInputData";
    public static String COLUMN_EXCLUDES = "synchro.database.column.excludes";
    public static String TABLE_INCLUDES = "synchro.database.table.includes";
    public static String SYSTEM_TIMESTAMP = "synchro.database.systimestamp";
    public static String COLUMN_ID = "synchro.database.column.id";
    public static String COLUMN_UPDATE_DATE = "synchro.database.column.updateDate";
    public static String SEQUENCE_SUFFIX = "synchro.database.sequence.suffix";
    public static String MAX_SQL_NAME_LENGTH = "synchro.database.maxSqlNameLength";
    public static String DIALECT = "hibernate.dialect";
    public static String DRIVER = "hibernate.connection.driver_class";
    public static String URL = "hibernate.connection.url";
    public static String USER = "hibernate.connection.username";
    public static String PASS = "hibernate.connection.password";
    private Properties properties;
    private Dialect dialect;
    private String columnUpdateDate;
    private String columnId;
    private String sequenceSuffix;
    private int maxSqlNameLength;

    public SynchroDatabaseConfiguration(SynchroConfiguration config, Properties settings, boolean isTarget) {
        this.properties = settings;
        this.setIsTarget(isTarget);
        this.setReadOnly(!isTarget);
        this.reloadCachedFields(config);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public SynchroDatabaseConfiguration setProperties(Properties properties) {
        boolean savedIsTarget = this.isTarget();
        this.properties = properties;
        this.setIsTarget(savedIsTarget);
        this.reloadCachedFields(SynchroConfiguration.getInstance());
        return this;
    }

    private void reloadCachedFields(SynchroConfiguration config) {
        this.dialect = Dialect.getDialect((Properties)this.properties);
        this.columnId = ConfigurationHelper.getString((String)COLUMN_ID, (Map)this.properties, (String)config.getColumnId());
        this.columnUpdateDate = ConfigurationHelper.getString((String)COLUMN_UPDATE_DATE, (Map)this.properties, (String)config.getColumnUpdateDate());
        this.sequenceSuffix = ConfigurationHelper.getString((String)SEQUENCE_SUFFIX, (Map)this.properties, (String)config.getSequenceSuffix());
        this.maxSqlNameLength = ConfigurationHelper.getInt((String)MAX_SQL_NAME_LENGTH, (Map)this.properties, (int)config.getMaxSqlNameLength());
    }

    public String getJdbcSchema() {
        return ConfigurationHelper.getString((String)"hibernate.default_schema", (Map)this.properties);
    }

    public String getJdbcCatalog() {
        return ConfigurationHelper.getString((String)"hibernate.default_catalog", (Map)this.properties);
    }

    public String getJdbcUser() {
        return ConfigurationHelper.getString((String)"hibernate.connection.username", (Map)this.properties);
    }

    public SynchroDatabaseConfiguration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public SynchroDatabaseConfiguration setColumnId(String columnName) {
        this.columnId = columnName;
        this.setProperty(COLUMN_ID, columnName);
        return this;
    }

    public String getColumnUpdateDate() {
        return this.columnUpdateDate;
    }

    public SynchroDatabaseConfiguration setColumnUpdateDate(String columnName) {
        this.columnUpdateDate = columnName;
        this.setProperty(COLUMN_UPDATE_DATE, columnName);
        return this;
    }

    public String getSequenceSuffix() {
        return this.sequenceSuffix;
    }

    public SynchroDatabaseConfiguration setSequenceSuffix(String sequenceSuffix) {
        this.sequenceSuffix = sequenceSuffix;
        this.setProperty(SEQUENCE_SUFFIX, sequenceSuffix);
        return this;
    }

    public int getMaxSqlNameLength() {
        return this.maxSqlNameLength;
    }

    public SynchroDatabaseConfiguration setMaxSqlNameLength(int maxSqlNameLength) {
        this.maxSqlNameLength = maxSqlNameLength;
        this.setProperty(MAX_SQL_NAME_LENGTH, Integer.toString(maxSqlNameLength));
        return this;
    }

    public String getUrl() {
        return this.getProperty(URL);
    }

    public String getUser() {
        return this.getProperty(USER);
    }

    public String getPassword() {
        return this.getProperty(PASS);
    }

    public String getSchema() {
        return this.getProperty("hibernate.default_schema");
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean isTarget() {
        return ConfigurationHelper.getBoolean((String)IS_TARGET_DATABASE, (Map)this.getProperties(), (boolean)false);
    }

    public boolean isSource() {
        return !this.isTarget();
    }

    public SynchroDatabaseConfiguration setIsTarget(boolean isTarget) {
        this.setProperty(IS_TARGET_DATABASE, Boolean.toString(isTarget));
        return this;
    }

    public SynchroDatabaseConfiguration setReadOnly(boolean readonly) {
        this.setProperty(READ_ONLY, Boolean.toString(readonly));
        return this;
    }

    public boolean isReadOnly() {
        return ConfigurationHelper.getBoolean((String)READ_ONLY, (Map)this.getProperties(), (boolean)false);
    }

    public void setSystemTimestamp(Timestamp systimestamp) {
        if (systimestamp == null) {
            this.properties.remove(SYSTEM_TIMESTAMP);
            return;
        }
        long timeInNanos = systimestamp.getTime() / 1000L * 1000000000L + (long)systimestamp.getNanos();
        this.setProperty(SYSTEM_TIMESTAMP, Long.toString(timeInNanos));
    }

    public Timestamp getSystemTimestamp() {
        Long timeInNanos = ConfigurationHelper.getLong((String)SYSTEM_TIMESTAMP, (Map)this.getProperties(), (int)-1);
        if (timeInNanos == -1L) {
            return null;
        }
        long time = timeInNanos / 1000000000L * 1000L;
        int nanos = (int)(timeInNanos % 1000000000L);
        Timestamp result = new Timestamp(time);
        result.setNanos(nanos);
        return result;
    }

    public boolean isFullMetadataEnable() {
        return ConfigurationHelper.getBoolean((String)ENABLE_FULL_METADATA, (Map)this.getProperties(), (boolean)this.isTarget());
    }

    public void setFullMetadataEnable(boolean enable) {
        this.setProperty(ENABLE_FULL_METADATA, Boolean.toString(enable));
    }

    public boolean isMirrorDatabase() {
        return ConfigurationHelper.getBoolean((String)IS_MIRROR_DATABASE, (Map)this.getProperties(), (boolean)this.isTarget());
    }

    public void setIsMirrorDatabase(boolean isMirror) {
        this.setProperty(IS_MIRROR_DATABASE, Boolean.toString(isMirror));
    }

    public boolean isKeepWhereClauseOnQueriesByFks() {
        return ConfigurationHelper.getBoolean((String)KEEP_WHERE_CLAUSE_ON_QUERIES_BY_FKS, (Map)this.getProperties(), (boolean)true);
    }

    public void setKeepWhereClauseOnQueriesByFks(boolean keepWhereClauseOnQueriesByFks) {
        this.setProperty(KEEP_WHERE_CLAUSE_ON_QUERIES_BY_FKS, Boolean.toString(keepWhereClauseOnQueriesByFks));
    }

    public boolean isCheckUniqueConstraintBetweenInputRows() {
        return ConfigurationHelper.getBoolean((String)CHECK_UNIQUE_CONSTRAINTS_BETWEEN_INPUT_ROWS, (Map)this.getProperties(), (boolean)true);
    }

    public void setCheckUniqueConstraintBetweenInputRows(boolean checkUniqueConstraintOverInputData) {
        this.setProperty(CHECK_UNIQUE_CONSTRAINTS_BETWEEN_INPUT_ROWS, Boolean.toString(checkUniqueConstraintOverInputData));
    }

    public String getColumnExcludes() {
        return ConfigurationHelper.getString((String)COLUMN_EXCLUDES, (Map)this.getProperties(), null);
    }

    public Set<String> getColumnExcludesAsSet() {
        String columnExcludesProperty = this.getColumnExcludes();
        if (StringUtils.isBlank((CharSequence)columnExcludesProperty)) {
            return null;
        }
        HashSet columnExcludes = Sets.newHashSet(Arrays.asList(columnExcludesProperty.split(",")));
        return columnExcludes;
    }

    public SynchroDatabaseConfiguration addColumnExclude(String tableName, String columnName) {
        Preconditions.checkNotNull((Object)this.getProperties());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tableName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)columnName));
        String excludesProperty = this.getProperty(COLUMN_EXCLUDES);
        HashSet excludes = Sets.newHashSet();
        if (excludesProperty != null) {
            excludes.addAll(Arrays.asList(excludesProperty.split(",")));
        }
        excludes.add(tableName.toLowerCase() + "." + columnName.toLowerCase());
        excludesProperty = Joiner.on((char)',').join((Iterable)excludes);
        this.setProperty(COLUMN_EXCLUDES, excludesProperty);
        return this;
    }

    public SynchroDatabaseConfiguration addColumnExclude(String columnName) {
        return this.addColumnExclude("%", columnName);
    }

    public SynchroDatabaseConfiguration addColumnExcludes(Set<String> columnExcludes) {
        Preconditions.checkNotNull((Object)this.getProperties());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnExcludes));
        String excludesProperty = this.getProperty(COLUMN_EXCLUDES);
        HashSet excludes = Sets.newHashSet();
        if (excludesProperty != null) {
            excludes.addAll(Splitter.on((char)',').trimResults().splitToList((CharSequence)excludesProperty));
        }
        for (String exclude : columnExcludes) {
            excludes.add(exclude.toLowerCase());
        }
        excludesProperty = Joiner.on((char)',').join((Iterable)excludes);
        this.setProperty(COLUMN_EXCLUDES, excludesProperty);
        return this;
    }

    public SynchroDatabaseConfiguration removeColumnExclude(String columnName) {
        return this.removeColumnExclude("%", columnName);
    }

    public SynchroDatabaseConfiguration removeColumnExclude(String tableName, String columnName) {
        Preconditions.checkNotNull((Object)this.getProperties());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tableName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)columnName));
        String excludesProperty = this.getProperty(COLUMN_EXCLUDES);
        HashSet excludes = Sets.newHashSet();
        if (excludesProperty != null) {
            excludes.addAll(Arrays.asList(excludesProperty.split(",")));
        }
        excludes.remove(tableName.toLowerCase() + "." + columnName.toLowerCase());
        excludesProperty = Joiner.on((char)',').join((Iterable)excludes);
        this.setProperty(COLUMN_EXCLUDES, excludesProperty);
        return this;
    }

    protected boolean getPropertyAsBoolean(String key, boolean defaultValue) {
        String property = this.getProperty(key);
        if (StringUtils.isBlank((CharSequence)property)) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(property);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isTarget()) {
            sb.append("Target ");
        } else {
            sb.append("Source ");
        }
        sb.append("database configuration:");
        sb.append("\n    JDBC URL: ").append(this.getUrl());
        sb.append("\n    JDBC User: ").append(this.getUser());
        sb.append("\n    JDBC Schema: ").append(this.getSchema());
        sb.append("\n    readOnly: ").append(this.isReadOnly());
        sb.append("\n    enableFullMetadata: ").append(this.isFullMetadataEnable());
        sb.append("\n    is mirror: ").append(this.isMirrorDatabase());
        sb.append("\n    check unique constraint between input data: ").append(this.isCheckUniqueConstraintBetweenInputRows());
        String columnExcludes = this.getColumnExcludes();
        sb.append("\n    excludes columns: ");
        if (StringUtils.isNotBlank((CharSequence)columnExcludes)) {
            sb.append(columnExcludes);
        }
        return sb.toString();
    }
}

