/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferentialImportRequest<E extends TuttiReferentialEntity, K> {
    private final List<E> toAdd = Lists.newArrayList();
    private final List<E> toUpdate = Lists.newArrayList();
    private final List<E> toLink = Lists.newArrayList();
    private final List<K> toDelete = Lists.newArrayList();
    private final Map<K, E> existingEntitiesById;
    private final Set<String> existingNaturalIds;
    private final Set<K> newIds;
    private final Set<String> newNaturalIds;
    private final Function<E, K> entityToIdFunction;

    public ReferentialImportRequest(List<E> existingEntities, Function<E, K> entityToIdFunction, Function<E, String> naturalIdFunction) {
        this.entityToIdFunction = entityToIdFunction;
        this.existingEntitiesById = Maps.uniqueIndex(existingEntities, entityToIdFunction);
        this.existingNaturalIds = Sets.newHashSet((Iterable)existingEntities.stream().map(arg_0 -> naturalIdFunction.apply(arg_0)).collect(Collectors.toList()));
        this.newIds = new HashSet<K>();
        this.newNaturalIds = new HashSet<String>();
    }

    public void addEntityToAdd(E entityToAdd) {
        this.toAdd.add(entityToAdd);
        Object id = this.entityToIdFunction.apply(entityToAdd);
        this.newIds.add(id);
    }

    public void addEntityToUpdate(E entityToUpdate) {
        this.toUpdate.add(entityToUpdate);
    }

    public void addEntityToLink(E entityToLink) {
        this.toLink.add(entityToLink);
    }

    public void addIdToDelete(K entityToDelete) {
        this.toDelete.add(entityToDelete);
    }

    public boolean withEntitiesToAdd() {
        return !this.toAdd.isEmpty();
    }

    public boolean withEntitiesToUpdate() {
        return !this.toUpdate.isEmpty();
    }

    public boolean withEntitiesToLink() {
        return !this.toLink.isEmpty();
    }

    public boolean withEntitiesToDelete() {
        return !this.toDelete.isEmpty();
    }

    public List<K> getIdsToDelete() {
        return Lists.newArrayList(this.toDelete);
    }

    public List<E> getEntitiesToAdd() {
        return Lists.newArrayList(this.toAdd);
    }

    public List<E> getEntitiesToUpdate() {
        return Lists.newArrayList(this.toUpdate);
    }

    public List<E> getEntitiesToLink() {
        return Lists.newArrayList(this.toLink);
    }

    public E getExistingEntityById(K id) {
        return (E)((TuttiReferentialEntity)this.existingEntitiesById.get(id));
    }

    public boolean addExistingNaturalId(String naturalId) {
        boolean added = this.existingNaturalIds.add(naturalId);
        if (added) {
            this.newNaturalIds.add(naturalId);
        }
        return added;
    }

    public boolean isNaturalIdAlreadyAdded(String naturalId) {
        return this.newNaturalIds.contains(naturalId);
    }

    public boolean isIdAlreadyAdded(K id) {
        return this.newIds.contains(id);
    }

    public void removeExistingNaturalId(String naturalId) {
        this.existingNaturalIds.remove(naturalId);
    }

    public Function<E, K> getEntityToIdFunction() {
        return this.entityToIdFunction;
    }
}

