/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.MarineLitterBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.util.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.tree.BatchTreeHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service(value="marineLitterBatchPersistenceService")
public class MarineLitterBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements MarineLitterBatchPersistenceService {
    private static final Log log = LogFactory.getLog(MarineLitterBatchPersistenceServiceImpl.class);
    @Resource(name="caracteristicPersistenceService")
    private CaracteristicPersistenceService caracteristicService;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="batchTreeHelper")
    protected BatchTreeHelper batchTreeHelper;
    protected Integer marineLitterCategory;
    protected Integer marineLitterSizeCategory;
    protected Map<Integer, CaracteristicQualitativeValue> marineLitterCategoryCaracteristicValues;
    protected Map<Integer, CaracteristicQualitativeValue> marineLitterSizeCategoryCaracteristicValues;

    @Override
    public void init() {
        super.init();
        Caracteristic marineLitterCategoryCaracteristic = this.caracteristicService.getMarineLitterCategoryCaracteristic();
        this.marineLitterCategory = marineLitterCategoryCaracteristic.getIdAsInt();
        this.marineLitterCategoryCaracteristicValues = TuttiEntities.splitByIdAsInt(marineLitterCategoryCaracteristic.getQualitativeValue());
        Caracteristic marineLitterSizeCategoryCaracteristic = this.caracteristicService.getMarineLitterSizeCategoryCaracteristic();
        this.marineLitterSizeCategory = marineLitterSizeCategoryCaracteristic.getIdAsInt();
        this.marineLitterSizeCategoryCaracteristicValues = TuttiEntities.splitByIdAsInt(marineLitterSizeCategoryCaracteristic.getQualitativeValue());
    }

    @Override
    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch(Integer fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        SortingBatch sortingBatch = this.batchTreeHelper.getMarineLitterRootBatch(catchBatch);
        BatchContainer<MarineLitterBatch> result = new BatchContainer<MarineLitterBatch>();
        if (sortingBatch != null) {
            result.setId(sortingBatch.getId());
            for (Batch batch1 : sortingBatch.getChildBatchs()) {
                SortingBatch source = (SortingBatch)batch1;
                MarineLitterBatch target = MarineLitterBatchs.newMarineLitterBatch();
                this.entityToBean(source, target);
                result.addChildren(target);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded CatchBatch Hors Vrac > MarineLetter > " + target.getMarineLitterCategory().getName() + " / " + target.getMarineLitterSizeCategory().getName() + ": " + target.getId()));
            }
        }
        return result;
    }

    @Override
    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(bean.getFishingOperation().getIdAsInt(), false);
        return this.createMarineLitterBatch(catchBatch, bean);
    }

    @Override
    public Collection<MarineLitterBatch> createMarineLitterBatches(Integer fishingOperationId, Collection<MarineLitterBatch> beans) {
        Preconditions.checkNotNull(beans);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        ArrayList<MarineLitterBatch> result = new ArrayList<MarineLitterBatch>(beans.size());
        for (MarineLitterBatch bean : beans) {
            MarineLitterBatch created = this.createMarineLitterBatch(catchBatch, bean);
            result.add(created);
        }
        return result;
    }

    protected MarineLitterBatch createMarineLitterBatch(CatchBatch catchBatch, MarineLitterBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getMarineLitterCategory());
        Preconditions.checkNotNull((Object)bean.getMarineLitterSizeCategory());
        Preconditions.checkNotNull((Object)bean.getNumber());
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.beanToEntity(bean, batch, catchBatch);
        return this.batchHelper.createSortingBatch(bean, catchBatch, batch);
    }

    @Override
    public MarineLitterBatch saveMarineLitterBatch(MarineLitterBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Integer batchId = bean.getIdAsInt();
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(batchId);
        SortingBatch batch = this.batchHelper.getSortingBatchById(catchBatch, batchId);
        this.beanToEntity(bean, batch, catchBatch);
        this.batchHelper.updateSortingBatch(batch, catchBatch);
        return bean;
    }

    @Override
    public void deleteMarineLitterBatch(Integer id) {
        Preconditions.checkNotNull((Object)id);
        this.batchHelper.deleteBatch(id);
    }

    public MarineLitterBatch entityToBean(SortingBatch source, MarineLitterBatch target) {
        target.setId(source.getId().toString());
        target.setRankOrder((int)source.getRankOrder());
        target.setNumber(source.getIndividualCount());
        target.setWeight(source.getWeight());
        target.setComment(source.getComments());
        for (SortingMeasurement measurement : source.getSortingMeasurements()) {
            CaracteristicQualitativeValue value;
            Integer id;
            QualitativeValue qualitativeValue;
            Integer pmfmId = measurement.getPmfm().getId();
            if (this.marineLitterCategory.equals(pmfmId)) {
                qualitativeValue = measurement.getQualitativeValue();
                id = qualitativeValue.getId();
                value = this.marineLitterCategoryCaracteristicValues.get(id);
                target.setMarineLitterCategory(value);
                continue;
            }
            if (!this.marineLitterSizeCategory.equals(pmfmId)) continue;
            qualitativeValue = measurement.getQualitativeValue();
            id = qualitativeValue.getId();
            value = this.marineLitterSizeCategoryCaracteristicValues.get(id);
            target.setMarineLitterSizeCategory(value);
        }
        return target;
    }

    protected void beanToEntity(MarineLitterBatch source, SortingBatch target, CatchBatch catchBatch) {
        SortingMeasurement measurement;
        if (target.getId() == null || target.getRootBatch() == null) {
            this.setMarineLitterBatchParents(target, catchBatch);
        }
        if (target.getRankOrder() == null) {
            short rankOrder = this.batchHelper.computeRankOrder(target);
            target.setRankOrder(Short.valueOf(rankOrder));
        }
        target.setSubgroupCount(Float.valueOf(1.0f));
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (source.getMarineLitterCategory() != null) {
            measurement = this.measurementPersistenceHelper.setSortingMeasurement(target, this.marineLitterCategory, source.getMarineLitterCategory().getIdAsInt());
            notChangedSortingMeasurements.remove(measurement);
        }
        if (source.getMarineLitterSizeCategory() != null) {
            measurement = this.measurementPersistenceHelper.setSortingMeasurement(target, this.marineLitterSizeCategory, source.getMarineLitterSizeCategory().getIdAsInt());
            notChangedSortingMeasurements.remove(measurement);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
        this.batchTreeHelper.setWeightAndSampleRatio(target, source.getWeight(), null);
        target.setIndividualCount(source.getNumber());
        QualityFlagImpl qualityFlag = this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue()));
        target.setQualityFlag((QualityFlag)qualityFlag);
        target.setComments(source.getComment());
        target.setExhaustiveInventory(Boolean.valueOf(true));
    }

    private void setMarineLitterBatchParents(SortingBatch target, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)target);
        SortingBatch parentBatch = this.batchTreeHelper.getMarineLitterRootBatch(catchBatch);
        if (parentBatch == null) {
            SortingBatch horsVracBatch = this.batchTreeHelper.getOrCreateHorsVracBatch(catchBatch);
            parentBatch = this.batchTreeHelper.getOrCreateMarineLitterRootBatch(catchBatch, horsVracBatch, null);
        }
        target.setParentBatch((Batch)parentBatch);
        target.setRootBatch(catchBatch);
    }
}

