/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute.impl;

import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public class BoundsImpl
extends EObjectImpl
implements Bounds {
    protected static final double LEFT_EDEFAULT = 0.0;
    protected double left = 0.0;
    protected boolean leftESet;
    protected static final double TOP_EDEFAULT = 0.0;
    protected double top = 0.0;
    protected boolean topESet;
    protected static final double WIDTH_EDEFAULT = 0.0;
    protected double width = 0.0;
    protected boolean widthESet;
    protected static final double HEIGHT_EDEFAULT = 0.0;
    protected double height = 0.0;
    protected boolean heightESet;

    protected BoundsImpl() {
    }

    protected EClass eStaticClass() {
        return AttributePackage.Literals.BOUNDS;
    }

    @Override
    public double getLeft() {
        return this.left;
    }

    @Override
    public void setLeft(double newLeft) {
        double oldLeft = this.left;
        this.left = newLeft;
        boolean oldLeftESet = this.leftESet;
        this.leftESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldLeft, this.left, !oldLeftESet));
        }
    }

    @Override
    public void unsetLeft() {
        double oldLeft = this.left;
        boolean oldLeftESet = this.leftESet;
        this.left = 0.0;
        this.leftESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 0, oldLeft, 0.0, oldLeftESet));
        }
    }

    @Override
    public boolean isSetLeft() {
        return this.leftESet;
    }

    @Override
    public double getTop() {
        return this.top;
    }

    @Override
    public void setTop(double newTop) {
        double oldTop = this.top;
        this.top = newTop;
        boolean oldTopESet = this.topESet;
        this.topESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldTop, this.top, !oldTopESet));
        }
    }

    @Override
    public void unsetTop() {
        double oldTop = this.top;
        boolean oldTopESet = this.topESet;
        this.top = 0.0;
        this.topESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 1, oldTop, 0.0, oldTopESet));
        }
    }

    @Override
    public boolean isSetTop() {
        return this.topESet;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(double newWidth) {
        double oldWidth = this.width;
        this.width = newWidth;
        boolean oldWidthESet = this.widthESet;
        this.widthESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldWidth, this.width, !oldWidthESet));
        }
    }

    @Override
    public void unsetWidth() {
        double oldWidth = this.width;
        boolean oldWidthESet = this.widthESet;
        this.width = 0.0;
        this.widthESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 2, oldWidth, 0.0, oldWidthESet));
        }
    }

    @Override
    public boolean isSetWidth() {
        return this.widthESet;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double newHeight) {
        double oldHeight = this.height;
        this.height = newHeight;
        boolean oldHeightESet = this.heightESet;
        this.heightESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldHeight, this.height, !oldHeightESet));
        }
    }

    @Override
    public void unsetHeight() {
        double oldHeight = this.height;
        boolean oldHeightESet = this.heightESet;
        this.height = 0.0;
        this.heightESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 3, oldHeight, 0.0, oldHeightESet));
        }
    }

    @Override
    public boolean isSetHeight() {
        return this.heightESet;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getLeft();
            }
            case 1: {
                return this.getTop();
            }
            case 2: {
                return this.getWidth();
            }
            case 3: {
                return this.getHeight();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLeft((Double)newValue);
                return;
            }
            case 1: {
                this.setTop((Double)newValue);
                return;
            }
            case 2: {
                this.setWidth((Double)newValue);
                return;
            }
            case 3: {
                this.setHeight((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.unsetLeft();
                return;
            }
            case 1: {
                this.unsetTop();
                return;
            }
            case 2: {
                this.unsetWidth();
                return;
            }
            case 3: {
                this.unsetHeight();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetLeft();
            }
            case 1: {
                return this.isSetTop();
            }
            case 2: {
                return this.isSetWidth();
            }
            case 3: {
                return this.isSetHeight();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (left: ");
        if (this.leftESet) {
            result.append(this.left);
        } else {
            result.append("<unset>");
        }
        result.append(", top: ");
        if (this.topESet) {
            result.append(this.top);
        } else {
            result.append("<unset>");
        }
        result.append(", width: ");
        if (this.widthESet) {
            result.append(this.width);
        } else {
            result.append("<unset>");
        }
        result.append(", height: ");
        if (this.heightESet) {
            result.append(this.height);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    protected void set(Bounds src) {
        this.left = src.getLeft();
        this.leftESet = src.isSetLeft();
        this.top = src.getTop();
        this.topESet = src.isSetTop();
        this.width = src.getWidth();
        this.widthESet = src.isSetWidth();
        this.height = src.getHeight();
        this.heightESet = src.isSetHeight();
    }

    @Override
    public void set(double dLeft, double dTop, double dWidth, double dHeight) {
        this.left = dLeft;
        this.leftESet = true;
        this.top = dTop;
        this.topESet = true;
        this.width = dWidth;
        this.widthESet = true;
        this.height = dHeight;
        this.heightESet = true;
    }

    public static final Bounds create(double dLeft, double dTop, double dWidth, double dHeight) {
        BoundsImpl bo = new BoundsImpl();
        bo.left = dLeft;
        bo.leftESet = true;
        bo.top = dTop;
        bo.topESet = true;
        bo.width = dWidth;
        bo.widthESet = true;
        bo.height = dHeight;
        bo.heightESet = true;
        return bo;
    }

    public static final Bounds createDefault(double dLeft, double dTop, double dWidth, double dHeight) {
        BoundsImpl bo = new BoundsImpl();
        bo.left = dLeft;
        bo.top = dTop;
        bo.width = dWidth;
        bo.height = dHeight;
        return bo;
    }

    @Override
    public final Bounds adjustedInstance(Insets ins) {
        Bounds bo = this.copyInstance();
        bo.adjust(ins);
        return bo;
    }

    @Override
    public final Bounds translateInstance(double dTranslateX, double dTranslateY) {
        return BoundsImpl.create(this.getLeft() + dTranslateX, this.getTop() + dTranslateY, this.getWidth(), this.getHeight());
    }

    @Override
    public final void delta(double dLeft, double dTop, double dWidth, double dHeight) {
        this.setLeft(this.getLeft() + dLeft);
        this.setTop(this.getTop() + dTop);
        this.setWidth(this.getWidth() + dWidth);
        this.setHeight(this.getHeight() + dHeight);
    }

    @Override
    public final void translate(double dTranslateX, double dTranslateY) {
        this.setLeft(this.getLeft() + dTranslateX);
        this.setTop(this.getTop() + dTranslateY);
    }

    @Override
    public final void scale(double dScale) {
        this.setLeft(this.getLeft() * dScale);
        this.setTop(this.getTop() * dScale);
        this.setWidth(this.getWidth() * dScale);
        this.setHeight(this.getHeight() * dScale);
    }

    @Override
    public final Bounds scaledInstance(double dScale) {
        Bounds bo = this.copyInstance();
        bo.scale(dScale);
        return bo;
    }

    @Override
    public void adjust(Insets ins) {
        double dDeltaWidth = ins.getLeft() + ins.getRight();
        double dDeltaHeight = ins.getTop() + ins.getBottom();
        double dNewLeft = this.left + ins.getLeft();
        double dNewTop = this.top + ins.getTop();
        double dNewWidth = this.width - dDeltaWidth;
        double dNewHeight = this.height - dDeltaHeight;
        if (this.width - dDeltaWidth < 0.0) {
            dNewWidth = 0.0;
            dNewLeft = this.left + ins.getLeft() * Math.abs(this.width / dDeltaWidth);
        }
        if (this.height - dDeltaHeight < 0.0) {
            dNewHeight = 0.0;
            dNewTop = this.top + ins.getTop() * Math.abs(this.height / dDeltaHeight);
        }
        this.set(dNewLeft, dNewTop, dNewWidth, dNewHeight);
    }

    @Override
    public void updateFrom(Location[] loa) {
        if (loa == null) {
            return;
        }
        double dXMin = 0.0;
        double dXMax = 0.0;
        double dYMin = 0.0;
        double dYMax = 0.0;
        int i = 0;
        while (i < loa.length) {
            if (i == 0) {
                dXMin = loa[i].getX();
                dXMax = loa[i].getX();
                dYMin = loa[i].getY();
                dYMax = loa[i].getY();
            } else {
                dXMin = Math.min(loa[i].getX(), dXMin);
                dYMin = Math.min(loa[i].getY(), dYMin);
                dXMax = Math.max(loa[i].getX(), dXMax);
                dYMax = Math.max(loa[i].getY(), dYMax);
            }
            ++i;
        }
        this.set(dXMin, dYMin, dXMax - dXMin, dYMax - dYMin);
    }

    @Override
    public final void max(Bounds bo) {
        double dXMin = this.getLeft();
        double dXMax = this.getLeft() + this.getWidth();
        double dYMin = this.getTop();
        double dYMax = this.getTop() + this.getHeight();
        if (dXMin > bo.getLeft()) {
            dXMin = bo.getLeft();
        }
        if (dXMax < bo.getLeft() + this.getWidth()) {
            dXMax = bo.getLeft() + bo.getWidth();
        }
        if (dYMin > bo.getTop()) {
            dYMin = bo.getTop();
        }
        if (dYMax < bo.getTop() + bo.getHeight()) {
            dYMax = bo.getTop() + bo.getHeight();
        }
        this.setLeft(dXMin);
        this.setWidth(dXMax - dXMin);
        this.setTop(dYMin);
        this.setHeight(dYMax - dYMin);
    }

    @Override
    public boolean contains(Location lo) {
        double w = this.getWidth();
        double h = this.getHeight();
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        double x = this.getLeft();
        double y = this.getTop();
        if (lo.getX() < x || lo.getY() < y) {
            return false;
        }
        return ((w += x) < x || w > lo.getX()) && ((h += y) < y || h > lo.getY());
    }

    @Override
    public Bounds copyInstance() {
        BoundsImpl dest = new BoundsImpl();
        dest.left = this.getLeft();
        dest.leftESet = this.isSetLeft();
        dest.top = this.getTop();
        dest.topESet = this.isSetTop();
        dest.width = this.getWidth();
        dest.widthESet = this.isSetWidth();
        dest.height = this.getHeight();
        dest.heightESet = this.isSetHeight();
        return dest;
    }
}

