/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.toconfirmreport;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCache;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCaches;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PdfGeneratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.export.toconfirmreport.ToConfirmReportBatchEntryBean;
import fr.ifremer.tutti.service.export.toconfirmreport.ToConfirmReportBean;
import fr.ifremer.tutti.service.export.toconfirmreport.ToConfirmReportFishingOperationBean;
import fr.ifremer.tutti.service.export.toconfirmreport.ToConfirmReportFishingOperationData;
import fr.ifremer.tutti.type.WeightUnit;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ToConfirmReportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ToConfirmReportService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected PdfGeneratorService pdfGeneratorService;
    protected WeightComputingService weightComputingService;
    protected WeightUnit speciesWeightUnit;
    protected WeightUnit benthosWeightUnit;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.pdfGeneratorService = this.getService(PdfGeneratorService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
        this.speciesWeightUnit = context.getConfig().getSpeciesWeightUnit();
        this.benthosWeightUnit = context.getConfig().getBenthosWeightUnit();
    }

    public int getNumberOfSteps(Integer cruiseId) {
        List<Integer> allFishingOperation = this.persistenceService.getAllFishingOperationIds(cruiseId);
        return allFishingOperation.size() + 3;
    }

    public void createToConfirmReport(File file, Integer cruiseId, ProgressionModel progressionModel) {
        progressionModel.increments(I18n.t((String)"tutti.toconfirmReport.loading.cruise", (Object[])new Object[]{cruiseId}));
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cruise " + this.decoratorService.getDecorator(cruise).toString((Object)cruise)));
        }
        progressionModel.increments(I18n.t((String)"tutti.toconfirmReport.loading.protocol", (Object[])new Object[0]));
        TuttiProtocol protocol = this.context.getDataContext().getProtocol();
        TaxonCache speciesCache = TaxonCaches.createSpeciesCache((TuttiPersistence)this.persistenceService, (TuttiProtocol)protocol);
        TaxonCache benthosCache = TaxonCaches.createBenthosCache((TuttiPersistence)this.persistenceService, (TuttiProtocol)protocol);
        List<Integer> allFishingOperation = this.persistenceService.getAllFishingOperationIds(cruiseId);
        ToConfirmReportBean reportBean = new ToConfirmReportBean(cruise, this.speciesWeightUnit, this.benthosWeightUnit);
        int currentOperation = 1;
        int nbOperations = allFishingOperation.size();
        for (Integer operationId : allFishingOperation) {
            progressionModel.increments(I18n.t((String)"tutti.toconfirmReport.loading.operation", (Object[])new Object[]{operationId, currentOperation++, nbOperations}));
            ToConfirmReportFishingOperationData fishingOperationData = ToConfirmReportFishingOperationData.create(this.persistenceService, operationId);
            if (fishingOperationData == null) continue;
            ToConfirmReportFishingOperationBean operationBean = this.createOperationBean(fishingOperationData, speciesCache, benthosCache);
            reportBean.addOperation(operationBean);
        }
        progressionModel.increments(I18n.t((String)"tutti.toconfirmReport.generate.report", (Object[])new Object[0]));
        this.generatePdf(file, reportBean);
    }

    protected ToConfirmReportFishingOperationBean createOperationBean(ToConfirmReportFishingOperationData fishingOperationData, TaxonCache speciesCache, TaxonCache benthosCache) {
        List<ToConfirmReportBatchEntryBean> benthosCatchList;
        List<ToConfirmReportBatchEntryBean> speciesCatchList;
        if (fishingOperationData.isWithSpeciesBatchToConfirm()) {
            List<SpeciesBatch> speciesBatchEntries = fishingOperationData.getSpeciesBatchToConfirm();
            speciesCache.loadInBatches(speciesBatchEntries);
            speciesCatchList = this.createBatchBeans(this.speciesWeightUnit, speciesBatchEntries);
        } else {
            speciesCatchList = null;
        }
        if (fishingOperationData.isWithBenthosBatchToConfirm()) {
            List<SpeciesBatch> benthosBatchEntries = fishingOperationData.getBenthosBatchToConfirm();
            benthosCache.loadInBatches(benthosBatchEntries);
            benthosCatchList = this.createBatchBeans(this.benthosWeightUnit, benthosBatchEntries);
        } else {
            benthosCatchList = null;
        }
        return new ToConfirmReportFishingOperationBean(fishingOperationData.getFishingOperation(), speciesCatchList, benthosCatchList);
    }

    protected List<ToConfirmReportBatchEntryBean> createBatchBeans(WeightUnit weightUnit, List<SpeciesBatch> batchEntries) {
        ArrayList<ToConfirmReportBatchEntryBean> catchList = new ArrayList<ToConfirmReportBatchEntryBean>();
        for (SpeciesBatch batch : batchEntries) {
            Species species = batch.getSpecies();
            Float sampleCategoryWeightValue = weightUnit.fromEntity(batch.getSampleCategoryWeight());
            String sampleCategoryWeight = weightUnit.renderWeight(sampleCategoryWeightValue);
            Float weightValue = weightUnit.fromEntity(batch.getWeight());
            String weight = weightUnit.renderWeight(weightValue);
            String comment = batch.getComment();
            String category = this.getBatchDecoratedSampleCategoryValue(batch);
            while (batch.getParentBatch() != null) {
                batch = batch.getParentBatch();
                category = this.getBatchDecoratedSampleCategoryValue(batch) + " / " + category;
            }
            ToConfirmReportBatchEntryBean reportEntry = new ToConfirmReportBatchEntryBean(species, category, sampleCategoryWeight, weight, comment);
            catchList.add(reportEntry);
        }
        return catchList;
    }

    protected String getBatchDecoratedSampleCategoryValue(SpeciesBatch batch) {
        Serializable sampleCategoryValue = batch.getSampleCategoryValue();
        return this.decoratorService.getDecorator(sampleCategoryValue).toString((Object)sampleCategoryValue);
    }

    protected void generatePdf(File targetFile, ToConfirmReportBean reportBean) {
        Locale locale = this.context.getConfig().getI18nLocale();
        this.pdfGeneratorService.generatePdf(targetFile, locale, "toConfirmSpeciesReport.ftl", reportBean);
    }
}

