/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.cruise;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.cruise.CruiseCache;
import fr.ifremer.tutti.service.sampling.CruiseSamplingCache;
import fr.ifremer.tutti.service.sampling.SamplingCodeCache;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class CruiseCacheLoader {
    private static final Log log = LogFactory.getLog(CruiseCacheLoader.class);
    private final PersistenceService persistenceService;
    private final DecoratorService decoratorService;
    private final ProgressionModel progressionModel;
    private final CruiseCache cruiseCache;

    public static CruiseCacheLoader newCacheLoader(PersistenceService persistenceService, DecoratorService decoratorService, ProgressionModel progressionModel, TuttiProtocol protocol, Integer cruiseId) {
        CruiseSamplingCache cruiseSamplingCache;
        boolean loadSamplingCache;
        boolean bl = loadSamplingCache = protocol != null && protocol.isUseCalcifiedPieceSampling();
        if (loadSamplingCache) {
            Caracteristic sexCaracteristic = persistenceService.getSexCaracteristic();
            List<Caracteristic> maturityCaracteristics = persistenceService.getMaturityCaracteristics(persistenceService.getAllCaracteristic());
            cruiseSamplingCache = new CruiseSamplingCache(protocol, sexCaracteristic, maturityCaracteristics);
        } else {
            cruiseSamplingCache = null;
        }
        CruiseCache cruiseCache = new CruiseCache(cruiseId, protocol == null ? null : protocol.getId(), cruiseSamplingCache, new SamplingCodeCache());
        return new CruiseCacheLoader(persistenceService, decoratorService, progressionModel, cruiseCache);
    }

    public static CruiseCacheLoader newCacheLoader(PersistenceService persistenceService, DecoratorService decoratorService, ProgressionModel progressionModel, CruiseCache cruiseCache) {
        return new CruiseCacheLoader(persistenceService, decoratorService, progressionModel, cruiseCache);
    }

    public CruiseCache loadCruiseCache() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Loading cruise cache: " + this.cruiseCache));
        }
        Decorator<FishingOperation> fishingOperationDecorator = this.decoratorService.getDecoratorByType(FishingOperation.class);
        this.persistenceService.getAllFishingOperationIds(this.cruiseCache.getCruiseId()).forEach(fishingOperationId -> {
            FishingOperation fishingOperation = this.persistenceService.getFishingOperation((Integer)fishingOperationId);
            this.progressionModel.increments(I18n.t((String)"tutti.cruise.cacheLoader.loading.fishingOperation", (Object[])new Object[]{fishingOperationDecorator.toString((Object)fishingOperation)}));
            this.loadCruiseCacheForFishingOperation(fishingOperation);
        });
        if (log.isInfoEnabled()) {
            log.info((Object)("Cruise cache loaded: " + this.cruiseCache));
        }
        return this.cruiseCache;
    }

    public CruiseCache loadCruiseCacheForFishingOperation(FishingOperation fishingOperation) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Loading cruise cache for fishing operation: " + fishingOperation + " \u2192 " + this.cruiseCache));
        }
        List<IndividualObservationBatch> individualObservations = this.persistenceService.getAllIndividualObservationBatchsForFishingOperation(fishingOperation.getIdAsInt());
        this.cruiseCache.addFishingOperation(fishingOperation, individualObservations);
        if (log.isInfoEnabled()) {
            log.info((Object)("Cruise cache loaded for fishing operation: " + fishingOperation + " \u2192 " + this.cruiseCache));
        }
        return this.cruiseCache;
    }

    private CruiseCacheLoader(PersistenceService persistenceService, DecoratorService decoratorService, ProgressionModel progressionModel, CruiseCache cruiseCache) {
        this.persistenceService = persistenceService;
        this.decoratorService = decoratorService;
        this.progressionModel = progressionModel;
        this.cruiseCache = cruiseCache;
    }
}

