/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import com.google.common.base.Defaults;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.beans.InstanceFactory;
import org.nuiton.util.beans.PropertyDiff;

public class Binder<I, O>
implements Serializable {
    private static final Log log = LogFactory.getLog(Binder.class);
    private static final long serialVersionUID = 1L;
    protected BinderModel<I, O> model;

    public Class<I> getSourceType() {
        return this.getModel().getSourceType();
    }

    public Class<O> getTargetType() {
        return this.getModel().getTargetType();
    }

    public Map<String, Object> obtainProperties(I source, boolean includeNullValues, String ... propertyNames) {
        if (source == null) {
            return Collections.emptyMap();
        }
        propertyNames = this.getProperties(propertyNames);
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (String sourceProperty : propertyNames) {
            try {
                boolean include;
                Method readMethod = this.model.getSourceReadMethod(sourceProperty);
                Object read = readMethod.invoke(source, new Object[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property " + sourceProperty + ", type : " + readMethod.getReturnType() + ", value = " + read));
                }
                if (readMethod.getReturnType().isPrimitive() && ObjectUtil.getNullValue(readMethod.getReturnType()).equals(read)) {
                    read = null;
                }
                if (read != null) {
                    if (this.model.containsBinderProperty(sourceProperty)) {
                        read = this.model.containsCollectionProperty(sourceProperty) ? this.bindCollection(sourceProperty, read) : this.bindProperty(sourceProperty, read);
                    } else if (this.model.containsCollectionProperty(sourceProperty)) {
                        read = this.getCollectionValue(sourceProperty, read);
                    }
                }
                boolean bl = include = read != null || includeNullValues;
                if (!include) continue;
                result.put(sourceProperty, read);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not obtain property: " + sourceProperty, e);
            }
        }
        return result;
    }

    public Map<String, Object> obtainProperties(I source, String ... propertyNames) {
        return this.obtainProperties(source, false, propertyNames);
    }

    public <OO> OO obtainSourceProperty(I source, String propertyName) {
        Preconditions.checkNotNull(source, (Object)"source can not be null");
        Preconditions.checkNotNull((Object)propertyName, (Object)"propertyName can not be null");
        Method readMethod = this.model.getSourceReadMethod(propertyName);
        Preconditions.checkNotNull((Object)readMethod, (Object)("Could not find source getter for property: " + propertyName));
        try {
            Object result = readMethod.invoke(source, new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("property " + propertyName + ", type : " + readMethod.getReturnType() + ", value = " + result));
            }
            return (OO)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not obtain property: " + propertyName, e);
        }
    }

    public <OO> OO obtainTargetProperty(O target, String propertyName) {
        Preconditions.checkNotNull(target, (Object)"target can not be null");
        Preconditions.checkNotNull((Object)propertyName, (Object)"propertyName can not be null");
        Method readMethod = this.model.getTargetReadMethod(propertyName);
        Preconditions.checkNotNull((Object)readMethod, (Object)("Could not find target getter for property: " + propertyName));
        try {
            Object result = readMethod.invoke(target, new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("property " + propertyName + ", type : " + readMethod.getReturnType() + ", value = " + result));
            }
            return (OO)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not obtain property: " + propertyName, e);
        }
    }

    public void injectProperties(Map<String, Object> properties, O target) {
        this.injectProperties(properties, target, false);
    }

    public void injectProperties(Map<String, Object> properties, O target, boolean includeNullValues) {
        boolean useFunctions = this.model.isUseFunctions();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Class<?> targetPropertyType;
            String propertyName = entry.getKey();
            if (!this.getModel().containsTargetProperty(propertyName)) {
                throw new IllegalStateException("Could not find property '" + propertyName + "' in binder " + this + ".");
            }
            Object propertyValue = entry.getValue();
            if (propertyValue == null && !includeNullValues) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inject property: " + propertyName + " to " + target));
            }
            if (useFunctions && propertyValue != null) {
                propertyValue = this.transform(propertyName, propertyValue);
            }
            if (propertyValue == null && (targetPropertyType = this.getTargetPropertyType(propertyName)).isPrimitive()) {
                propertyValue = Defaults.defaultValue(targetPropertyType);
            }
            Method writeMethod = this.getModel().getTargetWriteMethod(propertyName);
            try {
                writeMethod.invoke(target, propertyValue);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set property [" + target.getClass().getName() + ":" + propertyName + "]", e);
            }
        }
    }

    protected Object transform(String propertyName, Object propertyValue) {
        Function function = this.model.getFunction(propertyValue.getClass());
        if (function != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Transform property: " + propertyName));
            }
            propertyValue = function.apply(propertyValue);
        }
        return propertyValue;
    }

    public void copy(I source, O target, String ... propertyNames) {
        this.copy(source, target, false, propertyNames);
    }

    public void copyExcluding(I source, O target, String ... propertyNames) {
        this.copy(source, target, true, propertyNames);
    }

    public Class<?> getSourcePropertyType(String propertyName) {
        if (!this.model.containsSourceProperty(propertyName)) {
            throw new IllegalArgumentException("Binder " + this + " does not contains source property: " + propertyName);
        }
        return this.model.getSourceReadMethod(propertyName).getReturnType();
    }

    public Type getSourcePropertyGenericType(String propertyName) {
        if (!this.model.containsSourceProperty(propertyName)) {
            throw new IllegalArgumentException("Binder " + this + " does not contains source property: " + propertyName);
        }
        return this.model.getSourceReadMethod(propertyName).getGenericReturnType();
    }

    public Class<?> getTargetPropertyType(String propertyName) {
        if (!this.model.containsTargetProperty(propertyName)) {
            throw new IllegalArgumentException("Binder " + this + " does not contains target property: " + propertyName);
        }
        return this.model.getTargetWriteMethod(propertyName).getParameterTypes()[0];
    }

    public Type getTargetPropertyGenericType(String propertyName) {
        if (!this.model.containsTargetProperty(propertyName)) {
            throw new IllegalArgumentException("Binder " + this + " does not contains target property: " + propertyName);
        }
        return this.model.getTargetWriteMethod(propertyName).getGenericParameterTypes()[0];
    }

    protected void copy(I source, O target, boolean excludeProperties, String ... propertyNames) throws RuntimeException {
        if (target == null) {
            throw new NullPointerException("parameter 'target' can no be null");
        }
        propertyNames = excludeProperties ? this.getAllPropertiesExclude(propertyNames) : this.getProperties(propertyNames);
        boolean useFunctions = this.model.isUseFunctions();
        for (String sourceProperty : propertyNames) {
            String targetProperty = this.model.getTargetProperty(sourceProperty);
            try {
                Object read = null;
                Method readMethod = this.model.getSourceReadMethod(sourceProperty);
                if (source != null) {
                    read = readMethod.invoke(source, new Object[0]);
                }
                if (read == null) {
                    read = ObjectUtil.getNullValue(readMethod.getReturnType());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property " + sourceProperty + ", type : " + readMethod.getReturnType() + ", value = " + read));
                }
                if (this.model.containsBinderProperty(sourceProperty)) {
                    read = this.model.containsCollectionProperty(sourceProperty) ? this.bindCollection(sourceProperty, read) : this.bindProperty(sourceProperty, read);
                } else if (this.model.containsCollectionProperty(sourceProperty)) {
                    read = this.getCollectionValue(sourceProperty, read);
                }
                if (useFunctions && read != null) {
                    read = this.transform(sourceProperty, read);
                }
                this.model.getTargetWriteMethod(targetProperty).invoke(target, read);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not bind property [" + source.getClass().getName() + ":" + sourceProperty + "] to [" + target.getClass().getName() + ":" + targetProperty + "]", e);
            }
        }
    }

    protected Object readProperty(String sourceProperty, Object source, Method readMethod) {
        try {
            Object read = null;
            if (source != null) {
                read = readMethod.invoke(source, new Object[0]);
            }
            if (read == null) {
                read = ObjectUtil.getNullValue(readMethod.getReturnType());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("property " + sourceProperty + ", type : " + readMethod.getReturnType() + ", value = " + read));
            }
            if (this.model.containsBinderProperty(sourceProperty)) {
                read = this.model.containsCollectionProperty(sourceProperty) ? this.bindCollection(sourceProperty, read) : this.bindProperty(sourceProperty, read);
            } else if (this.model.containsCollectionProperty(sourceProperty)) {
                read = this.getCollectionValue(sourceProperty, read);
            }
            return read;
        }
        catch (Exception e) {
            throw new RuntimeException("could not read property " + sourceProperty + " on source " + source);
        }
    }

    protected List<PropertyDiff> diff(I source, O target, boolean excludeProperties, String ... propertyNames) {
        if (source == null) {
            throw new NullPointerException("parameter 'source' can no be null");
        }
        if (target == null) {
            throw new NullPointerException("parameter 'target' can no be null");
        }
        propertyNames = excludeProperties ? this.getAllPropertiesExclude(propertyNames) : this.getProperties(propertyNames);
        LinkedList<PropertyDiff> result = new LinkedList<PropertyDiff>();
        for (String sourceProperty : propertyNames) {
            Method targetReadMethod;
            String targetProperty;
            Object targetRead;
            Method sourceReadMethod = this.model.getSourceReadMethod(sourceProperty);
            Object sourceRead = this.readProperty(sourceProperty, source, sourceReadMethod);
            if (!ObjectUtils.notEqual((Object)sourceRead, (Object)(targetRead = this.readProperty(targetProperty = this.model.getTargetProperty(sourceProperty), target, targetReadMethod = this.model.getTargetReadMethod(targetProperty))))) continue;
            PropertyDiff propertyDiff = new PropertyDiff(sourceProperty, sourceRead, targetProperty, targetRead, sourceReadMethod.getReturnType());
            result.add(propertyDiff);
        }
        return result;
    }

    public List<PropertyDiff> diff(I source, O target) {
        return this.diff(source, target, false, new String[0]);
    }

    public List<PropertyDiff> diffExcluding(I source, O target, String ... propertyNames) {
        return this.diff(source, target, true, propertyNames);
    }

    protected BinderModel<I, O> getModel() {
        return this.model;
    }

    protected void setModel(BinderModel<I, O> model) {
        this.model = model;
    }

    protected String[] getProperties(String ... propertyNames) {
        if (propertyNames.length == 0) {
            propertyNames = this.model.getSourceDescriptors();
        } else {
            for (String propertyName : propertyNames) {
                if (this.model.containsSourceProperty(propertyName)) continue;
                throw new IllegalArgumentException("property '" + propertyName + "' is not known by binder");
            }
        }
        return propertyNames;
    }

    protected String[] getAllPropertiesExclude(String ... propertyNameExcludes) {
        List<String> excludes = Arrays.asList(propertyNameExcludes);
        ArrayList<String> results = new ArrayList<String>();
        for (String propertyName : this.model.getSourceDescriptors()) {
            if (excludes.contains(propertyName)) continue;
            results.add(propertyName);
        }
        return results.toArray(new String[results.size()]);
    }

    protected Object getCollectionValue(String sourceProperty, Object readValue) {
        CollectionStrategy strategy = this.model.getCollectionStrategy(sourceProperty);
        Object result = strategy.copy(readValue);
        return result;
    }

    protected Object bindProperty(String sourceProperty, Object read) throws IllegalAccessException, InstantiationException {
        Binder<?, ?> binder = this.model.getBinder(sourceProperty);
        Object result = this.bind(binder, read);
        return result;
    }

    protected Object bindCollection(String sourceProperty, Object read) throws IllegalAccessException, InstantiationException {
        if (read == null) {
            return null;
        }
        Binder<?, ?> binder = this.model.getBinder(sourceProperty);
        Collection result = (Collection)this.model.getCollectionStrategy(sourceProperty).copy(read);
        Collection collection = (Collection)read;
        for (Object o : collection) {
            Object r = this.bind(binder, o);
            result.add(r);
        }
        return result;
    }

    protected Object bind(Binder binder, Object read) throws IllegalAccessException, InstantiationException {
        O result = null;
        if (read != null) {
            InstanceFactory<O> instanceFactory = binder.model.getInstanceFactory();
            result = instanceFactory == null ? (O)read.getClass().newInstance() : (O)instanceFactory.newInstance();
            binder.copy(read, result, new String[0]);
        }
        return result;
    }

    public static class BinderModel<S, T>
    implements Serializable {
        protected final Class<S> sourceType;
        protected final Class<T> targetType;
        protected final Map<String, PropertyDescriptor> sourceDescriptors;
        protected final Map<String, PropertyDescriptor> targetDescriptors;
        protected final Map<String, String> propertiesMapping;
        protected Map<String, CollectionStrategy> collectionStrategies;
        protected Map<String, Binder<?, ?>> binders;
        protected InstanceFactory<T> instanceFactory;
        protected final Map<Class<?>, Function<?, ?>> functions;
        private static final long serialVersionUID = 2L;

        public BinderModel(Class<S> sourceType, Class<T> targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.sourceDescriptors = new TreeMap<String, PropertyDescriptor>();
            this.targetDescriptors = new TreeMap<String, PropertyDescriptor>();
            this.propertiesMapping = new TreeMap<String, String>();
            this.collectionStrategies = new TreeMap<String, CollectionStrategy>();
            this.binders = new TreeMap();
            this.functions = new LinkedHashMap();
        }

        public Class<S> getSourceType() {
            return this.sourceType;
        }

        public Class<T> getTargetType() {
            return this.targetType;
        }

        public String[] getSourceDescriptors() {
            Set<String> universe = this.sourceDescriptors.keySet();
            return universe.toArray(new String[this.sourceDescriptors.size()]);
        }

        public CollectionStrategy getCollectionStrategy(String property) {
            return this.collectionStrategies.get(property);
        }

        public String[] getTargetDescriptors() {
            Set<String> universe = this.targetDescriptors.keySet();
            return universe.toArray(new String[this.targetDescriptors.size()]);
        }

        public String getTargetProperty(String sourceProperty) {
            if (!this.containsSourceProperty(sourceProperty)) {
                return null;
            }
            String dstProperty = this.propertiesMapping.get(sourceProperty);
            return dstProperty;
        }

        public PropertyDescriptor getSourceDescriptor(String sourceProperty) {
            if (!this.containsSourceProperty(sourceProperty)) {
                return null;
            }
            PropertyDescriptor descriptor = this.sourceDescriptors.get(sourceProperty);
            return descriptor;
        }

        public Method getSourceReadMethod(String srcProperty) {
            PropertyDescriptor descriptor = this.getSourceDescriptor(srcProperty);
            Method readMethod = null;
            if (descriptor != null) {
                readMethod = descriptor.getReadMethod();
            }
            return readMethod;
        }

        public Method getSourceWriteMethod(String sourceProperty) {
            PropertyDescriptor descriptor = this.getSourceDescriptor(sourceProperty);
            Method writeMethod = null;
            if (descriptor != null) {
                writeMethod = descriptor.getWriteMethod();
            }
            return writeMethod;
        }

        public PropertyDescriptor getTargetDescriptor(String targetProperty) {
            if (!this.containsTargetProperty(targetProperty)) {
                return null;
            }
            PropertyDescriptor descriptor = this.targetDescriptors.get(targetProperty);
            return descriptor;
        }

        public Method getTargetReadMethod(String targetProperty) {
            PropertyDescriptor descriptor = this.getTargetDescriptor(targetProperty);
            Method readMethod = null;
            if (descriptor != null) {
                readMethod = descriptor.getReadMethod();
            }
            return readMethod;
        }

        public Method getTargetWriteMethod(String targetProperty) {
            PropertyDescriptor descriptor = this.getTargetDescriptor(targetProperty);
            Method writeMethod = null;
            if (descriptor != null) {
                writeMethod = descriptor.getWriteMethod();
            }
            return writeMethod;
        }

        public Class<?> getCollectionType(String sourceProperty) {
            Method method = this.getSourceReadMethod(sourceProperty);
            Class<?> type = method.getReturnType();
            if (Collection.class.isAssignableFrom(type)) {
                return type;
            }
            return null;
        }

        public void addCollectionStrategy(String propertyName, CollectionStrategy strategy) {
            this.collectionStrategies.put(propertyName, strategy);
        }

        public void addBinder(String propertyName, Binder<?, ?> binder) {
            this.binders.put(propertyName, binder);
        }

        public boolean containsSourceProperty(String sourceProperty) {
            return this.propertiesMapping.containsKey(sourceProperty);
        }

        public boolean containsTargetProperty(String targetProperty) {
            return this.propertiesMapping.containsValue(targetProperty);
        }

        public boolean containsCollectionProperty(String propertyName) {
            return this.collectionStrategies.containsKey(propertyName);
        }

        public boolean containsBinderProperty(String propertyName) {
            return this.binders.containsKey(propertyName);
        }

        protected void addBinding(PropertyDescriptor sourceDescriptor, PropertyDescriptor targetDescriptor) {
            String sourceProperty = sourceDescriptor.getName();
            String targetProperty = targetDescriptor.getName();
            this.sourceDescriptors.put(sourceProperty, sourceDescriptor);
            this.targetDescriptors.put(targetProperty, targetDescriptor);
            this.propertiesMapping.put(sourceProperty, targetProperty);
        }

        protected void removeBinding(String source) {
            String target = this.propertiesMapping.get(source);
            this.sourceDescriptors.remove(source);
            this.targetDescriptors.remove(target);
            this.propertiesMapping.remove(source);
            if (this.containsBinderProperty(source)) {
                this.binders.remove(source);
            }
            if (this.containsCollectionProperty(source)) {
                this.collectionStrategies.remove(source);
            }
        }

        protected Map<String, String> getPropertiesMapping() {
            return this.propertiesMapping;
        }

        public Binder<?, ?> getBinder(String sourceProperty) {
            return this.binders.get(sourceProperty);
        }

        public void setInstanceFactory(InstanceFactory<T> instanceFactory) {
            this.instanceFactory = instanceFactory;
        }

        public InstanceFactory<T> getInstanceFactory() {
            return this.instanceFactory;
        }

        public Function getFunction(Class<?> aClass) {
            return this.functions.get(aClass);
        }

        public boolean isUseFunctions() {
            return !this.functions.isEmpty();
        }
    }

    public static enum CollectionStrategy {
        copy{

            @Override
            public Object copy(Object readValue) {
                return readValue;
            }
        }
        ,
        duplicate{

            @Override
            public Object copy(Object readValue) {
                if (readValue instanceof LinkedHashSet) {
                    return new LinkedHashSet((Set)readValue);
                }
                if (readValue instanceof Set) {
                    return new HashSet((Set)readValue);
                }
                if (readValue instanceof Collection) {
                    return new ArrayList((Collection)readValue);
                }
                return readValue;
            }
        }
        ,
        bind{

            @Override
            public Object copy(Object readValue) {
                if (readValue instanceof LinkedHashSet) {
                    return new LinkedHashSet();
                }
                if (readValue instanceof Set) {
                    return new HashSet();
                }
                if (readValue instanceof Collection) {
                    return new ArrayList();
                }
                return readValue;
            }
        };


        public abstract Object copy(Object var1);
    }
}

