/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinition;
import fr.ifremer.tutti.persistence.entities.protocol.Zone;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.sampling.CalcifiedPiecesSamplingAlgorithmEntryNotFoundException;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingContext;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingStatus;
import fr.ifremer.tutti.service.sampling.SizeNotDefinedOnIndividualObservationException;
import fr.ifremer.tutti.service.sampling.ZoneNotDefinedOnFishingOperationException;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationUICache;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SamplingNotificationZoneModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SamplingNotificationZoneStatus;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class SamplingNotificationZoneHandler
implements Closeable {
    private static final Log log = LogFactory.getLog(SamplingNotificationZoneHandler.class);
    private final SpeciesFrequencyUIModel uiModel;
    private final SamplingNotificationZoneModel model;
    private final IndividualObservationBatchTableModel individualObservationTableModel;
    private final ListSelectionModel listSelectionModel;
    private final IndividualObservationUICache individualObservationUICache;
    private final JLabel samplingWarningLabel;
    private final JLabel samplingSummaryLabel;
    private final ListSelectionListener listSelectionListener;
    private final PropertyChangeListener modelSummaryTextChanged;
    private final PropertyChangeListener modelSelectedRowChanged;
    private final PropertyChangeListener modelUpdatedRowChanged;
    private final PropertyChangeListener modelStatusChanged;
    private final Decorator<Integer> infiniteDecorator;
    private final Decorator<Species> speciesDecorator;
    private final Decorator<Zone> zoneDecorator;
    private final Color colorHighlightInfoForeground;
    private final Color colorHighlightInfoBackground;

    public SamplingNotificationZoneHandler(SpeciesFrequencyUI ui, SamplingNotificationZoneModel model, IndividualObservationUICache individualObservationUICache) {
        this.uiModel = ui.getModel();
        this.samplingWarningLabel = ui.getSamplingWarningLabel();
        this.samplingSummaryLabel = ui.getSamplingResumeLabel();
        this.individualObservationTableModel = (IndividualObservationBatchTableModel)((Object)ui.getObsTable().getModel());
        this.model = model;
        this.listSelectionModel = ui.getObsTable().getSelectionModel();
        SpeciesFrequencyUIHandler uiHandler = ui.getHandler();
        this.individualObservationUICache = individualObservationUICache;
        this.infiniteDecorator = uiHandler.getDecorator(Integer.class, "nullInfinite");
        this.speciesDecorator = uiHandler.getDecorator(Species.class, "withSurveyCode");
        this.zoneDecorator = uiHandler.getDecorator(Zone.class, null);
        this.colorHighlightInfoForeground = uiHandler.getConfig().getColorHighlightInfoForeground();
        this.colorHighlightInfoBackground = uiHandler.getConfig().getColorHighlightInfoBackground();
        this.modelStatusChanged = event -> {
            SamplingNotificationZoneStatus newValue = (SamplingNotificationZoneStatus)((Object)((Object)event.getNewValue()));
            switch (newValue) {
                case DISABLED: {
                    this.samplingWarningLabel.setText(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.samplingDisabled", (Object[])new Object[0]));
                    this.samplingWarningLabel.setForeground(null);
                    this.samplingWarningLabel.setBackground(Color.LIGHT_GRAY);
                    break;
                }
                case NOT_USING_SAMPLING: {
                    this.samplingWarningLabel.setText(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.samplingNotUsed", (Object[])new Object[0]));
                    this.samplingWarningLabel.setForeground(null);
                    this.samplingWarningLabel.setBackground(Color.LIGHT_GRAY);
                    break;
                }
                case NEED_SAMPLING: {
                    this.samplingWarningLabel.setText(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.samplingNeeded", (Object[])new Object[0]));
                    this.samplingWarningLabel.setForeground(this.colorHighlightInfoForeground);
                    this.samplingWarningLabel.setBackground(this.colorHighlightInfoBackground);
                    break;
                }
                case NO_SAMPLING_REQUIRED: {
                    this.samplingWarningLabel.setText(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.noSamplingRequired", (Object[])new Object[0]));
                    this.samplingWarningLabel.setForeground(null);
                    this.samplingWarningLabel.setBackground(Color.LIGHT_GRAY);
                    break;
                }
                case COUNT_ATTAINED: {
                    this.samplingWarningLabel.setText(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.samplingTotalCountAttained", (Object[])new Object[0]));
                    this.samplingWarningLabel.setForeground(null);
                    this.samplingWarningLabel.setBackground(Color.LIGHT_GRAY);
                    break;
                }
                case NONE: {
                    this.samplingWarningLabel.setText(null);
                    this.samplingWarningLabel.setForeground(null);
                    this.samplingWarningLabel.setBackground(null);
                }
            }
        };
        this.modelSummaryTextChanged = event -> {
            String newValue = (String)event.getNewValue();
            this.samplingSummaryLabel.setText(newValue);
        };
        this.modelSelectedRowChanged = event -> {
            IndividualObservationBatchRowModel selectedRow = (IndividualObservationBatchRowModel)event.getNewValue();
            if (selectedRow == null) {
                this.hideAll();
                return;
            }
            IndividualObservationSamplingStatus status = this.getIndividualObservationSamplingStatus(selectedRow);
            if (status != null) {
                String summaryText = this.getSummaryText(status);
                model.setSummaryText(summaryText);
                SamplingNotificationZoneStatus samplingNotificationZoneStatus = status.isOneTotalCountIsAttained() ? SamplingNotificationZoneStatus.COUNT_ATTAINED : (status.isNotUsingSampling() ? SamplingNotificationZoneStatus.NOT_USING_SAMPLING : SamplingNotificationZoneStatus.NONE);
                model.setSamplingNotificationZoneStatus(samplingNotificationZoneStatus);
            }
        };
        this.modelUpdatedRowChanged = event -> {
            IndividualObservationBatchRowModel updatedRow = (IndividualObservationBatchRowModel)event.getNewValue();
            Objects.requireNonNull(updatedRow);
            IndividualObservationSamplingStatus status = this.getIndividualObservationSamplingStatus(updatedRow);
            if (status != null) {
                String summaryText = this.getSummaryText(status);
                model.setSummaryText(summaryText);
                SamplingNotificationZoneStatus samplingNotificationZoneStatus = status.isNeedSampling() ? SamplingNotificationZoneStatus.NEED_SAMPLING : (status.isOneTotalCountIsAttained() ? SamplingNotificationZoneStatus.COUNT_ATTAINED : (status.isNotUsingSampling() ? SamplingNotificationZoneStatus.NOT_USING_SAMPLING : (updatedRow.withSamplingCode() ? SamplingNotificationZoneStatus.NONE : SamplingNotificationZoneStatus.NO_SAMPLING_REQUIRED)));
                model.setSamplingNotificationZoneStatus(samplingNotificationZoneStatus);
            }
        };
        this.listSelectionListener = event -> {
            ListSelectionModel source = (ListSelectionModel)event.getSource();
            if (model.isValueAdjusting()) {
                return;
            }
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (source.isSelectionEmpty()) {
                model.setSelectedRow(null);
                return;
            }
            if (this.getSelectedRowCount(source) > 1) {
                this.hideAll();
                return;
            }
            IndividualObservationBatchRowModel selectedRow = (IndividualObservationBatchRowModel)this.individualObservationTableModel.getEntry(source.getMinSelectionIndex());
            model.setSelectedRow(selectedRow);
        };
    }

    public void editBatch(SpeciesBatch speciesBatch) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Edit batch for " + speciesBatch));
        }
        this.listSelectionModel.removeListSelectionListener(this.listSelectionListener);
        this.model.removePropertyChangeListener("selectedRow", this.modelSelectedRowChanged);
        this.model.removePropertyChangeListener("updatedRow", this.modelUpdatedRowChanged);
        this.model.removePropertyChangeListener("samplingNotificationZoneStatus", this.modelStatusChanged);
        this.model.removePropertyChangeListener("summaryText", this.modelSummaryTextChanged);
        this.model.addPropertyChangeListener("selectedRow", this.modelSelectedRowChanged);
        this.model.addPropertyChangeListener("updatedRow", this.modelUpdatedRowChanged);
        this.model.addPropertyChangeListener("samplingNotificationZoneStatus", this.modelStatusChanged);
        this.model.addPropertyChangeListener("summaryText", this.modelSummaryTextChanged);
        if (!this.uiModel.isProtocolFilled()) {
            this.stopUsingStatusNotication(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.noProtocol", (Object[])new Object[0]));
            return;
        }
        if (!this.uiModel.isProtocolUseCalcifiedPieceSampling()) {
            this.stopUsingStatusNotication(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.notUsingAlgorithm", (Object[])new Object[0]));
            return;
        }
        if (!this.individualObservationUICache.isFishingOperationWithZone()) {
            this.stopUsingStatusNotication(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.fishingOperationNotInAZone", (Object[])new Object[0]));
            return;
        }
        if (!this.individualObservationUICache.isSpeciesDefinedInCalcifiedPiecesSampling()) {
            this.stopUsingStatusNotication(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.speciesNotInAlgorithm", (Object[])new Object[0]));
            return;
        }
        Preconditions.checkState((boolean)this.individualObservationUICache.useCruiseSamplingCache());
        this.model.setSelectedRow(null);
        this.listSelectionModel.addListSelectionListener(this.listSelectionListener);
    }

    @Override
    public void close() {
        this.listSelectionModel.removeListSelectionListener(this.listSelectionListener);
        this.model.removePropertyChangeListener("selectedRow", this.modelSelectedRowChanged);
        this.model.removePropertyChangeListener("updatedRow", this.modelUpdatedRowChanged);
        this.model.removePropertyChangeListener("samplingNotificationZoneStatus", this.modelStatusChanged);
        this.model.removePropertyChangeListener("summaryText", this.modelSummaryTextChanged);
    }

    private void hideAll() {
        this.model.setSummaryText(null);
        this.model.setSamplingNotificationZoneStatus(SamplingNotificationZoneStatus.NONE);
    }

    private void whenCanNotUseSampling(String message) {
        this.model.setSummaryText(message);
        this.model.setSamplingNotificationZoneStatus(SamplingNotificationZoneStatus.DISABLED);
    }

    private void stopUsingStatusNotication(String message) {
        this.whenCanNotUseSampling(message);
        this.model.removePropertyChangeListener("selectedRow", this.modelSelectedRowChanged);
        this.model.removePropertyChangeListener("updatedRow", this.modelUpdatedRowChanged);
        this.model.removePropertyChangeListener("samplingNotificationZoneStatus", this.modelStatusChanged);
        this.model.removePropertyChangeListener("summaryText", this.modelSummaryTextChanged);
    }

    private String getSummaryText(IndividualObservationSamplingStatus status) {
        IndividualObservationSamplingContext individualObservationSamplingContext = status.getIndividualObservationSamplingContext();
        CalcifiedPiecesSamplingDefinition calcifiedPiecesSamplingDefinition = status.getCalcifiedPiecesSamplingDefinition();
        int nbForOperation = status.getSamplingCountInFishingOperation();
        int nbForZone = status.getSamplingCountInZone();
        int nbForCruise = status.getSamplingCountInCruise();
        String nbForOperationLabel = this.getLabelForSamplingNumber(nbForOperation, calcifiedPiecesSamplingDefinition.getOperationLimitation());
        String nbForZoneLabel = this.getLabelForSamplingNumber(nbForZone, calcifiedPiecesSamplingDefinition.getZoneLimitation());
        String nbForCruiseLabel = this.getLabelForSamplingNumber(nbForCruise, calcifiedPiecesSamplingDefinition.getMaxByLenghtStep());
        String key = this.speciesDecorator.toString((Object)individualObservationSamplingContext.getSpecies()) + " " + this.uiModel.convertFromMm(individualObservationSamplingContext.getLengthStep().intValue()) + " " + this.uiModel.getLengthStepCaracteristicUnit();
        if (individualObservationSamplingContext.withGender()) {
            key = key + " " + individualObservationSamplingContext.getGender().getDescription();
        }
        if (individualObservationSamplingContext.withMaturity()) {
            key = individualObservationSamplingContext.getMaturity() != false ? key + " " + I18n.t((String)"tutti.editSpeciesFrequencies.samplingNeeded.mature", (Object[])new Object[0]) : key + " " + I18n.t((String)"tutti.editSpeciesFrequencies.samplingNeeded.immature", (Object[])new Object[0]);
        }
        String zone = this.zoneDecorator.toString((Object)individualObservationSamplingContext.getZone());
        return I18n.t((String)"tutti.editSpeciesFrequencies.samplingNeeded.summary", (Object[])new Object[]{key, nbForOperationLabel, zone, nbForZoneLabel, nbForCruiseLabel});
    }

    private int getSelectedRowCount(ListSelectionModel selectionModel) {
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        int count = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            ++count;
        }
        return count;
    }

    private String getLabelForSamplingNumber(int value, Integer max) {
        return "<strong>" + this.infiniteDecorator.toString((Object)value) + "</strong> (" + this.infiniteDecorator.toString((Object)max) + ")";
    }

    private IndividualObservationSamplingStatus getIndividualObservationSamplingStatus(IndividualObservationBatchRowModel selectedRow) {
        IndividualObservationSamplingStatus individualObservationSamplingStatus = null;
        try {
            individualObservationSamplingStatus = this.individualObservationUICache.getIndividualObservationSamplingStatus(selectedRow);
        }
        catch (CalcifiedPiecesSamplingAlgorithmEntryNotFoundException e) {
            this.whenCanNotUseSampling(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.noAlgorithmEntry", (Object[])new Object[0]));
        }
        catch (SizeNotDefinedOnIndividualObservationException e) {
            this.whenCanNotUseSampling(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.sizeNotDefined", (Object[])new Object[0]));
        }
        catch (ZoneNotDefinedOnFishingOperationException e) {
            this.whenCanNotUseSampling(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNotification.warning.fishingOperationNotInAZone", (Object[])new Object[0]));
        }
        return individualObservationSamplingStatus;
    }
}

