/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequenciesHistogramModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiNumberTickUnitSource;
import fr.ifremer.tutti.util.Units;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.data.xy.IntervalXYDataset;
import org.nuiton.i18n.I18n;

public class FrequenciesHistogramHandler
implements Closeable {
    private static final Log log = LogFactory.getLog(FrequenciesHistogramHandler.class);
    private final FrequenciesHistogramModel model;
    private final JFreeChart chart;
    private final JFrame popup;

    public FrequenciesHistogramHandler(SpeciesFrequencyUI ui) {
        SpeciesFrequencyUIModel uiModel = ui.getModel();
        SpeciesFrequencyUIHandler uiHandler = ui.getHandler();
        this.model = uiModel.getFrequenciesHistogramModel();
        this.chart = ChartFactory.createXYBarChart(null, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (boolean)false, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), (IntervalXYDataset)this.model.getDataset());
        this.chart.clearSubtitles();
        ValueAxis rangeAxis = this.chart.getXYPlot().getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setStandardTickUnits((TickUnitSource)new NumberTickUnitSource(true));
        ValueAxis domainAxis = this.chart.getXYPlot().getDomainAxis();
        domainAxis.setAutoRange(true);
        domainAxis.setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(true));
        domainAxis.setMinorTickMarksVisible(true);
        this.chart.getXYPlot().getRenderer().setSeriesPaint(0, (Paint)uiHandler.getConfig().getColorComputedWeights());
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setDomainZoomable(false);
        chartPanel.setMouseZoomable(false);
        chartPanel.setPopupMenu(null);
        ui.getHistogramPanel().add((Component)chartPanel, "Center");
        this.popup = new JFrame();
        chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() > 1) {
                    FrequenciesHistogramHandler.this.popup.getContentPane().removeAll();
                    ChartPanel chartPanel = new ChartPanel(FrequenciesHistogramHandler.this.chart);
                    FrequenciesHistogramHandler.this.popup.getContentPane().add((Component)chartPanel);
                    FrequenciesHistogramHandler.this.popup.pack();
                    FrequenciesHistogramHandler.this.popup.setVisible(true);
                }
            }
        });
        uiModel.addPropertyChangeListener("step", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Float step1 = (Float)evt.getNewValue();
                FrequenciesHistogramHandler.this.model.setStep(step1);
            }
        });
        uiModel.addPropertyChangeListener("lengthStepCaracteristicUnit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String unit = (String)evt.getNewValue();
                if (unit == null) {
                    unit = I18n.t((String)"tutti.editSpeciesFrequencies.unkownStepUnit", (Object[])new Object[0]);
                }
                String lengthStepLabelWithUnit = Units.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), unit);
                FrequenciesHistogramHandler.this.model.setLengthStepLabelWithUnit(lengthStepLabelWithUnit);
            }
        });
        this.model.addPropertyChangeListener("title", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String title = (String)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Frequencies graph title changed to: " + title));
                }
                FrequenciesHistogramHandler.this.popup.setTitle(title);
            }
        });
        this.model.addPropertyChangeListener("lengthStepLabelWithUnit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String lengthStepLabelWithUnit = (String)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Frequencies graph lengthStepLabelWithUnit changed to: " + lengthStepLabelWithUnit));
                }
                FrequenciesHistogramHandler.this.chart.getXYPlot().getDomainAxis().setLabel(lengthStepLabelWithUnit);
            }
        });
        this.model.addPropertyChangeListener("step", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Float step = (Float)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Frequencies graph step changed to: " + step));
                }
                FrequenciesHistogramHandler.this.chart.getXYPlot().getDomainAxis().setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(step.floatValue() == 1.0f));
                FrequenciesHistogramHandler.this.model.getDataset().setIntervalWidth((double)step.floatValue());
            }
        });
    }

    @Override
    public void close() {
        this.popup.dispose();
    }
}

